//durchgehende Töne !

public class Rendern2 implements Runnable
{
    private double[] frequenzen = {70,105,140,175,  205,240,315,350,  420,490,525,630,  700,735,980,1050};
  
    private double[][] merker;
    private int ANZAHL_BILDER;
    private int ANZAHL_SAMPLES;
    //double[] enthält nur die x,y-Koordinaten der 64 synchron pulsierenden Töne
    //Diese haben 1/5 Sekunde Ton und danach Stille
    //0..15: Positon
    //16..31: Negaton
    //32..47: Positon
    //48..64:negaton
    
    //Jeder Ton hat drei Obertöne, Gewichtung: 1 1/8 1/4
    int DELTA = 1764;
    
    double[] ab = new double[128]; //x y x y ...
    double[] ab_alt =null; //x y x y ...

    double FSAMP = 44100.0;
    double VSCHALL = 334.0;
    double OHR = 0.15;
    
    public Rendern2(double[][] merker)
    {
        this.merker = merker;
        this.ANZAHL_BILDER = merker.length; //Anzahl der Bilder mit 25 Bilder pro Sekunde => 1/25 Sekunde pro Bild
        //Bei 44100 Samplerate, werden in 1/25 Sekunde 1764 Samples durchlaufen.
        //Immer zwischen zwei Bildern wird interpoliert.
        //Die Dauer des letzten Bildes bleibt "still", da keine Interpolation möglich, bzw hat ein Fadeout
        // des letzten Sustandes
        this.ANZAHL_SAMPLES = this.ANZAHL_BILDER*DELTA;
//        (new Thread(this)).start();
    }

    int rr_alt = -1;
  
    public void run()
    {
           println("**** SPEICHERN ****");

           PrintWriter pw;
           try
           {
                 pw = new PrintWriter(new FileWriter(new File(BASISPFAD+"/wavstueck.txt")));
           }
           catch(Exception e)
           {
                 println(e);
                 return;
           }
                int ZAEHLER = 0; 
                for(int i=0;i<ANZAHL_BILDER;i++)
                {                  
                    double[] a = merker[i];
                    double[] b;
                    double FADING = 1.0;

                    if(i==ANZAHL_BILDER-1)
                        b=a; //letzten Zustand halten und Fadeout einleiten
                    else
                        b = merker[i+1];
                        
                    for(int k=0;k<DELTA;k++)
                    {
                        double t = (double)ZAEHLER/FSAMP;
                        double links  = 0.0;
                        double rechts = 0.0;

                        if(i==0)
                            FADING = (double)k/(double)DELTA;
                        else if(i==ANZAHL_BILDER-1)    
                            FADING = 1.0 - (double)(k+1)/(double)DELTA;
                        else
                            FADING = 1.0;
                        
                        //Alle Koordinaten interpolieren:
                        double anteil1 = (double)k/(double)DELTA;
                        double anteil2 = 1.0 - anteil1;
                        for(int r=0;r<ab.length;r++)
                           ab[r] = anteil1*a[r]+anteil2*b[r];

                        for(int r=0;r<64;r++) //Alle Tonquellen durchgehen
                        {
                            double x = ab[r*2+0];  
                            double y = ab[r*2+1];
                            double VORZEICHEN = 1.0;
                                                        
                            double f1 = frequenzen[r%16];
                            double f2 = f1;
                            double f3 = f2;

                            if((r/16)%2==1)
                                VORZEICHEN=-1.0;
                            
                            if(r%16==14)
                            {
                                 f3=frequenzen[15];
                            }
                            else if(r%16<14)
                            {                              
                                 f2=frequenzen[r%16+1];                              
                                 f3=frequenzen[r%16+2];
                            }
                            
                            //Halbe Wellenlänge
                            double HW = 0.5*VSCHALL/f1;                                                        
                            
                            double dist_links  = Math.sqrt((x-OHR)*(x-OHR)+y*y);  
                            double dist_rechts = Math.sqrt((x+OHR)*(x+OHR)+y*y);  
                            
                            double t_phase_links = t - dist_links/VSCHALL;
                            double t_phase_rechts = t - dist_rechts/VSCHALL;
                            
                            //Beides auf Bereich zwischen 0..1Sekunde schiften:
                            if(t_phase_links>=0.0)
                                t_phase_links = t_phase_links - Math.floor(t_phase_links);
                            else
                                t_phase_links = t_phase_links + Math.ceil(Math.abs(t_phase_links));
                            
                            if(t_phase_rechts>=0.0)
                                t_phase_rechts = t_phase_rechts - Math.floor(t_phase_rechts);
                            else
                                t_phase_rechts = t_phase_rechts + Math.ceil(Math.abs(t_phase_rechts));

                            //Abschwächung am Hinterkopf:
                            double rrr = Math.sqrt(x*x + y*y);  
                            if(rrr==0.0)
                                rrr = 0.000001;
                            double phiphi = Math.acos(x/rrr);    //phi rekonstruieren acos.. 0..PI
                            if(y<0.0)
                                phiphi = -phiphi;

                            //Abdämpfung nach hinten:
                            double hinterkopf = 0.25*(4.0 - Math.cos(phiphi-Math.PI*0.5));
//2. Alphorn: Quint höher                           
if(r>=32)
{
    f1*=1.5;
    f2*=1.5;
    f3*=1.5;
}
                            //if(t_phase_links<1.0/5.0)
                            //{
                                links+=hinterkopf*VORZEICHEN*(  
                                                       1.0*Math.sin(2.0*Math.PI*f1*t_phase_links)+
                                                       0.125*Math.sin(2.0*Math.PI*f2*t_phase_links)+
                                                       0.25*Math.sin(2.0*Math.PI*f3*t_phase_links)
                                                   );
                            //}
                            //if(t_phase_rechts<1.0/5.0)
                            //{
                                rechts+=hinterkopf*VORZEICHEN*(  
                                                       1.0*Math.sin(2.0*Math.PI*f1*t_phase_rechts)+
                                                       0.125*Math.sin(2.0*Math.PI*f2*t_phase_rechts)+
                                                       0.25*Math.sin(2.0*Math.PI*f3*t_phase_rechts)
                                                   );
                            //}
                            //pw.print(x+" "+y+" ");
                            
                        } //for(int r=0;r<64;r++) //Alle Tonquellen durchgehen

                        pw.println(links*FADING+" "+rechts*FADING);
//pw.println();
                        if(ab_alt==null)
                            ab_alt = new double[128];
                        for(int rr=0;rr<ab.length;rr++)
                            ab_alt[rr] = ab[rr];
                           
                        ZAEHLER++;   
                    }//for(int k=0;k<DELTA;k++)
                }//for(int i=0;i<ANZAHL_BILDER;i++)
                pw.close();
                
           println("**** SPEICHERN BEENDET ****");
         
    }
}
