public class Partikel implements Modell
{
    public int ANZAHL;
//    public int anzahl = 3; //Anzahl der Gleichungen , ANPASSEN!

    public double[] F;  //Kraftkomponenten. 3 pro Partikel
    public double[] yalt; //hier den alten Systemzustand registrieren für setze-Methode!

    public double D; //Dämpfung gegen Geschwindigkeit.

    public void setzeKraft(int nr, double Fx, double Fy, double Fz)
    {
         F[nr*3+0] = Fx;
         F[nr*3+1] = Fy;
         F[nr*3+2] = Fz;
    }

    public void setzeZustand(int nr, double x, double y, double z, 
                                     double vx, double vy, double vz, 
                                     double Fx, double Fy, double Fz)
    {
         F[nr*3+0] = Fx;
         F[nr*3+1] = Fy;
         F[nr*3+2] = Fz;
         
         yalt[nr*6+0] = x;
         yalt[nr*6+1] = vx;
         yalt[nr*6+2] = y;
         yalt[nr*6+3] = vy;
         yalt[nr*6+4] = z;
         yalt[nr*6+5] = vz;
    }

    public Partikel(int PARTIKEL_ANZAHL, double[] yalt, double D)
    {
         this.ANZAHL = PARTIKEL_ANZAHL*6; //x vx y vy z vz ...
         this.F = new double[PARTIKEL_ANZAHL*3]; // Fx Fy Fz
         this.yalt = yalt;
         this.D = D;
    }

    public int getGleichungsanzahl()
    {
        return this.ANZAHL;
    }
    public void steigung(double[] f, double[] yy,double t)
    {
        for(int i=0;i<f.length;i+=6)
        {
            f[i+0] = yy[i+1]; //x
            f[i+1] = F[i/2+0] - D*yy[i+1]; //vx
            f[i+2] = yy[i+3]; //y
            f[i+3] = F[i/2+1] - D*yy[i+3]; //vy
            f[i+4] = yy[i+5]; //z
            f[i+5] = F[i/2+2] - D*yy[i+5]; //vz
        }    
    }
}
