public class KeplersortierungZ
{
    //Anziehung jeder der 64 Partikel mit jedem 
    //Grundfaktor, muß noch mit Abstand gewichtet werden.
    public int[][] anziehung;
    double[] F = new double[3]; 
  
    public KeplersortierungZ()
    {
        anziehung = new int[MAXPARTIKEL][MAXPARTIKEL];
        for(int i=0;i<anziehung.length;i++)
        {
             for(int k=0;k<anziehung[i].length;k++)
             {
                  if(i!=k)
                  {
                      int f1 = frequenzen[i%16];
                      int f2 = frequenzen[i%16];
                      
                      for(int q=0;q<harmonisch.length;q++)
                      {
                          if(f1*harmonisch[q][0]==f2*harmonisch[q][1] || f1*harmonisch[q][1]==f2*harmonisch[q][0])
                          {
                               anziehung[i][k]=1;
                               break;
                          }
                      }
                      if(anziehung[i][k]==0)
                         anziehung[i][k]=-1;
                  }
             }
        }
    }
    
    public double[] berechneKraft(int nr, double[] yyalt)
    {
          double x1 = yyalt[nr*6+0];
          double y1 = yyalt[nr*6+2];
          double z1 = yyalt[nr*6+4];
          
          F[0]=0.0;
          F[1]=0.0;
          F[2]=0.0;

          

          double Fbest = 0.0;
          for(int i=0;i<MAXPARTIKEL;i++)
          {
              if(i!=nr)
              {
                  double x2 = yyalt[i*6+0];
                  double y2 = yyalt[i*6+2];
                  double z2 = yyalt[i*6+4];
                  
                  //Über Rand hinweg, wenn nötig:
                  //if(Math.abs(z1-z2)>ZMAX3D*0.5)
                  
                  double dist = Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1)+(z2-z1)*(z2-z1));
                  
                  double ex = x2-x1;
                  double ey = y2-y1;
                  double ez = z2-z1;
                  
                  if(dist>1.0 && Math.abs(z1-z2)<ZMAX3D*0.5)// && anziehung[nr][i]>0)
//                  if(dist>1.0 && Math.abs(z1-z2)<20.0)// && anziehung[nr][i]>0)
                  {
                        double Fneu=(double)anziehung[nr][i]*ez/(0.01+Math.sqrt(dist));
                        if(Math.abs(Fneu)>Math.abs(Fbest))
                        {
                           Fbest = Fneu;
                           F[0]=(double)anziehung[nr][i]*ex/(0.01+Math.sqrt(dist));
                           F[1]=(double)anziehung[nr][i]*ey/(0.01+Math.sqrt(dist));
                           F[2]=(double)anziehung[nr][i]*ez/(0.01+Math.sqrt(dist));

                        }   
//                        F[2]+=(double)anziehung[nr][i]*ez/(0.01+Math.sqrt(dist));
//                        F[2]+=(double)anziehung[nr][i]*ez;
                  }
              }
          }
          
          return F;
          /*
          if(F[2]>0.0)
            return 8.0;
          else if(F[2]==0.0)
            return 0.0;
          else
            return -8.0;
          */  
    }
}
