                                              
                                              
//2*32 Samplelängen, die alle harmonischen Verhältnisse realisieren lassen und
//mit 44100 Samplerate darstellbar sind:

// Benötigt KGV 2*2 3 5

// Obertonreihe: 1 2 3 4 5 6 7 8 9 10 12 14, KGV == 2*2*3*3*5*7, es bleiben: 5*7==35

// dann wäre aber alles verbraucht und die kleinste Frequenz == 1Hz !!!!

// Reduktion deshalb:
// Obertonreihe: 1 2 3 4 5 6 8 10 12, KGV == 2*2*3*5, es bleiben: 3*5*7*7==735

// läßt man 7*7 immer bestehen, dann ergibt sich: 

// 7*7*2*2*3*5 == 2940Samples == 44100/2940 == 15Hz

// Faktor 3 statt 7:
// 7*3*2*2*3*5 == 1260Samples == 44100/2100 == 35Hz

// Tonvarianten: 3*2*2 = 12 ... zu wenig!

// (2*2*3*3*5*5*7*7)/(7*3*2*2*3*5) === 35Hz Oberton 0 
//*********************************************************+
// 3*3*2*2==36 ... oberste weglassen!
// Samples:  7*7*   2*2*3*3*5*7 === 3*3*2*2Varianten  
//Oberton:
//1*       (2*2*3*3*5*5*7*7)/(2*2*3*3*5*7)  ==   35Hz Grundton weglassen
//2*       (2*2*3*3*5*5*7*7)/(2*1*3*3*5*7)  ==   70Hz 1
//3*       (2*2*3*3*5*5*7*7)/(2*2*3*1*5*7)  ==  105Hz 2
//4*       (2*2*3*3*5*5*7*7)/(1*1*3*3*5*7)  ==  140Hz 3
//5*       (2*2*3*3*5*5*7*7)/(2*2*3*3*1*7)  ==  175Hz 4
//6*       (2*2*3*3*5*5*7*7)/(2*1*3*1*5*7)  ==  205Hz 5
//7*       (2*2*3*3*5*5*7*7)/(2*2*3*3*5*1)  ==  240Hz 6
//8*  ----
//9*       (2*2*3*3*5*5*7*7)/(2*2*1*1*5*7)  ==  315Hz 7
//10*      (2*2*3*3*5*5*7*7)/(2*1*3*3*1*7)  ==  350Hz 8
//12*      (2*2*3*3*5*5*7*7)/(1*1*3*1*5*7)  ==  420Hz 9
//13* ----
//14*      (2*2*3*3*5*5*7*7)/(2*1*3*3*5*1)  ==  490Hz 10
//15*      (2*2*3*3*5*5*7*7)/(2*2*3*1*1*7)  ==  525Hz 11
//16* ----
//17* ----
//18*      (2*2*3*3*5*5*7*7)/(2*1*1*1*5*7)  ==  630Hz 12
//19* ----
//20*      (2*2*3*3*5*5*7*7)/(1*1*3*3*1*7)  ==  700Hz 13
//21*      (2*2*3*3*5*5*7*7)/(2*2*3*1*5*1)  ==  735Hz 14
//22* ----
//23* ----
//24* ----
//25* ----
//26* ----
//27* ----
//28*      (2*2*3*3*5*5*7*7)/(1*1*3*3*5*1)  ==  980Hz 15  //sozusagen Flageollettöne
//29* ----
//30*      (2*2*3*3*5*5*7*7)/(2*1*3*1*1*7)  == 1050Hz 16  // 3,5 Oktaven

double[] HW; //Halbe Wellenlänge eines Tones, wird in Kepler initialisiert.

int[][] TONFARBEN; //Jeder Ton und Antiton bekommt seine eigene Farbe gemäß der laufenden Nummer 0..15

public class Kepler
{
    public Kepler()
    {
        HW = new double[frequenzen.length];
        
        for(int i=0;i<HW.length;i++)
        {
            HW[i] = 0.5*VSCHALL/(double)frequenzen[i];
        }
        TONFARBEN = new int[ANZAHL_TOENE][3];
        //Antiton als nicht gefüllten Kreis zeichnen?
        for(int i=0;i<TONFARBEN.length;i++)
        {
          if(i<32)
          {
            int ii=i%16;
            TONFARBEN[i][0] = 75+60*(ii%4);
            TONFARBEN[i][1] = 75+30*((ii/4)%4);
            TONFARBEN[i][2] = 75+30*((ii/16)%4);
          }
          else 
          {
            int ii=(i%16)*2;
            TONFARBEN[i][0] = 75+30*(ii%4);
            TONFARBEN[i][1] = 75+60*((ii/4)%4);
            TONFARBEN[i][2] = 75+30*((ii/16)%4);
          }
          /*
           int ii=i%16;
           if(i<16)
           {
              TONFARBEN[i][0] = 105+50*ii%4;
              TONFARBEN[i][1] = 0;
              TONFARBEN[i][2] = 105+50*((ii/4)%4);
           }   
           else if(i<32)
           {
              TONFARBEN[i][0] = 0;
              TONFARBEN[i][1] = 105+50*ii%4;
              TONFARBEN[i][2] = 105+50*((ii/4)%4);
           }
           else if(i<48)
           {
              TONFARBEN[i][0] = 105+50*((ii/4)%4);
              TONFARBEN[i][1] = 0;
              TONFARBEN[i][2] = 105+50*(ii%4);
           }
           else
           {
              TONFARBEN[i][0] = 105+50*((i%16)/4)%4;
              TONFARBEN[i][1] = 105+50*(i%16)%4;
              TONFARBEN[i][2] = 0;
           }
          */ 
        }
        
    }
}
