public class Integrator
{
    int anzahl;
  
    double[] k1,k2,k3,k4;
    
    double[] yhilf;
  
    Modell modell;
  
    public Integrator(Modell modell)
    {
        this.modell = modell;
        anzahl = modell.getGleichungsanzahl();
        k1 = new double[anzahl];      
        k2 = new double[anzahl];      
        k3 = new double[anzahl];      
        k4 = new double[anzahl];
  
        yhilf = new double[anzahl];            
    }  
    
    public void zeitschritt(double[] y,double[] y_alt, double t, double dt)
    {
        modell.steigung(k1,y_alt,t);
        for(int i=0;i<anzahl;i++)
            yhilf[i] = y_alt[i] + 0.5*dt*k1[i];
            
        modell.steigung(k2,yhilf,t+0.5*dt);            
        for(int i=0;i<anzahl;i++)
            yhilf[i] = y_alt[i] + 0.5*dt*k2[i];

        modell.steigung(k3,yhilf,t+0.5*dt);            
        for(int i=0;i<anzahl;i++)
            yhilf[i] = y_alt[i] + dt*k3[i];

        modell.steigung(k4,yhilf,t+dt);

        for(int i=0;i<anzahl;i++)
            y[i] = y_alt[i] + (dt/6.0)*(k1[i]+2.0*k2[i]+2.0*k3[i]+k4[i]);        
     }
}
