public class Kepler
{

//int[][] harmonisch = {{1,2},{1,3},{1,4},{1,5},{1,6},{2,3},{3,4},{4,5},{3,5},{5,8}};
//8er weglassen:
int[][] harmonisch = {{1,2},{1,3},{1,4},{1,5},{1,6},{2,3},{3,4},{4,5},{3,5}};

//2*32 Samplelängen, die alle harmonischen Verhältnisse realisieren lassen und
//mit 44100 Samplerate darstellbar sind:

// Benötigt KGV 2*2 3 5

// Obertonreihe: 1 2 3 4 5 6 7 8 9 10 12 14, KGV == 2*2*3*3*5*7, es bleiben: 5*7==35

// dann wäre aber alles verbraucht und die kleinste Frequenz == 1Hz !!!!

// Reduktion deshalb:
// Obertonreihe: 1 2 3 4 5 6 8 10 12, KGV == 2*2*3*5, es bleiben: 3*5*7*7==735

// läßt man 7*7 immer bestehen, dann ergibt sich: 

// 7*7*2*2*3*5 == 2940Samples == 44100/2940 == 15Hz

// Faktor 3 statt 7:
// 7*3*2*2*3*5 == 1260Samples == 44100/2100 == 35Hz

// Tonvarianten: 3*2*2 = 12 ... zu wenig!

// (2*2*3*3*5*5*7*7)/(7*3*2*2*3*5) === 35Hz Oberton 0 
//*********************************************************+
// 3*3*2*2==36 ... oberste weglassen!
// Samples:  7*7*   2*2*3*3*5*7 === 3*3*2*2Varianten  
//Oberton:
//1*       (2*2*3*3*5*5*7*7)/(2*2*3*3*5*7)  ==   35Hz Grundton weglassen
//2*       (2*2*3*3*5*5*7*7)/(2*1*3*3*5*7)  ==   70Hz 1
//3*       (2*2*3*3*5*5*7*7)/(2*2*3*1*5*7)  ==  105Hz 2
//4*       (2*2*3*3*5*5*7*7)/(1*1*3*3*5*7)  ==  140Hz 3
//5*       (2*2*3*3*5*5*7*7)/(2*2*3*3*1*7)  ==  175Hz 4
//6*       (2*2*3*3*5*5*7*7)/(2*1*3*1*5*7)  ==  205Hz 5
//7*       (2*2*3*3*5*5*7*7)/(2*2*3*3*5*1)  ==  240Hz 6
//8*  ----
//9*       (2*2*3*3*5*5*7*7)/(2*2*1*1*5*7)  ==  315Hz 7
//10*      (2*2*3*3*5*5*7*7)/(2*1*3*3*1*7)  ==  350Hz 8
//12*      (2*2*3*3*5*5*7*7)/(1*1*3*1*5*7)  ==  420Hz 9
//13* ----
//14*      (2*2*3*3*5*5*7*7)/(2*1*3*3*5*1)  ==  490Hz 10
//15*      (2*2*3*3*5*5*7*7)/(2*2*3*1*1*7)  ==  525Hz 11
//16* ----
//17* ----
//18*      (2*2*3*3*5*5*7*7)/(2*1*1*1*5*7)  ==  630Hz 12
//19* ----
//20*      (2*2*3*3*5*5*7*7)/(1*1*3*3*1*7)  ==  700Hz 13
//21*      (2*2*3*3*5*5*7*7)/(2*2*3*1*5*1)  ==  735Hz 14
//22* ----
//23* ----
//24* ----
//25* ----
//26* ----
//27* ----
//28*      (2*2*3*3*5*5*7*7)/(1*1*3*3*5*1)  ==  980Hz 15  //sozusagen Flageollettöne
//29* ----
//30*      (2*2*3*3*5*5*7*7)/(2*1*3*1*1*7)  == 1050Hz 16  // 3,5 Oktaven

//                   70Hz          105Hz          140Hz        175Hz
int[] samples = {(2*1*3*3*5*7),(2*2*3*1*5*7),(1*1*3*3*5*7),(2*2*3*3*1*7),
//                  205Hz          240Hz          315Hz        350Hz
                 (2*1*3*1*5*7),(2*2*3*3*5*1),(2*2*1*1*5*7),(2*1*3*3*1*7),
//                  420Hz          490Hz          525Hz        630Hz 
                 (1*1*3*1*5*7),(2*1*3*3*5*1),(2*2*3*1*1*7),(2*1*1*1*5*7),
//                  700Hz          735Hz          980Hz       1050Hz                    
                 (1*1*3*3*1*7),(2*2*3*1*5*1),(1*1*3*3*5*1),(2*1*3*1*1*7)};

   private int schritte = 100;
   private float ddt = 1.0f/(float)schritte; //Sekunden pro Schritt
   private int[] testwelle = new int[schritte];
   private float n = 1.0f/5.0f; //  Puls geht 1/5 Sekunde, Rest Stille,
                                //Phasenverschiebung:
    //Jeder Partikel pulst n=1/5 Sekunde.
    //und erfährt in der Hörerfahrung bei (0|0) eine Phasenverschiebung
    //um t = (abstand m)/(334m/s)                 
       
                 
                 
    public int[][] hmatrix = new int[samples.length][samples.length];                  
    public Kepler()
    {
         //Testwelle vorbereiten:
         for(int i=0;i<testwelle.length;i++)
         {
               if((float)i<n*(float)schritte)
                   testwelle[i]=1;
               else
                   testwelle[i]=0;
         }
      
         //Matrix, in der markiert ist, welche Töne harmonisch zueinander sind:
         for(int i=0;i<hmatrix.length;i++)
         {
             for(int k=0;k<hmatrix[i].length;k++)
             {
                   int f1 = 44100/samples[i];
                   int f2 = 44100/samples[k];
                   
                   for(int h=0;h<harmonisch.length;h++)
                   {
                         int z = harmonisch[h][0];
                         int n = harmonisch[h][1];
                         
                         if(f1%z==0 && f2%n==0 && (f2/n)*z==f1)
                         {
                               hmatrix[i][k] = h+1;
                               hmatrix[k][i] = h+1;
                               break;
                         }
                         else if(f1%n==0 && f2%z==0 && (f1/n)*z==f2)
                         {
                               hmatrix[i][k] = h+1;
                               hmatrix[k][i] = h+1;
                               break;
                         }
                   }
             }
         }
                  
    }
    
    public boolean istHarmonisch(Partikel p, Partikel q)
    {
        int typ1 = p.TYP%16;
        int typ2 = q.TYP%16;
        
        if(hmatrix[typ1][typ2]>0)
            return true;
        else
            return false;
    }
    
    //Jeder Partikel pulst n=1/5 Sekunde.
    //und erfährt in der Hörerfahrung bei (0|0) eine Phasenverschiebung
    //um t = (abstand m)/(334m/s)
    public int berechneUeberlappungsgrad(Partikel p, Partikel q)
    {
         int ueberlappung = 0; 

         float r1 = sqrt(p.x*p.x+p.y*p.y);
         int phase1 = (int)((r1/334.0f)/ddt); 
         float r2 = sqrt(q.x*q.x+q.y*q.y);
         int phase2 = (int)((r2/334.0f)/ddt); 
         
         for(int i=0;i<schritte;i++)
              ueberlappung+=testwelle[(i+phase1)%testwelle.length]*testwelle[(i+phase2)%testwelle.length];
         
         return ueberlappung;         
    }
    
    public int faktorAnziehungskraft(Partikel p, Partikel q) //...oder Abstoßung
    {
        int ue = berechneUeberlappungsgrad(p,q);
      
        if(istHarmonisch(p,q))
        {
            return ue;
        }
        else
        {
            return -ue;
        }
    }
    
    public int faktorAnziehungskraftInline(Partikel p, Partikel q) //...oder Abstoßung
    {
         int ue = 0; 

         float r1 = sqrt(p.x*p.x+p.y*p.y);
         int phase1 = (int)((r1/334.0f)/ddt); 
         float r2 = sqrt(q.x*q.x+q.y*q.y);
         int phase2 = (int)((r2/334.0f)/ddt); 
         
         //Achtung: Pixelmax == 334:
         r1*=334.0f/(float)(K/2);
         r2*=334.0f/(float)(K/2);
         
         for(int i=0;i<schritte;i++)
              ue+=testwelle[(i+phase1)%testwelle.length]*testwelle[(i+phase2)%testwelle.length];
               
        if(istHarmonisch(p,q))
            return ue;
        else
            return -ue;
    }
}                 
