import ketai.sensors.*;


KetaiSensor sensor;

float accelerometerX, accelerometerY, accelerometerZ;

//   z in Tablet hinein
//       |-------|
//  Kabel| TABLET|----> y
//       |_______|
//           |
//           v x

void setup()
{
  sensor = new KetaiSensor(this);
  sensor.start();
  orientation(LANDSCAPE);
  textAlign(CENTER, CENTER);
  textSize(36);
}

void draw()
{
  background(78, 93, 75);
    
    
    // cos phi = az/g
    // g = sqrt(ax^2 + ay^2 + az^2)
    double g = Math.sqrt(accelerometerX*accelerometerX+accelerometerY*accelerometerY+
                         accelerometerZ*accelerometerZ);
    double phi = (180.0/Math.PI)*Math.acos(accelerometerZ/g);
    
  text("Accelerometer: \n" + 
    "x: " + nfp(accelerometerX, 1, 3) + "\n" +
    "y: " + nfp(accelerometerY, 1, 3) + "\n" +
    "z: " + nfp(accelerometerZ, 1, 3) + "\n" +
    "phi = "+phi, 0, 0, width, height);
    
    
}

void onAccelerometerEvent(float x, float y, float z)
{
  accelerometerX = x;
  accelerometerY = y;
  accelerometerZ = z;
}

