package processing.test.kiba;

import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.io.File; 
import java.util.ArrayList; 
import java.util.ArrayList; 
import java.util.ArrayList; 
import android.media.AudioTrack; 
import android.media.AudioFormat; 
import android.media.AudioManager; 
import java.util.concurrent.Executors; 
import java.util.concurrent.ScheduledExecutorService; 
import java.util.concurrent.TimeUnit; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class KIBA extends PApplet {

Zeitsteuerung zeitsteueurung;
Rasterplayer rasterplayer;


/**
* Spielfeld, in dem die gelegten Chips gespeichert werden.
* Wichtigstes datenelement, das von verschiedenen Stellen her sichtbar sein sollte.
*/
int[][] raster;

int GEGRIFFEN = 0;

    //Pentatonische Frequenzen:
    //degah
    //a  h  d  e  g  a  h  d
    // 2  3  2  3   2  2  3

public String[] tonnamen = {
     //a           h            d             e             g              a             h            d
    "vib69_h.wav","vib71_h.wav","vib74_h.wav","vib76_h.wav","vib79_h.wav","vib81_h.wav","vib83_h.wav","vib86_h.wav",    
//    "xyl69_h.wav","xyl71_h.wav","xyl74_h.wav","xyl76_h.wav","xyl79_h.wav","xyl81_h.wav","xyl83_h.wav","xyl86_h.wav",
    "cem57_h.wav","cem59_h.wav","cem62_h.wav","cem64_h.wav","cem67_h.wav","cem69_h.wav","cem71_h.wav","cem74_h.wav",
    "akk57_h.wav","akk59_h.wav","akk62_h.wav","akk64_h.wav","akk67_h.wav","akk69_h.wav","akk71_h.wav","akk74_h.wav" 
//    "vib69_h.wav","vib71_h.wav","vib74_h.wav","vib76_h.wav","vib79_h.wav","vib81_h.wav","vib83_h.wav","vib86_h.wav",    
    
};

public double[][][] ton;

Label label;

public void setup()
{
  
  
    initialisieren();
    
    //Initialisierungen f\u00fcr Rasterplayer
    raster = new int[ZEILEN][SPALTEN];
            
    rasterplayer = new Rasterplayer(raster, BPM); //aus raster wird breite und H\u00f6he extrahiert.
    
    //ton = ladeWav("xyl69_h.wav",rasterplayer.benoetigteSampleanzahl()); //Es wird nur ein Abschnitt geladen, wie maximal gebraucht wird. Bis eine Sekunde steht zur Verf\u00fcgung.
    
    ton = new double[tonnamen.length][][];
    for(int i=0;i<tonnamen.length;i++)    
        ton[i] = ladeWav(tonnamen[i],rasterplayer.benoetigteSampleanzahl());
    
    
    zeitsteueurung = new Zeitsteuerung(rasterplayer); //Rasterplayer wird bei der Zeitsteuerung registriert!
    
    //public Label(PApplet pap, int ZEILEN, int SPALTEN, int XOFF, int YOFF,
    //             int PANEL_BREITE, int PANEL_HOEHE, int TEXT_MAXLAENGE)
    
    label =     new Label(this,ZEILEN*2,SPALTEN/4, QX+RASTERB*2, QY-RASTERH/3,
                 QB, QH, 17);
    //add(String bezeichnung, String beschriftung, int zeile, int spalte)                 
    label.add("gk","KIBA by G.Kramann",ZEILEN,SPALTEN/8-1);             

    
    frameRate(24);
}

public void draw()
{
    zeichneHintergrund();
    zeichneBedienelemente();
    zeichneRastermarker();
    label.draw();
    zeichneRaster();
    zeichneZaehlzeit();
    zeichneGegriffenenChip();
}
public void zeichneBedienelemente()
{
    noStroke();
    for(int i=0;i<kreisfarben.length;i++)
    {
         //Kreise mit Plus-Symbolen links
         fill(kreisfarben[i][0],kreisfarben[i][1],kreisfarben[i][2]);
         ellipse(RASTERMITTEX[0],RASTERMITTEY[i],RASTERB,RASTERH);
         
         fill(0);
         rect(RASTERX[0]+LINIENDICKE/2,RASTERMITTEY[i]-LINIENDICKE/2,RASTERB-LINIENDICKE,LINIENDICKE);
         rect(RASTERMITTEX[0]-LINIENDICKE/2,RASTERY[i]+LINIENDICKE/2,LINIENDICKE,RASTERH-LINIENDICKE);
         
         //Kreise mit Minus-Symbolen rechts
         fill(kreisfarben[i][0],kreisfarben[i][1],kreisfarben[i][2]);
         ellipse(RASTERMITTEX[SPALTEN+1],RASTERMITTEY[i],RASTERB,RASTERH);
         
         fill(0);
         rect(RASTERX[SPALTEN+1]+LINIENDICKE/2,RASTERMITTEY[i]-LINIENDICKE/2,RASTERB-LINIENDICKE,LINIENDICKE);
         
    }
    
    //Rechts unten Minus-Kreis zeichnen, mit dem alle Elemente entfernt werden k\u00f6nnen.
    fill(grau[0],grau[1],grau[2]);
    ellipse(RASTERMITTEX[SPALTEN+1],RASTERMITTEY[kreisfarben.length],RASTERB,RASTERH);
         
    fill(0);
    rect(RASTERX[SPALTEN+1]+LINIENDICKE/2,RASTERMITTEY[kreisfarben.length]-LINIENDICKE/2,RASTERB-LINIENDICKE,LINIENDICKE);
    
}

/**
*    Die nachfolgenden Operationen werden alle                                 <br/>
*    im Verzeichnis "data" unterhalb des aktuellen Sketches ausgef\u00fchrt.        <br/>
*    Die Methoden funktionieren unter Java am PC und mit einem Android-Device. <br/>
*    Das Verzeichnis "data" mu\u00df von Hand angelegt werden.                      <br/>
*/
public class Data
{
    private PApplet pap;
    public Data(PApplet pap)
    {
        this.pap = pap;
    }
    
    /**
    * Ausgangspunkt bilden die Processing-eigenen Datei-Operationen.
    */
    public byte[] ladeBinaer(String dateiname)
    {
        return pap.loadBytes(dateiname);
    }
    public String[] ladeZeilen(String dateiname)
    {
        return pap.loadStrings(dateiname);
    }
    public PImage ladeBild(String dateiname)
    {
        return pap.loadImage(dateiname);
    }
    public PFont ladeFont(String dateiname)
    {
        return pap.loadFont(dateiname);
    }

    public void speicherBinaer(String dateiname, byte[] bytes)
    {
        pap.saveBytes(dateiname,bytes);
    }
    public void speicherZeilen(String dateiname, String[] zeilen)
    {
        pap.saveStrings(dateiname,zeilen);
    }
    
    /**
    * Die nachfolgenden Methoden sind Erweiterungen der Processing-eigenen Datei-Operationen.<br/>
    * ...darum das vorangestellte x.
    */
    public double[][] xladeDoubleMatrix(String dateiname)
    {
        String[] zeilen = ladeZeilen(dateiname);
        double[][] matrix = new double[zeilen.length][];
        for(int i=0;i<matrix.length;i++)
        {
            int anfang=0;
            int ende=0;
            int anz=0;
            zeilen[i]=zeilen[i].trim();
            for(int k=0;k<zeilen[i].length();k++)
            {
                while(k<zeilen[i].length() && !Character.isWhitespace(zeilen[i].charAt(k)))
                {
                    k++;
                }
                while(k<zeilen[i].length() && Character.isWhitespace(zeilen[i].charAt(k)))
                {
                    k++;
                }
                k--;
                anz++;
            }
            matrix[i]=new double[anz];
            anz=0;
            for(int k=0;k<zeilen[i].length();k++)
            {
                anfang=k;
                while(k<zeilen[i].length() && !Character.isWhitespace(zeilen[i].charAt(k)))
                {
                    k++;
                }
pap.println("Zerlegen:"+zeilen[i].substring(anfang,k));
                matrix[i][anz]=Double.parseDouble(zeilen[i].substring(anfang,k));
                while(k<zeilen[i].length() && Character.isWhitespace(zeilen[i].charAt(k)))
                {
                    k++;
                }
                k--;
                anz++;
            }
        }
        return matrix;
    }

    public int[][] xladeIntegerMatrix(String dateiname)
    {
        double[][] mat = xladeDoubleMatrix(dateiname);    
        int[][] matrix = new int[mat.length][];
        for(int i=0;i<mat.length;i++)
        {
            matrix[i]=new int[mat[i].length];
            for(int k=0;k<mat[i].length;k++)
                matrix[i][k]=(int)mat[i][k];
        }
        return matrix;
    }

    public void xspeicherDoubleMatrix(String dateiname, double[][] matrix)
    {
        String[] zeilen = new String[matrix.length];
        for(int i=0;i<matrix.length;i++)
        {
            StringBuffer sb = new StringBuffer();
            for(int k=0;k<matrix[i].length;k++)
            {
                sb.append(matrix[i][k]);
                sb.append(" ");
            }
            zeilen[i]=sb.toString();
        }
        speicherZeilen(dateiname,zeilen);
    }

    public void xspeicherIntegerMatrix(String dateiname, int[][] matrix)
    {
        String[] zeilen = new String[matrix.length];
        for(int i=0;i<matrix.length;i++)
        {
            StringBuffer sb = new StringBuffer();
            for(int k=0;k<matrix[i].length;k++)
            {
                sb.append(""+matrix[i][k]);
                sb.append(" ");
            }
            zeilen[i]=sb.toString();
        }
        speicherZeilen(dateiname,zeilen);
    }

    /**
    *   Bin\u00e4rdaten lesbar anzeigen in 10-er Reihen.
    */
    public void zeigeBinaer(byte[] dat, int max)
    {
        if(max>dat.length)
            max=dat.length;
        for(int i=0;i<max;i++)
        {
            if(i>0 && i%10==0)
                System.out.println();
            System.out.print((int)dat[i]+" ");
        }
    }
}


/**
* Hilfsklasse, die beschreibt, wie ein Zeichen dargestellt wird.
*/
public class Hzeichen
{
  
    private PApplet pap;
//    private float breite = 30.0f;
//    private float hoehe  = 70.0f;
    private float breite = 1.0f;
    private float hoehe  = 1.0f;
    
    private float real_breite = breite;
    private float real_hoehe  = hoehe;
    
    private float xscale  = real_breite/breite;
    private float yscale  = real_hoehe/hoehe;
    private float mscale  = 0.5f*(xscale+yscale);
    
    private float stiftbreite = 2.0f;
    public float real_stiftbreite = 2.0f;
    
    public float xraster = real_breite/3.0f;
    public float yraster = real_hoehe/8.0f;
    
    public Hzeichen(PApplet pap, float real_breite, float real_hoehe)
    {
        this.pap = pap; 
        
        this.real_breite = real_breite;
        this.real_hoehe = real_hoehe;
        this.xscale  = real_breite/breite;
        this.yscale  = real_hoehe/hoehe;
        this.mscale  = 0.5f*(xscale+yscale)/20.0f;
        this.real_stiftbreite = stiftbreite*mscale;
        this.xraster = real_breite/3.0f;
        this.yraster = real_hoehe/7.0f;
//println("real_breite="+real_breite);        
//println("real_hoehe="+real_hoehe);        
//println("xraster="+xraster);        
//println("yraster="+yraster);        
    }   

    public void linie(int x1,int y1, int x2, int y2, float xoff, float yoff)
    {
        pap.line(
                     xoff+0.5f*xraster+(float)x1*xraster,   
                     yoff             +(float)y1*yraster,   
                     xoff+0.5f*xraster+(float)x2*xraster,   
                     yoff             +(float)y2*yraster   
                );
    }


    public void bogen1(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+0.5f*xraster+xraster*(float)x1;
         float my = yoff+yraster*(float)y1;
         pap.arc(mx,my,xraster*2.0f,yraster*2.0f,0,pap.HALF_PI);
    }

    public void bogen2(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff-xraster+xraster*0.5f+xraster+xraster*(float)x1;
         float my = yoff+yraster+yraster*(float)y1;
         pap.arc(mx,my,xraster*2.0f,yraster*2.0f,pap.PI+pap.HALF_PI,pap.TWO_PI);
    }

    public void bogen3(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+xraster*0.5f+xraster+xraster*(float)x1;
         float my = yoff+yraster+yraster*(float)y1;
         pap.arc(mx,my,xraster*2.0f,yraster*2.0f,pap.PI,pap.PI+pap.HALF_PI);
    }
    
    public void bogen4(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+0.5f*xraster+xraster+xraster*(float)x1;
         float my = yoff+yraster*(float)y1;
         pap.arc(mx,my,xraster*2.0f,yraster*2.0f,pap.HALF_PI,pap.PI);
    }

//--

    public void Bogen1(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+0.5f*xraster+xraster*(float)x1;
         float my = yoff+yraster*(float)y1;
         pap.arc(mx,my,xraster*4.0f,yraster*4.0f,0,pap.HALF_PI);
    }

    public void Bogen2(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff-xraster+xraster*0.5f+xraster+xraster*(float)x1;
         float my = yoff+2.0f*yraster+yraster*(float)y1;
         pap.arc(mx,my,xraster*4.0f,yraster*4.0f,pap.PI+pap.HALF_PI,pap.TWO_PI);
    }

    public void Bogen3(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+xraster+xraster*0.5f+xraster+xraster*(float)x1;
         float my = yoff+2.0f*yraster+yraster*(float)y1;
         pap.arc(mx,my,xraster*4.0f,yraster*4.0f,pap.PI,pap.PI+pap.HALF_PI);
    }
    
    public void Bogen4(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+0.5f*xraster+2.0f*xraster+xraster*(float)x1;
         float my = yoff+yraster*(float)y1;
         pap.arc(mx,my,xraster*4.0f,yraster*4.0f,pap.HALF_PI,pap.PI);
    }

    public void punkt(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+0.05f*xraster+xraster*(float)x1;
         float my = yoff-1.0f*yraster+yraster*(float)y1;
         pap.ellipse(mx,my,xraster*0.3f,yraster*0.3f);
    }


    public void testraster(float xoff, float yoff)
    {
         for(int i=0;i<8;i++)
           pap.line(xoff+xraster*0.5f,yoff+(float)i*yraster,xoff+xraster*0.5f+xraster*2.0f,yoff+(float)i*yraster);
         for(int i=0;i<3;i++)
           pap.line(xoff+xraster*0.5f+(float)i*xraster,yoff,xoff+xraster*0.5f+(float)i*xraster,yoff+7.0f*yraster);
    }
           
    public void draw(char c, int zeile, int spalte)
    {
         float xoff = (float)spalte*real_breite;
         float yoff = (float)zeile*real_hoehe+yraster*0.5f;
         
//translate(100,100);    
//scale(10);
         for(int i=0;i<b.length;i++)
         {
             if(b[i][0].charAt(0)==c && b[i][1].length()==4)
             {
                 for(int k=1;k<b[i].length;k++)
                 {
                      if(b[i][k].charAt(0)=='B')
                      {
                          int xx = (int)b[i][k].charAt(2)-48;
                          int yy = (int)b[i][k].charAt(3)-48;
                          
                          if(b[i][k].charAt(1)=='1')
                              Bogen1(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='2')
                              Bogen2(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='3')
                              Bogen3(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='4')
                              Bogen4(xx,yy,xoff,yoff);
                              
                      }
                      else if(b[i][k].charAt(0)=='b')
                      {
                          int xx = (int)b[i][k].charAt(2)-48;
                          int yy = (int)b[i][k].charAt(3)-48;
                          
                          if(b[i][k].charAt(1)=='1')
                              bogen1(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='2')
                              bogen2(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='3')
                              bogen3(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='4')
                              bogen4(xx,yy,xoff,yoff);
                              
                      }
                      else if(b[i][k].charAt(0)=='d')
                      {
                          int xx = (int)b[i][k].charAt(2)-48;
                          int yy = (int)b[i][k].charAt(3)-48;
                          float dx = 0.0f;
                          float dy = 0.0f;
                          if(b[i][k].charAt(1)=='0') { dx=0.0f; dy=0.0f; }
                          if(b[i][k].charAt(1)=='1') { dx=0.5f*xraster; dy=0.0f*yraster; }
                          if(b[i][k].charAt(1)=='2') { dx=1.0f*xraster; dy=0.0f*yraster; }
                          if(b[i][k].charAt(1)=='3') { dx=0.0f*xraster; dy=0.5f*yraster; }
                          if(b[i][k].charAt(1)=='4') { dx=0.5f*xraster; dy=0.5f*yraster; }
                          if(b[i][k].charAt(1)=='5') { dx=1.0f*xraster; dy=0.5f*yraster; }
                          if(b[i][k].charAt(1)=='6') { dx=0.0f*xraster; dy=1.0f*yraster; }
                          if(b[i][k].charAt(1)=='7') { dx=0.5f*xraster; dy=1.0f*yraster; }
                          if(b[i][k].charAt(1)=='8') { dx=1.0f*xraster; dy=1.0f*yraster; }

                          punkt(xx,yy,xoff+dx,yoff+dy);                                                        
                      }
                      else
                      {
                          int x1 = (int)b[i][k].charAt(0)-48;
                          int y1 = (int)b[i][k].charAt(1)-48;
                          int x2 = (int)b[i][k].charAt(2)-48;
                          int y2 = (int)b[i][k].charAt(3)-48;
                          linie(x1,y1,x2,y2,xoff,yoff);
                      }
                 }
             }
         }         
//scale(1.0f/10.0f);
//translate(-100,-100);         
    }

    /**
    *Definition aller Buchstaben
    *abcd 0122 3453 Linien
    *B100 B234 .. B\u00f6gen gross
    *b100 b234 .. B\u00f6gen klein
    */
    private String[][] b = {
                               {"A","2125","0323","0305","B301"},
                               {"B","0105","0111","0313","0515","b211","b112","b213","b114"},
                               {"C","B301","B403"},
                               {"D","B201","B103","0105"},
                               {"E","0121","0323","0525","0105"},
                               {"F","0121","0323","0105"},
                               {"G","B301","B403","2325","1323"},
                               {"H","0323","0105","2125"},
                               {"I","0121","0525","1115"},
                               {"J","0121","2125","b115","b405"},
                               {"K","0321","0325","0105"},
                               {"L","0525","0105"},
                               {"M","0205","1115","2125","b301","b311"},
                               {"N","0205","b301","1115","b114","2124"},
                               {"O","b301","b211","0204","2224","b114","b404"},                               
                               {"P","0105","0111","0313","b211","b112"},
                               {"Q","b301","b211","0204","2224","b114","b404","1425"},
                               {"R","0105","0111","0313","b211","b112","0325"},
                               {"S","b211","b301","b402","b213","b114","b404"},
                               {"T","0121","1115"},
                               {"U","0104","2124","b114","b404"},
                               {"V","0103","2125","B403"},
                               {"W","0104","1215","2125","b404","b414"},
                               {"X","0125","0521"},
                               {"Y","0521","0113"},
                               {"Z","0121","0525","0521"},
                               
                               {"a","b114","b213","b303","b404","2325"},                               
                               {"b","b114","b213","b303","b404","0105"},
                               {"c","b303","b404","1323","1525"},
                               {"d","b114","b213","b303","b404","2125"},
                               {"e","b213","b303","b404","0424"},
                               {"f","b105","1215","b311","0323"},
                               {"g","b114","b213","b303","b404","2326","b116","b406"},
                               {"h","0105","2425","b213","b303"},
                               {"i","1315","1112"},
                               {"j","1315","1112","b105"},
                               //{"k","b303","b404","1323","1525","0105"},
                               {"k","0423","0425","0105"},
                               {"l","1114","b414"},
                               {"m","0305","1315","2325","b303","b313"},
                               {"n","0305","2425","b303","b213"},
                               {"o","b114","b213","b303","b404"},
                               {"p","b114","b213","b303","b404","0307"},
                               {"q","b114","b213","b303","b404","2327"},
                               {"r","0305","b303","1323"},
                               {"s","b303","1323","0424","b114","0515"},
                               {"t","1114","b414","0222"},
                               {"u","b404","b114","0304","2324"},
                               {"v","0315","1523"},
                               {"w","0304","1315","2325","b404","b414"},
                               {"x","0325","0523"},
                               {"y","b404","b114","0304","2324","2326","b116","b406"},
                               {"z","0323","0525","0523"},
                               
                               {"0","b301","b211","b404","b114","0204","2224","0422"},
                               {"1","1115","0211"},
                               {"2","b301","b211","2205","0525"},
                               {"3","b301","b211","b404","b114","b112","b213"},
                               {"4","0411","0424","1315"},
                               {"5","0121","0103","0313","0515","b213","b114"},
                               {"6","b114","b213","b303","b404","0403","B301"},
                               {"7","0121","2105","0323"},
                               {"8","b114","b213","b303","b404","b112","b211","b301","b402"},
                               {"9","b112","b211","b301","b402","2223","B103"},
                               
                               {".","d715"},
                               {",","b106"},
                               {";","d715","b106"},
                               {":","d712","d714"},
                               {"?","b301","b211","b112","b303","b404","b114","d716"},
                               {"!","1114","d715"},
                               {"+","0323","1214"},
                               {"-","0323"},
                               {"*","d114"},
                               {"/","0521"},
                               
                               {"\u00e4","b114","b213","b303","b404","2325","d203","d213"},                               
                               {"\u00f6","b114","b213","b303","b404","d203","d213"},
                               {"\u00fc","b404","b114","0304","2324","2325","d203","d213"},

                               {"\u00c4","2125","0323","0305","B301","2325","d201","d211"},
                               {"\u00d6","b301","b211","0204","2224","b114","b404","d201","d211"},                               
                               {"\u00dc","0104","2124","b114","b404","2325","d201","d211"},

                               {">","0105","0123","0523"},
                               {"<","2125","2103","2503"},
                               {"^","0411","2411","0424"},
                               {"|","0215","2215","0222"},
                               {"#","0204","0222","0424","2224"}
                               
                           };
    
}


/**
*   L\u00e4dt alle Dateien aus data mit dem Prefix infotext und stellt sie bei 
*   Bedarf mit Hilfe der draw-Methode dar.
*/
public class Infotext
{
    private PApplet pap;
    private Data data;
    private Knopf knopf;

    public ArrayList<Xtext> infos;
    public int SEITE;
    public boolean AKTIV;

    public int zzz_max=0;
    public int mmm_max=0;

    /**
    *    Die Dateien hinter den \u00fcbergebenen Dateinamen werden aus dem Ordner data heraus geladen.
    */
    public Infotext(PApplet pap, String[] dateinamen)
    {
        this.pap = pap;
        data = new Data(pap);

        infos = new ArrayList<Xtext>(); 
        SEITE=0;
        AKTIV=false;

        for(int i=0;i<dateinamen.length;i++)
        {
            String[] zeilen = data.ladeZeilen(dateinamen[i]);
            //pap.println(i+". Datei:");
            //for(int k=0;k<zeilen.length;k++)
            //{
            //    pap.println(zeilen[k]);
            //}
            //Aufbereiten f\u00fcr Xtext:
            StringBuffer sb = new StringBuffer();
            int MAX=0;         
            for(int k=0;k<zeilen.length;k++)
                if(zeilen[k].length()>MAX)
                    MAX=zeilen[k].length();

            int zzz = zeilen.length;
            int mmm = MAX;
            if(zzz<5) zzz=5;
            if(mmm<15) mmm=15;
            zzz++;

            if(zzz>zzz_max) zzz_max = zzz;
            if(mmm>mmm_max) mmm_max = mmm;

            for(int k=0;k<zzz;k++)
            {
                for(int p=0;p<mmm;p++)
                {
                    if(k<zeilen.length && p<zeilen[k].length())
                    {
                        char c = zeilen[k].charAt(p);
                        if(Character.isWhitespace(c))
                            sb.append('_');
                        else
                            sb.append(c);
                    }
                    else
                    {
                            sb.append(' ');
                    }
                }
            }
//    public Xtext(PApplet pap, float XOFF, float YOFF, float WIDTH, float HEIGHT, int zeilen, int spalten, int[] farbe)
 


            Xtext xtext = new Xtext(pap,0,0,pap.width,pap.height,zzz,mmm,new int[] {0,0,0});
            xtext.setzeTextNeu(sb.toString());
            infos.add(xtext);
        }       

        knopf = new Knopf(pap,zzz_max,5);
        knopf.add(zzz_max-1,2,"AKTIV","O.K.","O.K.");

        pap.println("infos.size()=="+infos.size()); 
    }    

    public boolean istAktiv()
    {
        return AKTIV;
    }
    public void setzeAktiv()
    {
        SEITE=0;
        AKTIV=true;
    }

    /**
    *   ...wird im PApplet als letztes aufgerufen, um alles andere zu \u00fcberdecken!
    */
    public void draw()
    {
        if(AKTIV && infos!=null && infos.size()>0 && SEITE>=0 && SEITE<infos.size())
        {             
            //pap.println("SEITE="+SEITE);
            Xtext xtext = infos.get(SEITE);
            xtext.draw();                       
            knopf.draw();
        }
    }

    /**
    *  aus PApplet-Methode mousePressed() heraus aufrufen zum umbl\u00e4ttern
    */
    public void mousePressed()
    {
        knopf.mousePressed();
        if(knopf.getZustand("AKTIV")==true)
        {
            knopf.setZustand("AKTIV",false);
            SEITE++;
            if(SEITE>=infos.size())
            {
                SEITE=0;
                AKTIV=false;
            }
        }
    }    
}
public void initialisieren()
{
    //Querformat erzwingen
    orientation(LANDSCAPE);
    //Volle Breite und H\u00f6he nutzen
    size(displayWidth,displayHeight);

    QH=displayHeight;
    QB=displayHeight;
    QY=0;
    QX=(displayWidth-QB)/2;  
    
    //Koordinaten f\u00fcr Rasterung vorausberechnen
    
    RASTERB = QB/SPALTEN;
    RASTERH = QH/ZEILEN;
    
    RASTERX = new int[SPALTEN+2];
    RASTERY = new int[ZEILEN];
    RASTERMITTEX = new int[SPALTEN+2];
    RASTERMITTEY = new int[ZEILEN];
    
    for(int i=0;i<SPALTEN+2;i++)
        RASTERX[i]=QX-QB/SPALTEN+i*RASTERB;
    for(int i=0;i<ZEILEN;i++)
        RASTERY[i]=QY+i*RASTERH;
    for(int i=0;i<SPALTEN+2;i++)
        RASTERMITTEX[i]=RASTERX[i]+RASTERB/2;
    for(int i=0;i<ZEILEN;i++)
        RASTERMITTEY[i]=RASTERY[i]+RASTERH/2;
    LINIENDICKE = RASTERB/10;       
}

public void zeichneHintergrund()
{
    clear();
    //Hintergrund zeichnen
    noStroke();
    fill(hintegrundfarbe[0],hintegrundfarbe[1],hintegrundfarbe[2]);
    rect(0,0,displayWidth,displayHeight);
    fill(hintegrundfarbemitte[0],hintegrundfarbemitte[1],hintegrundfarbemitte[2]);
    rect(QX,QY,QB,QH);  
}
public boolean setzeChip(int zeile, int spalte,int farbe)
{
     if(raster[zeile][spalte]==0) //wenn erlaubt
     {
         raster[zeile][spalte]=farbe+1;
         return true;
     }
     else
     {
         return false;
     }
}

public boolean entferneChip(int zeile, int spalte,int farbe)
{
     if(raster[zeile][spalte]==farbe+1) //wenn erlaubt
     {
         raster[zeile][spalte]=0;
         return true;
     }
     else
     {
         return false;
     }
}

public boolean loescheFarbe(int farbe)
{
      boolean gefunden = false;
      for(int i=0;i<ZEILEN;i++)
          for(int k=0;k<SPALTEN;k++)
              if(raster[i][k]==farbe+1)
              {
                  gefunden = true;
                  raster[i][k]=0;
              }
      return gefunden;        
}

public boolean loescheAlles()
{
      boolean gefunden = false;
      for(int i=0;i<ZEILEN;i++)
          for(int k=0;k<SPALTEN;k++)
              if(raster[i][k]>0)
              {
                  raster[i][k]=0;
                  gefunden = true;
              }    
      return gefunden;        
}

/**
*   Wenn mit dem Finger \u00fcber die Glasfl\u00e4che gezogen wird, dann k\u00f6nnte ein Chip damit geholt und auf das Spielfeld bewegt werden.
*/
public void mouseDragged() 
{
     int x = mouseX;
     int y = mouseY;
     if(GEGRIFFEN==0) //ggf. etwas vom linken Rand greifen
     {
         //Holen eines neuen Chips aus dem Depot:
         for(int i=0;i<kreisfarben.length;i++)
         {
               if(x>RASTERX[0] && x<RASTERX[0]+RASTERB && y>RASTERY[i] && y<RASTERY[i]+RASTERH)
               {
                   GEGRIFFEN = i+1;
                   break;
               }
         }
         
         //Entfernen eines einzelnen Chips vom Raster:
         for(int i=0;i<ZEILEN;i++)
         {
           for(int k=0;k<SPALTEN;k++)
           {
                   if(x>RASTERX[k+1] && x<RASTERX[k+1]+RASTERB && y>RASTERY[i] && y<RASTERY[i]+RASTERH
                     && raster[i][k]>0)
                   {
                        GEGRIFFEN=raster[i][k];
                        raster[i][k]=0;
                   }
           }
         }
     }          
}

/**
*   Wenn nach Ziehen \u00fcber das Glas die Finger wieder gehoben wird,
*   soll GEGRIFFEN wieder zur\u00fcckgesetzt werden und ggf. der Chip im Spielfeld eingetragen werden.
*/
public void mouseReleased()
{
    int x = mouseX;
    int y = mouseY;
    
    if(GEGRIFFEN>0)
    {
      for(int i=0;i<ZEILEN;i++)
      {
        for(int k=0;k<SPALTEN;k++)
        {
               if(x>RASTERX[k+1] && x<RASTERX[k+1]+RASTERB && y>RASTERY[i] && y<RASTERY[i]+RASTERH
                  && raster[i][k]==0)
               {
                    raster[i][k]=GEGRIFFEN;
               }
        }
      }
      GEGRIFFEN = 0;    
    }
    else
    {
      //Alle Chips einer Farbe, oder auch alles entfernen, wenn der entsprechende Knopf gedr\u00fcckt wird.
      if(x>RASTERX[SPALTEN+1] && x<RASTERX[SPALTEN+1]+RASTERB)
      {
        for(int i=0;i<kreisfarben.length;i++)
        {
            if(y>RASTERY[i] && y<RASTERY[i]+RASTERH)
            {
                loescheFarbe(i);
            }
        }
        if(y>RASTERY[kreisfarben.length] && y<RASTERY[kreisfarben.length]+RASTERH)
            loescheAlles();
      }
    }
}


/**
*   Eventuell gerade gegriffenen Chip zeichnen
*/
public void zeichneGegriffenenChip()
{
    if(GEGRIFFEN>0)
    {
        noStroke();
        fill(kreisfarben[GEGRIFFEN-1][0],kreisfarben[GEGRIFFEN-1][1],kreisfarben[GEGRIFFEN-1][2]);
        ellipse(mouseX,mouseY,RASTERB,RASTERH);        
    }
}





/**
* Schaltkn\u00f6pfe, die ihre Beschriftung und Farbe bei einer
* Zustands\u00e4nderung wechseln k\u00f6nnen.
* Abfrage des Zustands erfolgt \u00fcber den Button-Namen.
*/
public class Knopf
{
    private int HEIGHT;

    private int ZEILEN=8;
    private int SPALTEN=4;

    private int XOFF,YOFF,BREITE,HOEHE,PADDINGX,PADDINGY;

    private PApplet pap;

    public ArrayList<int[]> an_farbe;
    public ArrayList<int[]> aus_farbe;
    public ArrayList<String> knopfname;
    public ArrayList<String> an_beschriftung;
    public ArrayList<String> aus_beschriftung;
    public ArrayList<int[]> knopfbounds; //x,y,breite,hoehe
    public ArrayList<boolean[]> knopfzustand; 
    public ArrayList<boolean[]> knopf_mouseover; 

    public ArrayList<Xtext> beschriftung; 

    private int anzahl;

    private int PANEL=0;

    public void initialisieren()
    {
        this.HEIGHT = pap.height;
        an_farbe = new ArrayList<int[]>();
        aus_farbe = new ArrayList<int[]>();
        knopfname = new ArrayList<String>();
        an_beschriftung = new ArrayList<String>();
        aus_beschriftung = new ArrayList<String>();
        knopfbounds = new ArrayList<int[]>();
        knopfzustand = new ArrayList<boolean[]>();
        knopf_mouseover = new ArrayList<boolean[]>();

        beschriftung = new ArrayList<Xtext>();

        anzahl=0;
 
        XOFF = pap.width/20;
        YOFF = pap.height/20;
        BREITE = (pap.width  - XOFF - XOFF)/SPALTEN;
        HOEHE  = (pap.height - YOFF - YOFF)/ZEILEN;
        PADDINGX = 1+pap.width/100;
        PADDINGY = 1+pap.height/100;
    }

    public void initialisieren(int ZEILEN, int SPALTEN, int XOFF, int YOFF,int PANEL_BREITE, int PANEL_HOEHE)
    {
        this.PANEL=1;
        this.HEIGHT = PANEL_HOEHE;
        an_farbe = new ArrayList<int[]>();
        aus_farbe = new ArrayList<int[]>();
        knopfname = new ArrayList<String>();
        an_beschriftung = new ArrayList<String>();
        aus_beschriftung = new ArrayList<String>();
        knopfbounds = new ArrayList<int[]>();
        knopfzustand = new ArrayList<boolean[]>();
        knopf_mouseover = new ArrayList<boolean[]>();

        beschriftung = new ArrayList<Xtext>();

        anzahl=0;
 
        this.ZEILEN = ZEILEN;
        this.SPALTEN = SPALTEN;
        this.XOFF = XOFF;
        this.YOFF = YOFF;
        this.BREITE = (PANEL_BREITE)/SPALTEN;
        this.HOEHE  = (PANEL_HOEHE)/ZEILEN;

        PADDINGX = 1+this.BREITE/100;
        PADDINGY = 1+this.HOEHE/100;
    }

    public Knopf(PApplet pap)
    {
        this.pap = pap;        
        initialisieren();
    }
    public Knopf(PApplet pap,int ZEILEN, int SPALTEN)
    {
        this.pap = pap;        
        this.ZEILEN=ZEILEN;
        this.SPALTEN = SPALTEN;
        initialisieren();
    }


    public Knopf(PApplet pap,int ZEILEN, int SPALTEN, int XOFF, int YOFF, int PANEL_BREITE, int PANEL_HOEHE)
    {
        this.pap = pap;        
        initialisieren(ZEILEN,SPALTEN,XOFF,YOFF,PANEL_BREITE,PANEL_HOEHE);
    }

    private int name2index(String name)
    {
        for(int i=0;i<anzahl;i++)
            if(name.equals(knopfname.get(i)))
                return i;
        return -1;
    }

    public void setZustand(String name, boolean zustand)
    {
        setZustand(name2index(name),zustand);
    }
    public void setZustand(int nr,boolean zustand)
    {
        if(nr<0 || nr>=anzahl) return;
        boolean[] z = knopfzustand.get(nr);
        z[0]=zustand;    
    }
    public boolean getZustand(String name)
    {
        return getZustand(name2index(name));
    }
    public boolean getZustand(int nr)
    {
        if(nr<0 || nr>=anzahl) return false;
        boolean[] z = knopfzustand.get(nr);
        return z[0];    
    }

    public void add(String name, String an_b, String aus_b, int[] an_f, int[] aus_f,
                    int x, int y, int breite, int hoehe, boolean zust)
    {
        int[] an_farbe_neu = new int[] {an_f[0],an_f[1],an_f[2]};
        an_farbe.add(an_farbe_neu);
        int[] aus_farbe_neu = new int[] {aus_f[0],aus_f[1],aus_f[2]};
        aus_farbe.add(aus_farbe_neu);
        knopfname.add(name);

        int[] b = new int[] {x,y,breite,hoehe};
        knopfbounds.add(b);
        boolean[] z = new boolean[] {zust};
        knopfzustand.add(z);
        knopf_mouseover.add(new boolean[] {false});

     //public Xtext(PApplet pap, float XOFF, float YOFF, float WIDTH, float HEIGHT, int zeilen, int spalten, int[] farbe)

        int laenge = an_b.length();
        if(aus_b.length()>laenge)
            laenge=aus_b.length();
        Xtext xt = new Xtext(pap,x+PADDINGX,y-hoehe+PADDINGY+HEIGHT/50+(hoehe*14)/50,breite-PADDINGX*2,(hoehe*4)/5-PADDINGY*2,1,an_b.length(),new int[] {0,0,0});

        //Beide gleich lang machen, Unterstriche einsetzen:
        char[] an_bb = an_b.toCharArray();
        char[] aus_bb = aus_b.toCharArray();
        char[] an_bbb = an_bb;
        char[] aus_bbb = aus_bb;
        if(an_bb.length>=aus_bb.length)
        {
            aus_bbb=new char[an_bb.length];
            an_bbb=new char[an_bb.length];
        }
        else if(aus_bb.length>an_bb.length)
        {
            an_bbb=new char[aus_bb.length];
            aus_bbb=new char[aus_bb.length];
        }

        for(int i=0;i<aus_bbb.length;i++)
        {
            an_bbb[i]='_';
            aus_bbb[i]='_';
            if(i<an_bb.length && !Character.isWhitespace(an_bb[i]))
                an_bbb[i]=an_bb[i];
            if(i<aus_bb.length && !Character.isWhitespace(aus_bb[i]))
                aus_bbb[i]=aus_bb[i];
        }    
         
        an_b = new String(an_bbb);
        aus_b = new String(aus_bbb);
        //System.out.println("an_b:  "+an_b);
        //System.out.println("aus_b: "+an_b);
        //Ende gleich lang machen
        an_beschriftung.add(an_b);
        aus_beschriftung.add(aus_b);
 
        if(zust==true)
            xt.setzeTextNeu(an_b);
        else
            xt.setzeTextNeu(aus_b);

        beschriftung.add(xt);
        
        anzahl++;
    }

    public void add()
    {
        String name = "k"+anzahl;
        String an_b = "ON_";
        String aus_b = "OFF";
        int[] an_f = new int[] {127,255,127};
        int[] aus_f = new int[] {127,127,255};
        int x = XOFF+(anzahl%SPALTEN)*BREITE;
        int y = YOFF+(anzahl/SPALTEN)*HOEHE;
        int breite=BREITE;
        int hoehe=HOEHE;
        boolean zust = false;

        add(name,an_b,aus_b,an_f,aus_f,
            x,y,breite,hoehe,zust);
    }

    public void add(int zeile, int spalte, String name, String an_b, String aus_b)
    {
        int[] an_f = new int[] {127,255,127};
        int[] aus_f = new int[] {127,127,255};
        int x = XOFF+(spalte)*BREITE;
        int y = YOFF+(zeile)*HOEHE;
        int breite=BREITE;
        int hoehe=HOEHE;
        boolean zust = false;
        add(name,an_b,aus_b,an_f,aus_f,
            x,y,breite,hoehe,zust);
    }

    public void add(int zeile, int spalte, String name, String an_b, String aus_b,
                    int[] an_f, int[] aus_f)
    {
        int x = XOFF+(spalte)*BREITE;
        int y = YOFF+(zeile)*HOEHE;
        int breite=BREITE;
        int hoehe=HOEHE;
        boolean zust = false;
        add(name,an_b,aus_b,an_f,aus_f,
            x,y,breite,hoehe,zust);
    }

    public void setzeTextNeuAn(int index, String text)
    {
        //Xtext xt = beschriftung.get(index);
        //xt.setzeTextNeu(text);
//        an_beschriftung.set(index,text);
        Xtext xt = beschriftung.get(index);
//        xt.setzeTextNeu(text);
//        xt.setText(text);
        xt.ersetzeText(text);
    }

    public void setzeTextNeuAn(String name, String text)
    {
        setzeTextNeuAn(name2index(name),text);
    }

    public void setzeTextNeuAus(int index, String text)
    {
        //Xtext xt = beschriftung.get(index);
        //xt.setzeTextNeu(text);
//        aus_beschriftung.set(index,text);
        Xtext xt = beschriftung.get(index);
//        xt.setzeTextNeu(text);
//        xt.setText(text);
        xt.ersetzeText(text);
    }

    public void setzeTextNeuAus(String name, String text)
    {
        setzeTextNeuAus(name2index(name),text);
    }

    /**
    *    in pap.mousePressed() aufrufen!
    */
    public void mousePressed()
    {
        int x = pap.mouseX;
        int y = pap.mouseY;
        for(int i=0;i<anzahl;i++)
        {
            int[] b = knopfbounds.get(i);
            if(x>b[0] && x<b[0]+b[2] && y>b[1] && y<b[1]+b[3])
            {
                boolean[] z = knopfzustand.get(i);
                z[0]=!z[0];
                Xtext xt = beschriftung.get(i);
                if(z[0]==true)
                    xt.setzeTextNeu(an_beschriftung.get(i));
                else
                    xt.setzeTextNeu(aus_beschriftung.get(i));
            }
        }
    }

    /**
    *    in pap.mouseMoved() aufrufen!
    */
    public void mouseMoved()
    {
        int x = pap.mouseX;
        int y = pap.mouseY;
        for(int i=0;i<anzahl;i++)
        {
            int[] b = knopfbounds.get(i);
            if(x>b[0] && x<b[0]+b[2] && y>b[1] && y<b[1]+b[3])
            {
                boolean[] z = knopf_mouseover.get(i);
                z[0]=true;
            }
            else
            {
                boolean[] z = knopf_mouseover.get(i);
                z[0]=false;
            }
        }
    }


    /**
    *    in pap.draw() aufrufen!
    */
    public void draw()
    {        
        for(int i=0;i<anzahl;i++)
        {
            Xtext xt = beschriftung.get(i);
            int[] b = knopfbounds.get(i);
            if(knopfzustand.get(i)[0]==true)
            {
                pap.fill(an_farbe.get(i)[0],an_farbe.get(i)[1],an_farbe.get(i)[2]);
                pap.noStroke();
                pap.rect(b[0]+PADDINGX,b[1]+PADDINGY,b[2]-PADDINGX*2,b[3]-PADDINGY*2);
                pap.stroke(0);
                pap.noFill();
                if(knopf_mouseover.get(i)[0]==true)
                {
                  pap.rect(b[0]+PADDINGX,b[1]+PADDINGY,b[2]-PADDINGX*2,b[3]-PADDINGY*2);
                }
            }
            else
            {
                pap.fill(aus_farbe.get(i)[0],aus_farbe.get(i)[1],aus_farbe.get(i)[2]);
                pap.noStroke();
                pap.rect(b[0]+PADDINGX,b[1]+PADDINGY,b[2]-PADDINGX*2,b[3]-PADDINGY*2);
                pap.stroke(0);
                pap.noFill();
                if(knopf_mouseover.get(i)[0]==true)
                {
                  pap.rect(b[0]+PADDINGX,b[1]+PADDINGY,b[2]-PADDINGX*2,b[3]-PADDINGY*2);
                }
            }
            xt.draw();
        }
    }
}


/**
* Beschriftungsflaeche
*/
public class Label
{
    private Knopf knopf;
    private int TEXT_MAXLAENGE;

    /**
    * eigener Panel-Bereich
    */
    public Label(PApplet pap, int ZEILEN, int SPALTEN, int XOFF, int YOFF,
                 int PANEL_BREITE, int PANEL_HOEHE, int TEXT_MAXLAENGE)
    {
        this.TEXT_MAXLAENGE=TEXT_MAXLAENGE;
        knopf = new Knopf(pap,ZEILEN,SPALTEN,XOFF,YOFF,PANEL_BREITE,PANEL_HOEHE);
    }

    /**
    * auf ganzes Fenster bezogen
    */
    public Label(PApplet pap, int ZEILEN, int SPALTEN, int TEXT_MAXLAENGE)
    {
        this.TEXT_MAXLAENGE=TEXT_MAXLAENGE;
        knopf = new Knopf(pap,ZEILEN,SPALTEN);
    }

    public void add(String bezeichnung, String beschriftung, int zeile, int spalte)
    {

        char[] b = new char[this.TEXT_MAXLAENGE];
        for(int i=0;i<b.length;i++)  //um die maximale Breite zu reservieren.
            b[i]='x';
        knopf.add(zeile,spalte,bezeichnung,new String(b),beschriftung,
//                    new int[] {200,200,255}, new int[] {200,200,255});
//                    new int[] {255,255,255}, new int[] {255,255,255}); //weisser Hintergrund, wie App
                    hintegrundfarbemitte, hintegrundfarbemitte); //Hintergrund, wie Spielfeld

    }

    public void setzeTextNeu(String name, String text)
    {
        knopf.setzeTextNeuAus(name,text);
    }

    public void setzeTextNeu(int index, String text)
    {
        knopf.setzeTextNeuAus(index,text);
    }

    public void draw()
    {
        knopf.draw();
    }
}


//Farben der verf\u00fcgbaren Kreise:
int[][] kreisfarben = {
                          {255,0,0},
                          {0,255,0},
                          {0,0,255}
                       };
//weitere Farben
int[] hintegrundfarbe = {200,200,255};
int[] hintegrundfarbemitte = {200,255,200};
int[] grau = {190,190,190};
int[] rot = {255,0,0};

//Position, Breite und H\u00f6he des Spielfeldquadrates in der Mitte
int QX,QY,QB,QH;

int ZEILEN = 8;
int SPALTEN = 8;

int[] RASTERX;
int[] RASTERY;

int[] RASTERMITTEX;
int[] RASTERMITTEY;

int RASTERB,RASTERH; //Raster Breite und H\u00f6he
int LINIENDICKE;

//Parameter f\u00fcr die Zeitsteuerung
int BPM=120; //Beats per Minute, Tempo in dem die "8tel" (Spielfeldspalten) durchlaufen werden.
int INDEX=0; //Aktuelle Position der Z\u00e4hlzeit (0..7 bei 8 Spalten)



//Zeichnet an den Docking-Stellen im Spielfeld kleine Kreise ein.
public void zeichneRastermarker()
{
     noStroke();
     fill(hintegrundfarbe[0],hintegrundfarbe[1],hintegrundfarbe[2]);
     for(int i=0;i<ZEILEN;i++)
         for(int k=0;k<SPALTEN;k++)
             ellipse(RASTERMITTEX[k+1],RASTERMITTEY[i],RASTERB/5,RASTERH/5);
}

/**
* Derzeit auf dem Spielfeld befindliche Chips darstellen
*/
public void zeichneRaster()
{
     noStroke();
     for(int i=0;i<ZEILEN;i++)
     {
         for(int k=0;k<SPALTEN;k++)
         {
             if(raster[i][k]>0)
             {
                 int farbe = raster[i][k]-1;
                 fill(kreisfarben[farbe][0],kreisfarben[farbe][1],kreisfarben[farbe][2]);
                 ellipse(RASTERMITTEX[k+1],RASTERMITTEY[i],RASTERB,RASTERH);
             }    
         }
     }     
}










/**
* Die Puffergr\u00f6\u00dfe wird so gro\u00df wie eine 8-Tel gew\u00e4hlt.
* Somit l\u00e4\u00dft sich das Schreiben in line gut mit der Zeitsteuerung synchronisieren.
*
* Jedesmal, wenn ein INDEX-Inkrement auftritt, wird ein stereo-double-puffer, der in 8-tel-Paketen aufgeteilt ist
* an der aktuellen Idex-Stelle und den nachfolgenden gef\u00fcllt.
* Bei allen au\u00dfer dem Letzten wird auf das Vorhandene aufaddiert (Nachklang).
* Beim Letzten wird dessen Inhalt zun\u00e4chst gel\u00f6scht.
*
* In dem Parameter NACHKLANG ist festgelegt, wieviele Bl\u00f6cke (8-tel) lang ein Ton klingt.
* 
*
*
*/

public class Rasterplayer
{
    private AudioTrack out;
    private byte[] puffer;
    private byte[] zwei = new byte[2];
    double gross = 0.5f*(255.0f*256.0f + 255.0f);
    
    //Pentatonische Frequenzen:
    //degah
    //a  h  d  e  g  a  h  d
    // 2  3  2  3   2  2  3
    double h=Math.pow(2.0f,1.0f/12.0f);
    double h2=h*h;
    double h3=h*h*h;
    double[] fpenta = {440.0f,440.0f*h2,440.0f*h2*h3,440.0f*h2*h3*h2,
                       440.0f*h2*h3*h2*h3,440.0f*h2*h3*h2*h3*h2,440.0f*h2*h3*h2*h3*h2*h2,440.0f*h2*h3*h2*h3*h2*h2*h3};
  
    //Paraneter f\u00fcr Rasterplayer
    int[][] raster;  //Spielfeld mit Eintr\u00e4gen der Tonereignisse.
    int NACHKLANG=3;
    int SAMPLERATE=44100;
    double dt = 1.0f/(double)SAMPLERATE;
    double t=0.0f;
    int PUFFERGROESSE; //Anzahl der Samples, die in einer 8-tel Platz haben.
    double[][] stereopuffer_links;
    double[][] stereopuffer_rechts;
  
    int SPALTEN,ZEILEN,BPM;

    public int benoetigteSampleanzahl()
    {
          return NACHKLANG*PUFFERGROESSE;
    }
  
    public Rasterplayer(int[][] raster, int BPM)
    {
        this.raster = raster;
        this.ZEILEN = raster.length;
        this.SPALTEN = raster[0].length;
        this.BPM = BPM;
      
        try
        {
            out = new AudioTrack(AudioManager.STREAM_MUSIC, SAMPLERATE, 
                                    AudioFormat.CHANNEL_OUT_STEREO, 
                                    AudioFormat.ENCODING_PCM_16BIT, 
                                    16384*4, 
                                    AudioTrack.MODE_STREAM);
            out.play();
        }
        catch(Exception ee)
        {
            System.out.println("FEHLER: "+ee);
        }
        
        //Berechnung der Pufferl\u00e4nge eines Blocks gem\u00e4\u00df der Samplerate und dem Tempo:
        //Millisekunden pro Beat:
        int msb = 30000/(int)BPM;
        PUFFERGROESSE = (msb*SAMPLERATE)/1000;
        System.out.println("PUFFERGROESSE="+PUFFERGROESSE);
        stereopuffer_links = new double[SPALTEN][PUFFERGROESSE];
        stereopuffer_rechts = new double[SPALTEN][PUFFERGROESSE];
        
        //puffer = new byte[PUFFERGROESSE*4]; //4 Byte pro Sample == 16Bit Stereo 
        //11050...
        puffer = new byte[16384*4]; //4 Byte pro Sample == 16Bit Stereo
    }
    
    public void loescheHinterenPuffer(int INDEX)
    {
         int ih = (INDEX+NACHKLANG-1)%SPALTEN;
         for(int i=0;i<PUFFERGROESSE;i++)
             stereopuffer_links[ih][i]=0.0f;
         for(int i=0;i<PUFFERGROESSE;i++)
             stereopuffer_rechts[ih][i]=0.0f;
    }
    
    public void trageToeneEin(int zaehlzeit)
    {
        for(int i=0;i<raster.length;i++)//Zeilen durchgehen
        {
            if(raster[i][zaehlzeit]>0) //Wenn Tonereignis im Raster
            {
                 int klang = raster[i][zaehlzeit]-1;
                 int hoehe = raster.length-1-i;
                 double f = fpenta[hoehe];
                 //Oktavieren:
                 if(klang>0)
                     f*=0.5f;
                 if(klang>1)
                     f*=0.5f;
                 
                 double PAN = (double)klang/(double)(kreisfarben.length-1);     
                 t=0.0f;
                 double tmax = (double)(PUFFERGROESSE*NACHKLANG)*dt-dt;
                 double takt = 0.0f;

                 int wavindex=0;
                 for(int p=0;p<NACHKLANG;p++) //Bl\u00f6cke durchgehen und Samples darauf vertreilen
                 {
                     int z = (zaehlzeit + p)%SPALTEN;
                     for(int k=0;k<PUFFERGROESSE;k++)
                     {
                         //double huell = (tmax-takt)/tmax;
                         double huell = 1.0f;
                         
                         if(takt>tmax*0.9f)
                         {
                             huell = (tmax-takt)/(tmax*0.1f);
                         }
                         
                         huell*=huell;
                         
                       
//                         stereopuffer_links[z][k]  += huell*(PAN*0.5+0.5)*0.1*Math.sin(2.0*Math.PI*f*t);
//                         stereopuffer_rechts[z][k] += huell*((1.0-PAN)*0.5+0.5)*0.1*Math.sin(2.0*Math.PI*f*t);
                         stereopuffer_links[z][k]  += huell*(PAN*0.5f+0.5f)*0.5f*ton[hoehe+klang*ZEILEN][0][wavindex];
                         stereopuffer_rechts[z][k] += huell*((1.0f-PAN)*0.5f+0.5f)*0.5f*ton[hoehe+klang*ZEILEN][1][wavindex];
                         t+=dt;
                         takt+=dt;
                         wavindex++;
                     }
                 }     
            }
        }
    }

    private void double2Byte(byte[] zwei,double wert)
    {
                int gesamt = (int)(wert*gross + gross);    
               
                int hi = gesamt/256;
                int lo = gesamt - hi*256;
            
                int zh = hi-128;
                int zl = 0;
                if(lo<=127)
                    zl = lo;
                else        
                    zl = lo-256;
                    
                zwei[0]=(byte)zl;    
                zwei[1]=(byte)zh;    
      
    }
    
    //In den Line-Puffer aktuellen Stereopuffer schreiben.
    public void schreibePuffer(int zaehlzeit)
    {
        for(int i=0;i<PUFFERGROESSE;i++)
        {
            double2Byte(zwei,stereopuffer_links[zaehlzeit][i]);
            puffer[i*4+0]=zwei[0];            
            puffer[i*4+1]=zwei[1];            
            double2Byte(zwei,stereopuffer_rechts[zaehlzeit][i]);
            puffer[i*4+2]=zwei[0];            
            puffer[i*4+3]=zwei[1];            
        }
        
//        int geschrieben = out.write(puffer, PUFFERGROESSE*4,AudioManager.WRITE_BLOCKING);                                
        int geschrieben = out.write(puffer, 0,PUFFERGROESSE*4);                                
                
        if(geschrieben!=PUFFERGROESSE*4)
        {
              System.out.println("Fehler beim Lesen oder Schreiben: "+geschrieben);
        }
        
        
        
        
    }
}
    public double[][] ladeWav(String name, int sampleanzahl)
    {
            int zl,zh,lo,gesamt;
            double gross = 0.5f*(255.0f*256.0f + 255.0f);
          
            byte[] dat = loadBytes(name);

            int anz = dat.length;
          
            //double[][] y = new double[2][(anz-44)/4];                        
            double[][] y = new double[2][sampleanzahl];                        

            int inx=44;
            
            for(int i=0;i<y[0].length;i++)
            {
                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;
                
                 gesamt+=lo;
                
                 y[0][i] = ((double)gesamt - gross)/gross;        

                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;
                
                 gesamt+=lo;
                
                 y[1][i] = ((double)gesamt - gross)/gross;        
                 
            }    
            
            return y;
    }
    
    
public class Xtext
{
  public int cursorX=0;
  public int cursorY=0;
  
  
   private String[] tasten = {
             "ABCDEFGHIJKLM ^ ",       
             "NOPQRSTUVWXYZ< >",       
             "0123456789,!? | ",
             "RFR SPC DEL CLR "
                             };
  
   private String[] tasten_return = {
             "ABCDEFGHIJKLM ^ ",       
             "NOPQRSTUVWXYZ< >",       
             "0123456789,!? | ",
             "@@@ ___ \u00a7\u00a7\u00a7 $$$ "
                             };
  
     private float WIDTH;
     private float HEIGHT;
     private float XOFF;
     private float YOFF;
     private int[] FARBE = {0,0,0};
     private PApplet pap;
     public int zeilen  = 10;  //Anzahl der Textzeilen
     public int spalten = 30;  //Anzahl der Textspalten
     Hzeichen hz;
     public String text="";
     
     public float xraster = 10.0f;
     public float yraster = 10.0f;
     
     public Xtext(PApplet pap)
     {
         this.pap = pap;
         WIDTH = pap.width;
         HEIGHT = pap.height;
         XOFF = 0.0f;
         YOFF = 0.0f;
         FARBE[0] = 0;
         FARBE[1] = 0;
         FARBE[2] = 0;
         hz = new Hzeichen(pap,pap.width/(float)spalten,pap.height/(float)zeilen);
         this.xraster = WIDTH/(float)spalten;
         this.yraster = HEIGHT/(float)zeilen;

         text="";
         for(int i=0;i<zeilen;i++)
           for(int k=0;k<spalten;k++)
             text+=" ";
     }

     public void ersetzeText(String textneu)
     {
         char[] ttt = text.toCharArray();
         for(int i=0;i<text.length();i++)
         {
             if(i<textneu.length())
                 ttt[i]=textneu.charAt(i);
             else
                 ttt[i]='_';
         }
         text=String.valueOf(ttt);
     }

     public Xtext(PApplet pap, float XOFF, float YOFF, float WIDTH, float HEIGHT, int zeilen, int spalten, int[] farbe)
     {
         this.pap = pap;
         this.WIDTH = WIDTH;
         this.HEIGHT = HEIGHT;
         this.XOFF = XOFF;
         this.YOFF = YOFF;
         this.zeilen = zeilen;
         this.spalten = spalten;
         this.FARBE = farbe;
         
         hz = new Hzeichen(pap,WIDTH/(float)spalten,HEIGHT/(float)zeilen);
         
         this.xraster = WIDTH/(float)spalten;
         this.yraster = HEIGHT/(float)zeilen;

         text="";
         for(int i=0;i<zeilen;i++)
           for(int k=0;k<spalten;k++)
             text+=" ";
     }

     public void setzeTextNeu(String textneu)
     {
         text="";
         int zz=0;
         for(int i=0;i<zeilen;i++)
         {
           for(int k=0;k<spalten;k++)
           {
             if(textneu!=null && textneu.length()>zz)
             {
               text+=textneu.charAt(zz);
               zz++;
             }   
             else
             {
                 text+=" ";
             }
           }
         }   
     }
     
     
     public void clear()
     {
         text="";
         for(int i=0;i<zeilen;i++)
           for(int k=0;k<spalten;k++)
             text+=" ";
       
     }
     
     /**
     *Festlegen, welcher Text angezeigt wird.
     */
     public void setText(String text)
     {
         this.text = text;
     }
     
     public void testraster()
     {
         pap.noFill();
         pap.stroke(0,255,0);
         pap.strokeWeight(1.0f);
         for(int i=0;i<zeilen+1;i++)
             pap.line(XOFF,YOFF+(float)i*HEIGHT/(float)zeilen,XOFF+WIDTH,YOFF+(float)i*HEIGHT/(float)zeilen);
         for(int i=0;i<spalten+1;i++)
             pap.line(XOFF+(float)i*WIDTH/(float)spalten,YOFF,XOFF+(float)i*WIDTH/(float)spalten,YOFF+HEIGHT);    
             
     }
     
     /**
     *Text zeigen
     */
     public void draw()
     {
         int zeil = 0;
         int spal = 0;
         char c=' ';
         char c_alt=' ';
         
         pap.noFill();
         pap.stroke(FARBE[0],FARBE[1],FARBE[2]);
         pap.strokeWeight(hz.real_stiftbreite);
         pap.translate(XOFF,YOFF);
         for(int i=0;i<text.length();i++)
         {
             c = text.charAt(i);
             if(c!=c_alt && Character.isWhitespace(c_alt))
             {
                 int pos=spal;
                 while(pos<text.length() && !Character.isWhitespace(text.charAt(pos)))
                 {
                     pos++;
                 }
                 if(pos>=spalten)
                 {
                     spal=0;
                     zeil++;
                     c_alt=c;
                 }
                 else
                 {
                     c_alt = c;
                 }
             }
             else
             {
                 c_alt = c;
             }

             if(c=='+' || c=='-')
             {
                pap.noStroke();
                if(c=='+')
                    pap.fill(127,255,127);
                if(c=='-')
                    pap.fill(255,127,127);
                pap.ellipse(spal*xraster+0.5f*xraster,zeil*yraster+0.5f*yraster,xraster,yraster);
                pap.noFill();
                pap.stroke(FARBE[0],FARBE[1],FARBE[2]);
                
                
             }
             hz.draw(c,zeil,spal);             

             spal++;
             if(spal>=spalten || c=='\n')
             {
                 spal=0;
                 zeil++;
                 c_alt=' ';
             }             
         }
         pap.translate(-XOFF,-YOFF);
     }

     
     public Xtext erzeugeTastatur(PApplet pap)
     {
       return new Xtext(pap, 0.0f, pap.height/2.0f, pap.width, pap.height/2.0f, 4, 16, new int[] {0,0,255});       
     }
     
     public Xtext erzeugeTextLinks(PApplet pap)
     {
       return new Xtext(pap, 0.0f, 0.0f, pap.width/2.0f, pap.height/2.0f, 8, 20, new int[] {0,100,0});       
     }
     
     public Xtext erzeugeTextRechts(PApplet pap)
     {
       return new Xtext(pap, pap.width/2.0f, 0.0f, pap.width/2.0f, pap.height/2.0f, 8, 20, new int[] {100,0,0});       
     }
     
     public void maleTastatur()
     {
         pap.noFill();
         pap.stroke(FARBE[0],FARBE[1],FARBE[2]);
         pap.strokeWeight(hz.real_stiftbreite);
         pap.translate(XOFF,YOFF);
       for(int i=0;i<tasten.length;i++)
       {
         for(int k=0;k<tasten[i].length();k++)
         {
           hz.draw(tasten[i].charAt(k),i,k);
         }
       }
       
       //Rahmen um die Buchstaben zeichnen:
       pap.noFill();
       pap.stroke(100,100,255);
       pap.strokeWeight(pap.width/300.0f);
       for(int i=0;i<tasten.length-1;i++)
       {
         for(int k=0;k<tasten[i].length();k++)
         {
           float x = xraster*(float)k;
           float y = yraster*(float)i;
      
           //pap.rect(x-pap.width/20.0f, y-pap.height/20.0f, xraster-pap.width/10.0f, yraster-pap.height/10.0f);
           pap.rect(x, y, xraster, yraster);
         }
       }
       for(int i=0;i<4;i++)
       {
       float x = 4.0f*xraster*(float)i;
       float y = yraster*3.0f;
       pap.rect(x, y, 4.0f*xraster, yraster);         
       }
       
         pap.translate(-XOFF,-YOFF);
     }

     public void maleCursor()
     {
       float x = XOFF+(float)cursorX*xraster;
       float y = YOFF+(float)cursorY*yraster;
       
       pap.noFill();
       pap.stroke(255,100,100);
       pap.strokeWeight(pap.width/300.0f);
     pap.rect(x, y, xraster, yraster);                
     }
     
     
     public char getPressed(float x, float y)
     {
       y-=YOFF;
       x-=XOFF;
       x/=xraster;
       y/=yraster;
       
       int ix = (int)x;
       int iy = (int)y;
       
       if(ix>=0 && ix<tasten[0].length() && iy>=0 && iy<tasten.length)
       {
         return tasten_return[iy].charAt(ix);
       }
       else
       {
         return ' ';
       }
     }
}






//Zeichnet eine schwarze Linie vertikal ein, wo gerade die Z\u00e4hlzeit ist.
public void zeichneZaehlzeit()
{
    noStroke();
    //fill(rot[0],rot[1],rot[2]);
    fill(0);
    //Damit Klang und Linienstelle zusammenpassen, eins in die Vergangenheit gehen.
    int INDEX_ALT = (INDEX-1+SPALTEN)%SPALTEN;
    rect(RASTERMITTEX[INDEX_ALT+1]-LINIENDICKE/4,0,LINIENDICKE/2,QH);
}

public class Zeitsteuerung implements Runnable
{
    private Rasterplayer rasterplayer;
  
    protected ScheduledExecutorService schedExecService;  
    //Startet Thread, der run() zyklisch mit BPM aufruft
    public Zeitsteuerung(Rasterplayer rasterplayer)
    {
        this.rasterplayer = rasterplayer;
      
        schedExecService = Executors.newSingleThreadScheduledExecutor();
        long period = 30000/BPM; //Seconds per Beat==60/BPM, die H\u00e4lfte weil 8tel, mal 1000 weil Millisekunden.
        schedExecService.scheduleAtFixedRate(this, 0, period, TimeUnit.MILLISECONDS);      
    }
    
    public void run()
    {
        //1. INDEX+NACHKLANG-1-ten Puffer l\u00f6schen.
        rasterplayer.loescheHinterenPuffer(INDEX);
        //2. Auf Tonereignisse pr\u00fcfen und diese eintragen
        rasterplayer.trageToeneEin(INDEX);
        //3. Byte-Umwandlung des aktuellen Puffers vorbereiten und Abschnitt in den Lineausgang schreiben
        rasterplayer.schreibePuffer(INDEX);
        
        INDEX++;
        INDEX%=SPALTEN;
    }
}

}
