import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;


//Zeichnet eine schwarze Linie vertikal ein, wo gerade die Zählzeit ist.
public void zeichneZaehlzeit()
{
    noStroke();
    //fill(rot[0],rot[1],rot[2]);
    fill(0);
    //Damit Klang und Linienstelle zusammenpassen, eins in die Vergangenheit gehen.
    int INDEX_ALT = (INDEX-1+SPALTEN)%SPALTEN;
    rect(RASTERMITTEX[INDEX_ALT+1]-LINIENDICKE/4,0,LINIENDICKE/2,QH);
}

public class Zeitsteuerung implements Runnable
{
    private Rasterplayer rasterplayer;
  
    protected ScheduledExecutorService schedExecService;  
    //Startet Thread, der run() zyklisch mit BPM aufruft
    public Zeitsteuerung(Rasterplayer rasterplayer)
    {
        this.rasterplayer = rasterplayer;
      
        schedExecService = Executors.newSingleThreadScheduledExecutor();
        long period = 30000/BPM; //Seconds per Beat==60/BPM, die Hälfte weil 8tel, mal 1000 weil Millisekunden.
        schedExecService.scheduleAtFixedRate(this, 0, period, TimeUnit.MILLISECONDS);      
    }
    
    public void run()
    {
        //1. INDEX+NACHKLANG-1-ten Puffer löschen.
        rasterplayer.loescheHinterenPuffer(INDEX);
        //2. Auf Tonereignisse prüfen und diese eintragen
        rasterplayer.trageToeneEin(INDEX);
        //3. Byte-Umwandlung des aktuellen Puffers vorbereiten und Abschnitt in den Lineausgang schreiben
        rasterplayer.schreibePuffer(INDEX);
        
        INDEX++;
        INDEX%=SPALTEN;
    }
}
