public class Xtext
{
  public int cursorX=0;
  public int cursorY=0;
  
  
   private String[] tasten = {
             "ABCDEFGHIJKLM ^ ",       
             "NOPQRSTUVWXYZ< >",       
             "0123456789,!? | ",
             "RFR SPC DEL CLR "
                             };
  
   private String[] tasten_return = {
             "ABCDEFGHIJKLM ^ ",       
             "NOPQRSTUVWXYZ< >",       
             "0123456789,!? | ",
             "@@@ ___ §§§ $$$ "
                             };
  
     private float WIDTH;
     private float HEIGHT;
     private float XOFF;
     private float YOFF;
     private int[] FARBE = {0,0,0};
     private PApplet pap;
     public int zeilen  = 10;  //Anzahl der Textzeilen
     public int spalten = 30;  //Anzahl der Textspalten
     Hzeichen hz;
     public String text="";
     
     public float xraster = 10.0f;
     public float yraster = 10.0f;
     
     public Xtext(PApplet pap)
     {
         this.pap = pap;
         WIDTH = pap.width;
         HEIGHT = pap.height;
         XOFF = 0.0f;
         YOFF = 0.0f;
         FARBE[0] = 0;
         FARBE[1] = 0;
         FARBE[2] = 0;
         hz = new Hzeichen(pap,pap.width/(float)spalten,pap.height/(float)zeilen);
         this.xraster = WIDTH/(float)spalten;
         this.yraster = HEIGHT/(float)zeilen;

         text="";
         for(int i=0;i<zeilen;i++)
           for(int k=0;k<spalten;k++)
             text+=" ";
     }

     public void ersetzeText(String textneu)
     {
         char[] ttt = text.toCharArray();
         for(int i=0;i<text.length();i++)
         {
             if(i<textneu.length())
                 ttt[i]=textneu.charAt(i);
             else
                 ttt[i]='_';
         }
         text=String.valueOf(ttt);
     }

     public Xtext(PApplet pap, float XOFF, float YOFF, float WIDTH, float HEIGHT, int zeilen, int spalten, int[] farbe)
     {
         this.pap = pap;
         this.WIDTH = WIDTH;
         this.HEIGHT = HEIGHT;
         this.XOFF = XOFF;
         this.YOFF = YOFF;
         this.zeilen = zeilen;
         this.spalten = spalten;
         this.FARBE = farbe;
         
         hz = new Hzeichen(pap,WIDTH/(float)spalten,HEIGHT/(float)zeilen);
         
         this.xraster = WIDTH/(float)spalten;
         this.yraster = HEIGHT/(float)zeilen;

         text="";
         for(int i=0;i<zeilen;i++)
           for(int k=0;k<spalten;k++)
             text+=" ";
     }

     public void setzeTextNeu(String textneu)
     {
         text="";
         int zz=0;
         for(int i=0;i<zeilen;i++)
         {
           for(int k=0;k<spalten;k++)
           {
             if(textneu!=null && textneu.length()>zz)
             {
               text+=textneu.charAt(zz);
               zz++;
             }   
             else
             {
                 text+=" ";
             }
           }
         }   
     }
     
     
     public void clear()
     {
         text="";
         for(int i=0;i<zeilen;i++)
           for(int k=0;k<spalten;k++)
             text+=" ";
       
     }
     
     /**
     *Festlegen, welcher Text angezeigt wird.
     */
     public void setText(String text)
     {
         this.text = text;
     }
     
     public void testraster()
     {
         pap.noFill();
         pap.stroke(0,255,0);
         pap.strokeWeight(1.0f);
         for(int i=0;i<zeilen+1;i++)
             pap.line(XOFF,YOFF+(float)i*HEIGHT/(float)zeilen,XOFF+WIDTH,YOFF+(float)i*HEIGHT/(float)zeilen);
         for(int i=0;i<spalten+1;i++)
             pap.line(XOFF+(float)i*WIDTH/(float)spalten,YOFF,XOFF+(float)i*WIDTH/(float)spalten,YOFF+HEIGHT);    
             
     }
     
     /**
     *Text zeigen
     */
     public void draw()
     {
         int zeil = 0;
         int spal = 0;
         char c=' ';
         char c_alt=' ';
         
         pap.noFill();
         pap.stroke(FARBE[0],FARBE[1],FARBE[2]);
         pap.strokeWeight(hz.real_stiftbreite);
         pap.translate(XOFF,YOFF);
         for(int i=0;i<text.length();i++)
         {
             c = text.charAt(i);
             if(c!=c_alt && Character.isWhitespace(c_alt))
             {
                 int pos=spal;
                 while(pos<text.length() && !Character.isWhitespace(text.charAt(pos)))
                 {
                     pos++;
                 }
                 if(pos>=spalten)
                 {
                     spal=0;
                     zeil++;
                     c_alt=c;
                 }
                 else
                 {
                     c_alt = c;
                 }
             }
             else
             {
                 c_alt = c;
             }

             if(c=='+' || c=='-')
             {
                pap.noStroke();
                if(c=='+')
                    pap.fill(127,255,127);
                if(c=='-')
                    pap.fill(255,127,127);
                pap.ellipse(spal*xraster+0.5f*xraster,zeil*yraster+0.5f*yraster,xraster,yraster);
                pap.noFill();
                pap.stroke(FARBE[0],FARBE[1],FARBE[2]);
                
                
             }
             hz.draw(c,zeil,spal);             

             spal++;
             if(spal>=spalten || c=='\n')
             {
                 spal=0;
                 zeil++;
                 c_alt=' ';
             }             
         }
         pap.translate(-XOFF,-YOFF);
     }

     
     public Xtext erzeugeTastatur(PApplet pap)
     {
       return new Xtext(pap, 0.0f, pap.height/2.0f, pap.width, pap.height/2.0f, 4, 16, new int[] {0,0,255});       
     }
     
     public Xtext erzeugeTextLinks(PApplet pap)
     {
       return new Xtext(pap, 0.0f, 0.0f, pap.width/2.0f, pap.height/2.0f, 8, 20, new int[] {0,100,0});       
     }
     
     public Xtext erzeugeTextRechts(PApplet pap)
     {
       return new Xtext(pap, pap.width/2.0f, 0.0f, pap.width/2.0f, pap.height/2.0f, 8, 20, new int[] {100,0,0});       
     }
     
     public void maleTastatur()
     {
         pap.noFill();
         pap.stroke(FARBE[0],FARBE[1],FARBE[2]);
         pap.strokeWeight(hz.real_stiftbreite);
         pap.translate(XOFF,YOFF);
       for(int i=0;i<tasten.length;i++)
       {
         for(int k=0;k<tasten[i].length();k++)
         {
           hz.draw(tasten[i].charAt(k),i,k);
         }
       }
       
       //Rahmen um die Buchstaben zeichnen:
       pap.noFill();
       pap.stroke(100,100,255);
       pap.strokeWeight(pap.width/300.0f);
       for(int i=0;i<tasten.length-1;i++)
       {
         for(int k=0;k<tasten[i].length();k++)
         {
           float x = xraster*(float)k;
           float y = yraster*(float)i;
      
           //pap.rect(x-pap.width/20.0f, y-pap.height/20.0f, xraster-pap.width/10.0f, yraster-pap.height/10.0f);
           pap.rect(x, y, xraster, yraster);
         }
       }
       for(int i=0;i<4;i++)
       {
       float x = 4.0f*xraster*(float)i;
       float y = yraster*3.0f;
       pap.rect(x, y, 4.0f*xraster, yraster);         
       }
       
         pap.translate(-XOFF,-YOFF);
     }

     public void maleCursor()
     {
       float x = XOFF+(float)cursorX*xraster;
       float y = YOFF+(float)cursorY*yraster;
       
       pap.noFill();
       pap.stroke(255,100,100);
       pap.strokeWeight(pap.width/300.0f);
     pap.rect(x, y, xraster, yraster);                
     }
     
     
     public char getPressed(float x, float y)
     {
       y-=YOFF;
       x-=XOFF;
       x/=xraster;
       y/=yraster;
       
       int ix = (int)x;
       int iy = (int)y;
       
       if(ix>=0 && ix<tasten[0].length() && iy>=0 && iy<tasten.length)
       {
         return tasten_return[iy].charAt(ix);
       }
       else
       {
         return ' ';
       }
     }
}

