import java.util.ArrayList;

/**
* Schaltknöpfe, die ihre Beschriftung und Farbe bei einer
* Zustandsänderung wechseln können.
* Abfrage des Zustands erfolgt über den Button-Namen.
*/
public class Knopf
{
    private int HEIGHT;

    private int ZEILEN=8;
    private int SPALTEN=4;

    private int XOFF,YOFF,BREITE,HOEHE,PADDINGX,PADDINGY;

    private PApplet pap;

    public ArrayList<int[]> an_farbe;
    public ArrayList<int[]> aus_farbe;
    public ArrayList<String> knopfname;
    public ArrayList<String> an_beschriftung;
    public ArrayList<String> aus_beschriftung;
    public ArrayList<int[]> knopfbounds; //x,y,breite,hoehe
    public ArrayList<boolean[]> knopfzustand; 
    public ArrayList<boolean[]> knopf_mouseover; 

    public ArrayList<Xtext> beschriftung; 

    private int anzahl;

    private int PANEL=0;

    public void initialisieren()
    {
        this.HEIGHT = pap.height;
        an_farbe = new ArrayList<int[]>();
        aus_farbe = new ArrayList<int[]>();
        knopfname = new ArrayList<String>();
        an_beschriftung = new ArrayList<String>();
        aus_beschriftung = new ArrayList<String>();
        knopfbounds = new ArrayList<int[]>();
        knopfzustand = new ArrayList<boolean[]>();
        knopf_mouseover = new ArrayList<boolean[]>();

        beschriftung = new ArrayList<Xtext>();

        anzahl=0;
 
        XOFF = pap.width/20;
        YOFF = pap.height/20;
        BREITE = (pap.width  - XOFF - XOFF)/SPALTEN;
        HOEHE  = (pap.height - YOFF - YOFF)/ZEILEN;
        PADDINGX = 1+pap.width/100;
        PADDINGY = 1+pap.height/100;
    }

    public void initialisieren(int ZEILEN, int SPALTEN, int XOFF, int YOFF,int PANEL_BREITE, int PANEL_HOEHE)
    {
        this.PANEL=1;
        this.HEIGHT = PANEL_HOEHE;
        an_farbe = new ArrayList<int[]>();
        aus_farbe = new ArrayList<int[]>();
        knopfname = new ArrayList<String>();
        an_beschriftung = new ArrayList<String>();
        aus_beschriftung = new ArrayList<String>();
        knopfbounds = new ArrayList<int[]>();
        knopfzustand = new ArrayList<boolean[]>();
        knopf_mouseover = new ArrayList<boolean[]>();

        beschriftung = new ArrayList<Xtext>();

        anzahl=0;
 
        this.ZEILEN = ZEILEN;
        this.SPALTEN = SPALTEN;
        this.XOFF = XOFF;
        this.YOFF = YOFF;
        this.BREITE = (PANEL_BREITE)/SPALTEN;
        this.HOEHE  = (PANEL_HOEHE)/ZEILEN;

        PADDINGX = 1+this.BREITE/100;
        PADDINGY = 1+this.HOEHE/100;
    }

    public Knopf(PApplet pap)
    {
        this.pap = pap;        
        initialisieren();
    }
    public Knopf(PApplet pap,int ZEILEN, int SPALTEN)
    {
        this.pap = pap;        
        this.ZEILEN=ZEILEN;
        this.SPALTEN = SPALTEN;
        initialisieren();
    }


    public Knopf(PApplet pap,int ZEILEN, int SPALTEN, int XOFF, int YOFF, int PANEL_BREITE, int PANEL_HOEHE)
    {
        this.pap = pap;        
        initialisieren(ZEILEN,SPALTEN,XOFF,YOFF,PANEL_BREITE,PANEL_HOEHE);
    }

    private int name2index(String name)
    {
        for(int i=0;i<anzahl;i++)
            if(name.equals(knopfname.get(i)))
                return i;
        return -1;
    }

    public void setZustand(String name, boolean zustand)
    {
        setZustand(name2index(name),zustand);
    }
    public void setZustand(int nr,boolean zustand)
    {
        if(nr<0 || nr>=anzahl) return;
        boolean[] z = knopfzustand.get(nr);
        z[0]=zustand;    
    }
    public boolean getZustand(String name)
    {
        return getZustand(name2index(name));
    }
    public boolean getZustand(int nr)
    {
        if(nr<0 || nr>=anzahl) return false;
        boolean[] z = knopfzustand.get(nr);
        return z[0];    
    }

    public void add(String name, String an_b, String aus_b, int[] an_f, int[] aus_f,
                    int x, int y, int breite, int hoehe, boolean zust)
    {
        int[] an_farbe_neu = new int[] {an_f[0],an_f[1],an_f[2]};
        an_farbe.add(an_farbe_neu);
        int[] aus_farbe_neu = new int[] {aus_f[0],aus_f[1],aus_f[2]};
        aus_farbe.add(aus_farbe_neu);
        knopfname.add(name);

        int[] b = new int[] {x,y,breite,hoehe};
        knopfbounds.add(b);
        boolean[] z = new boolean[] {zust};
        knopfzustand.add(z);
        knopf_mouseover.add(new boolean[] {false});

     //public Xtext(PApplet pap, float XOFF, float YOFF, float WIDTH, float HEIGHT, int zeilen, int spalten, int[] farbe)

        int laenge = an_b.length();
        if(aus_b.length()>laenge)
            laenge=aus_b.length();
        Xtext xt = new Xtext(pap,x+PADDINGX,y-hoehe+PADDINGY+HEIGHT/50+(hoehe*14)/50,breite-PADDINGX*2,(hoehe*4)/5-PADDINGY*2,1,an_b.length(),new int[] {0,0,0});

        //Beide gleich lang machen, Unterstriche einsetzen:
        char[] an_bb = an_b.toCharArray();
        char[] aus_bb = aus_b.toCharArray();
        char[] an_bbb = an_bb;
        char[] aus_bbb = aus_bb;
        if(an_bb.length>=aus_bb.length)
        {
            aus_bbb=new char[an_bb.length];
            an_bbb=new char[an_bb.length];
        }
        else if(aus_bb.length>an_bb.length)
        {
            an_bbb=new char[aus_bb.length];
            aus_bbb=new char[aus_bb.length];
        }

        for(int i=0;i<aus_bbb.length;i++)
        {
            an_bbb[i]='_';
            aus_bbb[i]='_';
            if(i<an_bb.length && !Character.isWhitespace(an_bb[i]))
                an_bbb[i]=an_bb[i];
            if(i<aus_bb.length && !Character.isWhitespace(aus_bb[i]))
                aus_bbb[i]=aus_bb[i];
        }    
         
        an_b = new String(an_bbb);
        aus_b = new String(aus_bbb);
        //System.out.println("an_b:  "+an_b);
        //System.out.println("aus_b: "+an_b);
        //Ende gleich lang machen
        an_beschriftung.add(an_b);
        aus_beschriftung.add(aus_b);
 
        if(zust==true)
            xt.setzeTextNeu(an_b);
        else
            xt.setzeTextNeu(aus_b);

        beschriftung.add(xt);
        
        anzahl++;
    }

    public void add()
    {
        String name = "k"+anzahl;
        String an_b = "ON_";
        String aus_b = "OFF";
        int[] an_f = new int[] {127,255,127};
        int[] aus_f = new int[] {127,127,255};
        int x = XOFF+(anzahl%SPALTEN)*BREITE;
        int y = YOFF+(anzahl/SPALTEN)*HOEHE;
        int breite=BREITE;
        int hoehe=HOEHE;
        boolean zust = false;

        add(name,an_b,aus_b,an_f,aus_f,
            x,y,breite,hoehe,zust);
    }

    public void add(int zeile, int spalte, String name, String an_b, String aus_b)
    {
        int[] an_f = new int[] {127,255,127};
        int[] aus_f = new int[] {127,127,255};
        int x = XOFF+(spalte)*BREITE;
        int y = YOFF+(zeile)*HOEHE;
        int breite=BREITE;
        int hoehe=HOEHE;
        boolean zust = false;
        add(name,an_b,aus_b,an_f,aus_f,
            x,y,breite,hoehe,zust);
    }

    public void add(int zeile, int spalte, String name, String an_b, String aus_b,
                    int[] an_f, int[] aus_f)
    {
        int x = XOFF+(spalte)*BREITE;
        int y = YOFF+(zeile)*HOEHE;
        int breite=BREITE;
        int hoehe=HOEHE;
        boolean zust = false;
        add(name,an_b,aus_b,an_f,aus_f,
            x,y,breite,hoehe,zust);
    }

    public void setzeTextNeuAn(int index, String text)
    {
        //Xtext xt = beschriftung.get(index);
        //xt.setzeTextNeu(text);
//        an_beschriftung.set(index,text);
        Xtext xt = beschriftung.get(index);
//        xt.setzeTextNeu(text);
//        xt.setText(text);
        xt.ersetzeText(text);
    }

    public void setzeTextNeuAn(String name, String text)
    {
        setzeTextNeuAn(name2index(name),text);
    }

    public void setzeTextNeuAus(int index, String text)
    {
        //Xtext xt = beschriftung.get(index);
        //xt.setzeTextNeu(text);
//        aus_beschriftung.set(index,text);
        Xtext xt = beschriftung.get(index);
//        xt.setzeTextNeu(text);
//        xt.setText(text);
        xt.ersetzeText(text);
    }

    public void setzeTextNeuAus(String name, String text)
    {
        setzeTextNeuAus(name2index(name),text);
    }

    /**
    *    in pap.mousePressed() aufrufen!
    */
    public void mousePressed()
    {
        int x = pap.mouseX;
        int y = pap.mouseY;
        for(int i=0;i<anzahl;i++)
        {
            int[] b = knopfbounds.get(i);
            if(x>b[0] && x<b[0]+b[2] && y>b[1] && y<b[1]+b[3])
            {
                boolean[] z = knopfzustand.get(i);
                z[0]=!z[0];
                Xtext xt = beschriftung.get(i);
                if(z[0]==true)
                    xt.setzeTextNeu(an_beschriftung.get(i));
                else
                    xt.setzeTextNeu(aus_beschriftung.get(i));
            }
        }
    }

    /**
    *    in pap.mouseMoved() aufrufen!
    */
    public void mouseMoved()
    {
        int x = pap.mouseX;
        int y = pap.mouseY;
        for(int i=0;i<anzahl;i++)
        {
            int[] b = knopfbounds.get(i);
            if(x>b[0] && x<b[0]+b[2] && y>b[1] && y<b[1]+b[3])
            {
                boolean[] z = knopf_mouseover.get(i);
                z[0]=true;
            }
            else
            {
                boolean[] z = knopf_mouseover.get(i);
                z[0]=false;
            }
        }
    }


    /**
    *    in pap.draw() aufrufen!
    */
    public void draw()
    {        
        for(int i=0;i<anzahl;i++)
        {
            Xtext xt = beschriftung.get(i);
            int[] b = knopfbounds.get(i);
            if(knopfzustand.get(i)[0]==true)
            {
                pap.fill(an_farbe.get(i)[0],an_farbe.get(i)[1],an_farbe.get(i)[2]);
                pap.noStroke();
                pap.rect(b[0]+PADDINGX,b[1]+PADDINGY,b[2]-PADDINGX*2,b[3]-PADDINGY*2);
                pap.stroke(0);
                pap.noFill();
                if(knopf_mouseover.get(i)[0]==true)
                {
                  pap.rect(b[0]+PADDINGX,b[1]+PADDINGY,b[2]-PADDINGX*2,b[3]-PADDINGY*2);
                }
            }
            else
            {
                pap.fill(aus_farbe.get(i)[0],aus_farbe.get(i)[1],aus_farbe.get(i)[2]);
                pap.noStroke();
                pap.rect(b[0]+PADDINGX,b[1]+PADDINGY,b[2]-PADDINGX*2,b[3]-PADDINGY*2);
                pap.stroke(0);
                pap.noFill();
                if(knopf_mouseover.get(i)[0]==true)
                {
                  pap.rect(b[0]+PADDINGX,b[1]+PADDINGY,b[2]-PADDINGX*2,b[3]-PADDINGY*2);
                }
            }
            xt.draw();
        }
    }
}
