public boolean setzeChip(int zeile, int spalte,int farbe)
{
     if(raster[zeile][spalte]==0) //wenn erlaubt
     {
         raster[zeile][spalte]=farbe+1;
         return true;
     }
     else
     {
         return false;
     }
}

public boolean entferneChip(int zeile, int spalte,int farbe)
{
     if(raster[zeile][spalte]==farbe+1) //wenn erlaubt
     {
         raster[zeile][spalte]=0;
         return true;
     }
     else
     {
         return false;
     }
}

public boolean loescheFarbe(int farbe)
{
      boolean gefunden = false;
      for(int i=0;i<ZEILEN;i++)
          for(int k=0;k<SPALTEN;k++)
              if(raster[i][k]==farbe+1)
              {
                  gefunden = true;
                  raster[i][k]=0;
              }
      return gefunden;        
}

public boolean loescheAlles()
{
      boolean gefunden = false;
      for(int i=0;i<ZEILEN;i++)
          for(int k=0;k<SPALTEN;k++)
              if(raster[i][k]>0)
              {
                  raster[i][k]=0;
                  gefunden = true;
              }    
      return gefunden;        
}

/**
*   Wenn mit dem Finger über die Glasfläche gezogen wird, dann könnte ein Chip damit geholt und auf das Spielfeld bewegt werden.
*/
public void mouseDragged() 
{
     int x = mouseX;
     int y = mouseY;
     if(GEGRIFFEN==0) //ggf. etwas vom linken Rand greifen
     {
         //Holen eines neuen Chips aus dem Depot:
         for(int i=0;i<kreisfarben.length;i++)
         {
               if(x>RASTERX[0] && x<RASTERX[0]+RASTERB && y>RASTERY[i] && y<RASTERY[i]+RASTERH)
               {
                   GEGRIFFEN = i+1;
                   break;
               }
         }
         
         //Entfernen eines einzelnen Chips vom Raster:
         for(int i=0;i<ZEILEN;i++)
         {
           for(int k=0;k<SPALTEN;k++)
           {
                   if(x>RASTERX[k+1] && x<RASTERX[k+1]+RASTERB && y>RASTERY[i] && y<RASTERY[i]+RASTERH
                     && raster[i][k]>0)
                   {
                        GEGRIFFEN=raster[i][k];
                        raster[i][k]=0;
                   }
           }
         }
     }          
}

/**
*   Wenn nach Ziehen über das Glas die Finger wieder gehoben wird,
*   soll GEGRIFFEN wieder zurückgesetzt werden und ggf. der Chip im Spielfeld eingetragen werden.
*/
public void mouseReleased()
{
    int x = mouseX;
    int y = mouseY;
    
    if(GEGRIFFEN>0)
    {
      for(int i=0;i<ZEILEN;i++)
      {
        for(int k=0;k<SPALTEN;k++)
        {
               if(x>RASTERX[k+1] && x<RASTERX[k+1]+RASTERB && y>RASTERY[i] && y<RASTERY[i]+RASTERH
                  && raster[i][k]==0)
               {
                    raster[i][k]=GEGRIFFEN;
               }
        }
      }
      GEGRIFFEN = 0;    
    }
    else
    {
      //Alle Chips einer Farbe, oder auch alles entfernen, wenn der entsprechende Knopf gedrückt wird.
      if(x>RASTERX[SPALTEN+1] && x<RASTERX[SPALTEN+1]+RASTERB)
      {
        for(int i=0;i<kreisfarben.length;i++)
        {
            if(y>RASTERY[i] && y<RASTERY[i]+RASTERH)
            {
                loescheFarbe(i);
            }
        }
        if(y>RASTERY[kreisfarben.length] && y<RASTERY[kreisfarben.length]+RASTERH)
            loescheAlles();
      }
    }
}


/**
*   Eventuell gerade gegriffenen Chip zeichnen
*/
public void zeichneGegriffenenChip()
{
    if(GEGRIFFEN>0)
    {
        noStroke();
        fill(kreisfarben[GEGRIFFEN-1][0],kreisfarben[GEGRIFFEN-1][1],kreisfarben[GEGRIFFEN-1][2]);
        ellipse(mouseX,mouseY,RASTERB,RASTERH);        
    }
}



