import java.util.ArrayList;

/**
*   Lädt alle Dateien aus data mit dem Prefix infotext und stellt sie bei 
*   Bedarf mit Hilfe der draw-Methode dar.
*/
public class Infotext
{
    private PApplet pap;
    private Data data;
    private Knopf knopf;

    public ArrayList<Xtext> infos;
    public int SEITE;
    public boolean AKTIV;

    public int zzz_max=0;
    public int mmm_max=0;

    /**
    *    Die Dateien hinter den übergebenen Dateinamen werden aus dem Ordner data heraus geladen.
    */
    public Infotext(PApplet pap, String[] dateinamen)
    {
        this.pap = pap;
        data = new Data(pap);

        infos = new ArrayList<Xtext>(); 
        SEITE=0;
        AKTIV=false;

        for(int i=0;i<dateinamen.length;i++)
        {
            String[] zeilen = data.ladeZeilen(dateinamen[i]);
            //pap.println(i+". Datei:");
            //for(int k=0;k<zeilen.length;k++)
            //{
            //    pap.println(zeilen[k]);
            //}
            //Aufbereiten für Xtext:
            StringBuffer sb = new StringBuffer();
            int MAX=0;         
            for(int k=0;k<zeilen.length;k++)
                if(zeilen[k].length()>MAX)
                    MAX=zeilen[k].length();

            int zzz = zeilen.length;
            int mmm = MAX;
            if(zzz<5) zzz=5;
            if(mmm<15) mmm=15;
            zzz++;

            if(zzz>zzz_max) zzz_max = zzz;
            if(mmm>mmm_max) mmm_max = mmm;

            for(int k=0;k<zzz;k++)
            {
                for(int p=0;p<mmm;p++)
                {
                    if(k<zeilen.length && p<zeilen[k].length())
                    {
                        char c = zeilen[k].charAt(p);
                        if(Character.isWhitespace(c))
                            sb.append('_');
                        else
                            sb.append(c);
                    }
                    else
                    {
                            sb.append(' ');
                    }
                }
            }
//    public Xtext(PApplet pap, float XOFF, float YOFF, float WIDTH, float HEIGHT, int zeilen, int spalten, int[] farbe)
 


            Xtext xtext = new Xtext(pap,0,0,pap.width,pap.height,zzz,mmm,new int[] {0,0,0});
            xtext.setzeTextNeu(sb.toString());
            infos.add(xtext);
        }       

        knopf = new Knopf(pap,zzz_max,5);
        knopf.add(zzz_max-1,2,"AKTIV","O.K.","O.K.");

        pap.println("infos.size()=="+infos.size()); 
    }    

    public boolean istAktiv()
    {
        return AKTIV;
    }
    public void setzeAktiv()
    {
        SEITE=0;
        AKTIV=true;
    }

    /**
    *   ...wird im PApplet als letztes aufgerufen, um alles andere zu überdecken!
    */
    public void draw()
    {
        if(AKTIV && infos!=null && infos.size()>0 && SEITE>=0 && SEITE<infos.size())
        {             
            //pap.println("SEITE="+SEITE);
            Xtext xtext = infos.get(SEITE);
            xtext.draw();                       
            knopf.draw();
        }
    }

    /**
    *  aus PApplet-Methode mousePressed() heraus aufrufen zum umblättern
    */
    public void mousePressed()
    {
        knopf.mousePressed();
        if(knopf.getZustand("AKTIV")==true)
        {
            knopf.setZustand("AKTIV",false);
            SEITE++;
            if(SEITE>=infos.size())
            {
                SEITE=0;
                AKTIV=false;
            }
        }
    }    
}
