/**
* Hilfsklasse, die beschreibt, wie ein Zeichen dargestellt wird.
*/
public class Hzeichen
{
  
    private PApplet pap;
//    private float breite = 30.0f;
//    private float hoehe  = 70.0f;
    private float breite = 1.0f;
    private float hoehe  = 1.0f;
    
    private float real_breite = breite;
    private float real_hoehe  = hoehe;
    
    private float xscale  = real_breite/breite;
    private float yscale  = real_hoehe/hoehe;
    private float mscale  = 0.5f*(xscale+yscale);
    
    private float stiftbreite = 2.0f;
    public float real_stiftbreite = 2.0f;
    
    public float xraster = real_breite/3.0f;
    public float yraster = real_hoehe/8.0f;
    
    public Hzeichen(PApplet pap, float real_breite, float real_hoehe)
    {
        this.pap = pap; 
        
        this.real_breite = real_breite;
        this.real_hoehe = real_hoehe;
        this.xscale  = real_breite/breite;
        this.yscale  = real_hoehe/hoehe;
        this.mscale  = 0.5f*(xscale+yscale)/20.0f;
        this.real_stiftbreite = stiftbreite*mscale;
        this.xraster = real_breite/3.0f;
        this.yraster = real_hoehe/7.0f;
//println("real_breite="+real_breite);        
//println("real_hoehe="+real_hoehe);        
//println("xraster="+xraster);        
//println("yraster="+yraster);        
    }   

    public void linie(int x1,int y1, int x2, int y2, float xoff, float yoff)
    {
        pap.line(
                     xoff+0.5f*xraster+(float)x1*xraster,   
                     yoff             +(float)y1*yraster,   
                     xoff+0.5f*xraster+(float)x2*xraster,   
                     yoff             +(float)y2*yraster   
                );
    }


    public void bogen1(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+0.5f*xraster+xraster*(float)x1;
         float my = yoff+yraster*(float)y1;
         pap.arc(mx,my,xraster*2.0f,yraster*2.0f,0,pap.HALF_PI);
    }

    public void bogen2(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff-xraster+xraster*0.5f+xraster+xraster*(float)x1;
         float my = yoff+yraster+yraster*(float)y1;
         pap.arc(mx,my,xraster*2.0f,yraster*2.0f,pap.PI+pap.HALF_PI,pap.TWO_PI);
    }

    public void bogen3(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+xraster*0.5f+xraster+xraster*(float)x1;
         float my = yoff+yraster+yraster*(float)y1;
         pap.arc(mx,my,xraster*2.0f,yraster*2.0f,pap.PI,pap.PI+pap.HALF_PI);
    }
    
    public void bogen4(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+0.5f*xraster+xraster+xraster*(float)x1;
         float my = yoff+yraster*(float)y1;
         pap.arc(mx,my,xraster*2.0f,yraster*2.0f,pap.HALF_PI,pap.PI);
    }

//--

    public void Bogen1(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+0.5f*xraster+xraster*(float)x1;
         float my = yoff+yraster*(float)y1;
         pap.arc(mx,my,xraster*4.0f,yraster*4.0f,0,pap.HALF_PI);
    }

    public void Bogen2(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff-xraster+xraster*0.5f+xraster+xraster*(float)x1;
         float my = yoff+2.0f*yraster+yraster*(float)y1;
         pap.arc(mx,my,xraster*4.0f,yraster*4.0f,pap.PI+pap.HALF_PI,pap.TWO_PI);
    }

    public void Bogen3(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+xraster+xraster*0.5f+xraster+xraster*(float)x1;
         float my = yoff+2.0f*yraster+yraster*(float)y1;
         pap.arc(mx,my,xraster*4.0f,yraster*4.0f,pap.PI,pap.PI+pap.HALF_PI);
    }
    
    public void Bogen4(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+0.5f*xraster+2.0f*xraster+xraster*(float)x1;
         float my = yoff+yraster*(float)y1;
         pap.arc(mx,my,xraster*4.0f,yraster*4.0f,pap.HALF_PI,pap.PI);
    }

    public void punkt(int x1,int y1, float xoff, float yoff)
    {
         float mx = xoff+0.05f*xraster+xraster*(float)x1;
         float my = yoff-1.0f*yraster+yraster*(float)y1;
         pap.ellipse(mx,my,xraster*0.3f,yraster*0.3f);
    }


    public void testraster(float xoff, float yoff)
    {
         for(int i=0;i<8;i++)
           pap.line(xoff+xraster*0.5f,yoff+(float)i*yraster,xoff+xraster*0.5f+xraster*2.0f,yoff+(float)i*yraster);
         for(int i=0;i<3;i++)
           pap.line(xoff+xraster*0.5f+(float)i*xraster,yoff,xoff+xraster*0.5f+(float)i*xraster,yoff+7.0f*yraster);
    }
           
    public void draw(char c, int zeile, int spalte)
    {
         float xoff = (float)spalte*real_breite;
         float yoff = (float)zeile*real_hoehe+yraster*0.5f;
         
//translate(100,100);    
//scale(10);
         for(int i=0;i<b.length;i++)
         {
             if(b[i][0].charAt(0)==c && b[i][1].length()==4)
             {
                 for(int k=1;k<b[i].length;k++)
                 {
                      if(b[i][k].charAt(0)=='B')
                      {
                          int xx = (int)b[i][k].charAt(2)-48;
                          int yy = (int)b[i][k].charAt(3)-48;
                          
                          if(b[i][k].charAt(1)=='1')
                              Bogen1(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='2')
                              Bogen2(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='3')
                              Bogen3(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='4')
                              Bogen4(xx,yy,xoff,yoff);
                              
                      }
                      else if(b[i][k].charAt(0)=='b')
                      {
                          int xx = (int)b[i][k].charAt(2)-48;
                          int yy = (int)b[i][k].charAt(3)-48;
                          
                          if(b[i][k].charAt(1)=='1')
                              bogen1(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='2')
                              bogen2(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='3')
                              bogen3(xx,yy,xoff,yoff);
                          else if(b[i][k].charAt(1)=='4')
                              bogen4(xx,yy,xoff,yoff);
                              
                      }
                      else if(b[i][k].charAt(0)=='d')
                      {
                          int xx = (int)b[i][k].charAt(2)-48;
                          int yy = (int)b[i][k].charAt(3)-48;
                          float dx = 0.0f;
                          float dy = 0.0f;
                          if(b[i][k].charAt(1)=='0') { dx=0.0f; dy=0.0f; }
                          if(b[i][k].charAt(1)=='1') { dx=0.5f*xraster; dy=0.0f*yraster; }
                          if(b[i][k].charAt(1)=='2') { dx=1.0f*xraster; dy=0.0f*yraster; }
                          if(b[i][k].charAt(1)=='3') { dx=0.0f*xraster; dy=0.5f*yraster; }
                          if(b[i][k].charAt(1)=='4') { dx=0.5f*xraster; dy=0.5f*yraster; }
                          if(b[i][k].charAt(1)=='5') { dx=1.0f*xraster; dy=0.5f*yraster; }
                          if(b[i][k].charAt(1)=='6') { dx=0.0f*xraster; dy=1.0f*yraster; }
                          if(b[i][k].charAt(1)=='7') { dx=0.5f*xraster; dy=1.0f*yraster; }
                          if(b[i][k].charAt(1)=='8') { dx=1.0f*xraster; dy=1.0f*yraster; }

                          punkt(xx,yy,xoff+dx,yoff+dy);                                                        
                      }
                      else
                      {
                          int x1 = (int)b[i][k].charAt(0)-48;
                          int y1 = (int)b[i][k].charAt(1)-48;
                          int x2 = (int)b[i][k].charAt(2)-48;
                          int y2 = (int)b[i][k].charAt(3)-48;
                          linie(x1,y1,x2,y2,xoff,yoff);
                      }
                 }
             }
         }         
//scale(1.0f/10.0f);
//translate(-100,-100);         
    }

    /**
    *Definition aller Buchstaben
    *abcd 0122 3453 Linien
    *B100 B234 .. Bögen gross
    *b100 b234 .. Bögen klein
    */
    private String[][] b = {
                               {"A","2125","0323","0305","B301"},
                               {"B","0105","0111","0313","0515","b211","b112","b213","b114"},
                               {"C","B301","B403"},
                               {"D","B201","B103","0105"},
                               {"E","0121","0323","0525","0105"},
                               {"F","0121","0323","0105"},
                               {"G","B301","B403","2325","1323"},
                               {"H","0323","0105","2125"},
                               {"I","0121","0525","1115"},
                               {"J","0121","2125","b115","b405"},
                               {"K","0321","0325","0105"},
                               {"L","0525","0105"},
                               {"M","0205","1115","2125","b301","b311"},
                               {"N","0205","b301","1115","b114","2124"},
                               {"O","b301","b211","0204","2224","b114","b404"},                               
                               {"P","0105","0111","0313","b211","b112"},
                               {"Q","b301","b211","0204","2224","b114","b404","1425"},
                               {"R","0105","0111","0313","b211","b112","0325"},
                               {"S","b211","b301","b402","b213","b114","b404"},
                               {"T","0121","1115"},
                               {"U","0104","2124","b114","b404"},
                               {"V","0103","2125","B403"},
                               {"W","0104","1215","2125","b404","b414"},
                               {"X","0125","0521"},
                               {"Y","0521","0113"},
                               {"Z","0121","0525","0521"},
                               
                               {"a","b114","b213","b303","b404","2325"},                               
                               {"b","b114","b213","b303","b404","0105"},
                               {"c","b303","b404","1323","1525"},
                               {"d","b114","b213","b303","b404","2125"},
                               {"e","b213","b303","b404","0424"},
                               {"f","b105","1215","b311","0323"},
                               {"g","b114","b213","b303","b404","2326","b116","b406"},
                               {"h","0105","2425","b213","b303"},
                               {"i","1315","1112"},
                               {"j","1315","1112","b105"},
                               //{"k","b303","b404","1323","1525","0105"},
                               {"k","0423","0425","0105"},
                               {"l","1114","b414"},
                               {"m","0305","1315","2325","b303","b313"},
                               {"n","0305","2425","b303","b213"},
                               {"o","b114","b213","b303","b404"},
                               {"p","b114","b213","b303","b404","0307"},
                               {"q","b114","b213","b303","b404","2327"},
                               {"r","0305","b303","1323"},
                               {"s","b303","1323","0424","b114","0515"},
                               {"t","1114","b414","0222"},
                               {"u","b404","b114","0304","2324"},
                               {"v","0315","1523"},
                               {"w","0304","1315","2325","b404","b414"},
                               {"x","0325","0523"},
                               {"y","b404","b114","0304","2324","2326","b116","b406"},
                               {"z","0323","0525","0523"},
                               
                               {"0","b301","b211","b404","b114","0204","2224","0422"},
                               {"1","1115","0211"},
                               {"2","b301","b211","2205","0525"},
                               {"3","b301","b211","b404","b114","b112","b213"},
                               {"4","0411","0424","1315"},
                               {"5","0121","0103","0313","0515","b213","b114"},
                               {"6","b114","b213","b303","b404","0403","B301"},
                               {"7","0121","2105","0323"},
                               {"8","b114","b213","b303","b404","b112","b211","b301","b402"},
                               {"9","b112","b211","b301","b402","2223","B103"},
                               
                               {".","d715"},
                               {",","b106"},
                               {";","d715","b106"},
                               {":","d712","d714"},
                               {"?","b301","b211","b112","b303","b404","b114","d716"},
                               {"!","1114","d715"},
                               {"+","0323","1214"},
                               {"-","0323"},
                               {"*","d114"},
                               {"/","0521"},
                               
                               {"ä","b114","b213","b303","b404","2325","d203","d213"},                               
                               {"ö","b114","b213","b303","b404","d203","d213"},
                               {"ü","b404","b114","0304","2324","2325","d203","d213"},

                               {"Ä","2125","0323","0305","B301","2325","d201","d211"},
                               {"Ö","b301","b211","0204","2224","b114","b404","d201","d211"},                               
                               {"Ü","0104","2124","b114","b404","2325","d201","d211"},

                               {">","0105","0123","0523"},
                               {"<","2125","2103","2503"},
                               {"^","0411","2411","0424"},
                               {"|","0215","2215","0222"},
                               {"#","0204","0222","0424","2224"}
                               
                           };
    
}
