import java.io.File;
/**
*    Die nachfolgenden Operationen werden alle                                 <br/>
*    im Verzeichnis "data" unterhalb des aktuellen Sketches ausgeführt.        <br/>
*    Die Methoden funktionieren unter Java am PC und mit einem Android-Device. <br/>
*    Das Verzeichnis "data" muß von Hand angelegt werden.                      <br/>
*/
public class Data
{
    private PApplet pap;
    public Data(PApplet pap)
    {
        this.pap = pap;
    }
    
    /**
    * Ausgangspunkt bilden die Processing-eigenen Datei-Operationen.
    */
    public byte[] ladeBinaer(String dateiname)
    {
        return pap.loadBytes(dateiname);
    }
    public String[] ladeZeilen(String dateiname)
    {
        return pap.loadStrings(dateiname);
    }
    public PImage ladeBild(String dateiname)
    {
        return pap.loadImage(dateiname);
    }
    public PFont ladeFont(String dateiname)
    {
        return pap.loadFont(dateiname);
    }

    public void speicherBinaer(String dateiname, byte[] bytes)
    {
        pap.saveBytes(dateiname,bytes);
    }
    public void speicherZeilen(String dateiname, String[] zeilen)
    {
        pap.saveStrings(dateiname,zeilen);
    }
    
    /**
    * Die nachfolgenden Methoden sind Erweiterungen der Processing-eigenen Datei-Operationen.<br/>
    * ...darum das vorangestellte x.
    */
    public double[][] xladeDoubleMatrix(String dateiname)
    {
        String[] zeilen = ladeZeilen(dateiname);
        double[][] matrix = new double[zeilen.length][];
        for(int i=0;i<matrix.length;i++)
        {
            int anfang=0;
            int ende=0;
            int anz=0;
            zeilen[i]=zeilen[i].trim();
            for(int k=0;k<zeilen[i].length();k++)
            {
                while(k<zeilen[i].length() && !Character.isWhitespace(zeilen[i].charAt(k)))
                {
                    k++;
                }
                while(k<zeilen[i].length() && Character.isWhitespace(zeilen[i].charAt(k)))
                {
                    k++;
                }
                k--;
                anz++;
            }
            matrix[i]=new double[anz];
            anz=0;
            for(int k=0;k<zeilen[i].length();k++)
            {
                anfang=k;
                while(k<zeilen[i].length() && !Character.isWhitespace(zeilen[i].charAt(k)))
                {
                    k++;
                }
pap.println("Zerlegen:"+zeilen[i].substring(anfang,k));
                matrix[i][anz]=Double.parseDouble(zeilen[i].substring(anfang,k));
                while(k<zeilen[i].length() && Character.isWhitespace(zeilen[i].charAt(k)))
                {
                    k++;
                }
                k--;
                anz++;
            }
        }
        return matrix;
    }

    public int[][] xladeIntegerMatrix(String dateiname)
    {
        double[][] mat = xladeDoubleMatrix(dateiname);    
        int[][] matrix = new int[mat.length][];
        for(int i=0;i<mat.length;i++)
        {
            matrix[i]=new int[mat[i].length];
            for(int k=0;k<mat[i].length;k++)
                matrix[i][k]=(int)mat[i][k];
        }
        return matrix;
    }

    public void xspeicherDoubleMatrix(String dateiname, double[][] matrix)
    {
        String[] zeilen = new String[matrix.length];
        for(int i=0;i<matrix.length;i++)
        {
            StringBuffer sb = new StringBuffer();
            for(int k=0;k<matrix[i].length;k++)
            {
                sb.append(matrix[i][k]);
                sb.append(" ");
            }
            zeilen[i]=sb.toString();
        }
        speicherZeilen(dateiname,zeilen);
    }

    public void xspeicherIntegerMatrix(String dateiname, int[][] matrix)
    {
        String[] zeilen = new String[matrix.length];
        for(int i=0;i<matrix.length;i++)
        {
            StringBuffer sb = new StringBuffer();
            for(int k=0;k<matrix[i].length;k++)
            {
                sb.append(""+matrix[i][k]);
                sb.append(" ");
            }
            zeilen[i]=sb.toString();
        }
        speicherZeilen(dateiname,zeilen);
    }

    /**
    *   Binärdaten lesbar anzeigen in 10-er Reihen.
    */
    public void zeigeBinaer(byte[] dat, int max)
    {
        if(max>dat.length)
            max=dat.length;
        for(int i=0;i<max;i++)
        {
            if(i>0 && i%10==0)
                System.out.println();
            System.out.print((int)dat[i]+" ");
        }
    }
}


