/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.PGL;
import processing.opengl.PGraphics2D;
import processing.opengl.PGraphics3D;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShader;
import processing.opengl.Texture;

public class PShapeOpenGL
extends PShape {
    public static final int POSITION = 0;
    public static final int NORMAL = 1;
    public static final int TEXCOORD = 2;
    public static final int DIRECTION = 3;
    public static final int OFFSET = 4;
    protected static final int TRANSLATE = 0;
    protected static final int ROTATE = 1;
    protected static final int SCALE = 2;
    protected static final int MATRIX = 3;
    protected PGraphicsOpenGL pg;
    protected PGL pgl;
    protected int context;
    protected PShapeOpenGL root;
    protected PGraphicsOpenGL.InGeometry inGeo;
    protected PGraphicsOpenGL.TessGeometry tessGeo;
    protected PGraphicsOpenGL.Tessellator tessellator;
    protected HashSet<PImage> textures;
    protected boolean strokedTexture;
    public int glPolyVertex;
    public int glPolyColor;
    public int glPolyNormal;
    public int glPolyTexcoord;
    public int glPolyAmbient;
    public int glPolySpecular;
    public int glPolyEmissive;
    public int glPolyShininess;
    public int glPolyIndex;
    public int glLineVertex;
    public int glLineColor;
    public int glLineAttrib;
    public int glLineIndex;
    public int glPointVertex;
    public int glPointColor;
    public int glPointAttrib;
    public int glPointIndex;
    public int glUsage = PGL.STATIC_DRAW;
    protected int polyVertCopyOffset;
    protected int polyIndCopyOffset;
    protected int lineVertCopyOffset;
    protected int lineIndCopyOffset;
    protected int pointVertCopyOffset;
    protected int pointIndCopyOffset;
    protected int polyIndexOffset;
    protected int polyVertexOffset;
    protected int polyVertexAbs;
    protected int polyVertexRel;
    protected int lineIndexOffset;
    protected int lineVertexOffset;
    protected int lineVertexAbs;
    protected int lineVertexRel;
    protected int pointIndexOffset;
    protected int pointVertexOffset;
    protected int pointVertexAbs;
    protected int pointVertexRel;
    protected int firstPolyIndexCache;
    protected int lastPolyIndexCache;
    protected int firstLineIndexCache;
    protected int lastLineIndexCache;
    protected int firstPointIndexCache;
    protected int lastPointIndexCache;
    protected int firstPolyVertex;
    protected int lastPolyVertex;
    protected int firstLineVertex;
    protected int lastLineVertex;
    protected int firstPointVertex;
    protected int lastPointVertex;
    protected PMatrix transform;
    protected Stack<PMatrix> transformStack;
    protected boolean tessellated;
    protected boolean needBufferInit = false;
    protected boolean solid;
    protected boolean breakShape = false;
    protected boolean shapeCreated = false;
    protected boolean hasPolys;
    protected boolean hasLines;
    protected boolean hasPoints;
    protected int bezierDetail;
    protected int curveDetail;
    protected float curveTightness;
    protected int savedBezierDetail;
    protected int savedCurveDetail;
    protected float savedCurveTightness;
    protected float normalX;
    protected float normalY;
    protected float normalZ;
    protected static final int NORMAL_MODE_AUTO = 0;
    protected static final int NORMAL_MODE_SHAPE = 1;
    protected static final int NORMAL_MODE_VERTEX = 2;
    protected int normalMode;
    protected boolean modified;
    protected boolean modifiedPolyVertices;
    protected boolean modifiedPolyColors;
    protected boolean modifiedPolyNormals;
    protected boolean modifiedPolyTexCoords;
    protected boolean modifiedPolyAmbient;
    protected boolean modifiedPolySpecular;
    protected boolean modifiedPolyEmissive;
    protected boolean modifiedPolyShininess;
    protected boolean modifiedLineVertices;
    protected boolean modifiedLineColors;
    protected boolean modifiedLineAttributes;
    protected boolean modifiedPointVertices;
    protected boolean modifiedPointColors;
    protected boolean modifiedPointAttributes;
    protected int firstModifiedPolyVertex;
    protected int lastModifiedPolyVertex;
    protected int firstModifiedPolyColor;
    protected int lastModifiedPolyColor;
    protected int firstModifiedPolyNormal;
    protected int lastModifiedPolyNormal;
    protected int firstModifiedPolyTexcoord;
    protected int lastModifiedPolyTexcoord;
    protected int firstModifiedPolyAmbient;
    protected int lastModifiedPolyAmbient;
    protected int firstModifiedPolySpecular;
    protected int lastModifiedPolySpecular;
    protected int firstModifiedPolyEmissive;
    protected int lastModifiedPolyEmissive;
    protected int firstModifiedPolyShininess;
    protected int lastModifiedPolyShininess;
    protected int firstModifiedLineVertex;
    protected int lastModifiedLineVertex;
    protected int firstModifiedLineColor;
    protected int lastModifiedLineColor;
    protected int firstModifiedLineAttribute;
    protected int lastModifiedLineAttribute;
    protected int firstModifiedPointVertex;
    protected int lastModifiedPointVertex;
    protected int firstModifiedPointColor;
    protected int lastModifiedPointColor;
    protected int firstModifiedPointAttribute;
    protected int lastModifiedPointAttribute;
    protected boolean savedStroke;
    protected int savedStrokeColor;
    protected float savedStrokeWeight;
    protected int savedStrokeCap;
    protected int savedStrokeJoin;
    protected boolean savedFill;
    protected int savedFillColor;
    protected boolean savedTint;
    protected int savedTintColor;
    protected int savedAmbientColor;
    protected int savedSpecularColor;
    protected int savedEmissiveColor;
    protected float savedShininess;
    protected int savedTextureMode;

    PShapeOpenGL() {
    }

    public PShapeOpenGL(PGraphicsOpenGL pGraphicsOpenGL, int n) {
        this.pg = pGraphicsOpenGL;
        this.pgl = pGraphicsOpenGL.pgl;
        this.context = this.pgl.createEmptyContext();
        this.glPolyVertex = 0;
        this.glPolyColor = 0;
        this.glPolyNormal = 0;
        this.glPolyTexcoord = 0;
        this.glPolyAmbient = 0;
        this.glPolySpecular = 0;
        this.glPolyEmissive = 0;
        this.glPolyShininess = 0;
        this.glPolyIndex = 0;
        this.glLineVertex = 0;
        this.glLineColor = 0;
        this.glLineAttrib = 0;
        this.glLineIndex = 0;
        this.glPointVertex = 0;
        this.glPointColor = 0;
        this.glPointAttrib = 0;
        this.glPointIndex = 0;
        this.tessellator = PGraphicsOpenGL.tessellator;
        this.family = n;
        this.root = this;
        this.parent = null;
        this.tessellated = false;
        if (n == 3 || n == 1 || n == 2) {
            this.inGeo = PGraphicsOpenGL.newInGeometry(pGraphicsOpenGL, 1);
        }
        this.textureMode = pGraphicsOpenGL.textureMode;
        this.colorMode(pGraphicsOpenGL.colorMode, pGraphicsOpenGL.colorModeX, pGraphicsOpenGL.colorModeY, pGraphicsOpenGL.colorModeZ, pGraphicsOpenGL.colorModeA);
        this.fill = pGraphicsOpenGL.fill;
        this.fillColor = pGraphicsOpenGL.fillColor;
        this.stroke = pGraphicsOpenGL.stroke;
        this.strokeColor = pGraphicsOpenGL.strokeColor;
        this.strokeWeight = pGraphicsOpenGL.strokeWeight;
        this.strokeCap = pGraphicsOpenGL.strokeCap;
        this.strokeJoin = pGraphicsOpenGL.strokeJoin;
        this.tint = pGraphicsOpenGL.tint;
        this.tintColor = pGraphicsOpenGL.tintColor;
        this.setAmbient = pGraphicsOpenGL.setAmbient;
        this.ambientColor = pGraphicsOpenGL.ambientColor;
        this.specularColor = pGraphicsOpenGL.specularColor;
        this.emissiveColor = pGraphicsOpenGL.emissiveColor;
        this.shininess = pGraphicsOpenGL.shininess;
        this.sphereDetailU = pGraphicsOpenGL.sphereDetailU;
        this.sphereDetailV = pGraphicsOpenGL.sphereDetailV;
        this.bezierDetail = pGraphicsOpenGL.bezierDetail;
        this.curveDetail = pGraphicsOpenGL.curveDetail;
        this.curveTightness = pGraphicsOpenGL.curveTightness;
        this.rectMode = 0;
        this.ellipseMode = 0;
        this.normalY = 0.0f;
        this.normalX = 0.0f;
        this.normalZ = 1.0f;
        this.normalMode = 0;
        this.breakShape = false;
        if (n == 0) {
            this.shapeCreated = true;
        }
    }

    @Override
    public void addChild(PShape pShape) {
        if (pShape instanceof PShapeOpenGL) {
            if (this.family == 0) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)pShape;
                super.addChild(pShapeOpenGL);
                pShapeOpenGL.updateRoot(this.root);
                this.markForTessellation();
                if (pShapeOpenGL.family == 0) {
                    if (pShapeOpenGL.textures != null) {
                        for (PImage pImage : pShapeOpenGL.textures) {
                            this.addTexture(pImage);
                        }
                    }
                    if (pShapeOpenGL.strokedTexture) {
                        this.strokedTexture(true);
                    }
                } else if (pShapeOpenGL.image != null) {
                    this.addTexture(pShapeOpenGL.image);
                    if (pShapeOpenGL.stroke) {
                        this.strokedTexture(true);
                    }
                }
            } else {
                PGraphics.showWarning("Cannot add child shape to non-group shape.");
            }
        } else {
            PGraphics.showWarning("Shape must be OpenGL to be added to the group.");
        }
    }

    @Override
    public void addChild(PShape pShape, int n) {
        if (pShape instanceof PShapeOpenGL) {
            if (this.family == 0) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)pShape;
                super.addChild(pShapeOpenGL, n);
                pShapeOpenGL.updateRoot(this.root);
                this.markForTessellation();
                if (pShapeOpenGL.family == 0) {
                    if (pShapeOpenGL.textures != null) {
                        for (PImage pImage : pShapeOpenGL.textures) {
                            this.addTexture(pImage);
                        }
                    }
                    if (pShapeOpenGL.strokedTexture) {
                        this.strokedTexture(true);
                    }
                } else if (pShapeOpenGL.image != null) {
                    this.addTexture(pShapeOpenGL.image);
                    if (pShapeOpenGL.stroke) {
                        this.strokedTexture(true);
                    }
                }
            } else {
                PGraphics.showWarning("Cannot add child shape to non-group shape.");
            }
        } else {
            PGraphics.showWarning("Shape must be OpenGL to be added to the group.");
        }
    }

    @Override
    public void removeChild(int n) {
        super.removeChild(n);
        this.markForTessellation();
    }

    protected void updateRoot(PShape pShape) {
        this.root = (PShapeOpenGL)pShape;
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.updateRoot(pShape);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.finalizePolyBuffers();
            this.finalizeLineBuffers();
            this.finalizePointBuffers();
        }
        finally {
            super.finalize();
        }
    }

    protected void finalizePolyBuffers() {
        if (this.glPolyVertex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyVertex, this.context);
        }
        if (this.glPolyColor != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyColor, this.context);
        }
        if (this.glPolyNormal != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyNormal, this.context);
        }
        if (this.glPolyTexcoord != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyTexcoord, this.context);
        }
        if (this.glPolyAmbient != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyAmbient, this.context);
        }
        if (this.glPolySpecular != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolySpecular, this.context);
        }
        if (this.glPolyEmissive != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyEmissive, this.context);
        }
        if (this.glPolyShininess != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyShininess, this.context);
        }
        if (this.glPolyIndex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyIndex, this.context);
        }
    }

    protected void finalizeLineBuffers() {
        if (this.glLineVertex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glLineVertex, this.context);
        }
        if (this.glLineColor != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glLineColor, this.context);
        }
        if (this.glLineAttrib != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glLineAttrib, this.context);
        }
        if (this.glLineIndex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glLineIndex, this.context);
        }
    }

    protected void finalizePointBuffers() {
        if (this.glPointVertex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPointVertex, this.context);
        }
        if (this.glPointColor != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPointColor, this.context);
        }
        if (this.glPointAttrib != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPointAttrib, this.context);
        }
        if (this.glPointIndex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPointIndex, this.context);
        }
    }

    public static PShapeOpenGL createShape3D(PGraphicsOpenGL pGraphicsOpenGL, PShape pShape) {
        PShapeOpenGL pShapeOpenGL = null;
        if (pShape.getFamily() == 0) {
            pShapeOpenGL = PGraphics3D.createShapeImpl(pGraphicsOpenGL, 0);
            PShapeOpenGL.copyGroup3D(pGraphicsOpenGL, pShape, pShapeOpenGL);
        } else if (pShape.getFamily() == 1) {
            pShapeOpenGL = PGraphics3D.createShapeImpl(pGraphicsOpenGL, pShape.getKind(), pShape.getParams());
            PShape.copyPrimitive(pShape, pShapeOpenGL);
        } else if (pShape.getFamily() == 3) {
            pShapeOpenGL = PGraphics3D.createShapeImpl(pGraphicsOpenGL, 3);
            PShape.copyGeometry(pShape, pShapeOpenGL);
        } else if (pShape.getFamily() == 2) {
            pShapeOpenGL = PGraphics3D.createShapeImpl(pGraphicsOpenGL, 2);
            PShape.copyPath(pShape, pShapeOpenGL);
        }
        pShapeOpenGL.setName(pShape.getName());
        pShapeOpenGL.width = pShape.width;
        pShapeOpenGL.height = pShape.height;
        pShapeOpenGL.depth = pShape.depth;
        return pShapeOpenGL;
    }

    public static PShapeOpenGL createShape2D(PGraphicsOpenGL pGraphicsOpenGL, PShape pShape) {
        PShapeOpenGL pShapeOpenGL = null;
        if (pShape.getFamily() == 0) {
            pShapeOpenGL = PGraphics2D.createShapeImpl(pGraphicsOpenGL, 0);
            PShapeOpenGL.copyGroup2D(pGraphicsOpenGL, pShape, pShapeOpenGL);
        } else if (pShape.getFamily() == 1) {
            pShapeOpenGL = PGraphics2D.createShapeImpl(pGraphicsOpenGL, pShape.getKind(), pShape.getParams());
            PShape.copyPrimitive(pShape, pShapeOpenGL);
        } else if (pShape.getFamily() == 3) {
            pShapeOpenGL = PGraphics2D.createShapeImpl(pGraphicsOpenGL, 3);
            PShape.copyGeometry(pShape, pShapeOpenGL);
        } else if (pShape.getFamily() == 2) {
            pShapeOpenGL = PGraphics2D.createShapeImpl(pGraphicsOpenGL, 2);
            PShape.copyPath(pShape, pShapeOpenGL);
        }
        pShapeOpenGL.setName(pShape.getName());
        pShapeOpenGL.width = pShape.width;
        pShapeOpenGL.height = pShape.height;
        return pShapeOpenGL;
    }

    public static void copyGroup3D(PGraphicsOpenGL pGraphicsOpenGL, PShape pShape, PShape pShape2) {
        PShapeOpenGL.copyMatrix(pShape, pShape2);
        PShapeOpenGL.copyStyles(pShape, pShape2);
        PShapeOpenGL.copyImage(pShape, pShape2);
        for (int i = 0; i < pShape.getChildCount(); ++i) {
            PShapeOpenGL pShapeOpenGL = PShapeOpenGL.createShape3D(pGraphicsOpenGL, pShape.getChild(i));
            pShape2.addChild(pShapeOpenGL);
        }
    }

    public static void copyGroup2D(PGraphicsOpenGL pGraphicsOpenGL, PShape pShape, PShape pShape2) {
        PShapeOpenGL.copyMatrix(pShape, pShape2);
        PShapeOpenGL.copyStyles(pShape, pShape2);
        PShapeOpenGL.copyImage(pShape, pShape2);
        for (int i = 0; i < pShape.getChildCount(); ++i) {
            PShapeOpenGL pShapeOpenGL = PShapeOpenGL.createShape2D(pGraphicsOpenGL, pShape.getChild(i));
            pShape2.addChild(pShapeOpenGL);
        }
    }

    @Override
    public float getWidth() {
        PVector pVector = new PVector(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        PVector pVector2 = new PVector(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        if (this.shapeCreated) {
            this.getVertexMin(pVector);
            this.getVertexMax(pVector2);
        }
        this.width = pVector2.x - pVector.x;
        return this.width;
    }

    @Override
    public float getHeight() {
        PVector pVector = new PVector(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        PVector pVector2 = new PVector(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        if (this.shapeCreated) {
            this.getVertexMin(pVector);
            this.getVertexMax(pVector2);
        }
        this.height = pVector2.y - pVector.y;
        return this.height;
    }

    @Override
    public float getDepth() {
        PVector pVector = new PVector(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        PVector pVector2 = new PVector(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        if (this.shapeCreated) {
            this.getVertexMin(pVector);
            this.getVertexMax(pVector2);
        }
        this.depth = pVector2.z - pVector.z;
        return this.depth;
    }

    protected void getVertexMin(PVector pVector) {
        this.updateTessellation();
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.getVertexMin(pVector);
            }
        } else {
            if (this.hasPolys) {
                this.tessGeo.getPolyVertexMin(pVector, this.firstPolyVertex, this.lastPolyVertex);
            }
            if (this.is3D()) {
                if (this.hasLines) {
                    this.tessGeo.getLineVertexMin(pVector, this.firstLineVertex, this.lastLineVertex);
                }
                if (this.hasPoints) {
                    this.tessGeo.getPointVertexMin(pVector, this.firstPointVertex, this.lastPointVertex);
                }
            }
        }
    }

    protected void getVertexMax(PVector pVector) {
        this.updateTessellation();
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.getVertexMax(pVector);
            }
        } else {
            if (this.hasPolys) {
                this.tessGeo.getPolyVertexMax(pVector, this.firstPolyVertex, this.lastPolyVertex);
            }
            if (this.is3D()) {
                if (this.hasLines) {
                    this.tessGeo.getLineVertexMax(pVector, this.firstLineVertex, this.lastLineVertex);
                }
                if (this.hasPoints) {
                    this.tessGeo.getPointVertexMax(pVector, this.firstPointVertex, this.lastPointVertex);
                }
            }
        }
    }

    protected int getVertexSum(PVector pVector, int n) {
        this.updateTessellation();
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                n += pShapeOpenGL.getVertexSum(pVector, n);
            }
        } else {
            if (this.hasPolys) {
                n += this.tessGeo.getPolyVertexSum(pVector, this.firstPolyVertex, this.lastPolyVertex);
            }
            if (this.is3D()) {
                if (this.hasLines) {
                    n += this.tessGeo.getLineVertexSum(pVector, this.firstLineVertex, this.lastLineVertex);
                }
                if (this.hasPoints) {
                    n += this.tessGeo.getPointVertexSum(pVector, this.firstPointVertex, this.lastPointVertex);
                }
            }
        }
        return n;
    }

    @Override
    public void setTextureMode(int n) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setTextureMode()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setTextureMode(n);
            }
        } else {
            this.setTextureModeImpl(n);
        }
    }

    protected void setTextureModeImpl(int n) {
        if (this.textureMode == n) {
            return;
        }
        this.textureMode = n;
        if (this.image != null) {
            float f = this.image.width;
            float f2 = this.image.height;
            if (this.textureMode == 1) {
                f = 1.0f / f;
                f2 = 1.0f / f2;
            }
            this.scaleTextureUV(f, f2);
        }
    }

    @Override
    public void setTexture(PImage pImage) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setTexture()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setTexture(pImage);
            }
        } else {
            this.setTextureImpl(pImage);
        }
    }

    protected void setTextureImpl(PImage pImage) {
        PImage pImage2 = this.image;
        this.image = pImage;
        if (this.textureMode == 2 && pImage2 != this.image) {
            float f = 1.0f;
            float f2 = 1.0f;
            if (this.image != null) {
                f /= (float)this.image.width;
                f2 /= (float)this.image.height;
            }
            if (pImage2 != null) {
                f *= (float)pImage2.width;
                f2 *= (float)pImage2.height;
            }
            this.scaleTextureUV(f, f2);
        }
        if (pImage2 != pImage && this.parent != null) {
            ((PShapeOpenGL)this.parent).removeTexture(pImage);
        }
        if (this.parent != null) {
            ((PShapeOpenGL)this.parent).addTexture(this.image);
            if (this.is2D() && this.stroke) {
                ((PShapeOpenGL)this.parent).strokedTexture(true);
            }
        }
    }

    protected void scaleTextureUV(float f, float f2) {
        float f3;
        int n;
        if (PGraphicsOpenGL.same(f, 1.0f) && PGraphicsOpenGL.same(f2, 1.0f)) {
            return;
        }
        for (n = 0; n < this.inGeo.vertexCount; ++n) {
            float f4 = this.inGeo.texcoords[2 * n + 0];
            f3 = this.inGeo.texcoords[2 * n + 1];
            this.inGeo.texcoords[2 * n + 0] = PApplet.min(1.0f, f4 * f);
            this.inGeo.texcoords[2 * n + 1] = PApplet.min(1.0f, f3 * f);
        }
        if (this.shapeCreated && this.tessellated && this.hasPolys) {
            n = 0;
            if (this.is3D()) {
                n = this.lastPolyVertex + 1;
            } else if (this.is2D()) {
                n = this.lastPolyVertex + 1;
                if (-1 < this.firstLineVertex) {
                    n = this.firstLineVertex;
                }
                if (-1 < this.firstPointVertex) {
                    n = this.firstPointVertex;
                }
            }
            for (int i = this.firstLineVertex; i < n; ++i) {
                f3 = this.tessGeo.polyTexCoords[2 * i + 0];
                float f5 = this.tessGeo.polyTexCoords[2 * i + 1];
                this.tessGeo.polyTexCoords[2 * i + 0] = PApplet.min(1.0f, f3 * f);
                this.tessGeo.polyTexCoords[2 * i + 1] = PApplet.min(1.0f, f5 * f);
            }
            this.root.setModifiedPolyTexCoords(this.firstPolyVertex, n - 1);
        }
    }

    protected void addTexture(PImage pImage) {
        if (this.textures == null) {
            this.textures = new HashSet();
        }
        this.textures.add(pImage);
        if (this.parent != null) {
            ((PShapeOpenGL)this.parent).addTexture(pImage);
        }
    }

    protected void removeTexture(PImage pImage) {
        if (this.textures == null || !this.textures.contains(pImage)) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < this.childCount; ++i) {
            PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
            if (!pShapeOpenGL.hasTexture(pImage)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.textures.remove(pImage);
            if (this.textures.size() == 0) {
                this.textures = null;
            }
        }
        if (this.parent != null) {
            ((PShapeOpenGL)this.parent).removeTexture(pImage);
        }
    }

    protected void strokedTexture(boolean bl) {
        if (this.strokedTexture == bl) {
            return;
        }
        if (bl) {
            this.strokedTexture = true;
        } else {
            boolean bl2 = false;
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                if (!pShapeOpenGL.hasStrokedTexture()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.strokedTexture = false;
            }
        }
        if (this.parent != null) {
            ((PShapeOpenGL)this.parent).strokedTexture(bl);
        }
    }

    protected boolean hasTexture(PImage pImage) {
        if (this.family == 0) {
            return this.textures != null && this.textures.contains(pImage);
        }
        return this.image == pImage;
    }

    protected boolean hasStrokedTexture() {
        if (this.family == 0) {
            return this.strokedTexture;
        }
        return this.image != null && this.stroke;
    }

    @Override
    public void solid(boolean bl) {
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.solid(bl);
            }
        } else {
            this.solid = bl;
        }
    }

    @Override
    protected void beginContourImpl() {
        this.breakShape = true;
    }

    @Override
    protected void endContourImpl() {
    }

    @Override
    public void vertex(float f, float f2) {
        this.vertexImpl(f, f2, 0.0f, 0.0f, 0.0f);
        if (this.image != null) {
            PGraphics.showWarning("No uv texture coordinates supplied with vertex() call");
        }
    }

    @Override
    public void vertex(float f, float f2, float f3, float f4) {
        this.vertexImpl(f, f2, 0.0f, f3, f4);
    }

    @Override
    public void vertex(float f, float f2, float f3) {
        this.vertexImpl(f, f2, f3, 0.0f, 0.0f);
        if (this.image != null) {
            PGraphics.showWarning("No uv texture coordinates supplied with vertex() call");
        }
    }

    @Override
    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.vertexImpl(f, f2, f3, f4, f5);
    }

    protected void vertexImpl(float f, float f2, float f3, float f4, float f5) {
        if (!this.openShape) {
            PGraphics.showWarning("%1$s can only be called between beginShape() and endShape()", "vertex()");
            return;
        }
        if (this.family == 0) {
            PGraphics.showWarning("Cannot add vertices to GROUP shape");
            return;
        }
        boolean bl = this.image != null;
        int n = 0;
        if (this.fill || bl) {
            n = !bl ? this.fillColor : (this.tint ? this.tintColor : -1);
        }
        if (this.textureMode == 2 && this.image != null) {
            f4 /= (float)this.image.width;
            f5 /= (float)this.image.height;
        }
        int n2 = 0;
        float f6 = 0.0f;
        if (this.stroke) {
            n2 = this.strokeColor;
            f6 = this.strokeWeight;
        }
        this.inGeo.addVertex(f, f2, f3, n, this.normalX, this.normalY, this.normalZ, f4, f5, n2, f6, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess, 0, this.vertexBreak());
        this.markForTessellation();
    }

    protected boolean vertexBreak() {
        if (this.breakShape) {
            this.breakShape = false;
            return true;
        }
        return false;
    }

    @Override
    public void normal(float f, float f2, float f3) {
        if (!this.openShape) {
            PGraphics.showWarning("%1$s can only be called between beginShape() and endShape()", "normal()");
            return;
        }
        if (this.family == 0) {
            PGraphics.showWarning("Cannot set normal in GROUP shape");
            return;
        }
        this.normalX = f;
        this.normalY = f2;
        this.normalZ = f3;
        if (this.normalMode == 0) {
            this.normalMode = 1;
        } else if (this.normalMode == 1) {
            this.normalMode = 2;
        }
    }

    @Override
    public void endShape(int n) {
        super.endShape(n);
        this.inGeo.trim();
        this.close = n == 2;
        this.markForTessellation();
        this.shapeCreated = true;
    }

    @Override
    public void setParams(float[] fArray) {
        if (this.family != 1) {
            PGraphics.showWarning("Parameters can only be set to PRIMITIVE shapes");
            return;
        }
        super.setParams(fArray);
        this.markForTessellation();
        this.shapeCreated = true;
    }

    @Override
    public void setPath(int n, float[][] fArray, int n2, int[] nArray) {
        if (this.family != 2) {
            PGraphics.showWarning("Vertex coordinates and codes can only be set to PATH shapes");
            return;
        }
        super.setPath(n, fArray, n2, nArray);
        this.markForTessellation();
        this.shapeCreated = true;
    }

    @Override
    public void translate(float f, float f2) {
        if (this.is3D) {
            this.transform(0, f, f2, 0.0f);
        } else {
            this.transform(0, f, f2);
        }
    }

    @Override
    public void translate(float f, float f2, float f3) {
        this.transform(0, f, f2, f3);
    }

    @Override
    public void rotate(float f) {
        this.transform(1, f);
    }

    @Override
    public void rotateX(float f) {
        this.rotate(f, 1.0f, 0.0f, 0.0f);
    }

    @Override
    public void rotateY(float f) {
        this.rotate(f, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void rotateZ(float f) {
        this.transform(1, f);
    }

    @Override
    public void rotate(float f, float f2, float f3, float f4) {
        this.transform(1, f, f2, f3, f4);
    }

    @Override
    public void scale(float f) {
        if (this.is3D) {
            this.transform(2, f, f, f);
        } else {
            this.transform(2, f, f);
        }
    }

    @Override
    public void scale(float f, float f2) {
        if (this.is3D) {
            this.transform(2, f, f2, 1.0f);
        } else {
            this.transform(2, f, f2);
        }
    }

    @Override
    public void scale(float f, float f2, float f3) {
        this.transform(2, f, f2, f3);
    }

    @Override
    public void applyMatrix(PMatrix2D pMatrix2D) {
        this.transform(3, pMatrix2D.m00, pMatrix2D.m01, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, pMatrix2D.m12);
    }

    @Override
    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.transform(3, f, f2, f3, f4, f5, f6);
    }

    @Override
    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.transform(3, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    @Override
    public void resetMatrix() {
        if (this.shapeCreated && this.matrix != null && this.transformStack != null) {
            if (this.family == 0) {
                this.updateTessellation();
            }
            if (this.tessellated) {
                PMatrix pMatrix = this.popTransform();
                while (pMatrix != null) {
                    boolean bl = pMatrix.invert();
                    if (bl) {
                        this.applyMatrixImpl(pMatrix);
                    } else {
                        PGraphics.showWarning("Transformation applied on the shape cannot be inverted");
                    }
                    pMatrix = this.popTransform();
                }
            }
            this.matrix.reset();
            this.transformStack.clear();
        }
    }

    protected void transform(int n, float ... fArray) {
        int n2 = this.is3D ? 3 : 2;
        this.checkMatrix(n2);
        if (this.transform == null) {
            this.transform = n2 == 2 ? new PMatrix2D() : new PMatrix3D();
        } else {
            this.transform.reset();
        }
        int n3 = fArray.length;
        if (n == 1) {
            n3 = fArray.length == 1 ? 2 : 3;
        } else if (n == 3) {
            n3 = fArray.length == 6 ? 2 : 3;
        }
        switch (n) {
            case 0: {
                if (n3 == 3) {
                    this.transform.translate(fArray[0], fArray[1], fArray[2]);
                    break;
                }
                this.transform.translate(fArray[0], fArray[1]);
                break;
            }
            case 1: {
                if (n3 == 3) {
                    this.transform.rotate(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                this.transform.rotate(fArray[0]);
                break;
            }
            case 2: {
                if (n3 == 3) {
                    this.transform.scale(fArray[0], fArray[1], fArray[2]);
                    break;
                }
                this.transform.scale(fArray[0], fArray[1]);
                break;
            }
            case 3: {
                if (n3 == 3) {
                    this.transform.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7], fArray[8], fArray[9], fArray[10], fArray[11], fArray[12], fArray[13], fArray[14], fArray[15]);
                    break;
                }
                this.transform.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
            }
        }
        this.matrix.apply(this.transform);
        this.pushTransform();
        if (this.tessellated) {
            this.applyMatrixImpl(this.transform);
        }
    }

    protected void pushTransform() {
        if (this.transformStack == null) {
            this.transformStack = new Stack();
        }
        PMatrix pMatrix = this.transform instanceof PMatrix2D ? new PMatrix2D() : new PMatrix3D();
        pMatrix.set(this.transform);
        this.transformStack.push(pMatrix);
    }

    protected PMatrix popTransform() {
        if (this.transformStack == null || this.transformStack.size() == 0) {
            return null;
        }
        return this.transformStack.pop();
    }

    protected void applyMatrixImpl(PMatrix pMatrix) {
        if (this.hasPolys) {
            this.tessGeo.applyMatrixOnPolyGeometry(pMatrix, this.firstPolyVertex, this.lastPolyVertex);
            this.root.setModifiedPolyVertices(this.firstPolyVertex, this.lastPolyVertex);
            this.root.setModifiedPolyNormals(this.firstPolyVertex, this.lastPolyVertex);
        }
        if (this.is3D()) {
            if (this.hasLines) {
                this.tessGeo.applyMatrixOnLineGeometry(pMatrix, this.firstLineVertex, this.lastLineVertex);
                this.root.setModifiedLineVertices(this.firstLineVertex, this.lastLineVertex);
                this.root.setModifiedLineAttributes(this.firstLineVertex, this.lastLineVertex);
            }
            if (this.hasPoints) {
                this.tessGeo.applyMatrixOnPointGeometry(pMatrix, this.firstPointVertex, this.lastPointVertex);
                this.root.setModifiedPointVertices(this.firstPointVertex, this.lastPointVertex);
            }
        }
    }

    @Override
    public void bezierDetail(int n) {
        this.bezierDetail = n;
        if (0 < this.inGeo.codeCount) {
            this.markForTessellation();
        }
    }

    @Override
    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bezierVertexImpl(f, f2, 0.0f, f3, f4, 0.0f, f5, f6, 0.0f);
    }

    @Override
    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.bezierVertexImpl(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    protected void bezierVertexImpl(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addBezierVertex(f, f2, f3, f4, f5, f6, f7, f8, f9, this.vertexBreak());
    }

    @Override
    public void quadraticVertex(float f, float f2, float f3, float f4) {
        this.quadraticVertexImpl(f, f2, 0.0f, f3, f4, 0.0f);
    }

    @Override
    public void quadraticVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.quadraticVertexImpl(f, f2, f3, f4, f5, f6);
    }

    protected void quadraticVertexImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuadraticVertex(f, f2, f3, f4, f5, f6, this.vertexBreak());
    }

    @Override
    public void curveDetail(int n) {
        this.curveDetail = n;
        if (0 < this.inGeo.codeCount) {
            this.markForTessellation();
        }
    }

    @Override
    public void curveTightness(float f) {
        this.curveTightness = f;
        if (0 < this.inGeo.codeCount) {
            this.markForTessellation();
        }
    }

    @Override
    public void curveVertex(float f, float f2) {
        this.curveVertexImpl(f, f2, 0.0f);
    }

    @Override
    public void curveVertex(float f, float f2, float f3) {
        this.curveVertexImpl(f, f2, f3);
    }

    protected void curveVertexImpl(float f, float f2, float f3) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addCurveVertex(f, f2, f3, this.vertexBreak());
    }

    @Override
    public int getVertexCount() {
        if (this.family == 0) {
            return 0;
        }
        if (this.family == 1 || this.family == 2) {
            this.updateTessellation();
        }
        return this.inGeo.vertexCount;
    }

    @Override
    public PVector getVertex(int n, PVector pVector) {
        if (pVector == null) {
            pVector = new PVector();
        }
        pVector.x = this.inGeo.vertices[3 * n + 0];
        pVector.y = this.inGeo.vertices[3 * n + 1];
        pVector.z = this.inGeo.vertices[3 * n + 2];
        return pVector;
    }

    @Override
    public float getVertexX(int n) {
        return this.inGeo.vertices[3 * n + 0];
    }

    @Override
    public float getVertexY(int n) {
        return this.inGeo.vertices[3 * n + 1];
    }

    @Override
    public float getVertexZ(int n) {
        return this.inGeo.vertices[3 * n + 2];
    }

    @Override
    public void setVertex(int n, float f, float f2) {
        this.setVertex(n, f, f2, 0.0f);
    }

    @Override
    public void setVertex(int n, float f, float f2, float f3) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setVertex()");
            return;
        }
        this.inGeo.vertices[3 * n + 0] = f;
        this.inGeo.vertices[3 * n + 1] = f2;
        this.inGeo.vertices[3 * n + 2] = f3;
        this.markForTessellation();
    }

    @Override
    public void setVertex(int n, PVector pVector) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setVertex()");
            return;
        }
        this.inGeo.vertices[3 * n + 0] = pVector.x;
        this.inGeo.vertices[3 * n + 1] = pVector.y;
        this.inGeo.vertices[3 * n + 2] = pVector.z;
        this.markForTessellation();
    }

    @Override
    public PVector getNormal(int n, PVector pVector) {
        if (pVector == null) {
            pVector = new PVector();
        }
        pVector.x = this.inGeo.normals[3 * n + 0];
        pVector.y = this.inGeo.normals[3 * n + 1];
        pVector.z = this.inGeo.normals[3 * n + 2];
        return pVector;
    }

    @Override
    public float getNormalX(int n) {
        return this.inGeo.normals[3 * n + 0];
    }

    @Override
    public float getNormalY(int n) {
        return this.inGeo.normals[3 * n + 1];
    }

    @Override
    public float getNormalZ(int n) {
        return this.inGeo.normals[3 * n + 2];
    }

    @Override
    public void setNormal(int n, float f, float f2, float f3) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setNormal()");
            return;
        }
        this.inGeo.normals[3 * n + 0] = f;
        this.inGeo.normals[3 * n + 1] = f2;
        this.inGeo.normals[3 * n + 2] = f3;
        this.markForTessellation();
    }

    @Override
    public float getTextureU(int n) {
        return this.inGeo.texcoords[2 * n + 0];
    }

    @Override
    public float getTextureV(int n) {
        return this.inGeo.texcoords[2 * n + 1];
    }

    @Override
    public void setTextureUV(int n, float f, float f2) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setTextureUV()");
            return;
        }
        if (this.textureMode == 2 && this.image != null) {
            f /= (float)this.image.width;
            f2 /= (float)this.image.height;
        }
        this.inGeo.texcoords[2 * n + 0] = f;
        this.inGeo.texcoords[2 * n + 1] = f2;
        this.markForTessellation();
    }

    @Override
    public int getFill(int n) {
        if (this.family != 0 && this.image == null) {
            return PGL.nativeToJavaARGB(this.inGeo.colors[n]);
        }
        return 0;
    }

    @Override
    public void setFill(boolean bl) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setFill()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setFill(bl);
            }
        } else if (this.fill && !bl) {
            this.setFillImpl(0);
        }
        this.fill = bl;
    }

    @Override
    public void setFill(int n) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setFill()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setFill(n);
            }
        } else {
            this.setFillImpl(n);
        }
    }

    protected void setFillImpl(int n) {
        if (this.fillColor == n) {
            return;
        }
        this.fillColor = n;
        if (this.image == null) {
            Arrays.fill(this.inGeo.colors, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.fillColor));
            if (this.shapeCreated && this.tessellated && this.hasPolys) {
                if (this.is3D()) {
                    Arrays.fill(this.tessGeo.polyColors, this.firstPolyVertex, this.lastPolyVertex + 1, PGL.javaToNativeARGB(this.fillColor));
                    this.root.setModifiedPolyColors(this.firstPolyVertex, this.lastPolyVertex);
                } else if (this.is2D()) {
                    int n2 = this.lastPolyVertex + 1;
                    if (-1 < this.firstLineVertex) {
                        n2 = this.firstLineVertex;
                    }
                    if (-1 < this.firstPointVertex) {
                        n2 = this.firstPointVertex;
                    }
                    Arrays.fill(this.tessGeo.polyColors, this.firstPolyVertex, n2, PGL.javaToNativeARGB(this.fillColor));
                    this.root.setModifiedPolyColors(this.firstPolyVertex, n2 - 1);
                }
            }
        }
        if (!this.setAmbient) {
            this.setAmbientImpl(n);
            this.setAmbient = false;
        }
    }

    @Override
    public void setFill(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setFill()");
            return;
        }
        if (this.image == null) {
            this.inGeo.colors[n] = PGL.javaToNativeARGB(n2);
            this.markForTessellation();
        }
    }

    @Override
    public int getTint(int n) {
        if (this.family != 0 && this.image != null) {
            return PGL.nativeToJavaARGB(this.inGeo.colors[n]);
        }
        return 0;
    }

    @Override
    public void setTint(boolean bl) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setTint()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setTint(this.fill);
            }
        } else if (this.tint && !bl) {
            this.setTintImpl(-1);
        }
        this.tint = bl;
    }

    @Override
    public void setTint(int n) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setTint()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setTint(n);
            }
        } else {
            this.setTintImpl(n);
        }
    }

    protected void setTintImpl(int n) {
        if (this.tintColor == n) {
            return;
        }
        this.tintColor = n;
        if (this.image != null) {
            Arrays.fill(this.inGeo.colors, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.tintColor));
            if (this.shapeCreated && this.tessellated && this.hasPolys) {
                if (this.is3D()) {
                    Arrays.fill(this.tessGeo.polyColors, this.firstPolyVertex, this.lastPolyVertex + 1, PGL.javaToNativeARGB(this.tintColor));
                    this.root.setModifiedPolyColors(this.firstPolyVertex, this.lastPolyVertex);
                } else if (this.is2D()) {
                    int n2 = this.lastPolyVertex + 1;
                    if (-1 < this.firstLineVertex) {
                        n2 = this.firstLineVertex;
                    }
                    if (-1 < this.firstPointVertex) {
                        n2 = this.firstPointVertex;
                    }
                    Arrays.fill(this.tessGeo.polyColors, this.firstPolyVertex, n2, PGL.javaToNativeARGB(this.tintColor));
                    this.root.setModifiedPolyColors(this.firstPolyVertex, n2 - 1);
                }
            }
        }
    }

    @Override
    public void setTint(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setTint()");
            return;
        }
        if (this.image != null) {
            this.inGeo.colors[n] = PGL.javaToNativeARGB(n2);
            this.markForTessellation();
        }
    }

    @Override
    public int getStroke(int n) {
        if (this.family != 0) {
            return PGL.nativeToJavaARGB(this.inGeo.strokeColors[n]);
        }
        return 0;
    }

    @Override
    public void setStroke(boolean bl) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setStroke()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setStroke(bl);
            }
        } else if (this.stroke != bl) {
            if (this.stroke) {
                this.markForTessellation();
                bl = false;
            }
            this.setStrokeImpl(0);
            if (this.is2D() && this.parent != null) {
                ((PShapeOpenGL)this.parent).strokedTexture(false);
            }
        }
        this.stroke = bl;
    }

    @Override
    public void setStroke(int n) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setStroke()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setStroke(n);
            }
        } else {
            this.setStrokeImpl(n);
        }
    }

    protected void setStrokeImpl(int n) {
        if (this.strokeColor == n) {
            return;
        }
        this.strokeColor = n;
        Arrays.fill(this.inGeo.strokeColors, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.strokeColor));
        if (this.shapeCreated && this.tessellated && (this.hasLines || this.hasPoints)) {
            if (this.hasLines) {
                if (this.is3D()) {
                    Arrays.fill(this.tessGeo.lineColors, this.firstLineVertex, this.lastLineVertex + 1, PGL.javaToNativeARGB(this.strokeColor));
                    this.root.setModifiedLineColors(this.firstLineVertex, this.lastLineVertex);
                } else if (this.is2D()) {
                    Arrays.fill(this.tessGeo.polyColors, this.firstLineVertex, this.lastLineVertex + 1, PGL.javaToNativeARGB(this.strokeColor));
                    this.root.setModifiedPolyColors(this.firstLineVertex, this.lastLineVertex);
                }
            }
            if (this.hasPoints) {
                if (this.is3D()) {
                    Arrays.fill(this.tessGeo.pointColors, this.firstPointVertex, this.lastPointVertex + 1, PGL.javaToNativeARGB(this.strokeColor));
                    this.root.setModifiedPointColors(this.firstPointVertex, this.lastPointVertex);
                } else if (this.is2D()) {
                    Arrays.fill(this.tessGeo.polyColors, this.firstPointVertex, this.lastPointVertex + 1, PGL.javaToNativeARGB(this.strokeColor));
                    this.root.setModifiedPolyColors(this.firstPointVertex, this.lastPointVertex);
                }
            }
        }
    }

    @Override
    public void setStroke(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setStroke()");
            return;
        }
        this.inGeo.strokeColors[n] = PGL.javaToNativeARGB(n2);
        this.markForTessellation();
    }

    @Override
    public float getStrokeWeight(int n) {
        if (this.family != 0) {
            return this.inGeo.strokeWeights[n];
        }
        return 0.0f;
    }

    @Override
    public void setStrokeWeight(float f) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setStrokeWeight()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setStrokeWeight(f);
            }
        } else {
            this.setStrokeWeightImpl(f);
        }
    }

    protected void setStrokeWeightImpl(float f) {
        if (PGraphicsOpenGL.same(this.strokeWeight, f)) {
            return;
        }
        float f2 = this.strokeWeight;
        this.strokeWeight = f;
        Arrays.fill(this.inGeo.strokeWeights, 0, this.inGeo.vertexCount, this.strokeWeight);
        if (this.shapeCreated && this.tessellated && (this.hasLines || this.hasPoints)) {
            int n;
            float f3 = f / f2;
            if (this.hasLines) {
                if (this.is3D()) {
                    for (n = this.firstLineVertex; n <= this.lastLineVertex; ++n) {
                        int n2 = 4 * n + 3;
                        this.tessGeo.lineDirections[n2] = this.tessGeo.lineDirections[n2] * f3;
                    }
                    this.root.setModifiedLineAttributes(this.firstLineVertex, this.lastLineVertex);
                } else if (this.is2D()) {
                    this.markForTessellation();
                }
            }
            if (this.hasPoints) {
                if (this.is3D()) {
                    for (n = this.firstPointVertex; n <= this.lastPointVertex; ++n) {
                        int n3 = 2 * n + 0;
                        this.tessGeo.pointOffsets[n3] = this.tessGeo.pointOffsets[n3] * f3;
                        int n4 = 2 * n + 1;
                        this.tessGeo.pointOffsets[n4] = this.tessGeo.pointOffsets[n4] * f3;
                    }
                    this.root.setModifiedPointAttributes(this.firstPointVertex, this.lastPointVertex);
                } else if (this.is2D()) {
                    this.markForTessellation();
                }
            }
        }
    }

    @Override
    public void setStrokeWeight(int n, float f) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setStrokeWeight()");
            return;
        }
        this.inGeo.strokeWeights[n] = f;
        this.markForTessellation();
    }

    @Override
    public void setStrokeJoin(int n) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setStrokeJoin()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setStrokeJoin(n);
            }
        } else {
            if (this.is2D() && this.strokeJoin != n) {
                this.markForTessellation();
            }
            this.strokeJoin = n;
        }
    }

    @Override
    public void setStrokeCap(int n) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setStrokeCap()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setStrokeCap(n);
            }
        } else {
            if (this.is2D() && this.strokeCap != n) {
                this.markForTessellation();
            }
            this.strokeCap = n;
        }
    }

    @Override
    public int getAmbient(int n) {
        if (this.family != 0) {
            return PGL.nativeToJavaARGB(this.inGeo.ambient[n]);
        }
        return 0;
    }

    @Override
    public void setAmbient(int n) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setAmbient()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setAmbient(n);
            }
        } else {
            this.setAmbientImpl(n);
        }
    }

    protected void setAmbientImpl(int n) {
        if (this.ambientColor == n) {
            return;
        }
        this.ambientColor = n;
        Arrays.fill(this.inGeo.ambient, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.ambientColor));
        if (this.shapeCreated && this.tessellated && this.hasPolys) {
            if (this.is3D()) {
                Arrays.fill(this.tessGeo.polyAmbient, this.firstPolyVertex, this.lastPolyVertex + 1, PGL.javaToNativeARGB(this.ambientColor));
                this.root.setModifiedPolyAmbient(this.firstPolyVertex, this.lastPolyVertex);
            } else if (this.is2D()) {
                int n2 = this.lastPolyVertex + 1;
                if (-1 < this.firstLineVertex) {
                    n2 = this.firstLineVertex;
                }
                if (-1 < this.firstPointVertex) {
                    n2 = this.firstPointVertex;
                }
                Arrays.fill(this.tessGeo.polyAmbient, this.firstPolyVertex, n2, PGL.javaToNativeARGB(this.ambientColor));
                this.root.setModifiedPolyColors(this.firstPolyVertex, n2 - 1);
            }
        }
        this.setAmbient = true;
    }

    @Override
    public void setAmbient(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setAmbient()");
            return;
        }
        this.inGeo.ambient[n] = PGL.javaToNativeARGB(n2);
        this.markForTessellation();
        this.setAmbient = true;
    }

    @Override
    public int getSpecular(int n) {
        if (this.family == 0) {
            return PGL.nativeToJavaARGB(this.inGeo.specular[n]);
        }
        return 0;
    }

    @Override
    public void setSpecular(int n) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setSpecular()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setSpecular(n);
            }
        } else {
            this.setSpecularImpl(n);
        }
    }

    protected void setSpecularImpl(int n) {
        if (this.specularColor == n) {
            return;
        }
        this.specularColor = n;
        Arrays.fill(this.inGeo.specular, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.specularColor));
        if (this.shapeCreated && this.tessellated && this.hasPolys) {
            if (this.is3D()) {
                Arrays.fill(this.tessGeo.polySpecular, this.firstPolyVertex, this.lastPolyVertex + 1, PGL.javaToNativeARGB(this.specularColor));
                this.root.setModifiedPolySpecular(this.firstPolyVertex, this.lastPolyVertex);
            } else if (this.is2D()) {
                int n2 = this.lastPolyVertex + 1;
                if (-1 < this.firstLineVertex) {
                    n2 = this.firstLineVertex;
                }
                if (-1 < this.firstPointVertex) {
                    n2 = this.firstPointVertex;
                }
                Arrays.fill(this.tessGeo.polySpecular, this.firstPolyVertex, n2, PGL.javaToNativeARGB(this.specularColor));
                this.root.setModifiedPolyColors(this.firstPolyVertex, n2 - 1);
            }
        }
    }

    @Override
    public void setSpecular(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setSpecular()");
            return;
        }
        this.inGeo.specular[n] = PGL.javaToNativeARGB(n2);
        this.markForTessellation();
    }

    @Override
    public int getEmissive(int n) {
        if (this.family == 0) {
            return PGL.nativeToJavaARGB(this.inGeo.emissive[n]);
        }
        return 0;
    }

    @Override
    public void setEmissive(int n) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setEmissive()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setEmissive(n);
            }
        } else {
            this.setEmissiveImpl(n);
        }
    }

    protected void setEmissiveImpl(int n) {
        if (this.emissiveColor == n) {
            return;
        }
        this.emissiveColor = n;
        Arrays.fill(this.inGeo.emissive, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.emissiveColor));
        if (this.shapeCreated && this.tessellated && 0 < this.tessGeo.polyVertexCount) {
            if (this.is3D()) {
                Arrays.fill(this.tessGeo.polyEmissive, this.firstPolyVertex, this.lastPolyVertex + 1, PGL.javaToNativeARGB(this.emissiveColor));
                this.root.setModifiedPolyEmissive(this.firstPolyVertex, this.lastPolyVertex);
            } else if (this.is2D()) {
                int n2 = this.lastPolyVertex + 1;
                if (-1 < this.firstLineVertex) {
                    n2 = this.firstLineVertex;
                }
                if (-1 < this.firstPointVertex) {
                    n2 = this.firstPointVertex;
                }
                Arrays.fill(this.tessGeo.polyEmissive, this.firstPolyVertex, n2, PGL.javaToNativeARGB(this.emissiveColor));
                this.root.setModifiedPolyColors(this.firstPolyVertex, n2 - 1);
            }
        }
    }

    @Override
    public void setEmissive(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setEmissive()");
            return;
        }
        this.inGeo.emissive[n] = PGL.javaToNativeARGB(n2);
        this.markForTessellation();
    }

    @Override
    public float getShininess(int n) {
        if (this.family == 0) {
            return this.inGeo.shininess[n];
        }
        return 0.0f;
    }

    @Override
    public void setShininess(float f) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setShininess()");
            return;
        }
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.setShininess(f);
            }
        } else {
            this.setShininessImpl(f);
        }
    }

    protected void setShininessImpl(float f) {
        if (PGraphicsOpenGL.same(this.shininess, f)) {
            return;
        }
        this.shininess = f;
        Arrays.fill(this.inGeo.shininess, 0, this.inGeo.vertexCount, f);
        if (this.shapeCreated && this.tessellated && this.hasPolys) {
            if (this.is3D()) {
                Arrays.fill(this.tessGeo.polyShininess, this.firstPolyVertex, this.lastPolyVertex + 1, f);
                this.root.setModifiedPolyShininess(this.firstPolyVertex, this.lastPolyVertex);
            } else if (this.is2D()) {
                int n = this.lastPolyVertex + 1;
                if (-1 < this.firstLineVertex) {
                    n = this.firstLineVertex;
                }
                if (-1 < this.firstPointVertex) {
                    n = this.firstPointVertex;
                }
                Arrays.fill(this.tessGeo.polyShininess, this.firstPolyVertex, n, f);
                this.root.setModifiedPolyColors(this.firstPolyVertex, n - 1);
            }
        }
    }

    @Override
    public void setShininess(int n, float f) {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "setShininess()");
            return;
        }
        this.inGeo.shininess[n] = f;
        this.markForTessellation();
    }

    @Override
    public int[] getVertexCodes() {
        if (this.family == 0) {
            return null;
        }
        if (this.family == 1 || this.family == 2) {
            this.updateTessellation();
        }
        if (this.inGeo.codes == null) {
            return null;
        }
        return this.inGeo.codes;
    }

    @Override
    public int getVertexCodeCount() {
        if (this.family == 0) {
            return 0;
        }
        if (this.family == 1 || this.family == 2) {
            this.updateTessellation();
        }
        return this.inGeo.codeCount;
    }

    @Override
    public int getVertexCode(int n) {
        return this.inGeo.codes[n];
    }

    @Override
    public PShape getTessellation() {
        PShapeOpenGL pShapeOpenGL;
        this.updateTessellation();
        float[] fArray = this.tessGeo.polyVertices;
        float[] fArray2 = this.tessGeo.polyNormals;
        int[] nArray = this.tessGeo.polyColors;
        float[] fArray3 = this.tessGeo.polyTexCoords;
        short[] sArray = this.tessGeo.polyIndices;
        if (this.is3D()) {
            pShapeOpenGL = PGraphics3D.createShapeImpl(this.pg, 3);
        } else if (this.is2D()) {
            pShapeOpenGL = PGraphics2D.createShapeImpl(this.pg, 3);
        } else {
            PGraphics.showWarning("This shape is not either 2D or 3D!");
            return null;
        }
        pShapeOpenGL.beginShape(9);
        pShapeOpenGL.noStroke();
        PGraphicsOpenGL.IndexCache indexCache = this.tessGeo.polyIndexCache;
        for (int i = this.firstPolyIndexCache; i <= this.lastPolyIndexCache; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            for (int j = n / 3; j < (n + n2) / 3; ++j) {
                float f;
                float f2;
                float f3;
                float f4;
                float f5;
                float f6;
                int n4 = n3 + sArray[3 * j + 0];
                int n5 = n3 + sArray[3 * j + 1];
                int n6 = n3 + sArray[3 * j + 2];
                if (this.is3D()) {
                    f6 = fArray[4 * n4 + 0];
                    f5 = fArray[4 * n4 + 1];
                    f4 = fArray[4 * n4 + 2];
                    f3 = fArray[4 * n5 + 0];
                    f2 = fArray[4 * n5 + 1];
                    f = fArray[4 * n5 + 2];
                    float f7 = fArray[4 * n6 + 0];
                    float f8 = fArray[4 * n6 + 1];
                    float f9 = fArray[4 * n6 + 2];
                    float f10 = fArray2[3 * n4 + 0];
                    float f11 = fArray2[3 * n4 + 1];
                    float f12 = fArray2[3 * n4 + 2];
                    float f13 = fArray2[3 * n5 + 0];
                    float f14 = fArray2[3 * n5 + 1];
                    float f15 = fArray2[3 * n5 + 2];
                    float f16 = fArray2[3 * n6 + 0];
                    float f17 = fArray2[3 * n6 + 1];
                    float f18 = fArray2[3 * n6 + 2];
                    int n7 = PGL.nativeToJavaARGB(nArray[n4]);
                    int n8 = PGL.nativeToJavaARGB(nArray[n5]);
                    int n9 = PGL.nativeToJavaARGB(nArray[n6]);
                    pShapeOpenGL.fill(n7);
                    ((PShape)pShapeOpenGL).normal(f10, f11, f12);
                    ((PShape)pShapeOpenGL).vertex(f6, f5, f4, fArray3[2 * n4 + 0], fArray3[2 * n4 + 1]);
                    pShapeOpenGL.fill(n8);
                    ((PShape)pShapeOpenGL).normal(f13, f14, f15);
                    ((PShape)pShapeOpenGL).vertex(f3, f2, f, fArray3[2 * n5 + 0], fArray3[2 * n5 + 1]);
                    pShapeOpenGL.fill(n9);
                    ((PShape)pShapeOpenGL).normal(f16, f17, f18);
                    ((PShape)pShapeOpenGL).vertex(f7, f8, f9, fArray3[2 * n6 + 0], fArray3[2 * n6 + 1]);
                    continue;
                }
                if (!this.is2D()) continue;
                f6 = fArray[4 * n4 + 0];
                f5 = fArray[4 * n4 + 1];
                f4 = fArray[4 * n5 + 0];
                f3 = fArray[4 * n5 + 1];
                f2 = fArray[4 * n6 + 0];
                f = fArray[4 * n6 + 1];
                int n10 = PGL.nativeToJavaARGB(nArray[n4]);
                int n11 = PGL.nativeToJavaARGB(nArray[n5]);
                int n12 = PGL.nativeToJavaARGB(nArray[n6]);
                pShapeOpenGL.fill(n10);
                ((PShape)pShapeOpenGL).vertex(f6, f5, fArray3[2 * n4 + 0], fArray3[2 * n4 + 1]);
                pShapeOpenGL.fill(n11);
                ((PShape)pShapeOpenGL).vertex(f4, f3, fArray3[2 * n5 + 0], fArray3[2 * n5 + 1]);
                pShapeOpenGL.fill(n12);
                ((PShape)pShapeOpenGL).vertex(f2, f, fArray3[2 * n6 + 0], fArray3[2 * n6 + 1]);
            }
        }
        pShapeOpenGL.endShape();
        return pShapeOpenGL;
    }

    public float[] getTessellation(int n, int n2) {
        this.updateTessellation();
        if (n == 9) {
            if (n2 == 0) {
                if (this.is3D()) {
                    this.root.setModifiedPolyVertices(this.firstPolyVertex, this.lastPolyVertex);
                } else if (this.is2D()) {
                    int n3 = this.lastPolyVertex + 1;
                    if (-1 < this.firstLineVertex) {
                        n3 = this.firstLineVertex;
                    }
                    if (-1 < this.firstPointVertex) {
                        n3 = this.firstPointVertex;
                    }
                    this.root.setModifiedPolyVertices(this.firstPolyVertex, n3 - 1);
                }
                return this.tessGeo.polyVertices;
            }
            if (n2 == 1) {
                if (this.is3D()) {
                    this.root.setModifiedPolyNormals(this.firstPolyVertex, this.lastPolyVertex);
                } else if (this.is2D()) {
                    int n4 = this.lastPolyVertex + 1;
                    if (-1 < this.firstLineVertex) {
                        n4 = this.firstLineVertex;
                    }
                    if (-1 < this.firstPointVertex) {
                        n4 = this.firstPointVertex;
                    }
                    this.root.setModifiedPolyNormals(this.firstPolyVertex, n4 - 1);
                }
                return this.tessGeo.polyNormals;
            }
            if (n2 == 2) {
                if (this.is3D()) {
                    this.root.setModifiedPolyTexCoords(this.firstPolyVertex, this.lastPolyVertex);
                } else if (this.is2D()) {
                    int n5 = this.lastPolyVertex + 1;
                    if (-1 < this.firstLineVertex) {
                        n5 = this.firstLineVertex;
                    }
                    if (-1 < this.firstPointVertex) {
                        n5 = this.firstPointVertex;
                    }
                    this.root.setModifiedPolyTexCoords(this.firstPolyVertex, n5 - 1);
                }
                return this.tessGeo.polyTexCoords;
            }
        } else if (n == 5) {
            if (n2 == 0) {
                if (this.is3D()) {
                    this.root.setModifiedLineVertices(this.firstLineVertex, this.lastLineVertex);
                } else if (this.is2D()) {
                    this.root.setModifiedPolyVertices(this.firstLineVertex, this.lastLineVertex);
                }
                return this.tessGeo.lineVertices;
            }
            if (n2 == 3) {
                if (this.is2D()) {
                    this.root.setModifiedLineAttributes(this.firstLineVertex, this.lastLineVertex);
                }
                return this.tessGeo.lineDirections;
            }
        } else if (n == 3) {
            if (n2 == 0) {
                if (this.is3D()) {
                    this.root.setModifiedPointVertices(this.firstPointVertex, this.lastPointVertex);
                } else if (this.is2D()) {
                    this.root.setModifiedPolyVertices(this.firstPointVertex, this.lastPointVertex);
                }
                return this.tessGeo.pointVertices;
            }
            if (n2 == 4) {
                if (this.is2D()) {
                    this.root.setModifiedPointAttributes(this.firstPointVertex, this.lastPointVertex);
                }
                return this.tessGeo.pointOffsets;
            }
        }
        return null;
    }

    @Override
    public boolean contains(float f, float f2) {
        if (this.family == 2) {
            boolean bl = false;
            int n = 0;
            int n2 = this.inGeo.vertexCount - 1;
            while (n < this.inGeo.vertexCount) {
                if (this.inGeo.vertices[3 * n + 1] > f2 != this.inGeo.vertices[3 * n2 + 1] > f2 && f < (this.inGeo.vertices[3 * n2] - this.inGeo.vertices[3 * n]) * (f2 - this.inGeo.vertices[3 * n + 1]) / (this.inGeo.vertices[3 * n2 + 1] - this.inGeo.vertices[3 * n + 1]) + this.inGeo.vertices[3 * n]) {
                    bl = !bl;
                }
                n2 = n++;
            }
            return bl;
        }
        throw new IllegalArgumentException("The contains() method is only implemented for paths.");
    }

    protected void updateTessellation() {
        if (!this.root.tessellated) {
            this.root.tessellate();
            this.root.aggregate();
            this.root.initModified();
            this.root.needBufferInit = true;
        }
    }

    protected void markForTessellation() {
        this.root.tessellated = false;
        this.tessellated = false;
    }

    protected void initModified() {
        this.modified = false;
        this.modifiedPolyVertices = false;
        this.modifiedPolyColors = false;
        this.modifiedPolyNormals = false;
        this.modifiedPolyTexCoords = false;
        this.modifiedPolyAmbient = false;
        this.modifiedPolySpecular = false;
        this.modifiedPolyEmissive = false;
        this.modifiedPolyShininess = false;
        this.modifiedLineVertices = false;
        this.modifiedLineColors = false;
        this.modifiedLineAttributes = false;
        this.modifiedPointVertices = false;
        this.modifiedPointColors = false;
        this.modifiedPointAttributes = false;
        this.firstModifiedPolyVertex = Integer.MAX_VALUE;
        this.lastModifiedPolyVertex = Integer.MIN_VALUE;
        this.firstModifiedPolyColor = Integer.MAX_VALUE;
        this.lastModifiedPolyColor = Integer.MIN_VALUE;
        this.firstModifiedPolyNormal = Integer.MAX_VALUE;
        this.lastModifiedPolyNormal = Integer.MIN_VALUE;
        this.firstModifiedPolyTexcoord = Integer.MAX_VALUE;
        this.lastModifiedPolyTexcoord = Integer.MIN_VALUE;
        this.firstModifiedPolyAmbient = Integer.MAX_VALUE;
        this.lastModifiedPolyAmbient = Integer.MIN_VALUE;
        this.firstModifiedPolySpecular = Integer.MAX_VALUE;
        this.lastModifiedPolySpecular = Integer.MIN_VALUE;
        this.firstModifiedPolyEmissive = Integer.MAX_VALUE;
        this.lastModifiedPolyEmissive = Integer.MIN_VALUE;
        this.firstModifiedPolyShininess = Integer.MAX_VALUE;
        this.lastModifiedPolyShininess = Integer.MIN_VALUE;
        this.firstModifiedLineVertex = Integer.MAX_VALUE;
        this.lastModifiedLineVertex = Integer.MIN_VALUE;
        this.firstModifiedLineColor = Integer.MAX_VALUE;
        this.lastModifiedLineColor = Integer.MIN_VALUE;
        this.firstModifiedLineAttribute = Integer.MAX_VALUE;
        this.lastModifiedLineAttribute = Integer.MIN_VALUE;
        this.firstModifiedPointVertex = Integer.MAX_VALUE;
        this.lastModifiedPointVertex = Integer.MIN_VALUE;
        this.firstModifiedPointColor = Integer.MAX_VALUE;
        this.lastModifiedPointColor = Integer.MIN_VALUE;
        this.firstModifiedPointAttribute = Integer.MAX_VALUE;
        this.lastModifiedPointAttribute = Integer.MIN_VALUE;
    }

    protected void tessellate() {
        if (this.root == this && this.parent == null) {
            if (this.tessGeo == null) {
                this.tessGeo = PGraphicsOpenGL.newTessGeometry(this.pg, 1);
            }
            this.tessGeo.clear();
            this.tessellateImpl();
            this.tessGeo.trim();
        }
    }

    protected void tessellateImpl() {
        this.tessGeo = this.root.tessGeo;
        this.firstPolyIndexCache = -1;
        this.lastPolyIndexCache = -1;
        this.firstLineIndexCache = -1;
        this.lastLineIndexCache = -1;
        this.firstPointIndexCache = -1;
        this.lastPointIndexCache = -1;
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.tessellateImpl();
            }
        } else if (this.shapeCreated) {
            this.inGeo.clearEdges();
            this.tessellator.setInGeometry(this.inGeo);
            this.tessellator.setTessGeometry(this.tessGeo);
            this.tessellator.setFill(this.fill || this.image != null);
            this.tessellator.setTexCache(null, null);
            this.tessellator.setStroke(this.stroke);
            this.tessellator.setStrokeColor(this.strokeColor);
            this.tessellator.setStrokeWeight(this.strokeWeight);
            this.tessellator.setStrokeCap(this.strokeCap);
            this.tessellator.setStrokeJoin(this.strokeJoin);
            this.tessellator.setRenderer(this.pg);
            this.tessellator.setTransform(this.matrix);
            this.tessellator.set3D(this.is3D());
            if (this.family == 3) {
                if (this.kind == 3) {
                    this.tessellator.tessellatePoints();
                } else if (this.kind == 5) {
                    this.tessellator.tessellateLines();
                } else if (this.kind == 50) {
                    this.tessellator.tessellateLineStrip();
                } else if (this.kind == 51) {
                    this.tessellator.tessellateLineLoop();
                } else if (this.kind == 8 || this.kind == 9) {
                    if (this.stroke) {
                        this.inGeo.addTrianglesEdges();
                    }
                    if (this.normalMode == 0) {
                        this.inGeo.calcTrianglesNormals();
                    }
                    this.tessellator.tessellateTriangles();
                } else if (this.kind == 11) {
                    if (this.stroke) {
                        this.inGeo.addTriangleFanEdges();
                    }
                    if (this.normalMode == 0) {
                        this.inGeo.calcTriangleFanNormals();
                    }
                    this.tessellator.tessellateTriangleFan();
                } else if (this.kind == 10) {
                    if (this.stroke) {
                        this.inGeo.addTriangleStripEdges();
                    }
                    if (this.normalMode == 0) {
                        this.inGeo.calcTriangleStripNormals();
                    }
                    this.tessellator.tessellateTriangleStrip();
                } else if (this.kind == 16 || this.kind == 17) {
                    if (this.stroke) {
                        this.inGeo.addQuadsEdges();
                    }
                    if (this.normalMode == 0) {
                        this.inGeo.calcQuadsNormals();
                    }
                    this.tessellator.tessellateQuads();
                } else if (this.kind == 18) {
                    if (this.stroke) {
                        this.inGeo.addQuadStripEdges();
                    }
                    if (this.normalMode == 0) {
                        this.inGeo.calcQuadStripNormals();
                    }
                    this.tessellator.tessellateQuadStrip();
                } else if (this.kind == 20) {
                    boolean bl = this.inGeo.hasBezierVertex();
                    boolean bl2 = this.inGeo.hasQuadraticVertex();
                    boolean bl3 = this.inGeo.hasCurveVertex();
                    if (bl || bl2) {
                        this.saveBezierVertexSettings();
                    }
                    if (bl3) {
                        this.saveCurveVertexSettings();
                        this.tessellator.resetCurveVertexCount();
                    }
                    this.tessellator.tessellatePolygon(this.solid, this.close, this.normalMode == 0);
                    if (bl || bl2) {
                        this.restoreBezierVertexSettings();
                    }
                    if (bl3) {
                        this.restoreCurveVertexSettings();
                    }
                }
            } else if (this.family == 1) {
                this.inGeo.clear();
                if (this.kind == 2) {
                    this.tessellatePoint();
                } else if (this.kind == 4) {
                    this.tessellateLine();
                } else if (this.kind == 8) {
                    this.tessellateTriangle();
                } else if (this.kind == 16) {
                    this.tessellateQuad();
                } else if (this.kind == 30) {
                    this.tessellateRect();
                } else if (this.kind == 31) {
                    this.tessellateEllipse();
                } else if (this.kind == 32) {
                    this.tessellateArc();
                } else if (this.kind == 41) {
                    this.tessellateBox();
                } else if (this.kind == 40) {
                    this.tessellateSphere();
                }
            } else if (this.family == 2) {
                this.inGeo.clear();
                this.tessellatePath();
            }
            if (this.image != null && this.parent != null) {
                ((PShapeOpenGL)this.parent).addTexture(this.image);
            }
            this.firstPolyIndexCache = this.tessellator.firstPolyIndexCache;
            this.lastPolyIndexCache = this.tessellator.lastPolyIndexCache;
            this.firstLineIndexCache = this.tessellator.firstLineIndexCache;
            this.lastLineIndexCache = this.tessellator.lastLineIndexCache;
            this.firstPointIndexCache = this.tessellator.firstPointIndexCache;
            this.lastPointIndexCache = this.tessellator.lastPointIndexCache;
        }
        this.lastPolyVertex = -1;
        this.firstPolyVertex = -1;
        this.lastLineVertex = -1;
        this.firstLineVertex = -1;
        this.lastPointVertex = -1;
        this.firstPointVertex = -1;
        this.tessellated = true;
    }

    protected void tessellatePoint() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.params.length == 2) {
            f = this.params[0];
            f2 = this.params[1];
            f3 = 0.0f;
        } else if (this.params.length == 3) {
            f = this.params[0];
            f2 = this.params[1];
            f3 = this.params[2];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addPoint(f, f2, f3, this.fill, this.stroke);
        this.tessellator.tessellatePoints();
    }

    protected void tessellateLine() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.params.length == 4) {
            f = this.params[0];
            f2 = this.params[1];
            f4 = this.params[2];
            f5 = this.params[3];
        } else if (this.params.length == 6) {
            f = this.params[0];
            f2 = this.params[1];
            f3 = this.params[2];
            f4 = this.params[3];
            f5 = this.params[4];
            f6 = this.params[5];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addLine(f, f2, f3, f4, f5, f6, this.fill, this.stroke);
        this.tessellator.tessellateLines();
    }

    protected void tessellateTriangle() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.params.length == 6) {
            f = this.params[0];
            f2 = this.params[1];
            f3 = this.params[2];
            f4 = this.params[3];
            f5 = this.params[4];
            f6 = this.params[5];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addTriangle(f, f2, 0.0f, f3, f4, 0.0f, f5, f6, 0.0f, this.fill, this.stroke);
        this.tessellator.tessellateTriangles();
    }

    protected void tessellateQuad() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (this.params.length == 8) {
            f = this.params[0];
            f2 = this.params[1];
            f3 = this.params[2];
            f4 = this.params[3];
            f5 = this.params[4];
            f6 = this.params[5];
            f7 = this.params[6];
            f8 = this.params[7];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuad(f, f2, 0.0f, f3, f4, 0.0f, f5, f6, 0.0f, f7, f8, 0.0f, this.stroke);
        this.tessellator.tessellateQuads();
    }

    protected void tessellateRect() {
        float f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        boolean bl = false;
        int n = this.rectMode;
        if (this.params.length == 4 || this.params.length == 5) {
            f2 = this.params[0];
            f3 = this.params[1];
            f4 = this.params[2];
            f5 = this.params[3];
            if (this.params.length == 5) {
                n = (int)this.params[4];
            }
            bl = false;
        } else if (this.params.length == 8 || this.params.length == 9) {
            f2 = this.params[0];
            f3 = this.params[1];
            f4 = this.params[2];
            f5 = this.params[3];
            f6 = this.params[4];
            f7 = this.params[5];
            f8 = this.params[6];
            f9 = this.params[7];
            if (this.params.length == 9) {
                n = (int)this.params[8];
            }
            bl = true;
        }
        switch (n) {
            case 1: {
                break;
            }
            case 0: {
                f4 += f2;
                f5 += f3;
                break;
            }
            case 2: {
                float f10 = f4;
                float f11 = f5;
                f4 = f2 + f10;
                f5 = f3 + f11;
                f2 -= f10;
                f3 -= f11;
                break;
            }
            case 3: {
                float f12 = f4 / 2.0f;
                float f13 = f5 / 2.0f;
                f4 = f2 + f12;
                f5 = f3 + f13;
                f2 -= f12;
                f3 -= f13;
            }
        }
        if (f2 > f4) {
            f = f2;
            f2 = f4;
            f4 = f;
        }
        if (f3 > f5) {
            f = f3;
            f3 = f5;
            f5 = f;
        }
        if (f6 > (f = PApplet.min((f4 - f2) / 2.0f, (f5 - f3) / 2.0f))) {
            f6 = f;
        }
        if (f7 > f) {
            f7 = f;
        }
        if (f8 > f) {
            f8 = f;
        }
        if (f9 > f) {
            f9 = f;
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        if (bl) {
            this.saveBezierVertexSettings();
            this.inGeo.addRect(f2, f3, f4, f5, f6, f7, f8, f9, this.stroke);
            this.tessellator.tessellatePolygon(false, true, true);
            this.restoreBezierVertexSettings();
        } else {
            this.inGeo.addRect(f2, f3, f4, f5, this.stroke);
            this.tessellator.tessellateQuads();
        }
    }

    protected void tessellateEllipse() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n = this.ellipseMode;
        if (4 <= this.params.length) {
            f = this.params[0];
            f2 = this.params[1];
            f3 = this.params[2];
            f4 = this.params[3];
            if (this.params.length == 5) {
                n = (int)this.params[4];
            }
        }
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        if (n == 1) {
            f7 = f3 - f;
            f8 = f4 - f2;
        } else if (n == 2) {
            f5 = f - f3;
            f6 = f2 - f4;
            f7 = f3 * 2.0f;
            f8 = f4 * 2.0f;
        } else if (n == 3) {
            f5 = f - f3 / 2.0f;
            f6 = f2 - f4 / 2.0f;
        }
        if (f7 < 0.0f) {
            f5 += f7;
            f7 = -f7;
        }
        if (f8 < 0.0f) {
            f6 += f8;
            f8 = -f8;
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addEllipse(f5, f6, f7, f8, this.fill, this.stroke);
        this.tessellator.tessellateTriangleFan();
    }

    protected void tessellateArc() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n = this.ellipseMode;
        if (6 <= this.params.length) {
            f = this.params[0];
            f2 = this.params[1];
            f3 = this.params[2];
            f4 = this.params[3];
            f5 = this.params[4];
            f6 = this.params[5];
            if (this.params.length == 7) {
                n = (int)this.params[6];
            }
        }
        float f7 = f;
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        if (n == 1) {
            f9 = f3 - f;
            f10 = f4 - f2;
        } else if (n == 2) {
            f7 = f - f3;
            f8 = f2 - f4;
            f9 = f3 * 2.0f;
            f10 = f4 * 2.0f;
        } else if (n == 3) {
            f7 = f - f3 / 2.0f;
            f8 = f2 - f4 / 2.0f;
        }
        if (!Float.isInfinite(f5) && !Float.isInfinite(f6) && f6 > f5) {
            while (f5 < 0.0f) {
                f5 += (float)Math.PI * 2;
                f6 += (float)Math.PI * 2;
            }
            if (f6 - f5 > (float)Math.PI * 2) {
                f5 = 0.0f;
                f6 = (float)Math.PI * 2;
            }
            this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
            this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
            this.inGeo.addArc(f7, f8, f9, f10, f5, f6, this.fill, this.stroke, n);
            this.tessellator.tessellateTriangleFan();
        }
    }

    protected void tessellateBox() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.params.length == 1) {
            f2 = f3 = this.params[0];
            f = f3;
        } else if (this.params.length == 3) {
            f = this.params[0];
            f2 = this.params[1];
            f3 = this.params[2];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.addBox(f, f2, f3, this.fill, this.stroke);
        this.tessellator.tessellateQuads();
    }

    protected void tessellateSphere() {
        float f = 0.0f;
        int n = this.sphereDetailU;
        int n2 = this.sphereDetailV;
        if (1 <= this.params.length) {
            f = this.params[0];
            if (this.params.length == 2) {
                n = n2 = (int)this.params[1];
            } else if (this.params.length == 3) {
                n = (int)this.params[1];
                n2 = (int)this.params[2];
            }
        }
        if (n < 3 || n2 < 2) {
            n2 = 30;
            n = 30;
        }
        int n3 = this.pg.sphereDetailU;
        int n4 = this.pg.sphereDetailV;
        if (this.pg.sphereDetailU != n || this.pg.sphereDetailV != n2) {
            this.pg.sphereDetail(n, n2);
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        int[] nArray = this.inGeo.addSphere(f, n, n2, this.fill, this.stroke);
        this.tessellator.tessellateTriangles(nArray);
        if (n3 != n || n4 != n2) {
            this.pg.sphereDetail(n3, n4);
        }
    }

    protected void tessellatePath() {
        int n;
        boolean bl;
        int n2;
        if (this.vertices == null) {
            return;
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        if (this.vertexCodeCount == 0) {
            if (this.vertices[0].length == 2) {
                for (n2 = 0; n2 < this.vertexCount; ++n2) {
                    this.inGeo.addVertex(this.vertices[n2][0], this.vertices[n2][1], 0, false);
                }
            } else {
                for (n2 = 0; n2 < this.vertexCount; ++n2) {
                    this.inGeo.addVertex(this.vertices[n2][0], this.vertices[n2][1], this.vertices[n2][2], 0, false);
                }
            }
        } else {
            n2 = 0;
            bl = true;
            if (this.vertices[0].length == 2) {
                block16: for (n = 0; n < this.vertexCodeCount; ++n) {
                    switch (this.vertexCodes[n]) {
                        case 0: {
                            this.inGeo.addVertex(this.vertices[n2][0], this.vertices[n2][1], 0, bl);
                            bl = false;
                            ++n2;
                            continue block16;
                        }
                        case 2: {
                            this.inGeo.addQuadraticVertex(this.vertices[n2 + 0][0], this.vertices[n2 + 0][1], 0.0f, this.vertices[n2 + 1][0], this.vertices[n2 + 1][1], 0.0f, bl);
                            bl = false;
                            n2 += 2;
                            continue block16;
                        }
                        case 1: {
                            this.inGeo.addBezierVertex(this.vertices[n2 + 0][0], this.vertices[n2 + 0][1], 0.0f, this.vertices[n2 + 1][0], this.vertices[n2 + 1][1], 0.0f, this.vertices[n2 + 2][0], this.vertices[n2 + 2][1], 0.0f, bl);
                            bl = false;
                            n2 += 3;
                            continue block16;
                        }
                        case 3: {
                            this.inGeo.addCurveVertex(this.vertices[n2][0], this.vertices[n2][1], 0.0f, bl);
                            bl = false;
                            ++n2;
                            continue block16;
                        }
                        case 4: {
                            bl = true;
                        }
                    }
                }
            } else {
                block17: for (n = 0; n < this.vertexCodeCount; ++n) {
                    switch (this.vertexCodes[n]) {
                        case 0: {
                            this.inGeo.addVertex(this.vertices[n2][0], this.vertices[n2][1], this.vertices[n2][2], bl);
                            bl = false;
                            ++n2;
                            continue block17;
                        }
                        case 2: {
                            this.inGeo.addQuadraticVertex(this.vertices[n2 + 0][0], this.vertices[n2 + 0][1], this.vertices[n2 + 0][2], this.vertices[n2 + 1][0], this.vertices[n2 + 1][1], this.vertices[n2 + 0][2], bl);
                            bl = false;
                            n2 += 2;
                            continue block17;
                        }
                        case 1: {
                            this.inGeo.addBezierVertex(this.vertices[n2 + 0][0], this.vertices[n2 + 0][1], this.vertices[n2 + 0][2], this.vertices[n2 + 1][0], this.vertices[n2 + 1][1], this.vertices[n2 + 1][2], this.vertices[n2 + 2][0], this.vertices[n2 + 2][1], this.vertices[n2 + 2][2], bl);
                            bl = false;
                            n2 += 3;
                            continue block17;
                        }
                        case 3: {
                            this.inGeo.addCurveVertex(this.vertices[n2][0], this.vertices[n2][1], this.vertices[n2][2], bl);
                            bl = false;
                            ++n2;
                            continue block17;
                        }
                        case 4: {
                            bl = true;
                        }
                    }
                }
            }
        }
        n2 = this.inGeo.hasBezierVertex() ? 1 : 0;
        bl = this.inGeo.hasQuadraticVertex();
        n = this.inGeo.hasCurveVertex() ? 1 : 0;
        if (n2 != 0 || bl) {
            this.saveBezierVertexSettings();
        }
        if (n != 0) {
            this.saveCurveVertexSettings();
            this.tessellator.resetCurveVertexCount();
        }
        this.tessellator.tessellatePolygon(false, this.close, true);
        if (n2 != 0 || bl) {
            this.restoreBezierVertexSettings();
        }
        if (n != 0) {
            this.restoreCurveVertexSettings();
        }
    }

    protected void saveBezierVertexSettings() {
        this.savedBezierDetail = this.pg.bezierDetail;
        if (this.pg.bezierDetail != this.bezierDetail) {
            this.pg.bezierDetail(this.bezierDetail);
        }
    }

    protected void restoreBezierVertexSettings() {
        if (this.savedBezierDetail != this.bezierDetail) {
            this.pg.bezierDetail(this.savedBezierDetail);
        }
    }

    protected void saveCurveVertexSettings() {
        this.savedCurveDetail = this.pg.curveDetail;
        this.savedCurveTightness = this.pg.curveTightness;
        if (this.pg.curveDetail != this.curveDetail) {
            this.pg.curveDetail(this.curveDetail);
        }
        if (this.pg.curveTightness != this.curveTightness) {
            this.pg.curveTightness(this.curveTightness);
        }
    }

    protected void restoreCurveVertexSettings() {
        if (this.savedCurveDetail != this.curveDetail) {
            this.pg.curveDetail(this.savedCurveDetail);
        }
        if (this.savedCurveTightness != this.curveTightness) {
            this.pg.curveTightness(this.savedCurveTightness);
        }
    }

    protected void aggregate() {
        if (this.root == this && this.parent == null) {
            this.polyIndexOffset = 0;
            this.polyVertexOffset = 0;
            this.polyVertexAbs = 0;
            this.polyVertexRel = 0;
            this.lineIndexOffset = 0;
            this.lineVertexOffset = 0;
            this.lineVertexAbs = 0;
            this.lineVertexRel = 0;
            this.pointIndexOffset = 0;
            this.pointVertexOffset = 0;
            this.pointVertexAbs = 0;
            this.pointVertexRel = 0;
            this.aggregateImpl();
        }
    }

    protected void aggregateImpl() {
        if (this.family == 0) {
            this.hasPolys = false;
            this.hasLines = false;
            this.hasPoints = false;
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                pShapeOpenGL.aggregateImpl();
                this.hasPolys |= pShapeOpenGL.hasPolys;
                this.hasLines |= pShapeOpenGL.hasLines;
                this.hasPoints |= pShapeOpenGL.hasPoints;
            }
        } else {
            this.hasPolys = -1 < this.firstPolyIndexCache && -1 < this.lastPolyIndexCache;
            this.hasLines = -1 < this.firstLineIndexCache && -1 < this.lastLineIndexCache;
            boolean bl = this.hasPoints = -1 < this.firstPointIndexCache && -1 < this.lastPointIndexCache;
        }
        if (this.hasPolys) {
            this.updatePolyIndexCache();
        }
        if (this.is3D()) {
            if (this.hasLines) {
                this.updateLineIndexCache();
            }
            if (this.hasPoints) {
                this.updatePointIndexCache();
            }
        }
        if (this.matrix != null) {
            if (this.hasPolys) {
                this.tessGeo.applyMatrixOnPolyGeometry(this.matrix, this.firstPolyVertex, this.lastPolyVertex);
            }
            if (this.is3D()) {
                if (this.hasLines) {
                    this.tessGeo.applyMatrixOnLineGeometry(this.matrix, this.firstLineVertex, this.lastLineVertex);
                }
                if (this.hasPoints) {
                    this.tessGeo.applyMatrixOnPointGeometry(this.matrix, this.firstPointVertex, this.lastPointVertex);
                }
            }
        }
    }

    protected void updatePolyIndexCache() {
        PGraphicsOpenGL.IndexCache indexCache = this.tessGeo.polyIndexCache;
        if (this.family == 0) {
            this.lastPolyIndexCache = -1;
            this.firstPolyIndexCache = -1;
            int n = -1;
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                int n2 = pShapeOpenGL.firstPolyIndexCache;
                int n3 = -1 < n2 ? pShapeOpenGL.lastPolyIndexCache - n2 + 1 : -1;
                for (int j = n2; j < n2 + n3; ++j) {
                    if (n == -1) {
                        this.firstPolyIndexCache = n = indexCache.addNew(j);
                        continue;
                    }
                    if (indexCache.vertexOffset[n] == indexCache.vertexOffset[j]) {
                        indexCache.incCounts(n, indexCache.indexCount[j], indexCache.vertexCount[j]);
                        continue;
                    }
                    n = indexCache.addNew(j);
                }
                if (-1 < pShapeOpenGL.firstPolyVertex) {
                    if (this.firstPolyVertex == -1) {
                        this.firstPolyVertex = Integer.MAX_VALUE;
                    }
                    this.firstPolyVertex = PApplet.min(this.firstPolyVertex, pShapeOpenGL.firstPolyVertex);
                }
                if (-1 >= pShapeOpenGL.lastPolyVertex) continue;
                this.lastPolyVertex = PApplet.max(this.lastPolyVertex, pShapeOpenGL.lastPolyVertex);
            }
            this.lastPolyIndexCache = n;
        } else {
            this.firstPolyVertex = this.lastPolyVertex = indexCache.vertexOffset[this.firstPolyIndexCache];
            for (int i = this.firstPolyIndexCache; i <= this.lastPolyIndexCache; ++i) {
                int n = indexCache.indexOffset[i];
                int n4 = indexCache.indexCount[i];
                int n5 = indexCache.vertexCount[i];
                if (PGL.MAX_VERTEX_INDEX1 <= this.root.polyVertexRel + n5 || this.is2D() && this.startStrokedTex(i)) {
                    this.root.polyVertexRel = 0;
                    this.root.polyVertexOffset = this.root.polyVertexAbs;
                    indexCache.indexOffset[i] = this.root.polyIndexOffset;
                } else {
                    this.tessGeo.incPolyIndices(n, n + n4 - 1, this.root.polyVertexRel);
                }
                indexCache.vertexOffset[i] = this.root.polyVertexOffset;
                if (this.is2D()) {
                    this.setFirstStrokeVertex(i, this.lastPolyVertex);
                }
                this.root.polyIndexOffset += n4;
                this.root.polyVertexAbs += n5;
                this.root.polyVertexRel += n5;
                this.lastPolyVertex += n5;
            }
            --this.lastPolyVertex;
            if (this.is2D()) {
                this.setLastStrokeVertex(this.lastPolyVertex);
            }
        }
    }

    protected boolean startStrokedTex(int n) {
        return this.image != null && (n == this.firstLineIndexCache || n == this.firstPointIndexCache);
    }

    protected void setFirstStrokeVertex(int n, int n2) {
        if (n == this.firstLineIndexCache && this.firstLineVertex == -1) {
            this.firstLineVertex = this.lastLineVertex = n2;
        }
        if (n == this.firstPointIndexCache && this.firstPointVertex == -1) {
            this.firstPointVertex = this.lastPointVertex = n2;
        }
    }

    protected void setLastStrokeVertex(int n) {
        if (-1 < this.lastLineVertex) {
            this.lastLineVertex = n;
        }
        if (-1 < this.lastPointVertex) {
            this.lastPointVertex += n;
        }
    }

    protected void updateLineIndexCache() {
        PGraphicsOpenGL.IndexCache indexCache = this.tessGeo.lineIndexCache;
        if (this.family == 0) {
            this.lastLineIndexCache = -1;
            this.firstLineIndexCache = -1;
            int n = -1;
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                int n2 = pShapeOpenGL.firstLineIndexCache;
                int n3 = -1 < n2 ? pShapeOpenGL.lastLineIndexCache - n2 + 1 : -1;
                for (int j = n2; j < n2 + n3; ++j) {
                    if (n == -1) {
                        this.firstLineIndexCache = n = indexCache.addNew(j);
                        continue;
                    }
                    if (indexCache.vertexOffset[n] == indexCache.vertexOffset[j]) {
                        indexCache.incCounts(n, indexCache.indexCount[j], indexCache.vertexCount[j]);
                        continue;
                    }
                    n = indexCache.addNew(j);
                }
                if (-1 < pShapeOpenGL.firstLineVertex) {
                    if (this.firstLineVertex == -1) {
                        this.firstLineVertex = Integer.MAX_VALUE;
                    }
                    this.firstLineVertex = PApplet.min(this.firstLineVertex, pShapeOpenGL.firstLineVertex);
                }
                if (-1 >= pShapeOpenGL.lastLineVertex) continue;
                this.lastLineVertex = PApplet.max(this.lastLineVertex, pShapeOpenGL.lastLineVertex);
            }
            this.lastLineIndexCache = n;
        } else {
            this.firstLineVertex = this.lastLineVertex = indexCache.vertexOffset[this.firstLineIndexCache];
            for (int i = this.firstLineIndexCache; i <= this.lastLineIndexCache; ++i) {
                int n = indexCache.indexOffset[i];
                int n4 = indexCache.indexCount[i];
                int n5 = indexCache.vertexCount[i];
                if (PGL.MAX_VERTEX_INDEX1 <= this.root.lineVertexRel + n5) {
                    this.root.lineVertexRel = 0;
                    this.root.lineVertexOffset = this.root.lineVertexAbs;
                    indexCache.indexOffset[i] = this.root.lineIndexOffset;
                } else {
                    this.tessGeo.incLineIndices(n, n + n4 - 1, this.root.lineVertexRel);
                }
                indexCache.vertexOffset[i] = this.root.lineVertexOffset;
                this.root.lineIndexOffset += n4;
                this.root.lineVertexAbs += n5;
                this.root.lineVertexRel += n5;
                this.lastLineVertex += n5;
            }
            --this.lastLineVertex;
        }
    }

    protected void updatePointIndexCache() {
        PGraphicsOpenGL.IndexCache indexCache = this.tessGeo.pointIndexCache;
        if (this.family == 0) {
            this.lastPointIndexCache = -1;
            this.firstPointIndexCache = -1;
            int n = -1;
            for (int i = 0; i < this.childCount; ++i) {
                PShapeOpenGL pShapeOpenGL = (PShapeOpenGL)this.children[i];
                int n2 = pShapeOpenGL.firstPointIndexCache;
                int n3 = -1 < n2 ? pShapeOpenGL.lastPointIndexCache - n2 + 1 : -1;
                for (int j = n2; j < n2 + n3; ++j) {
                    if (n == -1) {
                        this.firstPointIndexCache = n = indexCache.addNew(j);
                        continue;
                    }
                    if (indexCache.vertexOffset[n] == indexCache.vertexOffset[j]) {
                        indexCache.incCounts(n, indexCache.indexCount[j], indexCache.vertexCount[j]);
                        continue;
                    }
                    n = indexCache.addNew(j);
                }
                if (-1 < pShapeOpenGL.firstPointVertex) {
                    if (this.firstPointVertex == -1) {
                        this.firstPointVertex = Integer.MAX_VALUE;
                    }
                    this.firstPointVertex = PApplet.min(this.firstPointVertex, pShapeOpenGL.firstPointVertex);
                }
                if (-1 >= pShapeOpenGL.lastPointVertex) continue;
                this.lastPointVertex = PApplet.max(this.lastPointVertex, pShapeOpenGL.lastPointVertex);
            }
            this.lastPointIndexCache = n;
        } else {
            this.firstPointVertex = this.lastPointVertex = indexCache.vertexOffset[this.firstPointIndexCache];
            for (int i = this.firstPointIndexCache; i <= this.lastPointIndexCache; ++i) {
                int n = indexCache.indexOffset[i];
                int n4 = indexCache.indexCount[i];
                int n5 = indexCache.vertexCount[i];
                if (PGL.MAX_VERTEX_INDEX1 <= this.root.pointVertexRel + n5) {
                    this.root.pointVertexRel = 0;
                    this.root.pointVertexOffset = this.root.pointVertexAbs;
                    indexCache.indexOffset[i] = this.root.pointIndexOffset;
                } else {
                    this.tessGeo.incPointIndices(n, n + n4 - 1, this.root.pointVertexRel);
                }
                indexCache.vertexOffset[i] = this.root.pointVertexOffset;
                this.root.pointIndexOffset += n4;
                this.root.pointVertexAbs += n5;
                this.root.pointVertexRel += n5;
                this.lastPointVertex += n5;
            }
            --this.lastPointVertex;
        }
    }

    protected void initBuffers() {
        boolean bl = this.contextIsOutdated();
        this.context = this.pgl.getCurrentContext();
        if (this.hasPolys && (this.needBufferInit || bl)) {
            this.initPolyBuffers();
        }
        if (this.hasLines && (this.needBufferInit || bl)) {
            this.initLineBuffers();
        }
        if (this.hasPoints && (this.needBufferInit || bl)) {
            this.initPointBuffers();
        }
        this.needBufferInit = false;
    }

    protected void initPolyBuffers() {
        int n = this.tessGeo.polyVertexCount;
        int n2 = n * PGL.SIZEOF_FLOAT;
        int n3 = n * PGL.SIZEOF_INT;
        this.tessGeo.updatePolyVerticesBuffer();
        if (this.glPolyVertex == 0) {
            this.glPolyVertex = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyVertex);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * n2, this.tessGeo.polyVerticesBuffer, this.glUsage);
        this.tessGeo.updatePolyColorsBuffer();
        if (this.glPolyColor == 0) {
            this.glPolyColor = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyColor);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.polyColorsBuffer, this.glUsage);
        this.tessGeo.updatePolyNormalsBuffer();
        if (this.glPolyNormal == 0) {
            this.glPolyNormal = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyNormal);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 3 * n2, this.tessGeo.polyNormalsBuffer, this.glUsage);
        this.tessGeo.updatePolyTexCoordsBuffer();
        if (this.glPolyTexcoord == 0) {
            this.glPolyTexcoord = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyTexcoord);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 2 * n2, this.tessGeo.polyTexCoordsBuffer, this.glUsage);
        this.tessGeo.updatePolyAmbientBuffer();
        if (this.glPolyAmbient == 0) {
            this.glPolyAmbient = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyAmbient);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.polyAmbientBuffer, this.glUsage);
        this.tessGeo.updatePolySpecularBuffer();
        if (this.glPolySpecular == 0) {
            this.glPolySpecular = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolySpecular);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.polySpecularBuffer, this.glUsage);
        this.tessGeo.updatePolyEmissiveBuffer();
        if (this.glPolyEmissive == 0) {
            this.glPolyEmissive = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyEmissive);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.polyEmissiveBuffer, this.glUsage);
        this.tessGeo.updatePolyShininessBuffer();
        if (this.glPolyShininess == 0) {
            this.glPolyShininess = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyShininess);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, n2, this.tessGeo.polyShininessBuffer, this.glUsage);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
        this.tessGeo.updatePolyIndicesBuffer();
        if (this.glPolyIndex == 0) {
            this.glPolyIndex = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.glPolyIndex);
        this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, this.tessGeo.polyIndexCount * PGL.SIZEOF_INDEX, this.tessGeo.polyIndicesBuffer, this.glUsage);
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
    }

    protected void initLineBuffers() {
        int n = this.tessGeo.lineVertexCount;
        int n2 = n * PGL.SIZEOF_FLOAT;
        int n3 = n * PGL.SIZEOF_INT;
        this.tessGeo.updateLineVerticesBuffer();
        if (this.glLineVertex == 0) {
            this.glLineVertex = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineVertex);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * n2, this.tessGeo.lineVerticesBuffer, this.glUsage);
        this.tessGeo.updateLineColorsBuffer();
        if (this.glLineColor == 0) {
            this.glLineColor = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineColor);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.lineColorsBuffer, this.glUsage);
        this.tessGeo.updateLineDirectionsBuffer();
        if (this.glLineAttrib == 0) {
            this.glLineAttrib = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineAttrib);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * n2, this.tessGeo.lineDirectionsBuffer, this.glUsage);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
        this.tessGeo.updateLineIndicesBuffer();
        if (this.glLineIndex == 0) {
            this.glLineIndex = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.glLineIndex);
        this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, this.tessGeo.lineIndexCount * PGL.SIZEOF_INDEX, this.tessGeo.lineIndicesBuffer, this.glUsage);
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
    }

    protected void initPointBuffers() {
        int n = this.tessGeo.pointVertexCount;
        int n2 = n * PGL.SIZEOF_FLOAT;
        int n3 = n * PGL.SIZEOF_INT;
        this.tessGeo.updatePointVerticesBuffer();
        if (this.glPointVertex == 0) {
            this.glPointVertex = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointVertex);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * n2, this.tessGeo.pointVerticesBuffer, this.glUsage);
        this.tessGeo.updatePointColorsBuffer();
        if (this.glPointColor == 0) {
            this.glPointColor = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointColor);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.pointColorsBuffer, this.glUsage);
        this.tessGeo.updatePointOffsetsBuffer();
        if (this.glPointAttrib == 0) {
            this.glPointAttrib = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointAttrib);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 2 * n2, this.tessGeo.pointOffsetsBuffer, this.glUsage);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
        this.tessGeo.updatePointIndicesBuffer();
        if (this.glPointIndex == 0) {
            this.glPointIndex = PGraphicsOpenGL.createVertexBufferObject(this.context, this.pgl);
        }
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.glPointIndex);
        this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, this.tessGeo.pointIndexCount * PGL.SIZEOF_INDEX, this.tessGeo.pointIndicesBuffer, this.glUsage);
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
    }

    protected boolean contextIsOutdated() {
        boolean bl;
        boolean bl2 = bl = !this.pgl.contextIsCurrent(this.context);
        if (bl) {
            PGraphicsOpenGL.removeVertexBufferObject(this.glPolyVertex, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPolyColor, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPolyNormal, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPolyTexcoord, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPolyAmbient, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPolySpecular, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPolyEmissive, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPolyShininess, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPolyIndex, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glLineVertex, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glLineColor, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glLineAttrib, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glLineIndex, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPointVertex, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPointColor, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPointAttrib, this.context);
            PGraphicsOpenGL.removeVertexBufferObject(this.glPointIndex, this.context);
            this.glPolyVertex = 0;
            this.glPolyColor = 0;
            this.glPolyNormal = 0;
            this.glPolyTexcoord = 0;
            this.glPolyAmbient = 0;
            this.glPolySpecular = 0;
            this.glPolyEmissive = 0;
            this.glPolyShininess = 0;
            this.glPolyIndex = 0;
            this.glLineVertex = 0;
            this.glLineColor = 0;
            this.glLineAttrib = 0;
            this.glLineIndex = 0;
            this.glPointVertex = 0;
            this.glPointColor = 0;
            this.glPointAttrib = 0;
            this.glPointIndex = 0;
        }
        return bl;
    }

    protected void dispose() {
        this.deletePolyBuffers();
        this.deleteLineBuffers();
        this.deletePointBuffers();
    }

    protected void deletePolyBuffers() {
        if (this.glPolyVertex != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyVertex, this.context, this.pgl);
            this.glPolyVertex = 0;
        }
        if (this.glPolyColor != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyColor, this.context, this.pgl);
            this.glPolyColor = 0;
        }
        if (this.glPolyNormal != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyNormal, this.context, this.pgl);
            this.glPolyNormal = 0;
        }
        if (this.glPolyTexcoord != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyTexcoord, this.context, this.pgl);
            this.glPolyTexcoord = 0;
        }
        if (this.glPolyAmbient != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyAmbient, this.context, this.pgl);
            this.glPolyAmbient = 0;
        }
        if (this.glPolySpecular != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolySpecular, this.context, this.pgl);
            this.glPolySpecular = 0;
        }
        if (this.glPolyEmissive != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyEmissive, this.context, this.pgl);
            this.glPolyEmissive = 0;
        }
        if (this.glPolyShininess != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyShininess, this.context, this.pgl);
            this.glPolyShininess = 0;
        }
        if (this.glPolyIndex != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyIndex, this.context, this.pgl);
            this.glPolyIndex = 0;
        }
    }

    protected void deleteLineBuffers() {
        if (this.glLineVertex != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glLineVertex, this.context, this.pgl);
            this.glLineVertex = 0;
        }
        if (this.glLineColor != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glLineColor, this.context, this.pgl);
            this.glLineColor = 0;
        }
        if (this.glLineAttrib != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glLineAttrib, this.context, this.pgl);
            this.glLineAttrib = 0;
        }
        if (this.glLineIndex != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glLineIndex, this.context, this.pgl);
            this.glLineIndex = 0;
        }
    }

    protected void deletePointBuffers() {
        if (this.glPointVertex != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPointVertex, this.context, this.pgl);
            this.glPointVertex = 0;
        }
        if (this.glPointColor != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPointColor, this.context, this.pgl);
            this.glPointColor = 0;
        }
        if (this.glPointAttrib != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPointAttrib, this.context, this.pgl);
            this.glPointAttrib = 0;
        }
        if (this.glPointIndex != 0) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPointIndex, this.context, this.pgl);
            this.glPointIndex = 0;
        }
    }

    protected void updateGeometry() {
        this.root.initBuffers();
        if (this.root.modified) {
            this.root.updateGeometryImpl();
        }
    }

    protected void updateGeometryImpl() {
        int n;
        int n2;
        if (this.modifiedPolyVertices) {
            n2 = this.firstModifiedPolyVertex;
            n = this.lastModifiedPolyVertex - n2 + 1;
            this.copyPolyVertices(n2, n);
            this.modifiedPolyVertices = false;
            this.firstModifiedPolyVertex = Integer.MAX_VALUE;
            this.lastModifiedPolyVertex = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyColors) {
            n2 = this.firstModifiedPolyColor;
            n = this.lastModifiedPolyColor - n2 + 1;
            this.copyPolyColors(n2, n);
            this.modifiedPolyColors = false;
            this.firstModifiedPolyColor = Integer.MAX_VALUE;
            this.lastModifiedPolyColor = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyNormals) {
            n2 = this.firstModifiedPolyNormal;
            n = this.lastModifiedPolyNormal - n2 + 1;
            this.copyPolyNormals(n2, n);
            this.modifiedPolyNormals = false;
            this.firstModifiedPolyNormal = Integer.MAX_VALUE;
            this.lastModifiedPolyNormal = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyTexCoords) {
            n2 = this.firstModifiedPolyTexcoord;
            n = this.lastModifiedPolyTexcoord - n2 + 1;
            this.copyPolyTexCoords(n2, n);
            this.modifiedPolyTexCoords = false;
            this.firstModifiedPolyTexcoord = Integer.MAX_VALUE;
            this.lastModifiedPolyTexcoord = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyAmbient) {
            n2 = this.firstModifiedPolyAmbient;
            n = this.lastModifiedPolyAmbient - n2 + 1;
            this.copyPolyAmbient(n2, n);
            this.modifiedPolyAmbient = false;
            this.firstModifiedPolyAmbient = Integer.MAX_VALUE;
            this.lastModifiedPolyAmbient = Integer.MIN_VALUE;
        }
        if (this.modifiedPolySpecular) {
            n2 = this.firstModifiedPolySpecular;
            n = this.lastModifiedPolySpecular - n2 + 1;
            this.copyPolySpecular(n2, n);
            this.modifiedPolySpecular = false;
            this.firstModifiedPolySpecular = Integer.MAX_VALUE;
            this.lastModifiedPolySpecular = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyEmissive) {
            n2 = this.firstModifiedPolyEmissive;
            n = this.lastModifiedPolyEmissive - n2 + 1;
            this.copyPolyEmissive(n2, n);
            this.modifiedPolyEmissive = false;
            this.firstModifiedPolyEmissive = Integer.MAX_VALUE;
            this.lastModifiedPolyEmissive = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyShininess) {
            n2 = this.firstModifiedPolyShininess;
            n = this.lastModifiedPolyShininess - n2 + 1;
            this.copyPolyShininess(n2, n);
            this.modifiedPolyShininess = false;
            this.firstModifiedPolyShininess = Integer.MAX_VALUE;
            this.lastModifiedPolyShininess = Integer.MIN_VALUE;
        }
        if (this.modifiedLineVertices) {
            n2 = this.firstModifiedLineVertex;
            n = this.lastModifiedLineVertex - n2 + 1;
            this.copyLineVertices(n2, n);
            this.modifiedLineVertices = false;
            this.firstModifiedLineVertex = Integer.MAX_VALUE;
            this.lastModifiedLineVertex = Integer.MIN_VALUE;
        }
        if (this.modifiedLineColors) {
            n2 = this.firstModifiedLineColor;
            n = this.lastModifiedLineColor - n2 + 1;
            this.copyLineColors(n2, n);
            this.modifiedLineColors = false;
            this.firstModifiedLineColor = Integer.MAX_VALUE;
            this.lastModifiedLineColor = Integer.MIN_VALUE;
        }
        if (this.modifiedLineAttributes) {
            n2 = this.firstModifiedLineAttribute;
            n = this.lastModifiedLineAttribute - n2 + 1;
            this.copyLineAttributes(n2, n);
            this.modifiedLineAttributes = false;
            this.firstModifiedLineAttribute = Integer.MAX_VALUE;
            this.lastModifiedLineAttribute = Integer.MIN_VALUE;
        }
        if (this.modifiedPointVertices) {
            n2 = this.firstModifiedPointVertex;
            n = this.lastModifiedPointVertex - n2 + 1;
            this.copyPointVertices(n2, n);
            this.modifiedPointVertices = false;
            this.firstModifiedPointVertex = Integer.MAX_VALUE;
            this.lastModifiedPointVertex = Integer.MIN_VALUE;
        }
        if (this.modifiedPointColors) {
            n2 = this.firstModifiedPointColor;
            n = this.lastModifiedPointColor - n2 + 1;
            this.copyPointColors(n2, n);
            this.modifiedPointColors = false;
            this.firstModifiedPointColor = Integer.MAX_VALUE;
            this.lastModifiedPointColor = Integer.MIN_VALUE;
        }
        if (this.modifiedPointAttributes) {
            n2 = this.firstModifiedPointAttribute;
            n = this.lastModifiedPointAttribute - n2 + 1;
            this.copyPointAttributes(n2, n);
            this.modifiedPointAttributes = false;
            this.firstModifiedPointAttribute = Integer.MAX_VALUE;
            this.lastModifiedPointAttribute = Integer.MIN_VALUE;
        }
        this.modified = false;
    }

    protected void copyPolyVertices(int n, int n2) {
        this.tessGeo.updatePolyVerticesBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyVertex);
        this.tessGeo.polyVerticesBuffer.position(4 * n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, 4 * n * PGL.SIZEOF_FLOAT, 4 * n2 * PGL.SIZEOF_FLOAT, this.tessGeo.polyVerticesBuffer);
        this.tessGeo.polyVerticesBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyPolyColors(int n, int n2) {
        this.tessGeo.updatePolyColorsBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyColor);
        this.tessGeo.polyColorsBuffer.position(n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, n * PGL.SIZEOF_INT, n2 * PGL.SIZEOF_INT, this.tessGeo.polyColorsBuffer);
        this.tessGeo.polyColorsBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyPolyNormals(int n, int n2) {
        this.tessGeo.updatePolyNormalsBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyNormal);
        this.tessGeo.polyNormalsBuffer.position(3 * n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, 3 * n * PGL.SIZEOF_FLOAT, 3 * n2 * PGL.SIZEOF_FLOAT, this.tessGeo.polyNormalsBuffer);
        this.tessGeo.polyNormalsBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyPolyTexCoords(int n, int n2) {
        this.tessGeo.updatePolyTexCoordsBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyTexcoord);
        this.tessGeo.polyTexCoordsBuffer.position(2 * n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, 2 * n * PGL.SIZEOF_FLOAT, 2 * n2 * PGL.SIZEOF_FLOAT, this.tessGeo.polyTexCoordsBuffer);
        this.tessGeo.polyTexCoordsBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyPolyAmbient(int n, int n2) {
        this.tessGeo.updatePolyAmbientBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyAmbient);
        this.tessGeo.polyAmbientBuffer.position(n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, n * PGL.SIZEOF_INT, n2 * PGL.SIZEOF_INT, this.tessGeo.polyAmbientBuffer);
        this.tessGeo.polyAmbientBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyPolySpecular(int n, int n2) {
        this.tessGeo.updatePolySpecularBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolySpecular);
        this.tessGeo.polySpecularBuffer.position(n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, n * PGL.SIZEOF_INT, n2 * PGL.SIZEOF_INT, this.tessGeo.polySpecularBuffer);
        this.tessGeo.polySpecularBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyPolyEmissive(int n, int n2) {
        this.tessGeo.updatePolyEmissiveBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyEmissive);
        this.tessGeo.polyEmissiveBuffer.position(n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, n * PGL.SIZEOF_INT, n2 * PGL.SIZEOF_INT, this.tessGeo.polyEmissiveBuffer);
        this.tessGeo.polyEmissiveBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyPolyShininess(int n, int n2) {
        this.tessGeo.updatePolyShininessBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyShininess);
        this.tessGeo.polyShininessBuffer.position(n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, n * PGL.SIZEOF_FLOAT, n2 * PGL.SIZEOF_FLOAT, this.tessGeo.polyShininessBuffer);
        this.tessGeo.polyShininessBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyLineVertices(int n, int n2) {
        this.tessGeo.updateLineVerticesBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineVertex);
        this.tessGeo.lineVerticesBuffer.position(4 * n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, 4 * n * PGL.SIZEOF_FLOAT, 4 * n2 * PGL.SIZEOF_FLOAT, this.tessGeo.lineVerticesBuffer);
        this.tessGeo.lineVerticesBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyLineColors(int n, int n2) {
        this.tessGeo.updateLineColorsBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineColor);
        this.tessGeo.lineColorsBuffer.position(n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, n * PGL.SIZEOF_INT, n2 * PGL.SIZEOF_INT, this.tessGeo.lineColorsBuffer);
        this.tessGeo.lineColorsBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyLineAttributes(int n, int n2) {
        this.tessGeo.updateLineDirectionsBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineAttrib);
        this.tessGeo.lineDirectionsBuffer.position(4 * n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, 4 * n * PGL.SIZEOF_FLOAT, 4 * n2 * PGL.SIZEOF_FLOAT, this.tessGeo.lineDirectionsBuffer);
        this.tessGeo.lineDirectionsBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyPointVertices(int n, int n2) {
        this.tessGeo.updatePointVerticesBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointVertex);
        this.tessGeo.pointVerticesBuffer.position(4 * n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, 4 * n * PGL.SIZEOF_FLOAT, 4 * n2 * PGL.SIZEOF_FLOAT, this.tessGeo.pointVerticesBuffer);
        this.tessGeo.pointVerticesBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyPointColors(int n, int n2) {
        this.tessGeo.updatePointColorsBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointColor);
        this.tessGeo.pointColorsBuffer.position(n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, n * PGL.SIZEOF_INT, n2 * PGL.SIZEOF_INT, this.tessGeo.pointColorsBuffer);
        this.tessGeo.pointColorsBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void copyPointAttributes(int n, int n2) {
        this.tessGeo.updatePointOffsetsBuffer(n, n2);
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointAttrib);
        this.tessGeo.pointOffsetsBuffer.position(2 * n);
        this.pgl.bufferSubData(PGL.ARRAY_BUFFER, 2 * n * PGL.SIZEOF_FLOAT, 2 * n2 * PGL.SIZEOF_FLOAT, this.tessGeo.pointOffsetsBuffer);
        this.tessGeo.pointOffsetsBuffer.rewind();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void setModifiedPolyVertices(int n, int n2) {
        if (n < this.firstModifiedPolyVertex) {
            this.firstModifiedPolyVertex = n;
        }
        if (n2 > this.lastModifiedPolyVertex) {
            this.lastModifiedPolyVertex = n2;
        }
        this.modifiedPolyVertices = true;
        this.modified = true;
    }

    protected void setModifiedPolyColors(int n, int n2) {
        if (n < this.firstModifiedPolyColor) {
            this.firstModifiedPolyColor = n;
        }
        if (n2 > this.lastModifiedPolyColor) {
            this.lastModifiedPolyColor = n2;
        }
        this.modifiedPolyColors = true;
        this.modified = true;
    }

    protected void setModifiedPolyNormals(int n, int n2) {
        if (n < this.firstModifiedPolyNormal) {
            this.firstModifiedPolyNormal = n;
        }
        if (n2 > this.lastModifiedPolyNormal) {
            this.lastModifiedPolyNormal = n2;
        }
        this.modifiedPolyNormals = true;
        this.modified = true;
    }

    protected void setModifiedPolyTexCoords(int n, int n2) {
        if (n < this.firstModifiedPolyTexcoord) {
            this.firstModifiedPolyTexcoord = n;
        }
        if (n2 > this.lastModifiedPolyTexcoord) {
            this.lastModifiedPolyTexcoord = n2;
        }
        this.modifiedPolyTexCoords = true;
        this.modified = true;
    }

    protected void setModifiedPolyAmbient(int n, int n2) {
        if (n < this.firstModifiedPolyAmbient) {
            this.firstModifiedPolyAmbient = n;
        }
        if (n2 > this.lastModifiedPolyAmbient) {
            this.lastModifiedPolyAmbient = n2;
        }
        this.modifiedPolyAmbient = true;
        this.modified = true;
    }

    protected void setModifiedPolySpecular(int n, int n2) {
        if (n < this.firstModifiedPolySpecular) {
            this.firstModifiedPolySpecular = n;
        }
        if (n2 > this.lastModifiedPolySpecular) {
            this.lastModifiedPolySpecular = n2;
        }
        this.modifiedPolySpecular = true;
        this.modified = true;
    }

    protected void setModifiedPolyEmissive(int n, int n2) {
        if (n < this.firstModifiedPolyEmissive) {
            this.firstModifiedPolyEmissive = n;
        }
        if (n2 > this.lastModifiedPolyEmissive) {
            this.lastModifiedPolyEmissive = n2;
        }
        this.modifiedPolyEmissive = true;
        this.modified = true;
    }

    protected void setModifiedPolyShininess(int n, int n2) {
        if (n < this.firstModifiedPolyShininess) {
            this.firstModifiedPolyShininess = n;
        }
        if (n2 > this.lastModifiedPolyShininess) {
            this.lastModifiedPolyShininess = n2;
        }
        this.modifiedPolyShininess = true;
        this.modified = true;
    }

    protected void setModifiedLineVertices(int n, int n2) {
        if (n < this.firstModifiedLineVertex) {
            this.firstModifiedLineVertex = n;
        }
        if (n2 > this.lastModifiedLineVertex) {
            this.lastModifiedLineVertex = n2;
        }
        this.modifiedLineVertices = true;
        this.modified = true;
    }

    protected void setModifiedLineColors(int n, int n2) {
        if (n < this.firstModifiedLineColor) {
            this.firstModifiedLineColor = n;
        }
        if (n2 > this.lastModifiedLineColor) {
            this.lastModifiedLineColor = n2;
        }
        this.modifiedLineColors = true;
        this.modified = true;
    }

    protected void setModifiedLineAttributes(int n, int n2) {
        if (n < this.firstModifiedLineAttribute) {
            this.firstModifiedLineAttribute = n;
        }
        if (n2 > this.lastModifiedLineAttribute) {
            this.lastModifiedLineAttribute = n2;
        }
        this.modifiedLineAttributes = true;
        this.modified = true;
    }

    protected void setModifiedPointVertices(int n, int n2) {
        if (n < this.firstModifiedPointVertex) {
            this.firstModifiedPointVertex = n;
        }
        if (n2 > this.lastModifiedPointVertex) {
            this.lastModifiedPointVertex = n2;
        }
        this.modifiedPointVertices = true;
        this.modified = true;
    }

    protected void setModifiedPointColors(int n, int n2) {
        if (n < this.firstModifiedPointColor) {
            this.firstModifiedPointColor = n;
        }
        if (n2 > this.lastModifiedPointColor) {
            this.lastModifiedPointColor = n2;
        }
        this.modifiedPointColors = true;
        this.modified = true;
    }

    protected void setModifiedPointAttributes(int n, int n2) {
        if (n < this.firstModifiedPointAttribute) {
            this.firstModifiedPointAttribute = n;
        }
        if (n2 > this.lastModifiedPointAttribute) {
            this.lastModifiedPointAttribute = n2;
        }
        this.modifiedPointAttributes = true;
        this.modified = true;
    }

    @Override
    public void disableStyle() {
        if (this.openShape) {
            PGraphics.showWarning("%1$s can only be called outside beginShape() and endShape()", "disableStyle()");
            return;
        }
        this.savedStroke = this.stroke;
        this.savedStrokeColor = this.strokeColor;
        this.savedStrokeWeight = this.strokeWeight;
        this.savedStrokeCap = this.strokeCap;
        this.savedStrokeJoin = this.strokeJoin;
        this.savedFill = this.fill;
        this.savedFillColor = this.fillColor;
        this.savedTint = this.tint;
        this.savedTintColor = this.tintColor;
        this.savedAmbientColor = this.ambientColor;
        this.savedSpecularColor = this.specularColor;
        this.savedEmissiveColor = this.emissiveColor;
        this.savedShininess = this.shininess;
        this.savedTextureMode = this.textureMode;
        super.disableStyle();
    }

    @Override
    public void enableStyle() {
        if (this.savedStroke) {
            this.setStroke(true);
            this.setStroke(this.savedStrokeColor);
            this.setStrokeWeight(this.savedStrokeWeight);
            this.setStrokeCap(this.savedStrokeCap);
            this.setStrokeJoin(this.savedStrokeJoin);
        } else {
            this.setStroke(false);
        }
        if (this.savedFill) {
            this.setFill(true);
            this.setFill(this.savedFillColor);
        } else {
            this.setFill(false);
        }
        if (this.savedTint) {
            this.setTint(true);
            this.setTint(this.savedTintColor);
        }
        this.setAmbient(this.savedAmbientColor);
        this.setSpecular(this.savedSpecularColor);
        this.setEmissive(this.savedEmissiveColor);
        this.setShininess(this.savedShininess);
        if (this.image != null) {
            this.setTextureMode(this.savedTextureMode);
        }
        super.enableStyle();
    }

    @Override
    protected void styles(PGraphics pGraphics) {
        if (pGraphics instanceof PGraphicsOpenGL) {
            if (pGraphics.stroke) {
                this.setStroke(true);
                this.setStroke(pGraphics.strokeColor);
                this.setStrokeWeight(pGraphics.strokeWeight);
                this.setStrokeCap(pGraphics.strokeCap);
                this.setStrokeJoin(pGraphics.strokeJoin);
            } else {
                this.setStroke(false);
            }
            if (pGraphics.fill) {
                this.setFill(true);
                this.setFill(pGraphics.fillColor);
            } else {
                this.setFill(false);
            }
            if (pGraphics.tint) {
                this.setTint(true);
                this.setTint(pGraphics.tintColor);
            }
            this.setAmbient(pGraphics.ambientColor);
            this.setSpecular(pGraphics.specularColor);
            this.setEmissive(pGraphics.emissiveColor);
            this.setShininess(pGraphics.shininess);
            if (this.image != null) {
                this.setTextureMode(pGraphics.textureMode);
            }
        } else {
            super.styles(pGraphics);
        }
    }

    public void draw() {
        this.draw(this.pg);
    }

    @Override
    public void draw(PGraphics pGraphics) {
        if (pGraphics instanceof PGraphicsOpenGL) {
            PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)pGraphics;
            if (this.visible) {
                this.pre(pGraphicsOpenGL);
                this.updateTessellation();
                this.updateGeometry();
                if (this.family == 0) {
                    if (this.fragmentedGroup(pGraphicsOpenGL)) {
                        for (int i = 0; i < this.childCount; ++i) {
                            ((PShapeOpenGL)this.children[i]).draw(pGraphicsOpenGL);
                        }
                    } else {
                        PImage pImage = null;
                        if (this.textures != null && this.textures.size() == 1) {
                            pImage = (PImage)this.textures.toArray()[0];
                        }
                        this.render(pGraphicsOpenGL, pImage);
                    }
                } else {
                    this.render(pGraphicsOpenGL, this.image);
                }
                this.post(pGraphicsOpenGL);
            }
        } else {
            super.draw(pGraphics);
        }
    }

    protected boolean fragmentedGroup(PGraphicsOpenGL pGraphicsOpenGL) {
        return pGraphicsOpenGL.getHint(6) || this.textures != null && 1 < this.textures.size() || this.strokedTexture;
    }

    @Override
    protected void pre(PGraphics pGraphics) {
        if (pGraphics instanceof PGraphicsOpenGL) {
            if (!this.style) {
                this.styles(pGraphics);
            }
        } else {
            super.pre(pGraphics);
        }
    }

    @Override
    protected void post(PGraphics pGraphics) {
        if (!(pGraphics instanceof PGraphicsOpenGL)) {
            super.post(pGraphics);
        }
    }

    @Override
    protected void drawGeometry(PGraphics pGraphics) {
        this.vertexCount = this.inGeo.vertexCount;
        this.vertices = this.inGeo.getVertexData();
        super.drawGeometry(pGraphics);
        this.vertexCount = 0;
        this.vertices = null;
    }

    protected void render(PGraphicsOpenGL pGraphicsOpenGL, PImage pImage) {
        if (this.root == null) {
            throw new RuntimeException("Error rendering PShapeOpenGL, root shape is null");
        }
        if (this.hasPolys) {
            this.renderPolys(pGraphicsOpenGL, pImage);
            if (pGraphicsOpenGL.haveRaw()) {
                this.rawPolys(pGraphicsOpenGL, pImage);
            }
        }
        if (this.is3D()) {
            if (this.hasLines) {
                this.renderLines(pGraphicsOpenGL);
                if (pGraphicsOpenGL.haveRaw()) {
                    this.rawLines(pGraphicsOpenGL);
                }
            }
            if (this.hasPoints) {
                this.renderPoints(pGraphicsOpenGL);
                if (pGraphicsOpenGL.haveRaw()) {
                    this.rawPoints(pGraphicsOpenGL);
                }
            }
        }
    }

    protected void renderPolys(PGraphicsOpenGL pGraphicsOpenGL, PImage pImage) {
        boolean bl = pGraphicsOpenGL.polyShader != null;
        boolean bl2 = bl ? pGraphicsOpenGL.polyShader.accessNormals() : false;
        boolean bl3 = bl ? pGraphicsOpenGL.polyShader.accessTexCoords() : false;
        Texture texture = pImage != null ? pGraphicsOpenGL.getTexture(pImage) : null;
        boolean bl4 = false;
        boolean bl5 = false;
        PShader pShader = null;
        PGraphicsOpenGL.IndexCache indexCache = this.tessGeo.polyIndexCache;
        for (int i = this.firstPolyIndexCache; i <= this.lastPolyIndexCache; ++i) {
            if (this.is3D() || texture != null && (this.firstLineIndexCache == -1 || i < this.firstLineIndexCache) && (this.firstPointIndexCache == -1 || i < this.firstPointIndexCache)) {
                if (!bl4) {
                    pShader = pGraphicsOpenGL.getPolyShader(pGraphicsOpenGL.lights, texture != null);
                    pShader.bind();
                    bl4 = true;
                }
            } else if (!bl5) {
                if (texture != null) {
                    texture.unbind();
                    texture = null;
                }
                if (pShader != null && pShader.bound()) {
                    pShader.unbind();
                }
                pShader = pGraphicsOpenGL.getPolyShader(pGraphicsOpenGL.lights, false);
                pShader.bind();
                bl4 = false;
                bl5 = true;
            }
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            pShader.setVertexAttribute(this.root.glPolyVertex, 4, PGL.FLOAT, 0, 4 * n3 * PGL.SIZEOF_FLOAT);
            pShader.setColorAttribute(this.root.glPolyColor, 4, PGL.UNSIGNED_BYTE, 0, 4 * n3 * PGL.SIZEOF_BYTE);
            if (pGraphicsOpenGL.lights) {
                pShader.setNormalAttribute(this.root.glPolyNormal, 3, PGL.FLOAT, 0, 3 * n3 * PGL.SIZEOF_FLOAT);
                pShader.setAmbientAttribute(this.root.glPolyAmbient, 4, PGL.UNSIGNED_BYTE, 0, 4 * n3 * PGL.SIZEOF_BYTE);
                pShader.setSpecularAttribute(this.root.glPolySpecular, 4, PGL.UNSIGNED_BYTE, 0, 4 * n3 * PGL.SIZEOF_BYTE);
                pShader.setEmissiveAttribute(this.root.glPolyEmissive, 4, PGL.UNSIGNED_BYTE, 0, 4 * n3 * PGL.SIZEOF_BYTE);
                pShader.setShininessAttribute(this.root.glPolyShininess, 1, PGL.FLOAT, 0, n3 * PGL.SIZEOF_FLOAT);
            }
            if (pGraphicsOpenGL.lights || bl2) {
                pShader.setNormalAttribute(this.root.glPolyNormal, 3, PGL.FLOAT, 0, 3 * n3 * PGL.SIZEOF_FLOAT);
            }
            if (texture != null || bl3) {
                pShader.setTexcoordAttribute(this.root.glPolyTexcoord, 2, PGL.FLOAT, 0, 2 * n3 * PGL.SIZEOF_FLOAT);
                pShader.setTexture(texture);
            }
            pShader.draw(this.root.glPolyIndex, n2, n);
        }
        if (pShader != null && pShader.bound()) {
            pShader.unbind();
        }
    }

    protected void rawPolys(PGraphicsOpenGL pGraphicsOpenGL, PImage pImage) {
        PGraphics pGraphics = pGraphicsOpenGL.getRaw();
        pGraphics.colorMode(1);
        pGraphics.noStroke();
        pGraphics.beginShape(9);
        float[] fArray = this.tessGeo.polyVertices;
        int[] nArray = this.tessGeo.polyColors;
        float[] fArray2 = this.tessGeo.polyTexCoords;
        short[] sArray = this.tessGeo.polyIndices;
        PGraphicsOpenGL.IndexCache indexCache = this.tessGeo.polyIndexCache;
        for (int i = this.firstPolyIndexCache; i <= this.lastPolyIndexCache; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            for (int j = n / 3; j < (n + n2) / 3; ++j) {
                float f;
                float f2;
                float f3;
                float f4;
                float f5;
                float f6;
                int n4 = n3 + sArray[3 * j + 0];
                int n5 = n3 + sArray[3 * j + 1];
                int n6 = n3 + sArray[3 * j + 2];
                float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray5 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray6 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray7 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray8 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                int n7 = PGL.nativeToJavaARGB(nArray[n4]);
                int n8 = PGL.nativeToJavaARGB(nArray[n5]);
                int n9 = PGL.nativeToJavaARGB(nArray[n6]);
                PApplet.arrayCopy(fArray, 4 * n4, fArray3, 0, 4);
                PApplet.arrayCopy(fArray, 4 * n5, fArray4, 0, 4);
                PApplet.arrayCopy(fArray, 4 * n6, fArray5, 0, 4);
                pGraphicsOpenGL.modelview.mult(fArray3, fArray6);
                pGraphicsOpenGL.modelview.mult(fArray4, fArray7);
                pGraphicsOpenGL.modelview.mult(fArray5, fArray8);
                if (pImage != null) {
                    pGraphics.texture(pImage);
                    if (pGraphics.is3D()) {
                        pGraphics.fill(n7);
                        pGraphics.vertex(fArray6[0], fArray6[1], fArray6[2], fArray2[2 * n4 + 0], fArray2[2 * n4 + 1]);
                        pGraphics.fill(n8);
                        pGraphics.vertex(fArray7[0], fArray7[1], fArray7[2], fArray2[2 * n5 + 0], fArray2[2 * n5 + 1]);
                        pGraphics.fill(n9);
                        pGraphics.vertex(fArray8[0], fArray8[1], fArray8[2], fArray2[2 * n6 + 0], fArray2[2 * n6 + 1]);
                        continue;
                    }
                    if (!pGraphics.is2D()) continue;
                    f6 = pGraphicsOpenGL.screenXImpl(fArray6[0], fArray6[1], fArray6[2], fArray6[3]);
                    f5 = pGraphicsOpenGL.screenYImpl(fArray6[0], fArray6[1], fArray6[2], fArray6[3]);
                    f4 = pGraphicsOpenGL.screenXImpl(fArray7[0], fArray7[1], fArray7[2], fArray7[3]);
                    f3 = pGraphicsOpenGL.screenYImpl(fArray7[0], fArray7[1], fArray7[2], fArray7[3]);
                    f2 = pGraphicsOpenGL.screenXImpl(fArray8[0], fArray8[1], fArray8[2], fArray8[3]);
                    f = pGraphicsOpenGL.screenYImpl(fArray8[0], fArray8[1], fArray8[2], fArray8[3]);
                    pGraphics.fill(n7);
                    pGraphics.vertex(f6, f5, fArray2[2 * n4 + 0], fArray2[2 * n4 + 1]);
                    pGraphics.fill(n8);
                    pGraphics.vertex(f4, f3, fArray2[2 * n5 + 0], fArray2[2 * n5 + 1]);
                    pGraphics.fill(n8);
                    pGraphics.vertex(f2, f, fArray2[2 * n6 + 0], fArray2[2 * n6 + 1]);
                    continue;
                }
                if (pGraphics.is3D()) {
                    pGraphics.fill(n7);
                    pGraphics.vertex(fArray6[0], fArray6[1], fArray6[2]);
                    pGraphics.fill(n8);
                    pGraphics.vertex(fArray7[0], fArray7[1], fArray7[2]);
                    pGraphics.fill(n9);
                    pGraphics.vertex(fArray8[0], fArray8[1], fArray8[2]);
                    continue;
                }
                if (!pGraphics.is2D()) continue;
                f6 = pGraphicsOpenGL.screenXImpl(fArray6[0], fArray6[1], fArray6[2], fArray6[3]);
                f5 = pGraphicsOpenGL.screenYImpl(fArray6[0], fArray6[1], fArray6[2], fArray6[3]);
                f4 = pGraphicsOpenGL.screenXImpl(fArray7[0], fArray7[1], fArray7[2], fArray7[3]);
                f3 = pGraphicsOpenGL.screenYImpl(fArray7[0], fArray7[1], fArray7[2], fArray7[3]);
                f2 = pGraphicsOpenGL.screenXImpl(fArray8[0], fArray8[1], fArray8[2], fArray8[3]);
                f = pGraphicsOpenGL.screenYImpl(fArray8[0], fArray8[1], fArray8[2], fArray8[3]);
                pGraphics.fill(n7);
                pGraphics.vertex(f6, f5);
                pGraphics.fill(n8);
                pGraphics.vertex(f4, f3);
                pGraphics.fill(n9);
                pGraphics.vertex(f2, f);
            }
        }
        pGraphics.endShape();
    }

    protected void renderLines(PGraphicsOpenGL pGraphicsOpenGL) {
        PShader pShader = pGraphicsOpenGL.getLineShader();
        pShader.bind();
        PGraphicsOpenGL.IndexCache indexCache = this.tessGeo.lineIndexCache;
        for (int i = this.firstLineIndexCache; i <= this.lastLineIndexCache; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            pShader.setVertexAttribute(this.root.glLineVertex, 4, PGL.FLOAT, 0, 4 * n3 * PGL.SIZEOF_FLOAT);
            pShader.setColorAttribute(this.root.glLineColor, 4, PGL.UNSIGNED_BYTE, 0, 4 * n3 * PGL.SIZEOF_BYTE);
            pShader.setLineAttribute(this.root.glLineAttrib, 4, PGL.FLOAT, 0, 4 * n3 * PGL.SIZEOF_FLOAT);
            pShader.draw(this.root.glLineIndex, n2, n);
        }
        pShader.unbind();
    }

    protected void rawLines(PGraphicsOpenGL pGraphicsOpenGL) {
        PGraphics pGraphics = pGraphicsOpenGL.getRaw();
        pGraphics.colorMode(1);
        pGraphics.noFill();
        pGraphics.strokeCap(this.strokeCap);
        pGraphics.strokeJoin(this.strokeJoin);
        pGraphics.beginShape(5);
        float[] fArray = this.tessGeo.lineVertices;
        int[] nArray = this.tessGeo.lineColors;
        float[] fArray2 = this.tessGeo.lineDirections;
        short[] sArray = this.tessGeo.lineIndices;
        PGraphicsOpenGL.IndexCache indexCache = this.tessGeo.lineIndexCache;
        for (int i = this.firstLineIndexCache; i <= this.lastLineIndexCache; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            for (int j = n / 6; j < (n + n2) / 6; ++j) {
                int n4 = n3 + sArray[6 * j + 0];
                int n5 = n3 + sArray[6 * j + 5];
                float f = 2.0f * fArray2[4 * n4 + 3];
                float f2 = 2.0f * fArray2[4 * n5 + 3];
                if (PGraphicsOpenGL.zero(f)) continue;
                float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray5 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray6 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                int n6 = PGL.nativeToJavaARGB(nArray[n4]);
                int n7 = PGL.nativeToJavaARGB(nArray[n5]);
                PApplet.arrayCopy(fArray, 4 * n4, fArray3, 0, 4);
                PApplet.arrayCopy(fArray, 4 * n5, fArray4, 0, 4);
                pGraphicsOpenGL.modelview.mult(fArray3, fArray5);
                pGraphicsOpenGL.modelview.mult(fArray4, fArray6);
                if (pGraphics.is3D()) {
                    pGraphics.strokeWeight(f);
                    pGraphics.stroke(n6);
                    pGraphics.vertex(fArray5[0], fArray5[1], fArray5[2]);
                    pGraphics.strokeWeight(f2);
                    pGraphics.stroke(n7);
                    pGraphics.vertex(fArray6[0], fArray6[1], fArray6[2]);
                    continue;
                }
                if (!pGraphics.is2D()) continue;
                float f3 = pGraphicsOpenGL.screenXImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                float f4 = pGraphicsOpenGL.screenYImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                float f5 = pGraphicsOpenGL.screenXImpl(fArray6[0], fArray6[1], fArray6[2], fArray6[3]);
                float f6 = pGraphicsOpenGL.screenYImpl(fArray6[0], fArray6[1], fArray6[2], fArray6[3]);
                pGraphics.strokeWeight(f);
                pGraphics.stroke(n6);
                pGraphics.vertex(f3, f4);
                pGraphics.strokeWeight(f2);
                pGraphics.stroke(n7);
                pGraphics.vertex(f5, f6);
            }
        }
        pGraphics.endShape();
    }

    protected void renderPoints(PGraphicsOpenGL pGraphicsOpenGL) {
        PShader pShader = pGraphicsOpenGL.getPointShader();
        pShader.bind();
        PGraphicsOpenGL.IndexCache indexCache = this.tessGeo.pointIndexCache;
        for (int i = this.firstPointIndexCache; i <= this.lastPointIndexCache; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            pShader.setVertexAttribute(this.root.glPointVertex, 4, PGL.FLOAT, 0, 4 * n3 * PGL.SIZEOF_FLOAT);
            pShader.setColorAttribute(this.root.glPointColor, 4, PGL.UNSIGNED_BYTE, 0, 4 * n3 * PGL.SIZEOF_BYTE);
            pShader.setPointAttribute(this.root.glPointAttrib, 2, PGL.FLOAT, 0, 2 * n3 * PGL.SIZEOF_FLOAT);
            pShader.draw(this.root.glPointIndex, n2, n);
        }
        pShader.unbind();
    }

    protected void rawPoints(PGraphicsOpenGL pGraphicsOpenGL) {
        PGraphics pGraphics = pGraphicsOpenGL.getRaw();
        pGraphics.colorMode(1);
        pGraphics.noFill();
        pGraphics.strokeCap(this.strokeCap);
        pGraphics.beginShape(3);
        float[] fArray = this.tessGeo.pointVertices;
        int[] nArray = this.tessGeo.pointColors;
        float[] fArray2 = this.tessGeo.pointOffsets;
        short[] sArray = this.tessGeo.pointIndices;
        PGraphicsOpenGL.IndexCache indexCache = this.tessGeo.pointIndexCache;
        for (int i = 0; i < indexCache.size; ++i) {
            int n;
            int n2 = indexCache.indexOffset[i];
            int n3 = indexCache.indexCount[i];
            int n4 = indexCache.vertexOffset[i];
            for (int j = n2; j < (n2 + n3) / 3; j += n) {
                float f;
                float f2 = fArray2[2 * j + 2];
                if (0.0f < f2) {
                    f = f2 / 0.5f;
                    n = PApplet.min(200, PApplet.max(20, (int)((float)Math.PI * 2 * f / 10.0f))) + 1;
                } else {
                    f = -f2 / 0.5f;
                    n = 5;
                }
                int n5 = n4 + sArray[3 * j];
                int n6 = PGL.nativeToJavaARGB(nArray[n5]);
                float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                PApplet.arrayCopy(fArray, 4 * n5, fArray4, 0, 4);
                pGraphicsOpenGL.modelview.mult(fArray4, fArray3);
                if (pGraphics.is3D()) {
                    pGraphics.strokeWeight(f);
                    pGraphics.stroke(n6);
                    pGraphics.vertex(fArray3[0], fArray3[1], fArray3[2]);
                    continue;
                }
                if (!pGraphics.is2D()) continue;
                float f3 = pGraphicsOpenGL.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                float f4 = pGraphicsOpenGL.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                pGraphics.strokeWeight(f);
                pGraphics.stroke(n6);
                pGraphics.vertex(f3, f4);
            }
        }
        pGraphics.endShape();
    }
}

