/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.util.zip.GZIPInputStream;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PShape;
import processing.core.PShapeOBJ;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShapeOpenGL;

public class PGraphics3D
extends PGraphicsOpenGL {
    @Override
    public boolean is2D() {
        return false;
    }

    @Override
    public boolean is3D() {
        return true;
    }

    @Override
    protected void defaultPerspective() {
        this.perspective();
    }

    @Override
    protected void defaultCamera() {
        this.camera();
    }

    @Override
    protected void begin2D() {
        this.pushProjection();
        this.ortho(0.0f, this.width, 0.0f, this.height, -1.0f, 1.0f);
        this.pushMatrix();
        float f = this.width / 2;
        float f2 = this.height / 2;
        this.modelview.reset();
        this.modelview.translate(-f, -f2);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.updateProjmodelview();
    }

    @Override
    protected void end2D() {
        this.popMatrix();
        this.popProjection();
    }

    protected static boolean isSupportedExtension(String string) {
        return string.equals("obj");
    }

    protected static PShape loadShapeImpl(PGraphics pGraphics, String string, String string2) {
        PShapeOBJ pShapeOBJ = null;
        if (string2.equals("obj")) {
            pShapeOBJ = new PShapeOBJ(pGraphics.parent, string);
        } else if (string2.equals("objz")) {
            try {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(pGraphics.parent.createInput(string));
                pShapeOBJ = new PShapeOBJ(pGraphics.parent, PApplet.createReader(gZIPInputStream));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (pShapeOBJ != null) {
            int n = pGraphics.textureMode;
            pGraphics.textureMode = 1;
            PShapeOpenGL pShapeOpenGL = PShapeOpenGL.createShape3D((PGraphicsOpenGL)pGraphics, pShapeOBJ);
            pGraphics.textureMode = n;
            return pShapeOpenGL;
        }
        return null;
    }

    @Override
    public PShape createShape(PShape pShape) {
        return PShapeOpenGL.createShape3D(this, pShape);
    }

    @Override
    public PShape createShape() {
        return this.createShape(3);
    }

    @Override
    public PShape createShape(int n) {
        return PGraphics3D.createShapeImpl(this, n);
    }

    @Override
    public PShape createShape(int n, float ... fArray) {
        return PGraphics3D.createShapeImpl(this, n, fArray);
    }

    protected static PShapeOpenGL createShapeImpl(PGraphicsOpenGL pGraphicsOpenGL, int n) {
        PShapeOpenGL pShapeOpenGL = null;
        if (n == 0) {
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 0);
        } else if (n == 2) {
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 2);
        } else if (n == 3) {
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 3);
        }
        pShapeOpenGL.is3D(true);
        return pShapeOpenGL;
    }

    protected static PShapeOpenGL createShapeImpl(PGraphicsOpenGL pGraphicsOpenGL, int n, float ... fArray) {
        PShapeOpenGL pShapeOpenGL = null;
        int n2 = fArray.length;
        if (n == 2) {
            if (n2 != 2 && n2 != 3) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 1);
            pShapeOpenGL.setKind(2);
        } else if (n == 4) {
            if (n2 != 4 && n2 != 6) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 1);
            pShapeOpenGL.setKind(4);
        } else if (n == 8) {
            if (n2 != 6) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 1);
            pShapeOpenGL.setKind(8);
        } else if (n == 16) {
            if (n2 != 8) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 1);
            pShapeOpenGL.setKind(16);
        } else if (n == 30) {
            if (n2 != 4 && n2 != 5 && n2 != 8 && n2 != 9) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 1);
            pShapeOpenGL.setKind(30);
        } else if (n == 31) {
            if (n2 != 4 && n2 != 5) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 1);
            pShapeOpenGL.setKind(31);
        } else if (n == 32) {
            if (n2 != 6 && n2 != 7) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 1);
            pShapeOpenGL.setKind(32);
        } else if (n == 41) {
            if (n2 != 1 && n2 != 3) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 1);
            pShapeOpenGL.setKind(41);
        } else if (n == 40) {
            if (n2 < 1 || 3 < n2) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            pShapeOpenGL = new PShapeOpenGL(pGraphicsOpenGL, 1);
            pShapeOpenGL.setKind(40);
        } else {
            PGraphics3D.showWarning("Unrecognized primitive type");
        }
        if (pShapeOpenGL != null) {
            pShapeOpenGL.setParams(fArray);
        }
        pShapeOpenGL.is3D(true);
        return pShapeOpenGL;
    }
}

