/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;
import processing.core.PApplet;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.tess.PGLU;
import processing.opengl.tess.PGLUtessellator;
import processing.opengl.tess.PGLUtessellatorCallbackAdapter;

public class PGLES
extends PGL {
    public GL10 gl;
    public PGLU glu = new PGLU();
    public static EGLContext context;
    public static GLSurfaceView glview;
    protected static AndroidRenderer renderer;
    protected static AndroidConfigChooser configChooser;
    protected static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    protected static final int EGL_OPENGL_ES2_BIT = 4;
    protected static final int EGL_COVERAGE_BUFFERS_NV = 12512;
    protected static final int EGL_COVERAGE_SAMPLES_NV = 12513;
    protected static final int GL_COVERAGE_BUFFER_BIT_NV = 32768;
    protected static boolean usingMultisampling;
    protected static boolean usingCoverageMultisampling;
    protected static int multisampleCount;

    public PGLES(PGraphicsOpenGL pGraphicsOpenGL) {
        super(pGraphicsOpenGL);
    }

    public GLSurfaceView getCanvas() {
        return glview;
    }

    @Override
    protected void setFps(float f) {
    }

    @Override
    protected void initSurface(int n) {
        glview = (GLSurfaceView)this.pg.parent.getSurfaceView();
        this.reqNumSamples = PGLES.qualityToSamples(n);
        this.registerListeners();
        this.fboLayerCreated = false;
        this.fboLayerInUse = false;
        this.firstFrame = true;
        this.setFps = false;
    }

    @Override
    protected void reinitSurface() {
    }

    @Override
    protected void registerListeners() {
    }

    @Override
    protected void getGL(PGL pGL) {
        PGLES pGLES = (PGLES)pGL;
        this.gl = pGLES.gl;
    }

    @Override
    protected boolean canDraw() {
        return true;
    }

    @Override
    protected void requestFocus() {
    }

    @Override
    protected void requestDraw() {
        if (this.pg.initialized && this.pg.parent.canDraw()) {
            glview.requestRender();
        }
    }

    @Override
    protected void swapBuffers() {
    }

    public AndroidRenderer getRenderer() {
        renderer = new AndroidRenderer();
        return renderer;
    }

    public AndroidContextFactory getContextFactory() {
        return new AndroidContextFactory();
    }

    public AndroidConfigChooser getConfigChooser(int n) {
        configChooser = new AndroidConfigChooser(5, 6, 5, 4, 16, 1, n);
        return configChooser;
    }

    public AndroidConfigChooser getConfigChooser(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        configChooser = new AndroidConfigChooser(n, n2, n3, n4, n5, n6, n7);
        return configChooser;
    }

    @Override
    protected Tessellator createTessellator(PGL.TessellatorCallback tessellatorCallback) {
        return new Tessellator(tessellatorCallback);
    }

    @Override
    protected String tessError(int n) {
        return PGLU.gluErrorString(n);
    }

    @Override
    protected PGL.FontOutline createFontOutline(char c, Object object) {
        return null;
    }

    @Override
    public void flush() {
        GLES20.glFlush();
    }

    @Override
    public void finish() {
        GLES20.glFinish();
    }

    @Override
    public void hint(int n, int n2) {
        GLES20.glHint((int)n, (int)n2);
    }

    @Override
    public void enable(int n) {
        if (-1 < n) {
            GLES20.glEnable((int)n);
        }
    }

    @Override
    public void disable(int n) {
        if (-1 < n) {
            GLES20.glDisable((int)n);
        }
    }

    @Override
    public void getBooleanv(int n, IntBuffer intBuffer) {
        if (-1 < n) {
            GLES20.glGetBooleanv((int)n, (IntBuffer)intBuffer);
        } else {
            PGLES.fillIntBuffer(intBuffer, 0, intBuffer.capacity(), 0);
        }
    }

    @Override
    public void getIntegerv(int n, IntBuffer intBuffer) {
        if (-1 < n) {
            GLES20.glGetIntegerv((int)n, (IntBuffer)intBuffer);
        } else {
            PGLES.fillIntBuffer(intBuffer, 0, intBuffer.capacity() - 1, 0);
        }
    }

    @Override
    public void getFloatv(int n, FloatBuffer floatBuffer) {
        if (-1 < n) {
            GLES20.glGetFloatv((int)n, (FloatBuffer)floatBuffer);
        } else {
            PGLES.fillFloatBuffer(floatBuffer, 0, floatBuffer.capacity() - 1, 0.0f);
        }
    }

    @Override
    public boolean isEnabled(int n) {
        return GLES20.glIsEnabled((int)n);
    }

    @Override
    public String getString(int n) {
        return GLES20.glGetString((int)n);
    }

    @Override
    public int getError() {
        return GLES20.glGetError();
    }

    @Override
    public String errorString(int n) {
        return GLU.gluErrorString((int)n);
    }

    @Override
    public void genBuffers(int n, IntBuffer intBuffer) {
        GLES20.glGenBuffers((int)n, (IntBuffer)intBuffer);
    }

    @Override
    public void deleteBuffers(int n, IntBuffer intBuffer) {
        GLES20.glDeleteBuffers((int)n, (IntBuffer)intBuffer);
    }

    @Override
    public void bindBuffer(int n, int n2) {
        GLES20.glBindBuffer((int)n, (int)n2);
    }

    @Override
    public void bufferData(int n, int n2, Buffer buffer, int n3) {
        GLES20.glBufferData((int)n, (int)n2, (Buffer)buffer, (int)n3);
    }

    @Override
    public void bufferSubData(int n, int n2, int n3, Buffer buffer) {
        GLES20.glBufferSubData((int)n, (int)n2, (int)n3, (Buffer)buffer);
    }

    @Override
    public void isBuffer(int n) {
        GLES20.glIsBuffer((int)n);
    }

    @Override
    public void getBufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glGetBufferParameteriv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public ByteBuffer mapBuffer(int n, int n2) {
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glMapBuffer"));
    }

    @Override
    public ByteBuffer mapBufferRange(int n, int n2, int n3, int n4) {
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glMapBufferRange"));
    }

    @Override
    public void unmapBuffer(int n) {
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glUnmapBuffer"));
    }

    @Override
    public void depthRangef(float f, float f2) {
        GLES20.glDepthRangef((float)f, (float)f2);
    }

    @Override
    public void viewport(int n, int n2, int n3, int n4) {
        GLES20.glViewport((int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    public void readPixelsImpl(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        GLES20.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (Buffer)buffer);
    }

    @Override
    public void vertexAttrib1f(int n, float f) {
        GLES20.glVertexAttrib1f((int)n, (float)f);
    }

    @Override
    public void vertexAttrib2f(int n, float f, float f2) {
        GLES20.glVertexAttrib2f((int)n, (float)f, (float)f2);
    }

    @Override
    public void vertexAttrib3f(int n, float f, float f2, float f3) {
        GLES20.glVertexAttrib3f((int)n, (float)f, (float)f2, (float)f3);
    }

    @Override
    public void vertexAttrib4f(int n, float f, float f2, float f3, float f4) {
        GLES20.glVertexAttrib4f((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @Override
    public void vertexAttrib1fv(int n, FloatBuffer floatBuffer) {
        GLES20.glVertexAttrib1fv((int)n, (FloatBuffer)floatBuffer);
    }

    @Override
    public void vertexAttrib2fv(int n, FloatBuffer floatBuffer) {
        GLES20.glVertexAttrib2fv((int)n, (FloatBuffer)floatBuffer);
    }

    @Override
    public void vertexAttrib3fv(int n, FloatBuffer floatBuffer) {
        GLES20.glVertexAttrib3fv((int)n, (FloatBuffer)floatBuffer);
    }

    @Override
    public void vertexAttri4fv(int n, FloatBuffer floatBuffer) {
        GLES20.glVertexAttrib4fv((int)n, (FloatBuffer)floatBuffer);
    }

    @Override
    public void vertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, int n5) {
        GLES20.glVertexAttribPointer((int)n, (int)n2, (int)n3, (boolean)bl, (int)n4, (int)n5);
    }

    @Override
    public void vertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, Buffer buffer) {
        GLES20.glVertexAttribPointer((int)n, (int)n2, (int)n3, (boolean)bl, (int)n4, (Buffer)buffer);
    }

    @Override
    public void enableVertexAttribArray(int n) {
        GLES20.glEnableVertexAttribArray((int)n);
    }

    @Override
    public void disableVertexAttribArray(int n) {
        GLES20.glDisableVertexAttribArray((int)n);
    }

    @Override
    public void drawArrays(int n, int n2, int n3) {
        GLES20.glDrawArrays((int)n, (int)n2, (int)n3);
    }

    @Override
    public void drawElements(int n, int n2, int n3, int n4) {
        GLES20.glDrawElements((int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    public void drawElements(int n, int n2, int n3, Buffer buffer) {
        GLES20.glDrawElements((int)n, (int)n2, (int)n3, (Buffer)buffer);
    }

    @Override
    public void lineWidth(float f) {
        GLES20.glLineWidth((float)f);
    }

    @Override
    public void frontFace(int n) {
        GLES20.glFrontFace((int)n);
    }

    @Override
    public void cullFace(int n) {
        GLES20.glCullFace((int)n);
    }

    @Override
    public void polygonOffset(float f, float f2) {
        GLES20.glPolygonOffset((float)f, (float)f2);
    }

    @Override
    public void pixelStorei(int n, int n2) {
        GLES20.glPixelStorei((int)n, (int)n2);
    }

    @Override
    public void texImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        GLES20.glTexImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (Buffer)buffer);
    }

    @Override
    public void copyTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GLES20.glCopyTexImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8);
    }

    @Override
    public void texSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        GLES20.glTexSubImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (Buffer)buffer);
    }

    @Override
    public void copyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GLES20.glCopyTexSubImage2D((int)n, (int)n2, (int)n5, (int)n6, (int)n3, (int)n4, (int)n7, (int)n8);
    }

    @Override
    public void compressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        GLES20.glCompressedTexImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (Buffer)buffer);
    }

    @Override
    public void compressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        GLES20.glCompressedTexSubImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (Buffer)buffer);
    }

    @Override
    public void texParameteri(int n, int n2, int n3) {
        GLES20.glTexParameteri((int)n, (int)n2, (int)n3);
    }

    @Override
    public void texParameterf(int n, int n2, float f) {
        this.gl.glTexParameterf(n, n2, f);
    }

    @Override
    public void texParameteriv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glTexParameteriv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public void texParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glTexParameterfv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    @Override
    public void generateMipmap(int n) {
        GLES20.glGenerateMipmap((int)n);
    }

    @Override
    public void genTextures(int n, IntBuffer intBuffer) {
        GLES20.glGenTextures((int)n, (IntBuffer)intBuffer);
    }

    @Override
    public void deleteTextures(int n, IntBuffer intBuffer) {
        GLES20.glDeleteTextures((int)n, (IntBuffer)intBuffer);
    }

    @Override
    public void getTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glGetTexParameteriv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public void getTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glGetTexParameterfv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    @Override
    public boolean isTexture(int n) {
        return GLES20.glIsTexture((int)n);
    }

    @Override
    protected void activeTextureImpl(int n) {
        GLES20.glActiveTexture((int)n);
    }

    @Override
    protected void bindTextureImpl(int n, int n2) {
        GLES20.glBindTexture((int)n, (int)n2);
    }

    @Override
    public int createShader(int n) {
        return GLES20.glCreateShader((int)n);
    }

    @Override
    public void shaderSource(int n, String string) {
        GLES20.glShaderSource((int)n, (String)string);
    }

    @Override
    public void compileShader(int n) {
        GLES20.glCompileShader((int)n);
    }

    @Override
    public void releaseShaderCompiler() {
        GLES20.glReleaseShaderCompiler();
    }

    @Override
    public void deleteShader(int n) {
        GLES20.glDeleteShader((int)n);
    }

    @Override
    public void shaderBinary(int n, IntBuffer intBuffer, int n2, Buffer buffer, int n3) {
        GLES20.glShaderBinary((int)n, (IntBuffer)intBuffer, (int)n2, (Buffer)buffer, (int)n3);
    }

    @Override
    public int createProgram() {
        return GLES20.glCreateProgram();
    }

    @Override
    public void attachShader(int n, int n2) {
        GLES20.glAttachShader((int)n, (int)n2);
    }

    @Override
    public void detachShader(int n, int n2) {
        GLES20.glDetachShader((int)n, (int)n2);
    }

    @Override
    public void linkProgram(int n) {
        GLES20.glLinkProgram((int)n);
    }

    @Override
    public void useProgram(int n) {
        GLES20.glUseProgram((int)n);
    }

    @Override
    public void deleteProgram(int n) {
        GLES20.glDeleteProgram((int)n);
    }

    @Override
    public String getActiveAttrib(int n, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        int[] nArray = new int[]{0, 0, 0};
        byte[] byArray = new byte[1024];
        GLES20.glGetActiveAttrib((int)n, (int)n2, (int)1024, (int[])nArray, (int)0, (int[])nArray, (int)1, (int[])nArray, (int)2, (byte[])byArray, (int)0);
        intBuffer.put(nArray[1]);
        intBuffer2.put(nArray[2]);
        String string = new String(byArray, 0, nArray[0]);
        return string;
    }

    @Override
    public int getAttribLocation(int n, String string) {
        return GLES20.glGetAttribLocation((int)n, (String)string);
    }

    @Override
    public void bindAttribLocation(int n, int n2, String string) {
        GLES20.glBindAttribLocation((int)n, (int)n2, (String)string);
    }

    @Override
    public int getUniformLocation(int n, String string) {
        return GLES20.glGetUniformLocation((int)n, (String)string);
    }

    @Override
    public String getActiveUniform(int n, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        int[] nArray = new int[]{0, 0, 0};
        byte[] byArray = new byte[1024];
        GLES20.glGetActiveUniform((int)n, (int)n2, (int)1024, (int[])nArray, (int)0, (int[])nArray, (int)1, (int[])nArray, (int)2, (byte[])byArray, (int)0);
        intBuffer.put(nArray[1]);
        intBuffer2.put(nArray[2]);
        String string = new String(byArray, 0, nArray[0]);
        return string;
    }

    @Override
    public void uniform1i(int n, int n2) {
        GLES20.glUniform1i((int)n, (int)n2);
    }

    @Override
    public void uniform2i(int n, int n2, int n3) {
        GLES20.glUniform2i((int)n, (int)n2, (int)n3);
    }

    @Override
    public void uniform3i(int n, int n2, int n3, int n4) {
        GLES20.glUniform3i((int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    public void uniform4i(int n, int n2, int n3, int n4, int n5) {
        GLES20.glUniform4i((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    @Override
    public void uniform1f(int n, float f) {
        GLES20.glUniform1f((int)n, (float)f);
    }

    @Override
    public void uniform2f(int n, float f, float f2) {
        GLES20.glUniform2f((int)n, (float)f, (float)f2);
    }

    @Override
    public void uniform3f(int n, float f, float f2, float f3) {
        GLES20.glUniform3f((int)n, (float)f, (float)f2, (float)f3);
    }

    @Override
    public void uniform4f(int n, float f, float f2, float f3, float f4) {
        GLES20.glUniform4f((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @Override
    public void uniform1iv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glUniform1iv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public void uniform2iv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glUniform2iv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public void uniform3iv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glUniform3iv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public void uniform4iv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glUniform4iv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public void uniform1fv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glUniform1fv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    @Override
    public void uniform2fv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glUniform2fv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    @Override
    public void uniform3fv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glUniform3fv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    @Override
    public void uniform4fv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glUniform4fv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    @Override
    public void uniformMatrix2fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        GLES20.glUniformMatrix2fv((int)n, (int)n2, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    @Override
    public void uniformMatrix3fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        GLES20.glUniformMatrix3fv((int)n, (int)n2, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    @Override
    public void uniformMatrix4fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        GLES20.glUniformMatrix4fv((int)n, (int)n2, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    @Override
    public void validateProgram(int n) {
        GLES20.glValidateProgram((int)n);
    }

    @Override
    public boolean isShader(int n) {
        return GLES20.glIsShader((int)n);
    }

    @Override
    public void getShaderiv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glGetShaderiv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public void getAttachedShaders(int n, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        GLES20.glGetAttachedShaders((int)n, (int)n2, (IntBuffer)intBuffer, (IntBuffer)intBuffer2);
    }

    @Override
    public String getShaderInfoLog(int n) {
        return GLES20.glGetShaderInfoLog((int)n);
    }

    @Override
    public String getShaderSource(int n) {
        int[] nArray = new int[]{0};
        byte[] byArray = new byte[1024];
        GLES20.glGetShaderSource((int)n, (int)1024, (int[])nArray, (int)0, (byte[])byArray, (int)0);
        return new String(byArray, 0, nArray[0]);
    }

    @Override
    public void getShaderPrecisionFormat(int n, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        GLES20.glGetShaderPrecisionFormat((int)n, (int)n2, (IntBuffer)intBuffer, (IntBuffer)intBuffer2);
    }

    @Override
    public void getVertexAttribfv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glGetVertexAttribfv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    @Override
    public void getVertexAttribiv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glGetVertexAttribiv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public void getVertexAttribPointerv(int n, int n2, ByteBuffer byteBuffer) {
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glGetVertexAttribPointerv()"));
    }

    @Override
    public void getUniformfv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glGetUniformfv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    @Override
    public void getUniformiv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glGetUniformiv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public boolean isProgram(int n) {
        return GLES20.glIsProgram((int)n);
    }

    @Override
    public void getProgramiv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glGetProgramiv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public String getProgramInfoLog(int n) {
        return GLES20.glGetProgramInfoLog((int)n);
    }

    @Override
    public void scissor(int n, int n2, int n3, int n4) {
        GLES20.glScissor((int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    public void sampleCoverage(float f, boolean bl) {
        GLES20.glSampleCoverage((float)f, (boolean)bl);
    }

    @Override
    public void stencilFunc(int n, int n2, int n3) {
        GLES20.glStencilFunc((int)n, (int)n2, (int)n3);
    }

    @Override
    public void stencilFuncSeparate(int n, int n2, int n3, int n4) {
        GLES20.glStencilFuncSeparate((int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    public void stencilOp(int n, int n2, int n3) {
        GLES20.glStencilOp((int)n, (int)n2, (int)n3);
    }

    @Override
    public void stencilOpSeparate(int n, int n2, int n3, int n4) {
        GLES20.glStencilOpSeparate((int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    public void depthFunc(int n) {
        GLES20.glDepthFunc((int)n);
    }

    @Override
    public void blendEquation(int n) {
        GLES20.glBlendEquation((int)n);
    }

    @Override
    public void blendEquationSeparate(int n, int n2) {
        GLES20.glBlendEquationSeparate((int)n, (int)n2);
    }

    @Override
    public void blendFunc(int n, int n2) {
        GLES20.glBlendFunc((int)n, (int)n2);
    }

    @Override
    public void blendFuncSeparate(int n, int n2, int n3, int n4) {
        GLES20.glBlendFuncSeparate((int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    public void blendColor(float f, float f2, float f3, float f4) {
        GLES20.glBlendColor((float)f, (float)f2, (float)f3, (float)f4);
    }

    @Override
    public void alphaFunc(int n, float f) {
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glAlphaFunc()"));
    }

    @Override
    public void colorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        GLES20.glColorMask((boolean)bl, (boolean)bl2, (boolean)bl3, (boolean)bl4);
    }

    @Override
    public void depthMask(boolean bl) {
        GLES20.glDepthMask((boolean)bl);
    }

    @Override
    public void stencilMask(int n) {
        GLES20.glStencilMask((int)n);
    }

    @Override
    public void stencilMaskSeparate(int n, int n2) {
        GLES20.glStencilMaskSeparate((int)n, (int)n2);
    }

    @Override
    public void clear(int n) {
        if (usingMultisampling && usingCoverageMultisampling) {
            n |= 0x8000;
        }
        GLES20.glClear((int)n);
    }

    @Override
    public void clearColor(float f, float f2, float f3, float f4) {
        GLES20.glClearColor((float)f, (float)f2, (float)f3, (float)f4);
    }

    @Override
    public void clearDepth(float f) {
        GLES20.glClearDepthf((float)f);
    }

    @Override
    public void clearStencil(int n) {
        GLES20.glClearStencil((int)n);
    }

    @Override
    protected void bindFramebufferImpl(int n, int n2) {
        GLES20.glBindFramebuffer((int)n, (int)n2);
    }

    @Override
    public void deleteFramebuffers(int n, IntBuffer intBuffer) {
        GLES20.glDeleteFramebuffers((int)n, (IntBuffer)intBuffer);
    }

    @Override
    public void genFramebuffers(int n, IntBuffer intBuffer) {
        GLES20.glGenFramebuffers((int)n, (IntBuffer)intBuffer);
    }

    @Override
    public void bindRenderbuffer(int n, int n2) {
        GLES20.glBindRenderbuffer((int)n, (int)n2);
    }

    @Override
    public void deleteRenderbuffers(int n, IntBuffer intBuffer) {
        GLES20.glDeleteRenderbuffers((int)n, (IntBuffer)intBuffer);
    }

    @Override
    public void genRenderbuffers(int n, IntBuffer intBuffer) {
        GLES20.glGenRenderbuffers((int)n, (IntBuffer)intBuffer);
    }

    @Override
    public void renderbufferStorage(int n, int n2, int n3, int n4) {
        GLES20.glRenderbufferStorage((int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    public void framebufferRenderbuffer(int n, int n2, int n3, int n4) {
        GLES20.glFramebufferRenderbuffer((int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    public void framebufferTexture2D(int n, int n2, int n3, int n4, int n5) {
        GLES20.glFramebufferTexture2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    @Override
    public int checkFramebufferStatus(int n) {
        return GLES20.glCheckFramebufferStatus((int)n);
    }

    @Override
    public boolean isFramebuffer(int n) {
        return GLES20.glIsFramebuffer((int)n);
    }

    @Override
    public void getFramebufferAttachmentParameteriv(int n, int n2, int n3, IntBuffer intBuffer) {
        GLES20.glGetFramebufferAttachmentParameteriv((int)n, (int)n2, (int)n3, (IntBuffer)intBuffer);
    }

    @Override
    public boolean isRenderbuffer(int n) {
        return GLES20.glIsRenderbuffer((int)n);
    }

    @Override
    public void getRenderbufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glGetRenderbufferParameteriv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    @Override
    public void blitFramebuffer(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glBlitFramebuffer()"));
    }

    @Override
    public void renderbufferStorageMultisample(int n, int n2, int n3, int n4, int n5) {
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glRenderbufferStorageMultisample()"));
    }

    @Override
    public void readBuffer(int n) {
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glReadBuffer()"));
    }

    @Override
    public void drawBuffer(int n) {
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glDrawBuffer()"));
    }

    static {
        MIN_DIRECT_BUFFER_SIZE = 1;
        INDEX_TYPE = 5123;
        SAVE_SURFACE_TO_PIXELS_HACK = false;
        MIPMAPS_ENABLED = false;
        DEFAULT_IN_VERTICES = 16;
        DEFAULT_IN_EDGES = 32;
        DEFAULT_IN_TEXTURES = 16;
        DEFAULT_TESS_VERTICES = 16;
        DEFAULT_TESS_INDICES = 32;
        MIN_FONT_TEX_SIZE = 128;
        MAX_FONT_TEX_SIZE = 512;
        MAX_CAPS_JOINS_LENGTH = 1000;
        usingMultisampling = false;
        usingCoverageMultisampling = false;
        multisampleCount = 1;
        SHAPE_TEXT_SUPPORTED = false;
        FALSE = 0;
        TRUE = 1;
        INT = 5124;
        BYTE = 5120;
        SHORT = 5122;
        FLOAT = 5126;
        BOOL = 35670;
        UNSIGNED_INT = 5125;
        UNSIGNED_BYTE = 5121;
        UNSIGNED_SHORT = 5123;
        RGB = 6407;
        RGBA = 6408;
        ALPHA = 6406;
        LUMINANCE = 6409;
        LUMINANCE_ALPHA = 6410;
        UNSIGNED_SHORT_5_6_5 = 33635;
        UNSIGNED_SHORT_4_4_4_4 = 32819;
        UNSIGNED_SHORT_5_5_5_1 = 32820;
        RGBA4 = 32854;
        RGB5_A1 = 32855;
        RGB565 = 36194;
        RGB8 = 32849;
        RGBA8 = 32856;
        ALPHA8 = -1;
        READ_ONLY = -1;
        WRITE_ONLY = 35001;
        READ_WRITE = -1;
        TESS_WINDING_NONZERO = 100131;
        TESS_WINDING_ODD = 100130;
        GENERATE_MIPMAP_HINT = 33170;
        FASTEST = 4353;
        NICEST = 4354;
        DONT_CARE = 4352;
        VENDOR = 7936;
        RENDERER = 7937;
        VERSION = 7938;
        EXTENSIONS = 7939;
        SHADING_LANGUAGE_VERSION = 35724;
        MAX_SAMPLES = -1;
        SAMPLES = 32937;
        ALIASED_LINE_WIDTH_RANGE = 33902;
        ALIASED_POINT_SIZE_RANGE = 33901;
        DEPTH_BITS = 3414;
        STENCIL_BITS = 3415;
        CCW = 2305;
        CW = 2304;
        VIEWPORT = 2978;
        ARRAY_BUFFER = 34962;
        ELEMENT_ARRAY_BUFFER = 34963;
        MAX_VERTEX_ATTRIBS = 34921;
        STATIC_DRAW = 35044;
        DYNAMIC_DRAW = 35048;
        STREAM_DRAW = 35040;
        BUFFER_SIZE = 34660;
        BUFFER_USAGE = 34661;
        POINTS = 0;
        LINE_STRIP = 3;
        LINE_LOOP = 2;
        LINES = 1;
        TRIANGLE_FAN = 6;
        TRIANGLE_STRIP = 5;
        TRIANGLES = 4;
        CULL_FACE = 2884;
        FRONT = 1028;
        BACK = 1029;
        FRONT_AND_BACK = 1032;
        POLYGON_OFFSET_FILL = 32823;
        UNPACK_ALIGNMENT = 3317;
        PACK_ALIGNMENT = 3333;
        TEXTURE_2D = 3553;
        TEXTURE_RECTANGLE = -1;
        TEXTURE_BINDING_2D = 32873;
        TEXTURE_BINDING_RECTANGLE = -1;
        MAX_TEXTURE_SIZE = 3379;
        TEXTURE_MAX_ANISOTROPY = 34046;
        MAX_TEXTURE_MAX_ANISOTROPY = 34047;
        MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
        MAX_TEXTURE_IMAGE_UNITS = 34930;
        MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
        NUM_COMPRESSED_TEXTURE_FORMATS = 34466;
        COMPRESSED_TEXTURE_FORMATS = 34467;
        NEAREST = 9728;
        LINEAR = 9729;
        LINEAR_MIPMAP_NEAREST = 9985;
        LINEAR_MIPMAP_LINEAR = 9987;
        CLAMP_TO_EDGE = 33071;
        REPEAT = 10497;
        TEXTURE0 = 33984;
        TEXTURE1 = 33985;
        TEXTURE2 = 33986;
        TEXTURE3 = 33987;
        TEXTURE_MIN_FILTER = 10241;
        TEXTURE_MAG_FILTER = 10240;
        TEXTURE_WRAP_S = 10242;
        TEXTURE_WRAP_T = 10243;
        TEXTURE_WRAP_R = 32882;
        TEXTURE_CUBE_MAP = 34067;
        TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
        TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
        TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
        TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
        TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
        TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
        VERTEX_SHADER = 35633;
        FRAGMENT_SHADER = 35632;
        INFO_LOG_LENGTH = 35716;
        SHADER_SOURCE_LENGTH = 35720;
        COMPILE_STATUS = 35713;
        LINK_STATUS = 35714;
        VALIDATE_STATUS = 35715;
        SHADER_TYPE = 35663;
        DELETE_STATUS = 35712;
        FLOAT_VEC2 = 35664;
        FLOAT_VEC3 = 35665;
        FLOAT_VEC4 = 35666;
        FLOAT_MAT2 = 35674;
        FLOAT_MAT3 = 35675;
        FLOAT_MAT4 = 35676;
        INT_VEC2 = 35667;
        INT_VEC3 = 35668;
        INT_VEC4 = 35669;
        BOOL_VEC2 = 35671;
        BOOL_VEC3 = 35672;
        BOOL_VEC4 = 35673;
        SAMPLER_2D = 35678;
        SAMPLER_CUBE = 35680;
        LOW_FLOAT = 36336;
        MEDIUM_FLOAT = 36337;
        HIGH_FLOAT = 36338;
        LOW_INT = 36339;
        MEDIUM_INT = 36340;
        HIGH_INT = 36341;
        CURRENT_VERTEX_ATTRIB = 34342;
        VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
        VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
        VERTEX_ATTRIB_ARRAY_SIZE = 34339;
        VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
        VERTEX_ATTRIB_ARRAY_TYPE = 34341;
        VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
        VERTEX_ATTRIB_ARRAY_POINTER = 34373;
        BLEND = 3042;
        ONE = 1;
        ZERO = 0;
        SRC_ALPHA = 770;
        DST_ALPHA = 772;
        ONE_MINUS_SRC_ALPHA = 771;
        ONE_MINUS_DST_COLOR = 775;
        ONE_MINUS_SRC_COLOR = 769;
        DST_COLOR = 774;
        SRC_COLOR = 768;
        SAMPLE_ALPHA_TO_COVERAGE = 32926;
        SAMPLE_COVERAGE = 32928;
        KEEP = 7680;
        REPLACE = 7681;
        INCR = 7682;
        DECR = 7683;
        INVERT = 5386;
        INCR_WRAP = 34055;
        DECR_WRAP = 34056;
        NEVER = 512;
        ALWAYS = 519;
        EQUAL = 514;
        LESS = 513;
        LEQUAL = 515;
        GREATER = 516;
        GEQUAL = 518;
        NOTEQUAL = 517;
        FUNC_ADD = 32774;
        FUNC_MIN = 32775;
        FUNC_MAX = 32776;
        FUNC_REVERSE_SUBTRACT = 32779;
        FUNC_SUBTRACT = 32778;
        DITHER = 3024;
        CONSTANT_COLOR = 32769;
        CONSTANT_ALPHA = 32771;
        ONE_MINUS_CONSTANT_COLOR = 32770;
        ONE_MINUS_CONSTANT_ALPHA = 32772;
        SRC_ALPHA_SATURATE = 776;
        SCISSOR_TEST = 3089;
        STENCIL_TEST = 2960;
        DEPTH_TEST = 2929;
        DEPTH_WRITEMASK = 2930;
        ALPHA_TEST = 3008;
        COLOR_BUFFER_BIT = 16384;
        DEPTH_BUFFER_BIT = 256;
        STENCIL_BUFFER_BIT = 1024;
        FRAMEBUFFER = 36160;
        COLOR_ATTACHMENT0 = 36064;
        COLOR_ATTACHMENT1 = -1;
        COLOR_ATTACHMENT2 = -1;
        COLOR_ATTACHMENT3 = -1;
        RENDERBUFFER = 36161;
        DEPTH_ATTACHMENT = 36096;
        STENCIL_ATTACHMENT = 36128;
        READ_FRAMEBUFFER = -1;
        DRAW_FRAMEBUFFER = -1;
        DEPTH24_STENCIL8 = 35056;
        DEPTH_COMPONENT = 6402;
        DEPTH_COMPONENT16 = 33189;
        DEPTH_COMPONENT24 = 33190;
        DEPTH_COMPONENT32 = 33191;
        STENCIL_INDEX = 6401;
        STENCIL_INDEX1 = 36166;
        STENCIL_INDEX4 = 36167;
        STENCIL_INDEX8 = 36168;
        DEPTH_STENCIL = 34041;
        FRAMEBUFFER_COMPLETE = 36053;
        FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
        FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
        FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
        FRAMEBUFFER_INCOMPLETE_FORMATS = 36058;
        FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = -1;
        FRAMEBUFFER_INCOMPLETE_READ_BUFFER = -1;
        FRAMEBUFFER_UNSUPPORTED = 36061;
        FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
        FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
        FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
        FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
        RENDERBUFFER_WIDTH = 36162;
        RENDERBUFFER_HEIGHT = 36163;
        RENDERBUFFER_RED_SIZE = 36176;
        RENDERBUFFER_GREEN_SIZE = 36177;
        RENDERBUFFER_BLUE_SIZE = 36178;
        RENDERBUFFER_ALPHA_SIZE = 36179;
        RENDERBUFFER_DEPTH_SIZE = 36180;
        RENDERBUFFER_STENCIL_SIZE = 36181;
        RENDERBUFFER_INTERNAL_FORMAT = 36164;
        MULTISAMPLE = -1;
        POINT_SMOOTH = -1;
        LINE_SMOOTH = -1;
        POLYGON_SMOOTH = -1;
    }

    protected class Tessellator
    implements PGL.Tessellator {
        protected PGLUtessellator tess;
        protected PGL.TessellatorCallback callback;
        protected GLUCallback gluCallback;

        public Tessellator(PGL.TessellatorCallback tessellatorCallback) {
            this.callback = tessellatorCallback;
            this.tess = PGLU.gluNewTess();
            this.gluCallback = new GLUCallback();
            PGLU.gluTessCallback(this.tess, 100100, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100102, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100101, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100105, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100103, this.gluCallback);
        }

        @Override
        public void beginPolygon() {
            PGLU.gluTessBeginPolygon(this.tess, null);
        }

        @Override
        public void endPolygon() {
            PGLU.gluTessEndPolygon(this.tess);
        }

        @Override
        public void setWindingRule(int n) {
            PGLU.gluTessProperty(this.tess, 100140, n);
        }

        @Override
        public void beginContour() {
            PGLU.gluTessBeginContour(this.tess);
        }

        @Override
        public void endContour() {
            PGLU.gluTessEndContour(this.tess);
        }

        @Override
        public void addVertex(double[] dArray) {
            PGLU.gluTessVertex(this.tess, dArray, 0, dArray);
        }

        protected class GLUCallback
        extends PGLUtessellatorCallbackAdapter {
            protected GLUCallback() {
            }

            @Override
            public void begin(int n) {
                Tessellator.this.callback.begin(n);
            }

            @Override
            public void end() {
                Tessellator.this.callback.end();
            }

            @Override
            public void vertex(Object object) {
                Tessellator.this.callback.vertex(object);
            }

            @Override
            public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
                Tessellator.this.callback.combine(dArray, objectArray, fArray, objectArray2);
            }

            @Override
            public void error(int n) {
                Tessellator.this.callback.error(n);
            }
        }
    }

    protected class AndroidConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        public int redTarget;
        public int greenTarget;
        public int blueTarget;
        public int alphaTarget;
        public int depthTarget;
        public int stencilTarget;
        public int redBits;
        public int greenBits;
        public int blueBits;
        public int alphaBits;
        public int depthBits;
        public int stencilBits;
        public int[] tempValue = new int[1];
        public int numSamples;
        protected int[] attribsNoMSAA = new int[]{12352, 4, 12338, 0, 12344};

        public AndroidConfigChooser(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.redTarget = n;
            this.greenTarget = n2;
            this.blueTarget = n3;
            this.alphaTarget = n4;
            this.depthTarget = n5;
            this.stencilTarget = n6;
            this.numSamples = n7;
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            EGLConfig[] eGLConfigArray = null;
            if (1 < this.numSamples) {
                int[] nArray = new int[]{12352, 4, 12338, 1, 12337, this.numSamples, 12344};
                eGLConfigArray = this.chooseConfigWithAttribs(eGL10, eGLDisplay, nArray);
                if (eGLConfigArray == null) {
                    int[] nArray2 = new int[]{12352, 4, 12512, 1, 12513, this.numSamples, 12344};
                    eGLConfigArray = this.chooseConfigWithAttribs(eGL10, eGLDisplay, nArray2);
                    if (eGLConfigArray == null) {
                        eGLConfigArray = this.chooseConfigWithAttribs(eGL10, eGLDisplay, this.attribsNoMSAA);
                    } else {
                        usingMultisampling = true;
                        usingCoverageMultisampling = true;
                        multisampleCount = this.numSamples;
                    }
                } else {
                    usingMultisampling = true;
                    usingCoverageMultisampling = false;
                    multisampleCount = this.numSamples;
                }
            } else {
                eGLConfigArray = this.chooseConfigWithAttribs(eGL10, eGLDisplay, this.attribsNoMSAA);
            }
            if (eGLConfigArray == null) {
                throw new IllegalArgumentException("No EGL configs match configSpec");
            }
            return this.chooseBestConfig(eGL10, eGLDisplay, eGLConfigArray);
        }

        public EGLConfig chooseBestConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            EGLConfig eGLConfig = null;
            float f = Float.MAX_VALUE;
            for (EGLConfig eGLConfig2 : eGLConfigArray) {
                boolean bl;
                int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12352, 0);
                boolean bl2 = bl = (n & 4) != 0;
                if (!bl) continue;
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12325, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12326, 0);
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12324, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12323, 0);
                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12322, 0);
                int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12321, 0);
                float f2 = 0.2f * (float)PApplet.abs(n4 - this.redTarget) + 0.2f * (float)PApplet.abs(n5 - this.greenTarget) + 0.2f * (float)PApplet.abs(n6 - this.blueTarget) + 0.15f * (float)PApplet.abs(n7 - this.alphaTarget) + 0.15f * (float)PApplet.abs(n2 - this.depthTarget) + 0.1f * (float)PApplet.abs(n3 - this.stencilTarget);
                if (!(f2 < f)) continue;
                eGLConfig = eGLConfig2;
                f = f2;
                this.redBits = n4;
                this.greenBits = n5;
                this.blueBits = n6;
                this.alphaBits = n7;
                this.depthBits = n2;
                this.stencilBits = n3;
            }
            return eGLConfig;
        }

        protected String printConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
            int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
            int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
            int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
            int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
            int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
            int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12352, 0);
            int n8 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12333, 0);
            int n9 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12320, 0);
            int n10 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12422, 0);
            return String.format("EGLConfig rgba=%d%d%d%d depth=%d stencil=%d", n, n2, n3, n4, n5, n6) + " type=" + n7 + " native=" + n8 + " buffer size=" + n9 + " buffer surface=" + n10 + String.format(" caveat=0x%04x", this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12327, 0));
        }

        protected int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.tempValue)) {
                return this.tempValue[0];
            }
            return n2;
        }

        protected EGLConfig[] chooseConfigWithAttribs(EGL10 eGL10, EGLDisplay eGLDisplay, int[] nArray) {
            int[] nArray2 = new int[1];
            eGL10.eglChooseConfig(eGLDisplay, nArray, null, 0, nArray2);
            int n = nArray2[0];
            if (n <= 0) {
                return null;
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[n];
            eGL10.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, n, nArray2);
            return eGLConfigArray;
        }
    }

    protected class AndroidContextFactory
    implements GLSurfaceView.EGLContextFactory {
        protected AndroidContextFactory() {
        }

        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{12440, 2, 12344};
            EGLContext eGLContext = eGL10.eglCreateContext(eGLDisplay, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray);
            return eGLContext;
        }

        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            eGL10.eglDestroyContext(eGLDisplay, eGLContext);
        }
    }

    protected class AndroidRenderer
    implements GLSurfaceView.Renderer {
        public void onDrawFrame(GL10 gL10) {
            PGLES.this.gl = gL10;
            PGLES.this.glThread = Thread.currentThread();
            PGLES.this.pg.parent.handleDraw();
        }

        public void onSurfaceChanged(GL10 gL10, int n, int n2) {
            PGLES.this.gl = gL10;
            PGLES.this.pg.setSize(n, n2);
        }

        public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
            PGLES.this.gl = gL10;
            context = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
            PGLES.this.glContext = context.hashCode();
            if (!PGLES.this.hasFBOs()) {
                throw new RuntimeException("Framebuffer objects are not supported by this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.");
            }
            if (!PGLES.this.hasShaders()) {
                throw new RuntimeException("GLSL shaders are not supported by this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.");
            }
        }
    }
}

