/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.io.IOException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public abstract class PGL {
    protected PGraphicsOpenGL pg;
    protected Thread glThread;
    protected int glContext;
    public boolean primaryPGL;
    protected static boolean USE_FBOLAYER_BY_DEFAULT = false;
    protected static int REQUESTED_DEPTH_BITS = 24;
    protected static int REQUESTED_STENCIL_BITS = 8;
    protected static int REQUESTED_ALPHA_BITS = 8;
    protected static boolean USE_DIRECT_BUFFERS = true;
    protected static int MIN_DIRECT_BUFFER_SIZE = 1;
    protected static boolean SAVE_SURFACE_TO_PIXELS_HACK = true;
    protected static boolean MIPMAPS_ENABLED = true;
    protected static int DEFAULT_IN_VERTICES = 64;
    protected static int DEFAULT_IN_EDGES = 128;
    protected static int DEFAULT_IN_TEXTURES = 64;
    protected static int DEFAULT_TESS_VERTICES = 64;
    protected static int DEFAULT_TESS_INDICES = 128;
    protected static int MAX_LIGHTS = 8;
    protected static int MAX_VERTEX_INDEX = Short.MAX_VALUE;
    protected static int MAX_VERTEX_INDEX1;
    protected static int FLUSH_VERTEX_COUNT;
    protected static int MIN_FONT_TEX_SIZE;
    protected static int MAX_FONT_TEX_SIZE;
    protected static float MIN_CAPS_JOINS_WEIGHT;
    protected static int MAX_CAPS_JOINS_LENGTH;
    protected static int MIN_ARRAYCOPY_SIZE;
    protected static float STROKE_DISPLACEMENT;
    protected boolean fboLayerRequested = false;
    protected boolean fboLayerCreated = false;
    protected boolean fboLayerInUse = false;
    protected boolean firstFrame = true;
    protected int reqNumSamples;
    protected int numSamples;
    protected IntBuffer glColorFbo;
    protected IntBuffer glMultiFbo;
    protected IntBuffer glColorBuf;
    protected IntBuffer glColorTex;
    protected IntBuffer glDepthStencil;
    protected IntBuffer glDepth;
    protected IntBuffer glStencil;
    protected int fboWidth;
    protected int fboHeight;
    protected int backTex;
    protected int frontTex;
    protected boolean usingFrontTex = false;
    protected boolean needSepFrontTex = false;
    protected boolean loadedTex2DShader = false;
    protected int tex2DShaderProgram;
    protected int tex2DVertShader;
    protected int tex2DFragShader;
    protected int tex2DShaderContext;
    protected int tex2DVertLoc;
    protected int tex2DTCoordLoc;
    protected int tex2DSamplerLoc;
    protected int tex2DGeoVBO;
    protected boolean loadedTexRectShader = false;
    protected int texRectShaderProgram;
    protected int texRectVertShader;
    protected int texRectFragShader;
    protected int texRectShaderContext;
    protected int texRectVertLoc;
    protected int texRectTCoordLoc;
    protected int texRectSamplerLoc;
    protected int texRectGeoVBO;
    protected float[] texCoords = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    protected FloatBuffer texData;
    protected static final String SHADER_PREPROCESSOR_DIRECTIVE = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\n";
    protected static String[] texVertShaderSource;
    protected static String[] tex2DFragShaderSource;
    protected static String[] texRectFragShaderSource;
    protected boolean[] texturingTargets = new boolean[]{false, false};
    protected int maxTexUnits;
    protected int activeTexUnit = 0;
    protected int[][] boundTextures;
    protected float targetFps = 60.0f;
    protected float currentFps = 60.0f;
    protected boolean setFps = false;
    protected ByteBuffer byteBuffer;
    protected IntBuffer intBuffer;
    protected IntBuffer viewBuffer;
    protected IntBuffer colorBuffer;
    protected FloatBuffer depthBuffer;
    protected ByteBuffer stencilBuffer;
    protected static final String WIKI = " Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    protected static final String FRAMEBUFFER_ERROR = "Framebuffer error (%1$s), rendering will probably not work as expected Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    protected static final String MISSING_FBO_ERROR = "Framebuffer objects are not supported by this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    protected static final String MISSING_GLSL_ERROR = "GLSL shaders are not supported by this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    protected static final String MISSING_GLFUNC_ERROR = "GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    protected static final String UNSUPPORTED_GLPROF_ERROR = "Unsupported OpenGL profile.";
    protected static final String TEXUNIT_ERROR = "Number of texture units not supported by this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.";
    protected static final String NONPRIMARY_ERROR = "The renderer is trying to call a PGL function that can only be called on a primary PGL. This is most likely due to a bug in the renderer's code, please report it with an issue on Processing's github page https://github.com/processing/processing/issues?state=open if using any of the built-in OpenGL renderers. If you are using a contributed library, contact the library's developers.";
    protected static int SIZEOF_SHORT;
    protected static int SIZEOF_INT;
    protected static int SIZEOF_FLOAT;
    protected static int SIZEOF_BYTE;
    protected static int SIZEOF_INDEX;
    protected static int INDEX_TYPE;
    protected static float FLOAT_EPS;
    protected static boolean BIG_ENDIAN;
    protected static boolean SHAPE_TEXT_SUPPORTED;
    protected static int SEG_MOVETO;
    protected static int SEG_LINETO;
    protected static int SEG_QUADTO;
    protected static int SEG_CUBICTO;
    protected static int SEG_CLOSE;
    public static int FALSE;
    public static int TRUE;
    public static int INT;
    public static int BYTE;
    public static int SHORT;
    public static int FLOAT;
    public static int BOOL;
    public static int UNSIGNED_INT;
    public static int UNSIGNED_BYTE;
    public static int UNSIGNED_SHORT;
    public static int RGB;
    public static int RGBA;
    public static int ALPHA;
    public static int LUMINANCE;
    public static int LUMINANCE_ALPHA;
    public static int UNSIGNED_SHORT_5_6_5;
    public static int UNSIGNED_SHORT_4_4_4_4;
    public static int UNSIGNED_SHORT_5_5_5_1;
    public static int RGBA4;
    public static int RGB5_A1;
    public static int RGB565;
    public static int RGB8;
    public static int RGBA8;
    public static int ALPHA8;
    public static int READ_ONLY;
    public static int WRITE_ONLY;
    public static int READ_WRITE;
    public static int TESS_WINDING_NONZERO;
    public static int TESS_WINDING_ODD;
    public static int GENERATE_MIPMAP_HINT;
    public static int FASTEST;
    public static int NICEST;
    public static int DONT_CARE;
    public static int VENDOR;
    public static int RENDERER;
    public static int VERSION;
    public static int EXTENSIONS;
    public static int SHADING_LANGUAGE_VERSION;
    public static int MAX_SAMPLES;
    public static int SAMPLES;
    public static int ALIASED_LINE_WIDTH_RANGE;
    public static int ALIASED_POINT_SIZE_RANGE;
    public static int DEPTH_BITS;
    public static int STENCIL_BITS;
    public static int CCW;
    public static int CW;
    public static int VIEWPORT;
    public static int ARRAY_BUFFER;
    public static int ELEMENT_ARRAY_BUFFER;
    public static int MAX_VERTEX_ATTRIBS;
    public static int STATIC_DRAW;
    public static int DYNAMIC_DRAW;
    public static int STREAM_DRAW;
    public static int BUFFER_SIZE;
    public static int BUFFER_USAGE;
    public static int POINTS;
    public static int LINE_STRIP;
    public static int LINE_LOOP;
    public static int LINES;
    public static int TRIANGLE_FAN;
    public static int TRIANGLE_STRIP;
    public static int TRIANGLES;
    public static int CULL_FACE;
    public static int FRONT;
    public static int BACK;
    public static int FRONT_AND_BACK;
    public static int POLYGON_OFFSET_FILL;
    public static int UNPACK_ALIGNMENT;
    public static int PACK_ALIGNMENT;
    public static int TEXTURE_2D;
    public static int TEXTURE_RECTANGLE;
    public static int TEXTURE_BINDING_2D;
    public static int TEXTURE_BINDING_RECTANGLE;
    public static int MAX_TEXTURE_SIZE;
    public static int TEXTURE_MAX_ANISOTROPY;
    public static int MAX_TEXTURE_MAX_ANISOTROPY;
    public static int MAX_VERTEX_TEXTURE_IMAGE_UNITS;
    public static int MAX_TEXTURE_IMAGE_UNITS;
    public static int MAX_COMBINED_TEXTURE_IMAGE_UNITS;
    public static int NUM_COMPRESSED_TEXTURE_FORMATS;
    public static int COMPRESSED_TEXTURE_FORMATS;
    public static int NEAREST;
    public static int LINEAR;
    public static int LINEAR_MIPMAP_NEAREST;
    public static int LINEAR_MIPMAP_LINEAR;
    public static int CLAMP_TO_EDGE;
    public static int REPEAT;
    public static int TEXTURE0;
    public static int TEXTURE1;
    public static int TEXTURE2;
    public static int TEXTURE3;
    public static int TEXTURE_MIN_FILTER;
    public static int TEXTURE_MAG_FILTER;
    public static int TEXTURE_WRAP_S;
    public static int TEXTURE_WRAP_T;
    public static int TEXTURE_WRAP_R;
    public static int TEXTURE_CUBE_MAP;
    public static int TEXTURE_CUBE_MAP_POSITIVE_X;
    public static int TEXTURE_CUBE_MAP_POSITIVE_Y;
    public static int TEXTURE_CUBE_MAP_POSITIVE_Z;
    public static int TEXTURE_CUBE_MAP_NEGATIVE_X;
    public static int TEXTURE_CUBE_MAP_NEGATIVE_Y;
    public static int TEXTURE_CUBE_MAP_NEGATIVE_Z;
    public static int VERTEX_SHADER;
    public static int FRAGMENT_SHADER;
    public static int INFO_LOG_LENGTH;
    public static int SHADER_SOURCE_LENGTH;
    public static int COMPILE_STATUS;
    public static int LINK_STATUS;
    public static int VALIDATE_STATUS;
    public static int SHADER_TYPE;
    public static int DELETE_STATUS;
    public static int FLOAT_VEC2;
    public static int FLOAT_VEC3;
    public static int FLOAT_VEC4;
    public static int FLOAT_MAT2;
    public static int FLOAT_MAT3;
    public static int FLOAT_MAT4;
    public static int INT_VEC2;
    public static int INT_VEC3;
    public static int INT_VEC4;
    public static int BOOL_VEC2;
    public static int BOOL_VEC3;
    public static int BOOL_VEC4;
    public static int SAMPLER_2D;
    public static int SAMPLER_CUBE;
    public static int LOW_FLOAT;
    public static int MEDIUM_FLOAT;
    public static int HIGH_FLOAT;
    public static int LOW_INT;
    public static int MEDIUM_INT;
    public static int HIGH_INT;
    public static int CURRENT_VERTEX_ATTRIB;
    public static int VERTEX_ATTRIB_ARRAY_BUFFER_BINDING;
    public static int VERTEX_ATTRIB_ARRAY_ENABLED;
    public static int VERTEX_ATTRIB_ARRAY_SIZE;
    public static int VERTEX_ATTRIB_ARRAY_STRIDE;
    public static int VERTEX_ATTRIB_ARRAY_TYPE;
    public static int VERTEX_ATTRIB_ARRAY_NORMALIZED;
    public static int VERTEX_ATTRIB_ARRAY_POINTER;
    public static int BLEND;
    public static int ONE;
    public static int ZERO;
    public static int SRC_ALPHA;
    public static int DST_ALPHA;
    public static int ONE_MINUS_SRC_ALPHA;
    public static int ONE_MINUS_DST_COLOR;
    public static int ONE_MINUS_SRC_COLOR;
    public static int DST_COLOR;
    public static int SRC_COLOR;
    public static int SAMPLE_ALPHA_TO_COVERAGE;
    public static int SAMPLE_COVERAGE;
    public static int KEEP;
    public static int REPLACE;
    public static int INCR;
    public static int DECR;
    public static int INVERT;
    public static int INCR_WRAP;
    public static int DECR_WRAP;
    public static int NEVER;
    public static int ALWAYS;
    public static int EQUAL;
    public static int LESS;
    public static int LEQUAL;
    public static int GREATER;
    public static int GEQUAL;
    public static int NOTEQUAL;
    public static int FUNC_ADD;
    public static int FUNC_MIN;
    public static int FUNC_MAX;
    public static int FUNC_REVERSE_SUBTRACT;
    public static int FUNC_SUBTRACT;
    public static int DITHER;
    public static int CONSTANT_COLOR;
    public static int CONSTANT_ALPHA;
    public static int ONE_MINUS_CONSTANT_COLOR;
    public static int ONE_MINUS_CONSTANT_ALPHA;
    public static int SRC_ALPHA_SATURATE;
    public static int SCISSOR_TEST;
    public static int STENCIL_TEST;
    public static int DEPTH_TEST;
    public static int DEPTH_WRITEMASK;
    public static int ALPHA_TEST;
    public static int COLOR_BUFFER_BIT;
    public static int DEPTH_BUFFER_BIT;
    public static int STENCIL_BUFFER_BIT;
    public static int FRAMEBUFFER;
    public static int COLOR_ATTACHMENT0;
    public static int COLOR_ATTACHMENT1;
    public static int COLOR_ATTACHMENT2;
    public static int COLOR_ATTACHMENT3;
    public static int RENDERBUFFER;
    public static int DEPTH_ATTACHMENT;
    public static int STENCIL_ATTACHMENT;
    public static int READ_FRAMEBUFFER;
    public static int DRAW_FRAMEBUFFER;
    public static int DEPTH24_STENCIL8;
    public static int DEPTH_COMPONENT;
    public static int DEPTH_COMPONENT16;
    public static int DEPTH_COMPONENT24;
    public static int DEPTH_COMPONENT32;
    public static int STENCIL_INDEX;
    public static int STENCIL_INDEX1;
    public static int STENCIL_INDEX4;
    public static int STENCIL_INDEX8;
    public static int DEPTH_STENCIL;
    public static int FRAMEBUFFER_COMPLETE;
    public static int FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
    public static int FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
    public static int FRAMEBUFFER_INCOMPLETE_DIMENSIONS;
    public static int FRAMEBUFFER_INCOMPLETE_FORMATS;
    public static int FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER;
    public static int FRAMEBUFFER_INCOMPLETE_READ_BUFFER;
    public static int FRAMEBUFFER_UNSUPPORTED;
    public static int FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE;
    public static int FRAMEBUFFER_ATTACHMENT_OBJECT_NAME;
    public static int FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL;
    public static int FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE;
    public static int RENDERBUFFER_WIDTH;
    public static int RENDERBUFFER_HEIGHT;
    public static int RENDERBUFFER_RED_SIZE;
    public static int RENDERBUFFER_GREEN_SIZE;
    public static int RENDERBUFFER_BLUE_SIZE;
    public static int RENDERBUFFER_ALPHA_SIZE;
    public static int RENDERBUFFER_DEPTH_SIZE;
    public static int RENDERBUFFER_STENCIL_SIZE;
    public static int RENDERBUFFER_INTERNAL_FORMAT;
    public static int MULTISAMPLE;
    public static int POINT_SMOOTH;
    public static int LINE_SMOOTH;
    public static int POLYGON_SMOOTH;

    public PGL() {
    }

    public PGL(PGraphicsOpenGL pGraphicsOpenGL) {
        this.pg = pGraphicsOpenGL;
        if (this.glColorTex == null) {
            this.glColorTex = PGL.allocateIntBuffer(2);
            this.glColorFbo = PGL.allocateIntBuffer(1);
            this.glMultiFbo = PGL.allocateIntBuffer(1);
            this.glColorBuf = PGL.allocateIntBuffer(1);
            this.glDepthStencil = PGL.allocateIntBuffer(1);
            this.glDepth = PGL.allocateIntBuffer(1);
            this.glStencil = PGL.allocateIntBuffer(1);
            this.fboLayerCreated = false;
            this.fboLayerInUse = false;
            this.firstFrame = false;
        }
        this.byteBuffer = PGL.allocateByteBuffer(1);
        this.intBuffer = PGL.allocateIntBuffer(1);
        this.viewBuffer = PGL.allocateIntBuffer(4);
    }

    public void setPrimary(boolean bl) {
        this.primaryPGL = bl;
    }

    public abstract Object getCanvas();

    protected abstract void setFps(float var1);

    protected abstract void initSurface(int var1);

    protected abstract void reinitSurface();

    protected abstract void registerListeners();

    protected void deleteSurface() {
        if (this.threadIsCurrent() && this.fboLayerCreated) {
            this.deleteTextures(2, this.glColorTex);
            this.deleteFramebuffers(1, this.glColorFbo);
            this.deleteFramebuffers(1, this.glMultiFbo);
            this.deleteRenderbuffers(1, this.glColorBuf);
            this.deleteRenderbuffers(1, this.glDepthStencil);
            this.deleteRenderbuffers(1, this.glDepth);
            this.deleteRenderbuffers(1, this.glStencil);
        }
        this.fboLayerCreated = false;
        this.fboLayerInUse = false;
        this.firstFrame = false;
    }

    protected int getReadFramebuffer() {
        return this.fboLayerInUse ? this.glColorFbo.get(0) : 0;
    }

    protected int getDrawFramebuffer() {
        if (this.fboLayerInUse) {
            return 1 < this.numSamples ? this.glMultiFbo.get(0) : this.glColorFbo.get(0);
        }
        return 0;
    }

    protected int getDefaultDrawBuffer() {
        return this.fboLayerInUse ? COLOR_ATTACHMENT0 : FRONT;
    }

    protected int getDefaultReadBuffer() {
        return this.fboLayerInUse ? COLOR_ATTACHMENT0 : FRONT;
    }

    protected boolean isFBOBacked() {
        return this.fboLayerInUse;
    }

    protected void requestFBOLayer() {
        this.fboLayerRequested = true;
    }

    protected boolean isMultisampled() {
        return 1 < this.numSamples;
    }

    protected int getDepthBits() {
        this.intBuffer.rewind();
        this.getIntegerv(DEPTH_BITS, this.intBuffer);
        return this.intBuffer.get(0);
    }

    protected int getStencilBits() {
        this.intBuffer.rewind();
        this.getIntegerv(STENCIL_BITS, this.intBuffer);
        return this.intBuffer.get(0);
    }

    protected boolean getDepthTest() {
        this.intBuffer.rewind();
        this.getBooleanv(DEPTH_TEST, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean getDepthWriteMask() {
        this.intBuffer.rewind();
        this.getBooleanv(DEPTH_WRITEMASK, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected Texture wrapBackTexture(Texture texture) {
        if (texture == null) {
            texture = new Texture(this.pg);
            texture.init(this.pg.width, this.pg.height, this.glColorTex.get(this.backTex), TEXTURE_2D, RGBA, this.fboWidth, this.fboHeight, NEAREST, NEAREST, CLAMP_TO_EDGE, CLAMP_TO_EDGE);
            texture.invertedY(true);
            texture.colorBuffer(true);
            this.pg.setCache(this.pg, texture);
        } else {
            texture.glName = this.glColorTex.get(this.backTex);
        }
        return texture;
    }

    protected Texture wrapFrontTexture(Texture texture) {
        if (texture == null) {
            texture = new Texture(this.pg);
            texture.init(this.pg.width, this.pg.height, this.glColorTex.get(this.frontTex), TEXTURE_2D, RGBA, this.fboWidth, this.fboHeight, NEAREST, NEAREST, CLAMP_TO_EDGE, CLAMP_TO_EDGE);
            texture.invertedY(true);
            texture.colorBuffer(true);
        } else {
            texture.glName = this.glColorTex.get(this.frontTex);
        }
        return texture;
    }

    protected void bindFrontTexture() {
        this.usingFrontTex = true;
        if (!this.texturingIsEnabled(TEXTURE_2D)) {
            this.enableTexturing(TEXTURE_2D);
        }
        this.bindTexture(TEXTURE_2D, this.glColorTex.get(this.frontTex));
    }

    protected void unbindFrontTexture() {
        if (this.textureIsBound(TEXTURE_2D, this.glColorTex.get(this.frontTex))) {
            if (!this.texturingIsEnabled(TEXTURE_2D)) {
                this.enableTexturing(TEXTURE_2D);
                this.bindTexture(TEXTURE_2D, 0);
                this.disableTexturing(TEXTURE_2D);
            } else {
                this.bindTexture(TEXTURE_2D, 0);
            }
        }
    }

    protected void syncBackTexture() {
        if (this.usingFrontTex) {
            this.needSepFrontTex = true;
        }
        if (1 < this.numSamples) {
            this.bindFramebufferImpl(READ_FRAMEBUFFER, this.glMultiFbo.get(0));
            this.bindFramebufferImpl(DRAW_FRAMEBUFFER, this.glColorFbo.get(0));
            this.blitFramebuffer(0, 0, this.fboWidth, this.fboHeight, 0, 0, this.fboWidth, this.fboHeight, COLOR_BUFFER_BIT, NEAREST);
        }
    }

    protected void beginDraw(boolean bl) {
        if (this.needFBOLayer(bl)) {
            if (!this.fboLayerCreated) {
                this.createFBOLayer();
            }
            this.bindFramebufferImpl(FRAMEBUFFER, this.glColorFbo.get(0));
            this.framebufferTexture2D(FRAMEBUFFER, COLOR_ATTACHMENT0, TEXTURE_2D, this.glColorTex.get(this.backTex), 0);
            if (1 < this.numSamples) {
                this.bindFramebufferImpl(FRAMEBUFFER, this.glMultiFbo.get(0));
            }
            if (this.firstFrame) {
                int n = this.pg.backgroundColor;
                float f = (float)(n >> 24 & 0xFF) / 255.0f;
                float f2 = (float)(n >> 16 & 0xFF) / 255.0f;
                float f3 = (float)(n >> 8 & 0xFF) / 255.0f;
                float f4 = (float)(n & 0xFF) / 255.0f;
                this.clearColor(f2, f3, f4, f);
                this.clear(COLOR_BUFFER_BIT);
            } else if (!bl) {
                this.drawTexture(TEXTURE_2D, this.glColorTex.get(this.frontTex), this.fboWidth, this.fboHeight, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            }
            this.fboLayerInUse = true;
        } else {
            this.fboLayerInUse = false;
        }
        if (this.firstFrame) {
            this.firstFrame = false;
        }
        if (!USE_FBOLAYER_BY_DEFAULT) {
            this.fboLayerRequested = false;
        }
    }

    protected void endDraw(boolean bl) {
        if (this.fboLayerInUse) {
            this.syncBackTexture();
            this.bindFramebufferImpl(FRAMEBUFFER, 0);
            this.clearDepth(1.0f);
            this.clearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.clear(COLOR_BUFFER_BIT | DEPTH_BUFFER_BIT);
            this.disable(BLEND);
            this.drawTexture(TEXTURE_2D, this.glColorTex.get(this.backTex), this.fboWidth, this.fboHeight, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            int n = this.frontTex;
            this.frontTex = this.backTex;
            this.backTex = n;
        }
    }

    protected abstract void getGL(PGL var1);

    protected abstract boolean canDraw();

    protected abstract void requestFocus();

    protected abstract void requestDraw();

    protected abstract void swapBuffers();

    protected boolean threadIsCurrent() {
        return Thread.currentThread() == this.glThread;
    }

    protected void beginGL() {
    }

    protected void endGL() {
    }

    private boolean needFBOLayer(boolean bl) {
        return !bl || this.fboLayerRequested || 1 < this.numSamples;
    }

    private void createFBOLayer() {
        int n;
        String string = this.getString(EXTENSIONS);
        if (-1 < string.indexOf("texture_non_power_of_two")) {
            this.fboWidth = this.pg.width;
            this.fboHeight = this.pg.height;
        } else {
            this.fboWidth = PGL.nextPowerOfTwo(this.pg.width);
            this.fboHeight = PGL.nextPowerOfTwo(this.pg.height);
        }
        int n2 = this.maxSamples();
        this.numSamples = -1 < string.indexOf("_framebuffer_multisample") && 1 < n2 ? PApplet.min(this.reqNumSamples, n2) : 1;
        boolean bl = 1 < this.numSamples;
        boolean bl2 = string.indexOf("packed_depth_stencil") != -1;
        int n3 = PApplet.min(REQUESTED_DEPTH_BITS, this.getDepthBits());
        int n4 = PApplet.min(REQUESTED_STENCIL_BITS, this.getStencilBits());
        this.genTextures(2, this.glColorTex);
        for (n = 0; n < 2; ++n) {
            this.bindTexture(TEXTURE_2D, this.glColorTex.get(n));
            this.texParameteri(TEXTURE_2D, TEXTURE_MIN_FILTER, NEAREST);
            this.texParameteri(TEXTURE_2D, TEXTURE_MAG_FILTER, NEAREST);
            this.texParameteri(TEXTURE_2D, TEXTURE_WRAP_S, CLAMP_TO_EDGE);
            this.texParameteri(TEXTURE_2D, TEXTURE_WRAP_T, CLAMP_TO_EDGE);
            this.texImage2D(TEXTURE_2D, 0, RGBA, this.fboWidth, this.fboHeight, 0, RGBA, UNSIGNED_BYTE, null);
            this.initTexture(TEXTURE_2D, RGBA, this.fboWidth, this.fboHeight, this.pg.backgroundColor);
        }
        this.bindTexture(TEXTURE_2D, 0);
        this.backTex = 0;
        this.frontTex = 1;
        this.genFramebuffers(1, this.glColorFbo);
        this.bindFramebufferImpl(FRAMEBUFFER, this.glColorFbo.get(0));
        this.framebufferTexture2D(FRAMEBUFFER, COLOR_ATTACHMENT0, TEXTURE_2D, this.glColorTex.get(this.backTex), 0);
        if (bl) {
            this.genFramebuffers(1, this.glMultiFbo);
            this.bindFramebufferImpl(FRAMEBUFFER, this.glMultiFbo.get(0));
            this.genRenderbuffers(1, this.glColorBuf);
            this.bindRenderbuffer(RENDERBUFFER, this.glColorBuf.get(0));
            this.renderbufferStorageMultisample(RENDERBUFFER, this.numSamples, RGBA8, this.fboWidth, this.fboHeight);
            this.framebufferRenderbuffer(FRAMEBUFFER, COLOR_ATTACHMENT0, RENDERBUFFER, this.glColorBuf.get(0));
        }
        if (bl2 && n3 == 24 && n4 == 8) {
            this.genRenderbuffers(1, this.glDepthStencil);
            this.bindRenderbuffer(RENDERBUFFER, this.glDepthStencil.get(0));
            if (bl) {
                this.renderbufferStorageMultisample(RENDERBUFFER, this.numSamples, DEPTH24_STENCIL8, this.fboWidth, this.fboHeight);
            } else {
                this.renderbufferStorage(RENDERBUFFER, DEPTH24_STENCIL8, this.fboWidth, this.fboHeight);
            }
            this.framebufferRenderbuffer(FRAMEBUFFER, DEPTH_ATTACHMENT, RENDERBUFFER, this.glDepthStencil.get(0));
            this.framebufferRenderbuffer(FRAMEBUFFER, STENCIL_ATTACHMENT, RENDERBUFFER, this.glDepthStencil.get(0));
        } else {
            if (0 < n3) {
                n = DEPTH_COMPONENT16;
                if (n3 == 32) {
                    n = DEPTH_COMPONENT32;
                } else if (n3 == 24) {
                    n = DEPTH_COMPONENT24;
                } else if (n3 == 16) {
                    n = DEPTH_COMPONENT16;
                }
                this.genRenderbuffers(1, this.glDepth);
                this.bindRenderbuffer(RENDERBUFFER, this.glDepth.get(0));
                if (bl) {
                    this.renderbufferStorageMultisample(RENDERBUFFER, this.numSamples, n, this.fboWidth, this.fboHeight);
                } else {
                    this.renderbufferStorage(RENDERBUFFER, n, this.fboWidth, this.fboHeight);
                }
                this.framebufferRenderbuffer(FRAMEBUFFER, DEPTH_ATTACHMENT, RENDERBUFFER, this.glDepth.get(0));
            }
            if (0 < n4) {
                n = STENCIL_INDEX1;
                if (n4 == 8) {
                    n = STENCIL_INDEX8;
                } else if (n4 == 4) {
                    n = STENCIL_INDEX4;
                } else if (n4 == 1) {
                    n = STENCIL_INDEX1;
                }
                this.genRenderbuffers(1, this.glStencil);
                this.bindRenderbuffer(RENDERBUFFER, this.glStencil.get(0));
                if (bl) {
                    this.renderbufferStorageMultisample(RENDERBUFFER, this.numSamples, n, this.fboWidth, this.fboHeight);
                } else {
                    this.renderbufferStorage(RENDERBUFFER, n, this.fboWidth, this.fboHeight);
                }
                this.framebufferRenderbuffer(FRAMEBUFFER, STENCIL_ATTACHMENT, RENDERBUFFER, this.glStencil.get(0));
            }
        }
        this.validateFramebuffer();
        this.clearDepth(1.0f);
        this.clearStencil(0);
        n = this.pg.backgroundColor;
        float f = (float)(n >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(n >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(n >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(n & 0xFF) / 255.0f;
        this.clearColor(f2, f3, f4, f);
        this.clear(DEPTH_BUFFER_BIT | STENCIL_BUFFER_BIT | COLOR_BUFFER_BIT);
        this.bindFramebufferImpl(FRAMEBUFFER, 0);
        this.fboLayerCreated = true;
    }

    protected int createEmptyContext() {
        return -1;
    }

    protected int getCurrentContext() {
        return this.glContext;
    }

    protected boolean contextIsCurrent(int n) {
        return n == -1 || n == this.glContext;
    }

    protected void enableTexturing(int n) {
        if (n == TEXTURE_2D) {
            this.texturingTargets[0] = true;
        } else if (n == TEXTURE_RECTANGLE) {
            this.texturingTargets[1] = true;
        }
    }

    protected void disableTexturing(int n) {
        if (n == TEXTURE_2D) {
            this.texturingTargets[0] = false;
        } else if (n == TEXTURE_RECTANGLE) {
            this.texturingTargets[1] = false;
        }
    }

    protected boolean texturingIsEnabled(int n) {
        if (n == TEXTURE_2D) {
            return this.texturingTargets[0];
        }
        if (n == TEXTURE_RECTANGLE) {
            return this.texturingTargets[1];
        }
        return false;
    }

    protected boolean textureIsBound(int n, int n2) {
        if (this.boundTextures == null) {
            return false;
        }
        if (n == TEXTURE_2D) {
            return this.boundTextures[this.activeTexUnit][0] == n2;
        }
        if (n == TEXTURE_RECTANGLE) {
            return this.boundTextures[this.activeTexUnit][1] == n2;
        }
        return false;
    }

    protected void initTexture(int n, int n2, int n3, int n4) {
        this.initTexture(n, n2, n3, n4, 0);
    }

    protected void initTexture(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[256];
        Arrays.fill(nArray, PGL.javaToNativeARGB(n5));
        IntBuffer intBuffer = PGL.allocateDirectIntBuffer(256);
        intBuffer.put(nArray);
        intBuffer.rewind();
        for (int i = 0; i < n4; i += 16) {
            int n6 = PApplet.min(16, n4 - i);
            for (int j = 0; j < n3; j += 16) {
                int n7 = PApplet.min(16, n3 - j);
                this.texSubImage2D(n, 0, j, i, n7, n6, n2, UNSIGNED_BYTE, intBuffer);
            }
        }
    }

    protected void copyToTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, IntBuffer intBuffer) {
        this.activeTexture(TEXTURE0);
        boolean bl = false;
        if (!this.texturingIsEnabled(n)) {
            this.enableTexturing(n);
            bl = true;
        }
        this.bindTexture(n, n3);
        this.texSubImage2D(n, 0, n4, n5, n6, n7, n2, UNSIGNED_BYTE, intBuffer);
        this.bindTexture(n, 0);
        if (bl) {
            this.disableTexturing(n);
        }
    }

    public void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.drawTexture(n, n2, n3, n4, n3, n4, n5, n6, n7, n8, n5, n6, n7, n8);
    }

    public void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        if (n == TEXTURE_2D) {
            this.drawTexture2D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14);
        } else if (n == TEXTURE_RECTANGLE) {
            this.drawTextureRect(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14);
        }
    }

    protected PGL initTex2DShader() {
        PGL pGL;
        PGL pGL2 = pGL = this.primaryPGL ? this : this.pg.getPrimaryPGL();
        if (!pGL.loadedTex2DShader || pGL.tex2DShaderContext != pGL.glContext) {
            String string = PApplet.join(texVertShaderSource, "\n");
            String string2 = PApplet.join(tex2DFragShaderSource, "\n");
            pGL.tex2DVertShader = this.createShader(VERTEX_SHADER, string);
            pGL.tex2DFragShader = this.createShader(FRAGMENT_SHADER, string2);
            if (0 < pGL.tex2DVertShader && 0 < pGL.tex2DFragShader) {
                pGL.tex2DShaderProgram = this.createProgram(pGL.tex2DVertShader, pGL.tex2DFragShader);
            }
            if (0 < pGL.tex2DShaderProgram) {
                pGL.tex2DVertLoc = this.getAttribLocation(pGL.tex2DShaderProgram, "position");
                pGL.tex2DTCoordLoc = this.getAttribLocation(pGL.tex2DShaderProgram, "texCoord");
                pGL.tex2DSamplerLoc = this.getUniformLocation(pGL.tex2DShaderProgram, "texMap");
            }
            pGL.loadedTex2DShader = true;
            pGL.tex2DShaderContext = pGL.glContext;
            this.genBuffers(1, this.intBuffer);
            pGL.tex2DGeoVBO = this.intBuffer.get(0);
            this.bindBuffer(ARRAY_BUFFER, pGL.tex2DGeoVBO);
            this.bufferData(ARRAY_BUFFER, 16 * SIZEOF_FLOAT, null, STATIC_DRAW);
        }
        if (this.texData == null) {
            this.texData = PGL.allocateDirectFloatBuffer(this.texCoords.length);
        }
        return pGL;
    }

    protected void drawTexture2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        PGL pGL = this.initTex2DShader();
        if (0 < pGL.tex2DShaderProgram) {
            boolean bl = this.getDepthTest();
            this.disable(DEPTH_TEST);
            boolean bl2 = this.getDepthWriteMask();
            this.depthMask(false);
            this.viewBuffer.rewind();
            this.getIntegerv(VIEWPORT, this.viewBuffer);
            this.viewport(0, 0, n4, n5);
            this.useProgram(pGL.tex2DShaderProgram);
            this.enableVertexAttribArray(pGL.tex2DVertLoc);
            this.enableVertexAttribArray(pGL.tex2DTCoordLoc);
            this.texCoords[0] = 2.0f * (float)n10 / (float)n4 - 1.0f;
            this.texCoords[1] = 2.0f * (float)n11 / (float)n5 - 1.0f;
            this.texCoords[2] = (float)n6 / (float)n2;
            this.texCoords[3] = (float)n7 / (float)n3;
            this.texCoords[4] = 2.0f * (float)n12 / (float)n4 - 1.0f;
            this.texCoords[5] = 2.0f * (float)n11 / (float)n5 - 1.0f;
            this.texCoords[6] = (float)n8 / (float)n2;
            this.texCoords[7] = (float)n7 / (float)n3;
            this.texCoords[8] = 2.0f * (float)n10 / (float)n4 - 1.0f;
            this.texCoords[9] = 2.0f * (float)n13 / (float)n5 - 1.0f;
            this.texCoords[10] = (float)n6 / (float)n2;
            this.texCoords[11] = (float)n9 / (float)n3;
            this.texCoords[12] = 2.0f * (float)n12 / (float)n4 - 1.0f;
            this.texCoords[13] = 2.0f * (float)n13 / (float)n5 - 1.0f;
            this.texCoords[14] = (float)n8 / (float)n2;
            this.texCoords[15] = (float)n9 / (float)n3;
            this.texData.rewind();
            this.texData.put(this.texCoords);
            this.activeTexture(TEXTURE0);
            boolean bl3 = false;
            if (!this.texturingIsEnabled(TEXTURE_2D)) {
                this.enableTexturing(TEXTURE_2D);
                bl3 = true;
            }
            this.bindTexture(TEXTURE_2D, n);
            this.uniform1i(pGL.tex2DSamplerLoc, 0);
            this.texData.position(0);
            this.bindBuffer(ARRAY_BUFFER, pGL.tex2DGeoVBO);
            this.bufferData(ARRAY_BUFFER, 16 * SIZEOF_FLOAT, this.texData, STATIC_DRAW);
            this.vertexAttribPointer(pGL.tex2DVertLoc, 2, FLOAT, false, 4 * SIZEOF_FLOAT, 0);
            this.vertexAttribPointer(pGL.tex2DTCoordLoc, 2, FLOAT, false, 4 * SIZEOF_FLOAT, 2 * SIZEOF_FLOAT);
            this.drawArrays(TRIANGLE_STRIP, 0, 4);
            this.bindBuffer(ARRAY_BUFFER, 0);
            this.bindTexture(TEXTURE_2D, 0);
            if (bl3) {
                this.disableTexturing(TEXTURE_2D);
            }
            this.disableVertexAttribArray(pGL.tex2DVertLoc);
            this.disableVertexAttribArray(pGL.tex2DTCoordLoc);
            this.useProgram(0);
            if (bl) {
                this.enable(DEPTH_TEST);
            } else {
                this.disable(DEPTH_TEST);
            }
            this.depthMask(bl2);
            this.viewport(this.viewBuffer.get(0), this.viewBuffer.get(1), this.viewBuffer.get(2), this.viewBuffer.get(3));
        }
    }

    protected PGL initTexRectShader() {
        PGL pGL;
        PGL pGL2 = pGL = this.primaryPGL ? this : this.pg.getPrimaryPGL();
        if (!pGL.loadedTexRectShader || pGL.texRectShaderContext != pGL.glContext) {
            String string = PApplet.join(texVertShaderSource, "\n");
            String string2 = PApplet.join(texRectFragShaderSource, "\n");
            pGL.texRectVertShader = this.createShader(VERTEX_SHADER, string);
            pGL.texRectFragShader = this.createShader(FRAGMENT_SHADER, string2);
            if (0 < pGL.texRectVertShader && 0 < pGL.texRectFragShader) {
                pGL.texRectShaderProgram = this.createProgram(pGL.texRectVertShader, pGL.texRectFragShader);
            }
            if (0 < pGL.texRectShaderProgram) {
                pGL.texRectVertLoc = this.getAttribLocation(pGL.texRectShaderProgram, "position");
                pGL.texRectTCoordLoc = this.getAttribLocation(pGL.texRectShaderProgram, "texCoord");
                pGL.texRectSamplerLoc = this.getUniformLocation(pGL.texRectShaderProgram, "texMap");
            }
            pGL.loadedTexRectShader = true;
            pGL.texRectShaderContext = pGL.glContext;
            this.genBuffers(1, this.intBuffer);
            pGL.texRectGeoVBO = this.intBuffer.get(0);
            this.bindBuffer(ARRAY_BUFFER, pGL.texRectGeoVBO);
            this.bufferData(ARRAY_BUFFER, 16 * SIZEOF_FLOAT, null, STATIC_DRAW);
        }
        return pGL;
    }

    protected void drawTextureRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        PGL pGL = this.initTexRectShader();
        if (this.texData == null) {
            this.texData = PGL.allocateDirectFloatBuffer(this.texCoords.length);
        }
        if (0 < pGL.texRectShaderProgram) {
            boolean bl = this.getDepthTest();
            this.disable(DEPTH_TEST);
            boolean bl2 = this.getDepthWriteMask();
            this.depthMask(false);
            this.viewBuffer.rewind();
            this.getIntegerv(VIEWPORT, this.viewBuffer);
            this.viewport(0, 0, n4, n5);
            this.useProgram(pGL.texRectShaderProgram);
            this.enableVertexAttribArray(pGL.texRectVertLoc);
            this.enableVertexAttribArray(pGL.texRectTCoordLoc);
            this.texCoords[0] = 2.0f * (float)n10 / (float)n4 - 1.0f;
            this.texCoords[1] = 2.0f * (float)n11 / (float)n5 - 1.0f;
            this.texCoords[2] = n6;
            this.texCoords[3] = n7;
            this.texCoords[4] = 2.0f * (float)n12 / (float)n4 - 1.0f;
            this.texCoords[5] = 2.0f * (float)n11 / (float)n5 - 1.0f;
            this.texCoords[6] = n8;
            this.texCoords[7] = n7;
            this.texCoords[8] = 2.0f * (float)n10 / (float)n4 - 1.0f;
            this.texCoords[9] = 2.0f * (float)n13 / (float)n5 - 1.0f;
            this.texCoords[10] = n6;
            this.texCoords[11] = n9;
            this.texCoords[12] = 2.0f * (float)n12 / (float)n4 - 1.0f;
            this.texCoords[13] = 2.0f * (float)n13 / (float)n5 - 1.0f;
            this.texCoords[14] = n8;
            this.texCoords[15] = n9;
            this.texData.rewind();
            this.texData.put(this.texCoords);
            this.activeTexture(TEXTURE0);
            boolean bl3 = false;
            if (!this.texturingIsEnabled(TEXTURE_RECTANGLE)) {
                this.enableTexturing(TEXTURE_RECTANGLE);
                bl3 = true;
            }
            this.bindTexture(TEXTURE_RECTANGLE, n);
            this.uniform1i(pGL.texRectSamplerLoc, 0);
            this.texData.position(0);
            this.bindBuffer(ARRAY_BUFFER, pGL.texRectGeoVBO);
            this.bufferData(ARRAY_BUFFER, 16 * SIZEOF_FLOAT, this.texData, STATIC_DRAW);
            this.vertexAttribPointer(pGL.texRectVertLoc, 2, FLOAT, false, 4 * SIZEOF_FLOAT, 0);
            this.vertexAttribPointer(pGL.texRectTCoordLoc, 2, FLOAT, false, 4 * SIZEOF_FLOAT, 2 * SIZEOF_FLOAT);
            this.drawArrays(TRIANGLE_STRIP, 0, 4);
            this.bindBuffer(ARRAY_BUFFER, 0);
            this.bindTexture(TEXTURE_RECTANGLE, 0);
            if (bl3) {
                this.disableTexturing(TEXTURE_RECTANGLE);
            }
            this.disableVertexAttribArray(pGL.texRectVertLoc);
            this.disableVertexAttribArray(pGL.texRectTCoordLoc);
            this.useProgram(0);
            if (bl) {
                this.enable(DEPTH_TEST);
            } else {
                this.disable(DEPTH_TEST);
            }
            this.depthMask(bl2);
            this.viewport(this.viewBuffer.get(0), this.viewBuffer.get(1), this.viewBuffer.get(2), this.viewBuffer.get(3));
        }
    }

    protected int getColorValue(int n, int n2) {
        if (this.colorBuffer == null) {
            this.colorBuffer = IntBuffer.allocate(1);
        }
        this.colorBuffer.rewind();
        this.readPixels(n, this.pg.height - n2 - 1, 1, 1, RGBA, UNSIGNED_BYTE, this.colorBuffer);
        return this.colorBuffer.get();
    }

    protected float getDepthValue(int n, int n2) {
        if (this.depthBuffer == null) {
            this.depthBuffer = FloatBuffer.allocate(1);
        }
        this.depthBuffer.rewind();
        this.readPixels(n, this.pg.height - n2 - 1, 1, 1, DEPTH_COMPONENT, FLOAT, this.depthBuffer);
        return this.depthBuffer.get(0);
    }

    protected byte getStencilValue(int n, int n2) {
        if (this.stencilBuffer == null) {
            this.stencilBuffer = ByteBuffer.allocate(1);
        }
        this.readPixels(n, this.pg.height - n2 - 1, 1, 1, STENCIL_INDEX, UNSIGNED_BYTE, this.stencilBuffer);
        return this.stencilBuffer.get(0);
    }

    protected static int nextPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    protected static int nativeToJavaARGB(int n) {
        if (BIG_ENDIAN) {
            return n >>> 8 | n << 24 & 0xFF000000;
        }
        return (n & 0xFF) << 16 | (n & 0xFF0000) >> 16 | n & 0xFF00FF00;
    }

    protected static void nativeToJavaARGB(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = (n2 - 1) * n;
        for (n4 = 0; n4 < n2 / 2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                int n7 = nArray[n6];
                int n8 = nArray[n5];
                if (BIG_ENDIAN) {
                    nArray[n5] = n7 >>> 8 | n7 << 24 & 0xFF000000;
                    nArray[n6] = n8 >>> 8 | n8 << 24 & 0xFF000000;
                } else {
                    nArray[n5] = (n7 & 0xFF) << 16 | (n7 & 0xFF0000) >> 16 | n7 & 0xFF00FF00;
                    nArray[n6] = (n8 & 0xFF) << 16 | (n8 & 0xFF0000) >> 16 | n8 & 0xFF00FF00;
                }
                ++n5;
                ++n6;
            }
            n6 -= n * 2;
        }
        if (n2 % 2 == 1) {
            n5 = n2 / 2 * n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = nArray[n5];
                nArray[n5] = BIG_ENDIAN ? n3 >>> 8 | n3 << 24 & 0xFF000000 : (n3 & 0xFF) << 16 | (n3 & 0xFF0000) >> 16 | n3 & 0xFF00FF00;
                ++n5;
            }
        }
    }

    protected static int nativeToJavaRGB(int n) {
        if (BIG_ENDIAN) {
            return n >>> 8 | 0xFF000000;
        }
        return (n & 0xFF) << 16 | (n & 0xFF0000) >> 16 | n & 0xFF00FF00 | 0xFF000000;
    }

    protected static void nativeToJavaRGB(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = (n2 - 1) * n;
        for (n4 = 0; n4 < n2 / 2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                int n7 = nArray[n6];
                int n8 = nArray[n5];
                if (BIG_ENDIAN) {
                    nArray[n5] = n7 >>> 8 | 0xFF000000;
                    nArray[n6] = n8 >>> 8 | 0xFF000000;
                } else {
                    nArray[n5] = (n7 & 0xFF) << 16 | (n7 & 0xFF0000) >> 16 | n7 & 0xFF00FF00 | 0xFF000000;
                    nArray[n6] = (n8 & 0xFF) << 16 | (n8 & 0xFF0000) >> 16 | n8 & 0xFF00FF00 | 0xFF000000;
                }
                ++n5;
                ++n6;
            }
            n6 -= n * 2;
        }
        if (n2 % 2 == 1) {
            n5 = n2 / 2 * n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = nArray[n5];
                nArray[n5] = BIG_ENDIAN ? n3 >>> 8 | 0xFF000000 : (n3 & 0xFF) << 16 | (n3 & 0xFF0000) >> 16 | n3 & 0xFF00FF00 | 0xFF000000;
                ++n5;
            }
        }
    }

    protected static int javaToNativeARGB(int n) {
        if (BIG_ENDIAN) {
            return n >> 24 & 0xFF | n << 8 & 0xFFFFFF00;
        }
        return n & 0xFF000000 | n << 16 & 0xFF0000 | n & 0xFF00 | n >> 16 & 0xFF;
    }

    protected static void javaToNativeARGB(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = (n2 - 1) * n;
        for (n4 = 0; n4 < n2 / 2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                int n7 = nArray[n6];
                int n8 = nArray[n5];
                if (BIG_ENDIAN) {
                    nArray[n5] = n7 >> 24 & 0xFF | n7 << 8 & 0xFFFFFF00;
                    nArray[n6] = n8 >> 24 & 0xFF | n8 << 8 & 0xFFFFFF00;
                } else {
                    nArray[n5] = n7 & 0xFF000000 | n7 << 16 & 0xFF0000 | n7 & 0xFF00 | n7 >> 16 & 0xFF;
                    nArray[n6] = n8 & 0xFF000000 | n8 << 16 & 0xFF0000 | n8 & 0xFF00 | n8 >> 16 & 0xFF;
                }
                ++n5;
                ++n6;
            }
            n6 -= n * 2;
        }
        if (n2 % 2 == 1) {
            n5 = n2 / 2 * n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = nArray[n5];
                nArray[n5] = BIG_ENDIAN ? n3 >> 24 & 0xFF | n3 << 8 & 0xFFFFFF00 : n3 & 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                ++n5;
            }
        }
    }

    protected static int javaToNativeRGB(int n) {
        if (BIG_ENDIAN) {
            return 0xFF | n << 8 & 0xFFFFFF00;
        }
        return 0xFF000000 | n << 16 & 0xFF0000 | n & 0xFF00 | n >> 16 & 0xFF;
    }

    protected static void javaToNativeRGB(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = (n2 - 1) * n;
        for (n4 = 0; n4 < n2 / 2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                int n7 = nArray[n6];
                int n8 = nArray[n5];
                if (BIG_ENDIAN) {
                    nArray[n5] = 0xFF | n7 << 8 & 0xFFFFFF00;
                    nArray[n6] = 0xFF | n8 << 8 & 0xFFFFFF00;
                } else {
                    nArray[n5] = 0xFF000000 | n7 << 16 & 0xFF0000 | n7 & 0xFF00 | n7 >> 16 & 0xFF;
                    nArray[n6] = 0xFF000000 | n8 << 16 & 0xFF0000 | n8 & 0xFF00 | n8 >> 16 & 0xFF;
                }
                ++n5;
                ++n6;
            }
            n6 -= n * 2;
        }
        if (n2 % 2 == 1) {
            n5 = n2 / 2 * n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = nArray[n5];
                nArray[n5] = BIG_ENDIAN ? 0xFF | n3 << 8 & 0xFFFFFF00 : 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                ++n5;
            }
        }
    }

    protected static int qualityToSamples(int n) {
        if (n <= 1) {
            return 1;
        }
        int n2 = 2 * (n / 2);
        return n2;
    }

    protected String[] loadVertexShader(String string) {
        return this.pg.parent.loadStrings(string);
    }

    protected String[] loadFragmentShader(String string) {
        return this.pg.parent.loadStrings(string);
    }

    protected String[] loadFragmentShader(URL uRL) {
        try {
            return PApplet.loadStrings(uRL.openStream());
        }
        catch (IOException iOException) {
            PGraphics.showException("Cannot load fragment shader " + uRL.getFile());
            return null;
        }
    }

    protected String[] loadVertexShader(URL uRL) {
        try {
            return PApplet.loadStrings(uRL.openStream());
        }
        catch (IOException iOException) {
            PGraphics.showException("Cannot load vertex shader " + uRL.getFile());
            return null;
        }
    }

    protected String[] loadVertexShader(String string, int n) {
        return this.loadVertexShader(string);
    }

    protected String[] loadFragmentShader(String string, int n) {
        return this.loadFragmentShader(string);
    }

    protected String[] loadFragmentShader(URL uRL, int n) {
        return this.loadFragmentShader(uRL);
    }

    protected String[] loadVertexShader(URL uRL, int n) {
        return this.loadVertexShader(uRL);
    }

    protected static String[] convertFragmentSource(String[] stringArray, int n, int n2) {
        if (n == 120 && n2 == 150) {
            String[] stringArray2 = new String[stringArray.length + 2];
            stringArray2[0] = "#version 150";
            stringArray2[1] = "out vec4 fragColor;";
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                string = string.replace("varying", "in");
                string = string.replace("attribute", "in");
                string = string.replace("gl_FragColor", "fragColor");
                string = string.replace("texture", "texMap");
                string = string.replace("texMap2D(", "texture(");
                stringArray2[i + 2] = string = string.replace("texMap2DRect(", "texture(");
            }
            return stringArray2;
        }
        return stringArray;
    }

    protected static String[] convertVertexSource(String[] stringArray, int n, int n2) {
        if (n == 120 && n2 == 150) {
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = "#version 150";
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                string = string.replace("attribute", "in");
                stringArray2[i + 1] = string = string.replace("varying", "out");
            }
            return stringArray2;
        }
        return stringArray;
    }

    protected int createShader(int n, String string) {
        int n2 = this.createShader(n);
        if (n2 != 0) {
            this.shaderSource(n2, string);
            this.compileShader(n2);
            if (!this.compiled(n2)) {
                System.err.println("Could not compile shader " + n + ":");
                System.err.println(this.getShaderInfoLog(n2));
                this.deleteShader(n2);
                n2 = 0;
            }
        }
        return n2;
    }

    protected int createProgram(int n, int n2) {
        int n3 = this.createProgram();
        if (n3 != 0) {
            this.attachShader(n3, n);
            this.attachShader(n3, n2);
            this.linkProgram(n3);
            if (!this.linked(n3)) {
                System.err.println("Could not link program: ");
                System.err.println(this.getProgramInfoLog(n3));
                this.deleteProgram(n3);
                n3 = 0;
            }
        }
        return n3;
    }

    protected boolean compiled(int n) {
        this.intBuffer.rewind();
        this.getShaderiv(n, COMPILE_STATUS, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean linked(int n) {
        this.intBuffer.rewind();
        this.getProgramiv(n, LINK_STATUS, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean validateFramebuffer() {
        int n = this.checkFramebufferStatus(FRAMEBUFFER);
        if (n == FRAMEBUFFER_COMPLETE) {
            return true;
        }
        if (n == FRAMEBUFFER_INCOMPLETE_ATTACHMENT) {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "incomplete attachment"));
        } else if (n == FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT) {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "incomplete missing attachment"));
        } else if (n == FRAMEBUFFER_INCOMPLETE_DIMENSIONS) {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "incomplete dimensions"));
        } else if (n == FRAMEBUFFER_INCOMPLETE_FORMATS) {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "incomplete formats"));
        } else if (n == FRAMEBUFFER_UNSUPPORTED) {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "framebuffer unsupported"));
        } else {
            System.err.println(String.format(FRAMEBUFFER_ERROR, "unknown error"));
        }
        return false;
    }

    protected int[] getGLVersion() {
        String string = this.getString(VERSION).trim();
        int[] nArray = new int[]{0, 0, 0};
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            if (0 >= stringArray[i].indexOf(".")) continue;
            String[] stringArray2 = stringArray[i].split("\\.");
            try {
                nArray[0] = Integer.parseInt(stringArray2[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (1 < stringArray2.length) {
                try {
                    nArray[1] = Integer.parseInt(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (2 >= stringArray2.length) break;
            try {
                nArray[2] = Integer.parseInt(stringArray2[2]);
            }
            catch (NumberFormatException numberFormatException) {}
            break;
        }
        return nArray;
    }

    protected boolean hasFBOs() {
        int n = this.getGLVersion()[0];
        if (n < 2) {
            String string = this.getString(EXTENSIONS);
            return string.indexOf("_framebuffer_object") != -1 && string.indexOf("_vertex_shader") != -1 && string.indexOf("_shader_objects") != -1 && string.indexOf("_shading_language") != -1;
        }
        return true;
    }

    protected boolean hasShaders() {
        int n = this.getGLVersion()[0];
        if (n < 2) {
            String string = this.getString(EXTENSIONS);
            return string.indexOf("_fragment_shader") != -1 && string.indexOf("_vertex_shader") != -1 && string.indexOf("_shader_objects") != -1 && string.indexOf("_shading_language") != -1;
        }
        return true;
    }

    protected boolean hasNpotTexSupport() {
        int n = this.getGLVersion()[0];
        if (n < 3) {
            String string = this.getString(EXTENSIONS);
            return -1 < string.indexOf("_texture_non_power_of_two");
        }
        return true;
    }

    protected boolean hasAutoMipmapGenSupport() {
        int n = this.getGLVersion()[0];
        if (n < 3) {
            String string = this.getString(EXTENSIONS);
            return -1 < string.indexOf("_generate_mipmap");
        }
        return true;
    }

    protected boolean hasFboMultisampleSupport() {
        int n = this.getGLVersion()[0];
        if (n < 3) {
            String string = this.getString(EXTENSIONS);
            return -1 < string.indexOf("_framebuffer_multisample");
        }
        return true;
    }

    protected boolean hasPackedDepthStencilSupport() {
        int n = this.getGLVersion()[0];
        if (n < 3) {
            String string = this.getString(EXTENSIONS);
            return -1 < string.indexOf("_packed_depth_stencil");
        }
        return true;
    }

    protected boolean hasAnisoSamplingSupport() {
        int n = this.getGLVersion()[0];
        if (n < 3) {
            String string = this.getString(EXTENSIONS);
            return -1 < string.indexOf("_texture_filter_anisotropic");
        }
        return true;
    }

    protected int maxSamples() {
        this.intBuffer.rewind();
        this.getIntegerv(MAX_SAMPLES, this.intBuffer);
        return this.intBuffer.get(0);
    }

    protected int getMaxTexUnits() {
        this.intBuffer.rewind();
        this.getIntegerv(MAX_TEXTURE_IMAGE_UNITS, this.intBuffer);
        return this.intBuffer.get(0);
    }

    protected static ByteBuffer allocateDirectByteBuffer(int n) {
        int n2 = PApplet.max(MIN_DIRECT_BUFFER_SIZE, n) * SIZEOF_BYTE;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
    }

    protected static ByteBuffer allocateByteBuffer(int n) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectByteBuffer(n);
        }
        return ByteBuffer.allocate(n);
    }

    protected static ByteBuffer allocateByteBuffer(byte[] byArray) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectByteBuffer(byArray.length);
        }
        return ByteBuffer.wrap(byArray);
    }

    protected static ByteBuffer updateByteBuffer(ByteBuffer byteBuffer, byte[] byArray, boolean bl) {
        if (USE_DIRECT_BUFFERS) {
            if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
                byteBuffer = PGL.allocateDirectByteBuffer(byArray.length);
            }
            byteBuffer.position(0);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
        } else if (bl) {
            byteBuffer = ByteBuffer.wrap(byArray);
        } else {
            if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
                byteBuffer = ByteBuffer.allocate(byArray.length);
            }
            byteBuffer.position(0);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
        }
        return byteBuffer;
    }

    protected static void updateByteBuffer(ByteBuffer byteBuffer, byte[] byArray, int n, int n2) {
        if (USE_DIRECT_BUFFERS || byteBuffer.hasArray() && byteBuffer.array() != byArray) {
            byteBuffer.position(n);
            byteBuffer.put(byArray, n, n2);
            byteBuffer.rewind();
        }
    }

    protected static void getByteArray(ByteBuffer byteBuffer, byte[] byArray) {
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            byteBuffer.position(0);
            byteBuffer.get(byArray);
            byteBuffer.rewind();
        }
    }

    protected static void putByteArray(ByteBuffer byteBuffer, byte[] byArray) {
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            byteBuffer.position(0);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
        }
    }

    protected static void fillByteBuffer(ByteBuffer byteBuffer, int n, int n2, byte by) {
        int n3 = n2 - n;
        byte[] byArray = new byte[n3];
        Arrays.fill(byArray, 0, n3, by);
        byteBuffer.position(n);
        byteBuffer.put(byArray, 0, n3);
        byteBuffer.rewind();
    }

    protected static ShortBuffer allocateDirectShortBuffer(int n) {
        int n2 = PApplet.max(MIN_DIRECT_BUFFER_SIZE, n) * SIZEOF_SHORT;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder()).asShortBuffer();
    }

    protected static ShortBuffer allocateShortBuffer(int n) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectShortBuffer(n);
        }
        return ShortBuffer.allocate(n);
    }

    protected static ShortBuffer allocateShortBuffer(short[] sArray) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectShortBuffer(sArray.length);
        }
        return ShortBuffer.wrap(sArray);
    }

    protected static ShortBuffer updateShortBuffer(ShortBuffer shortBuffer, short[] sArray, boolean bl) {
        if (USE_DIRECT_BUFFERS) {
            if (shortBuffer == null || shortBuffer.capacity() < sArray.length) {
                shortBuffer = PGL.allocateDirectShortBuffer(sArray.length);
            }
            shortBuffer.position(0);
            shortBuffer.put(sArray);
            shortBuffer.rewind();
        } else if (bl) {
            shortBuffer = ShortBuffer.wrap(sArray);
        } else {
            if (shortBuffer == null || shortBuffer.capacity() < sArray.length) {
                shortBuffer = ShortBuffer.allocate(sArray.length);
            }
            shortBuffer.position(0);
            shortBuffer.put(sArray);
            shortBuffer.rewind();
        }
        return shortBuffer;
    }

    protected static void updateShortBuffer(ShortBuffer shortBuffer, short[] sArray, int n, int n2) {
        if (USE_DIRECT_BUFFERS || shortBuffer.hasArray() && shortBuffer.array() != sArray) {
            shortBuffer.position(n);
            shortBuffer.put(sArray, n, n2);
            shortBuffer.rewind();
        }
    }

    protected static void getShortArray(ShortBuffer shortBuffer, short[] sArray) {
        if (!shortBuffer.hasArray() || shortBuffer.array() != sArray) {
            shortBuffer.position(0);
            shortBuffer.get(sArray);
            shortBuffer.rewind();
        }
    }

    protected static void putShortArray(ShortBuffer shortBuffer, short[] sArray) {
        if (!shortBuffer.hasArray() || shortBuffer.array() != sArray) {
            shortBuffer.position(0);
            shortBuffer.put(sArray);
            shortBuffer.rewind();
        }
    }

    protected static void fillShortBuffer(ShortBuffer shortBuffer, int n, int n2, short s) {
        int n3 = n2 - n;
        short[] sArray = new short[n3];
        Arrays.fill(sArray, 0, n3, s);
        shortBuffer.position(n);
        shortBuffer.put(sArray, 0, n3);
        shortBuffer.rewind();
    }

    protected static IntBuffer allocateDirectIntBuffer(int n) {
        int n2 = PApplet.max(MIN_DIRECT_BUFFER_SIZE, n) * SIZEOF_INT;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    protected static IntBuffer allocateIntBuffer(int n) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectIntBuffer(n);
        }
        return IntBuffer.allocate(n);
    }

    protected static IntBuffer allocateIntBuffer(int[] nArray) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectIntBuffer(nArray.length);
        }
        return IntBuffer.wrap(nArray);
    }

    protected static IntBuffer updateIntBuffer(IntBuffer intBuffer, int[] nArray, boolean bl) {
        if (USE_DIRECT_BUFFERS) {
            if (intBuffer == null || intBuffer.capacity() < nArray.length) {
                intBuffer = PGL.allocateDirectIntBuffer(nArray.length);
            }
            intBuffer.position(0);
            intBuffer.put(nArray);
            intBuffer.rewind();
        } else if (bl) {
            intBuffer = IntBuffer.wrap(nArray);
        } else {
            if (intBuffer == null || intBuffer.capacity() < nArray.length) {
                intBuffer = IntBuffer.allocate(nArray.length);
            }
            intBuffer.position(0);
            intBuffer.put(nArray);
            intBuffer.rewind();
        }
        return intBuffer;
    }

    protected static void updateIntBuffer(IntBuffer intBuffer, int[] nArray, int n, int n2) {
        if (USE_DIRECT_BUFFERS || intBuffer.hasArray() && intBuffer.array() != nArray) {
            intBuffer.position(n);
            intBuffer.put(nArray, n, n2);
            intBuffer.rewind();
        }
    }

    protected static void getIntArray(IntBuffer intBuffer, int[] nArray) {
        if (!intBuffer.hasArray() || intBuffer.array() != nArray) {
            intBuffer.position(0);
            intBuffer.get(nArray);
            intBuffer.rewind();
        }
    }

    protected static void putIntArray(IntBuffer intBuffer, int[] nArray) {
        if (!intBuffer.hasArray() || intBuffer.array() != nArray) {
            intBuffer.position(0);
            intBuffer.put(nArray);
            intBuffer.rewind();
        }
    }

    protected static void fillIntBuffer(IntBuffer intBuffer, int n, int n2, int n3) {
        int n4 = n2 - n;
        int[] nArray = new int[n4];
        Arrays.fill(nArray, 0, n4, n3);
        intBuffer.position(n);
        intBuffer.put(nArray, 0, n4);
        intBuffer.rewind();
    }

    protected static FloatBuffer allocateDirectFloatBuffer(int n) {
        int n2 = PApplet.max(MIN_DIRECT_BUFFER_SIZE, n) * SIZEOF_FLOAT;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    protected static FloatBuffer allocateFloatBuffer(int n) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectFloatBuffer(n);
        }
        return FloatBuffer.allocate(n);
    }

    protected static FloatBuffer allocateFloatBuffer(float[] fArray) {
        if (USE_DIRECT_BUFFERS) {
            return PGL.allocateDirectFloatBuffer(fArray.length);
        }
        return FloatBuffer.wrap(fArray);
    }

    protected static FloatBuffer updateFloatBuffer(FloatBuffer floatBuffer, float[] fArray, boolean bl) {
        if (USE_DIRECT_BUFFERS) {
            if (floatBuffer == null || floatBuffer.capacity() < fArray.length) {
                floatBuffer = PGL.allocateDirectFloatBuffer(fArray.length);
            }
            floatBuffer.position(0);
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        } else if (bl) {
            floatBuffer = FloatBuffer.wrap(fArray);
        } else {
            if (floatBuffer == null || floatBuffer.capacity() < fArray.length) {
                floatBuffer = FloatBuffer.allocate(fArray.length);
            }
            floatBuffer.position(0);
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        }
        return floatBuffer;
    }

    protected static void updateFloatBuffer(FloatBuffer floatBuffer, float[] fArray, int n, int n2) {
        if (USE_DIRECT_BUFFERS || floatBuffer.hasArray() && floatBuffer.array() != fArray) {
            floatBuffer.position(n);
            floatBuffer.put(fArray, n, n2);
            floatBuffer.rewind();
        }
    }

    protected static void getFloatArray(FloatBuffer floatBuffer, float[] fArray) {
        if (!floatBuffer.hasArray() || floatBuffer.array() != fArray) {
            floatBuffer.position(0);
            floatBuffer.get(fArray);
            floatBuffer.rewind();
        }
    }

    protected static void putFloatArray(FloatBuffer floatBuffer, float[] fArray) {
        if (!floatBuffer.hasArray() || floatBuffer.array() != fArray) {
            floatBuffer.position(0);
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        }
    }

    protected static void fillFloatBuffer(FloatBuffer floatBuffer, int n, int n2, float f) {
        int n3 = n2 - n;
        float[] fArray = new float[n3];
        Arrays.fill(fArray, 0, n3, f);
        floatBuffer.position(n);
        floatBuffer.put(fArray, 0, n3);
        floatBuffer.rewind();
    }

    protected int getFontAscent(Object object) {
        return 0;
    }

    protected int getFontDescent(Object object) {
        return 0;
    }

    protected int getTextWidth(Object object, char[] cArray, int n, int n2) {
        return 0;
    }

    protected Object getDerivedFont(Object object, float f) {
        return null;
    }

    protected abstract Tessellator createTessellator(TessellatorCallback var1);

    protected String tessError(int n) {
        return "";
    }

    protected abstract FontOutline createFontOutline(char var1, Object var2);

    public abstract void flush();

    public abstract void finish();

    public abstract void hint(int var1, int var2);

    public abstract void enable(int var1);

    public abstract void disable(int var1);

    public abstract void getBooleanv(int var1, IntBuffer var2);

    public abstract void getIntegerv(int var1, IntBuffer var2);

    public abstract void getFloatv(int var1, FloatBuffer var2);

    public abstract boolean isEnabled(int var1);

    public abstract String getString(int var1);

    public abstract int getError();

    public abstract String errorString(int var1);

    public abstract void genBuffers(int var1, IntBuffer var2);

    public abstract void deleteBuffers(int var1, IntBuffer var2);

    public abstract void bindBuffer(int var1, int var2);

    public abstract void bufferData(int var1, int var2, Buffer var3, int var4);

    public abstract void bufferSubData(int var1, int var2, int var3, Buffer var4);

    public abstract void isBuffer(int var1);

    public abstract void getBufferParameteriv(int var1, int var2, IntBuffer var3);

    public abstract ByteBuffer mapBuffer(int var1, int var2);

    public abstract ByteBuffer mapBufferRange(int var1, int var2, int var3, int var4);

    public abstract void unmapBuffer(int var1);

    public abstract void depthRangef(float var1, float var2);

    public abstract void viewport(int var1, int var2, int var3, int var4);

    public void readPixels(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        boolean bl;
        boolean bl2 = bl = n5 != STENCIL_INDEX && n5 != DEPTH_COMPONENT && n5 != DEPTH_STENCIL;
        if (bl) {
            this.pg.beginReadPixels();
        }
        this.readPixelsImpl(n, n2, n3, n4, n5, n6, buffer);
        if (bl) {
            this.pg.endReadPixels();
        }
    }

    protected abstract void readPixelsImpl(int var1, int var2, int var3, int var4, int var5, int var6, Buffer var7);

    public abstract void vertexAttrib1f(int var1, float var2);

    public abstract void vertexAttrib2f(int var1, float var2, float var3);

    public abstract void vertexAttrib3f(int var1, float var2, float var3, float var4);

    public abstract void vertexAttrib4f(int var1, float var2, float var3, float var4, float var5);

    public abstract void vertexAttrib1fv(int var1, FloatBuffer var2);

    public abstract void vertexAttrib2fv(int var1, FloatBuffer var2);

    public abstract void vertexAttrib3fv(int var1, FloatBuffer var2);

    public abstract void vertexAttri4fv(int var1, FloatBuffer var2);

    public abstract void vertexAttribPointer(int var1, int var2, int var3, boolean var4, int var5, int var6);

    public abstract void vertexAttribPointer(int var1, int var2, int var3, boolean var4, int var5, Buffer var6);

    public abstract void enableVertexAttribArray(int var1);

    public abstract void disableVertexAttribArray(int var1);

    public abstract void drawArrays(int var1, int var2, int var3);

    public abstract void drawElements(int var1, int var2, int var3, int var4);

    public abstract void drawElements(int var1, int var2, int var3, Buffer var4);

    public abstract void lineWidth(float var1);

    public abstract void frontFace(int var1);

    public abstract void cullFace(int var1);

    public abstract void polygonOffset(float var1, float var2);

    public abstract void pixelStorei(int var1, int var2);

    public abstract void texImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public abstract void copyTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void texSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public abstract void copyTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void compressedTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, Buffer var8);

    public abstract void compressedTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public abstract void texParameteri(int var1, int var2, int var3);

    public abstract void texParameterf(int var1, int var2, float var3);

    public abstract void texParameteriv(int var1, int var2, IntBuffer var3);

    public abstract void texParameterfv(int var1, int var2, FloatBuffer var3);

    public abstract void generateMipmap(int var1);

    public abstract void genTextures(int var1, IntBuffer var2);

    public abstract void deleteTextures(int var1, IntBuffer var2);

    public abstract void getTexParameteriv(int var1, int var2, IntBuffer var3);

    public abstract void getTexParameterfv(int var1, int var2, FloatBuffer var3);

    public abstract boolean isTexture(int var1);

    public void activeTexture(int n) {
        this.activeTexUnit = n - TEXTURE0;
        this.activeTextureImpl(n);
    }

    protected abstract void activeTextureImpl(int var1);

    public void bindTexture(int n, int n2) {
        this.bindTextureImpl(n, n2);
        if (this.boundTextures == null) {
            this.maxTexUnits = this.getMaxTexUnits();
            this.boundTextures = new int[this.maxTexUnits][2];
        }
        if (this.maxTexUnits <= this.activeTexUnit) {
            throw new RuntimeException(TEXUNIT_ERROR);
        }
        if (n == TEXTURE_2D) {
            this.boundTextures[this.activeTexUnit][0] = n2;
        } else if (n == TEXTURE_RECTANGLE) {
            this.boundTextures[this.activeTexUnit][1] = n2;
        }
    }

    protected abstract void bindTextureImpl(int var1, int var2);

    public abstract int createShader(int var1);

    public abstract void shaderSource(int var1, String var2);

    public abstract void compileShader(int var1);

    public abstract void releaseShaderCompiler();

    public abstract void deleteShader(int var1);

    public abstract void shaderBinary(int var1, IntBuffer var2, int var3, Buffer var4, int var5);

    public abstract int createProgram();

    public abstract void attachShader(int var1, int var2);

    public abstract void detachShader(int var1, int var2);

    public abstract void linkProgram(int var1);

    public abstract void useProgram(int var1);

    public abstract void deleteProgram(int var1);

    public abstract String getActiveAttrib(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract int getAttribLocation(int var1, String var2);

    public abstract void bindAttribLocation(int var1, int var2, String var3);

    public abstract int getUniformLocation(int var1, String var2);

    public abstract String getActiveUniform(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract void uniform1i(int var1, int var2);

    public abstract void uniform2i(int var1, int var2, int var3);

    public abstract void uniform3i(int var1, int var2, int var3, int var4);

    public abstract void uniform4i(int var1, int var2, int var3, int var4, int var5);

    public abstract void uniform1f(int var1, float var2);

    public abstract void uniform2f(int var1, float var2, float var3);

    public abstract void uniform3f(int var1, float var2, float var3, float var4);

    public abstract void uniform4f(int var1, float var2, float var3, float var4, float var5);

    public abstract void uniform1iv(int var1, int var2, IntBuffer var3);

    public abstract void uniform2iv(int var1, int var2, IntBuffer var3);

    public abstract void uniform3iv(int var1, int var2, IntBuffer var3);

    public abstract void uniform4iv(int var1, int var2, IntBuffer var3);

    public abstract void uniform1fv(int var1, int var2, FloatBuffer var3);

    public abstract void uniform2fv(int var1, int var2, FloatBuffer var3);

    public abstract void uniform3fv(int var1, int var2, FloatBuffer var3);

    public abstract void uniform4fv(int var1, int var2, FloatBuffer var3);

    public abstract void uniformMatrix2fv(int var1, int var2, boolean var3, FloatBuffer var4);

    public abstract void uniformMatrix3fv(int var1, int var2, boolean var3, FloatBuffer var4);

    public abstract void uniformMatrix4fv(int var1, int var2, boolean var3, FloatBuffer var4);

    public abstract void validateProgram(int var1);

    public abstract boolean isShader(int var1);

    public abstract void getShaderiv(int var1, int var2, IntBuffer var3);

    public abstract void getAttachedShaders(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract String getShaderInfoLog(int var1);

    public abstract String getShaderSource(int var1);

    public abstract void getShaderPrecisionFormat(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract void getVertexAttribfv(int var1, int var2, FloatBuffer var3);

    public abstract void getVertexAttribiv(int var1, int var2, IntBuffer var3);

    public abstract void getVertexAttribPointerv(int var1, int var2, ByteBuffer var3);

    public abstract void getUniformfv(int var1, int var2, FloatBuffer var3);

    public abstract void getUniformiv(int var1, int var2, IntBuffer var3);

    public abstract boolean isProgram(int var1);

    public abstract void getProgramiv(int var1, int var2, IntBuffer var3);

    public abstract String getProgramInfoLog(int var1);

    public abstract void scissor(int var1, int var2, int var3, int var4);

    public abstract void sampleCoverage(float var1, boolean var2);

    public abstract void stencilFunc(int var1, int var2, int var3);

    public abstract void stencilFuncSeparate(int var1, int var2, int var3, int var4);

    public abstract void stencilOp(int var1, int var2, int var3);

    public abstract void stencilOpSeparate(int var1, int var2, int var3, int var4);

    public abstract void depthFunc(int var1);

    public abstract void blendEquation(int var1);

    public abstract void blendEquationSeparate(int var1, int var2);

    public abstract void blendFunc(int var1, int var2);

    public abstract void blendFuncSeparate(int var1, int var2, int var3, int var4);

    public abstract void blendColor(float var1, float var2, float var3, float var4);

    public abstract void alphaFunc(int var1, float var2);

    public abstract void colorMask(boolean var1, boolean var2, boolean var3, boolean var4);

    public abstract void depthMask(boolean var1);

    public abstract void stencilMask(int var1);

    public abstract void stencilMaskSeparate(int var1, int var2);

    public abstract void clear(int var1);

    public abstract void clearColor(float var1, float var2, float var3, float var4);

    public abstract void clearDepth(float var1);

    public abstract void clearStencil(int var1);

    public void bindFramebuffer(int n, int n2) {
        this.pg.beginBindFramebuffer(n, n2);
        this.bindFramebufferImpl(n, n2);
        this.pg.endBindFramebuffer(n, n2);
    }

    protected abstract void bindFramebufferImpl(int var1, int var2);

    public abstract void deleteFramebuffers(int var1, IntBuffer var2);

    public abstract void genFramebuffers(int var1, IntBuffer var2);

    public abstract void bindRenderbuffer(int var1, int var2);

    public abstract void deleteRenderbuffers(int var1, IntBuffer var2);

    public abstract void genRenderbuffers(int var1, IntBuffer var2);

    public abstract void renderbufferStorage(int var1, int var2, int var3, int var4);

    public abstract void framebufferRenderbuffer(int var1, int var2, int var3, int var4);

    public abstract void framebufferTexture2D(int var1, int var2, int var3, int var4, int var5);

    public abstract int checkFramebufferStatus(int var1);

    public abstract boolean isFramebuffer(int var1);

    public abstract void getFramebufferAttachmentParameteriv(int var1, int var2, int var3, IntBuffer var4);

    public abstract boolean isRenderbuffer(int var1);

    public abstract void getRenderbufferParameteriv(int var1, int var2, IntBuffer var3);

    public abstract void blitFramebuffer(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public abstract void renderbufferStorageMultisample(int var1, int var2, int var3, int var4, int var5);

    public abstract void readBuffer(int var1);

    public abstract void drawBuffer(int var1);

    static {
        FLUSH_VERTEX_COUNT = MAX_VERTEX_INDEX1 = MAX_VERTEX_INDEX + 1;
        MIN_FONT_TEX_SIZE = 256;
        MAX_FONT_TEX_SIZE = 1024;
        MIN_CAPS_JOINS_WEIGHT = 2.0f;
        MAX_CAPS_JOINS_LENGTH = 5000;
        MIN_ARRAYCOPY_SIZE = 2;
        STROKE_DISPLACEMENT = 0.999f;
        texVertShaderSource = new String[]{"attribute vec2 position;", "attribute vec2 texCoord;", "varying vec2 vertTexCoord;", "void main() {", "  gl_Position = vec4(position, 0, 1);", "  vertTexCoord = texCoord;", "}"};
        tex2DFragShaderSource = new String[]{SHADER_PREPROCESSOR_DIRECTIVE, "uniform sampler2D texMap;", "varying vec2 vertTexCoord;", "void main() {", "  gl_FragColor = texture2D(texMap, vertTexCoord.st);", "}"};
        texRectFragShaderSource = new String[]{SHADER_PREPROCESSOR_DIRECTIVE, "uniform sampler2DRect texMap;", "varying vec2 vertTexCoord;", "void main() {", "  gl_FragColor = texture2DRect(texMap, vertTexCoord.st);", "}"};
        SIZEOF_SHORT = 2;
        SIZEOF_INT = 4;
        SIZEOF_FLOAT = 4;
        SIZEOF_BYTE = 1;
        SIZEOF_INDEX = SIZEOF_SHORT;
        INDEX_TYPE = 5123;
        FLOAT_EPS = Float.MIN_VALUE;
        float f = 1.0f;
        while ((double)((float)(1.0 + (double)(f /= 2.0f) / 2.0)) != 1.0) {
        }
        FLOAT_EPS = f;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }

    protected static interface FontOutline {
        public boolean isDone();

        public int currentSegment(float[] var1);

        public void next();
    }

    protected static interface TessellatorCallback {
        public void begin(int var1);

        public void end();

        public void vertex(Object var1);

        public void combine(double[] var1, Object[] var2, float[] var3, Object[] var4);

        public void error(int var1);
    }

    protected static interface Tessellator {
        public void beginPolygon();

        public void endPolygon();

        public void setWindingRule(int var1);

        public void beginContour();

        public void endContour();

        public void addVertex(double[] var1);
    }
}

