/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import processing.core.PMatrix2D;
import processing.opengl.LinePath;

public class LineStroker {
    private LineStroker output;
    private int capStyle;
    private int joinStyle;
    private int m00;
    private int m01;
    private int m10;
    private int m11;
    private int lineWidth2;
    private long scaledLineWidth2;
    private int numPenSegments;
    private int[] pen_dx;
    private int[] pen_dy;
    private boolean[] penIncluded;
    private int[] join;
    private int[] offset = new int[2];
    private int[] reverse = new int[100];
    private int[] miter = new int[2];
    private long miterLimitSq;
    private int prev;
    private int rindex;
    private boolean started;
    private boolean lineToOrigin;
    private boolean joinToOrigin;
    private int sx0;
    private int sy0;
    private int sx1;
    private int sy1;
    private int x0;
    private int y0;
    private int scolor0;
    private int pcolor0;
    private int color0;
    private int mx0;
    private int my0;
    private int omx;
    private int omy;
    private int px0;
    private int py0;
    private double m00_2_m01_2;
    private double m10_2_m11_2;
    private double m00_m10_m01_m11;
    private static final long ROUND_JOIN_THRESHOLD = 100000000L;
    private static final long ROUND_JOIN_INTERNAL_THRESHOLD = 1000000000L;
    boolean joinSegment = false;

    public LineStroker() {
    }

    public LineStroker(LineStroker lineStroker, int n, int n2, int n3, int n4, PMatrix2D pMatrix2D) {
        this.setOutput(lineStroker);
        this.setParameters(n, n2, n3, n4, pMatrix2D);
    }

    public void setOutput(LineStroker lineStroker) {
        this.output = lineStroker;
    }

    public void setParameters(int n, int n2, int n3, int n4, PMatrix2D pMatrix2D) {
        this.m00 = LinePath.FloatToS15_16(pMatrix2D.m00);
        this.m01 = LinePath.FloatToS15_16(pMatrix2D.m01);
        this.m10 = LinePath.FloatToS15_16(pMatrix2D.m10);
        this.m11 = LinePath.FloatToS15_16(pMatrix2D.m11);
        this.lineWidth2 = n >> 1;
        this.scaledLineWidth2 = (long)this.m00 * (long)this.lineWidth2 >> 16;
        this.capStyle = n2;
        this.joinStyle = n3;
        this.m00_2_m01_2 = (double)this.m00 * (double)this.m00 + (double)this.m01 * (double)this.m01;
        this.m10_2_m11_2 = (double)this.m10 * (double)this.m10 + (double)this.m11 * (double)this.m11;
        this.m00_m10_m01_m11 = (double)this.m00 * (double)this.m10 + (double)this.m01 * (double)this.m11;
        double d = (double)this.m00 / 65536.0;
        double d2 = (double)this.m01 / 65536.0;
        double d3 = (double)this.m10 / 65536.0;
        double d4 = (double)this.m11 / 65536.0;
        double d5 = d * d4 - d2 * d3;
        if (n3 == 0) {
            double d6 = (double)n4 / 65536.0 * ((double)this.lineWidth2 / 65536.0) * d5;
            double d7 = d6 * d6;
            this.miterLimitSq = (long)(d7 * 65536.0 * 65536.0);
        }
        this.numPenSegments = (int)(3.14159f * (float)n / 65536.0f);
        if (this.pen_dx == null || this.pen_dx.length < this.numPenSegments) {
            this.pen_dx = new int[this.numPenSegments];
            this.pen_dy = new int[this.numPenSegments];
            this.penIncluded = new boolean[this.numPenSegments];
            this.join = new int[2 * this.numPenSegments];
        }
        for (int i = 0; i < this.numPenSegments; ++i) {
            double d8 = (double)n / 2.0;
            double d9 = (double)(i * 2) * Math.PI / (double)this.numPenSegments;
            double d10 = Math.cos(d9);
            double d11 = Math.sin(d9);
            this.pen_dx[i] = (int)(d8 * (d * d10 + d2 * d11));
            this.pen_dy[i] = (int)(d8 * (d3 * d10 + d4 * d11));
        }
        this.prev = 2;
        this.rindex = 0;
        this.started = false;
        this.lineToOrigin = false;
    }

    private void computeOffset(int n, int n2, int n3, int n4, int[] nArray) {
        int n5;
        int n6;
        long l = (long)n3 - (long)n;
        long l2 = (long)n4 - (long)n2;
        if (this.m00 > 0 && this.m00 == this.m11 && this.m01 == 0 & this.m10 == 0) {
            long l3 = LinePath.hypot(l, l2);
            if (l3 == 0L) {
                n6 = 0;
                n5 = 0;
            } else {
                n5 = (int)(l2 * this.scaledLineWidth2 / l3);
                n6 = (int)(-(l * this.scaledLineWidth2) / l3);
            }
        } else {
            double d = n3 - n;
            double d2 = n4 - n2;
            double d3 = (double)this.m00 * (double)this.m11 - (double)this.m01 * (double)this.m10;
            int n7 = d3 > 0.0 ? 1 : -1;
            double d4 = d2 * (double)this.m00 - d * (double)this.m10;
            double d5 = d2 * (double)this.m01 - d * (double)this.m11;
            double d6 = LinePath.hypot(d4, d5);
            double d7 = (double)(n7 * this.lineWidth2) / (65536.0 * d6);
            double d8 = d2 * this.m00_2_m01_2 - d * this.m00_m10_m01_m11;
            double d9 = d2 * this.m00_m10_m01_m11 - d * this.m10_2_m11_2;
            n5 = (int)(d8 * d7);
            n6 = (int)(d9 * d7);
        }
        nArray[0] = n5;
        nArray[1] = n6;
    }

    private void ensureCapacity(int n) {
        if (this.reverse.length < n) {
            int[] nArray = new int[Math.max(n, 6 * this.reverse.length / 5)];
            System.arraycopy(this.reverse, 0, nArray, 0, this.rindex);
            this.reverse = nArray;
        }
    }

    private boolean isCCW(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 - n;
        int n8 = n6 - n4;
        int n9 = n4 - n2;
        int n10 = n5 - n3;
        return (long)n7 * (long)n8 < (long)n9 * (long)n10;
    }

    private boolean side(int n, int n2, int n3, int n4, int n5, int n6) {
        long l = n4;
        long l2 = n6;
        long l3 = n;
        long l4 = n5;
        long l5 = n3;
        long l6 = n2;
        return (l - l2) * l3 + (l4 - l5) * l6 + (l5 * l2 - l4 * l) > 0L;
    }

    private int computeRoundJoin(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, int[] nArray) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = 0;
        int n13 = n7 == 0 ? this.side(n, n2, n3, n4, n5, n6) : (n7 == 1 ? 1 : 0);
        for (n11 = 0; n11 < this.numPenSegments; ++n11) {
            n10 = n + this.pen_dx[n11];
            n9 = n2 + this.pen_dy[n11];
            n8 = this.side(n10, n9, n3, n4, n5, n6) ? 1 : 0;
            this.penIncluded[n11] = n8 != n13;
        }
        n11 = -1;
        n8 = -1;
        for (int i = 0; i < this.numPenSegments; ++i) {
            if (this.penIncluded[i] && !this.penIncluded[(i + this.numPenSegments - 1) % this.numPenSegments]) {
                n11 = i;
            }
            if (!this.penIncluded[i] || this.penIncluded[(i + 1) % this.numPenSegments]) continue;
            n8 = i;
        }
        if (n8 < n11) {
            n8 += this.numPenSegments;
        }
        if (n11 != -1 && n8 != -1) {
            long l = n + this.pen_dx[n11] - n3;
            long l2 = n2 + this.pen_dy[n11] - n4;
            long l3 = n + this.pen_dx[n11] - n5;
            long l4 = n2 + this.pen_dy[n11] - n6;
            boolean bl2 = l * l + l2 * l2 > l3 * l3 + l4 * l4;
            int n14 = bl2 ? n8 : n11;
            int n15 = bl2 ? -1 : 1;
            while (true) {
                int n16 = n14 % this.numPenSegments;
                n10 = n + this.pen_dx[n16];
                n9 = n2 + this.pen_dy[n16];
                nArray[n12++] = n10;
                nArray[n12++] = n9;
                if (n14 == (bl2 ? n11 : n8)) break;
                n14 += n15;
            }
        }
        return n12 / 2;
    }

    private void drawRoundJoin(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, long l) {
        if (n3 == 0 && n4 == 0 || n5 == 0 && n6 == 0) {
            return;
        }
        long l2 = (long)n3 - (long)n5;
        long l3 = (long)n4 - (long)n6;
        long l4 = l2 * l2 + l3 * l3;
        if (l4 < l) {
            return;
        }
        if (bl2) {
            n3 = -n3;
            n4 = -n4;
            n5 = -n5;
            n6 = -n6;
        }
        int n9 = n + n3;
        int n10 = n2 + n4;
        int n11 = n + n5;
        int n12 = n2 + n6;
        int n13 = this.computeRoundJoin(n, n2, n9, n10, n11, n12, n7, bl, this.join);
        for (int i = 0; i < n13; ++i) {
            this.emitLineTo(this.join[2 * i], this.join[2 * i + 1], n8, bl2);
        }
    }

    private void computeMiter(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        long l = n3;
        long l2 = n;
        long l3 = l - l2;
        long l4 = n8;
        long l5 = n6;
        long l6 = l4 - l5;
        long l7 = n7;
        long l8 = n5;
        long l9 = l7 - l8;
        long l10 = n4;
        long l11 = n2;
        long l12 = l10 - l11;
        long l13 = l3 * l6 - l9 * l12 >> 16;
        if (l13 == 0L) {
            nArray[0] = n;
            nArray[1] = n2;
            return;
        }
        long l14 = l7 * (l11 - l5) - l2 * l6 + l8 * (l4 - l11) >> 16;
        nArray[0] = (int)(l2 + l14 * l3 / l13);
        nArray[1] = (int)(l11 + l14 * l12 / l13);
    }

    private void drawMiter(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl) {
        if (n9 == n7 && n10 == n8) {
            return;
        }
        if (n == n3 && n2 == n4) {
            return;
        }
        if (n3 == n5 && n4 == n6) {
            return;
        }
        if (bl) {
            n7 = -n7;
            n8 = -n8;
            n9 = -n9;
            n10 = -n10;
        }
        this.computeMiter(n + n7, n2 + n8, n3 + n7, n4 + n8, n3 + n9, n4 + n10, n5 + n9, n6 + n10, this.miter);
        long l = (long)this.miter[0] - (long)n3;
        long l2 = (long)this.miter[1] - (long)n4;
        long l3 = l2 * (long)this.m00 - l * (long)this.m10 >> 16;
        long l4 = l2 * (long)this.m01 - l * (long)this.m11 >> 16;
        long l5 = l3 * l3 + l4 * l4;
        if (l5 < this.miterLimitSq) {
            this.emitLineTo(this.miter[0], this.miter[1], n11, bl);
        }
    }

    public void moveTo(int n, int n2, int n3) {
        if (this.lineToOrigin) {
            this.lineToImpl(this.sx0, this.sy0, this.scolor0, this.joinToOrigin);
            this.lineToOrigin = false;
        }
        if (this.prev == 1) {
            this.finish();
        }
        this.sx0 = this.x0 = n;
        this.sy0 = this.y0 = n2;
        this.scolor0 = this.color0 = n3;
        this.rindex = 0;
        this.started = false;
        this.joinSegment = false;
        this.prev = 0;
    }

    public void lineJoin() {
        this.joinSegment = true;
    }

    public void lineTo(int n, int n2, int n3) {
        if (this.lineToOrigin) {
            if (n == this.sx0 && n2 == this.sy0) {
                return;
            }
            this.lineToImpl(this.sx0, this.sy0, this.scolor0, this.joinToOrigin);
            this.lineToOrigin = false;
        } else {
            if (n == this.x0 && n2 == this.y0) {
                return;
            }
            if (n == this.sx0 && n2 == this.sy0) {
                this.lineToOrigin = true;
                this.joinToOrigin = this.joinSegment;
                this.joinSegment = false;
                return;
            }
        }
        this.lineToImpl(n, n2, n3, this.joinSegment);
        this.joinSegment = false;
    }

    private void lineToImpl(int n, int n2, int n3, boolean bl) {
        this.computeOffset(this.x0, this.y0, n, n2, this.offset);
        int n4 = this.offset[0];
        int n5 = this.offset[1];
        if (!this.started) {
            this.emitMoveTo(this.x0 + n4, this.y0 + n5, this.color0);
            this.sx1 = n;
            this.sy1 = n2;
            this.mx0 = n4;
            this.my0 = n5;
            this.started = true;
        } else {
            boolean bl2 = this.isCCW(this.px0, this.py0, this.x0, this.y0, n, n2);
            if (bl) {
                if (this.joinStyle == 0) {
                    this.drawMiter(this.px0, this.py0, this.x0, this.y0, n, n2, this.omx, this.omy, n4, n5, this.color0, bl2);
                } else if (this.joinStyle == 1) {
                    this.drawRoundJoin(this.x0, this.y0, this.omx, this.omy, n4, n5, 0, this.color0, false, bl2, 100000000L);
                }
            } else {
                this.drawRoundJoin(this.x0, this.y0, this.omx, this.omy, n4, n5, 0, this.color0, false, bl2, 1000000000L);
            }
            this.emitLineTo(this.x0, this.y0, this.color0, !bl2);
        }
        this.emitLineTo(this.x0 + n4, this.y0 + n5, this.color0, false);
        this.emitLineTo(n + n4, n2 + n5, n3, false);
        this.emitLineTo(this.x0 - n4, this.y0 - n5, this.color0, true);
        this.emitLineTo(n - n4, n2 - n5, n3, true);
        this.omx = n4;
        this.omy = n5;
        this.px0 = this.x0;
        this.py0 = this.y0;
        this.pcolor0 = this.color0;
        this.x0 = n;
        this.y0 = n2;
        this.color0 = n3;
        this.prev = 1;
    }

    public void close() {
        if (this.lineToOrigin) {
            this.lineToOrigin = false;
        }
        if (!this.started) {
            this.finish();
            return;
        }
        this.computeOffset(this.x0, this.y0, this.sx0, this.sy0, this.offset);
        int n = this.offset[0];
        int n2 = this.offset[1];
        boolean bl = this.isCCW(this.px0, this.py0, this.x0, this.y0, this.sx0, this.sy0);
        if (this.joinSegment) {
            if (this.joinStyle == 0) {
                this.drawMiter(this.px0, this.py0, this.x0, this.y0, this.sx0, this.sy0, this.omx, this.omy, n, n2, this.pcolor0, bl);
            } else if (this.joinStyle == 1) {
                this.drawRoundJoin(this.x0, this.y0, this.omx, this.omy, n, n2, 0, this.color0, false, bl, 100000000L);
            }
        } else {
            this.drawRoundJoin(this.x0, this.y0, this.omx, this.omy, n, n2, 0, this.color0, false, bl, 1000000000L);
        }
        this.emitLineTo(this.x0 + n, this.y0 + n2, this.color0);
        this.emitLineTo(this.sx0 + n, this.sy0 + n2, this.scolor0);
        bl = this.isCCW(this.x0, this.y0, this.sx0, this.sy0, this.sx1, this.sy1);
        if (!bl) {
            if (this.joinStyle == 0) {
                this.drawMiter(this.x0, this.y0, this.sx0, this.sy0, this.sx1, this.sy1, n, n2, this.mx0, this.my0, this.color0, false);
            } else if (this.joinStyle == 1) {
                this.drawRoundJoin(this.sx0, this.sy0, n, n2, this.mx0, this.my0, 0, this.scolor0, false, false, 100000000L);
            }
        }
        this.emitLineTo(this.sx0 + this.mx0, this.sy0 + this.my0, this.scolor0);
        this.emitLineTo(this.sx0 - this.mx0, this.sy0 - this.my0, this.scolor0);
        if (bl) {
            if (this.joinStyle == 0) {
                this.drawMiter(this.x0, this.y0, this.sx0, this.sy0, this.sx1, this.sy1, -n, -n2, -this.mx0, -this.my0, this.color0, false);
            } else if (this.joinStyle == 1) {
                this.drawRoundJoin(this.sx0, this.sy0, -n, -n2, -this.mx0, -this.my0, 0, this.scolor0, true, false, 100000000L);
            }
        }
        this.emitLineTo(this.sx0 - n, this.sy0 - n2, this.scolor0);
        this.emitLineTo(this.x0 - n, this.y0 - n2, this.color0);
        for (int i = this.rindex - 3; i >= 0; i -= 3) {
            this.emitLineTo(this.reverse[i], this.reverse[i + 1], this.reverse[i + 2]);
        }
        this.x0 = this.sx0;
        this.y0 = this.sy0;
        this.rindex = 0;
        this.started = false;
        this.joinSegment = false;
        this.prev = 2;
        this.emitClose();
    }

    public void end() {
        if (this.lineToOrigin) {
            this.lineToImpl(this.sx0, this.sy0, this.scolor0, this.joinToOrigin);
            this.lineToOrigin = false;
        }
        if (this.prev == 1) {
            this.finish();
        }
        this.output.end();
        this.joinSegment = false;
        this.prev = 0;
    }

    long lineLength(long l, long l2) {
        long l3 = (long)this.m00 * (long)this.m11 - (long)this.m01 * (long)this.m10 >> 16;
        long l4 = (l2 * (long)this.m00 - l * (long)this.m10) / l3;
        long l5 = (l2 * (long)this.m01 - l * (long)this.m11) / l3;
        long l6 = (int)LinePath.hypot(l4, l5);
        return l6;
    }

    private void finish() {
        long l;
        int n;
        int n2;
        long l2;
        long l3;
        long l4;
        long l5;
        if (this.capStyle == 1) {
            this.drawRoundJoin(this.x0, this.y0, this.omx, this.omy, -this.omx, -this.omy, 1, this.color0, false, false, 100000000L);
        } else if (this.capStyle == 2 && 0L < (l5 = this.lineLength(l4 = (long)(this.px0 - this.x0), l3 = (long)(this.py0 - this.y0)))) {
            l2 = (long)this.lineWidth2 * 65536L / l5;
            n2 = this.x0 - (int)(l4 * l2 >> 16);
            n = this.y0 - (int)(l3 * l2 >> 16);
            this.emitLineTo(n2 + this.omx, n + this.omy, this.color0);
            this.emitLineTo(n2 - this.omx, n - this.omy, this.color0);
        }
        for (int i = this.rindex - 3; i >= 0; i -= 3) {
            this.emitLineTo(this.reverse[i], this.reverse[i + 1], this.reverse[i + 2]);
        }
        this.rindex = 0;
        if (this.capStyle == 1) {
            this.drawRoundJoin(this.sx0, this.sy0, -this.mx0, -this.my0, this.mx0, this.my0, 1, this.scolor0, false, false, 100000000L);
        } else if (this.capStyle == 2 && 0L < (l5 = this.lineLength(l = (long)(this.sx1 - this.sx0), l3 = (long)(this.sy1 - this.sy0)))) {
            l2 = (long)this.lineWidth2 * 65536L / l5;
            n2 = this.sx0 - (int)(l * l2 >> 16);
            n = this.sy0 - (int)(l3 * l2 >> 16);
            this.emitLineTo(n2 - this.mx0, n - this.my0, this.scolor0);
            this.emitLineTo(n2 + this.mx0, n + this.my0, this.scolor0);
        }
        this.emitClose();
        this.joinSegment = false;
    }

    private void emitMoveTo(int n, int n2, int n3) {
        this.output.moveTo(n, n2, n3);
    }

    private void emitLineTo(int n, int n2, int n3) {
        this.output.lineTo(n, n2, n3);
    }

    private void emitLineTo(int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.ensureCapacity(this.rindex + 3);
            this.reverse[this.rindex++] = n;
            this.reverse[this.rindex++] = n2;
            this.reverse[this.rindex++] = n3;
        } else {
            this.emitLineTo(n, n2, n3);
        }
    }

    private void emitClose() {
        this.output.close();
    }
}

