/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.nio.IntBuffer;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public class FrameBuffer
implements PConstants {
    protected PGraphicsOpenGL pg;
    protected PGL pgl;
    protected int context;
    public int glFbo;
    public int glDepth;
    public int glStencil;
    public int glDepthStencil;
    public int glMultisample;
    public int width;
    public int height;
    protected int depthBits;
    protected int stencilBits;
    protected boolean packedDepthStencil;
    protected boolean multisample;
    protected int nsamples;
    protected int numColorBuffers;
    protected Texture[] colorBufferTex;
    protected boolean screenFb;
    protected boolean noDepth;
    protected IntBuffer pixelBuffer;

    FrameBuffer(PGraphicsOpenGL pGraphicsOpenGL) {
        this.pg = pGraphicsOpenGL;
        this.pgl = pGraphicsOpenGL.pgl;
        this.context = this.pgl.createEmptyContext();
    }

    FrameBuffer(PGraphicsOpenGL pGraphicsOpenGL, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        this(pGraphicsOpenGL);
        this.glFbo = 0;
        this.glDepth = 0;
        this.glStencil = 0;
        this.glDepthStencil = 0;
        this.glMultisample = 0;
        if (bl2) {
            n4 = 0;
            n3 = 0;
            n6 = 0;
            n5 = 0;
        }
        this.width = n;
        this.height = n2;
        if (1 < n3) {
            this.multisample = true;
            this.nsamples = n3;
        } else {
            this.multisample = false;
            this.nsamples = 1;
        }
        this.numColorBuffers = n4;
        this.colorBufferTex = new Texture[this.numColorBuffers];
        for (int i = 0; i < this.numColorBuffers; ++i) {
            this.colorBufferTex[i] = null;
        }
        if (n5 < 1 && n6 < 1) {
            this.depthBits = 0;
            this.stencilBits = 0;
            this.packedDepthStencil = false;
        } else if (bl) {
            this.depthBits = 24;
            this.stencilBits = 8;
            this.packedDepthStencil = true;
        } else {
            this.depthBits = n5;
            this.stencilBits = n6;
            this.packedDepthStencil = false;
        }
        this.screenFb = bl2;
        this.allocate();
        this.noDepth = false;
        this.pixelBuffer = null;
    }

    FrameBuffer(PGraphicsOpenGL pGraphicsOpenGL, int n, int n2) {
        this(pGraphicsOpenGL, n, n2, 1, 1, 0, 0, false, false);
    }

    FrameBuffer(PGraphicsOpenGL pGraphicsOpenGL, int n, int n2, boolean bl) {
        this(pGraphicsOpenGL, n, n2, 1, 1, 0, 0, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.screenFb) {
                if (this.glFbo != 0) {
                    PGraphicsOpenGL.finalizeFrameBufferObject(this.glFbo, this.context);
                }
                if (this.glDepth != 0) {
                    PGraphicsOpenGL.finalizeRenderBufferObject(this.glDepth, this.context);
                }
                if (this.glStencil != 0) {
                    PGraphicsOpenGL.finalizeRenderBufferObject(this.glStencil, this.context);
                }
                if (this.glMultisample != 0) {
                    PGraphicsOpenGL.finalizeRenderBufferObject(this.glMultisample, this.context);
                }
                if (this.glDepthStencil != 0) {
                    PGraphicsOpenGL.finalizeRenderBufferObject(this.glDepthStencil, this.context);
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.pgl.clearDepth(1.0f);
        this.pgl.clearStencil(0);
        this.pgl.clearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.pgl.clear(PGL.DEPTH_BUFFER_BIT | PGL.STENCIL_BUFFER_BIT | PGL.COLOR_BUFFER_BIT);
        this.pg.popFramebuffer();
    }

    public void copyColor(FrameBuffer frameBuffer) {
        this.copy(frameBuffer, PGL.COLOR_BUFFER_BIT);
    }

    public void copyDepth(FrameBuffer frameBuffer) {
        this.copy(frameBuffer, PGL.DEPTH_BUFFER_BIT);
    }

    public void copyStencil(FrameBuffer frameBuffer) {
        this.copy(frameBuffer, PGL.STENCIL_BUFFER_BIT);
    }

    public void copy(FrameBuffer frameBuffer, int n) {
        this.pgl.bindFramebufferImpl(PGL.READ_FRAMEBUFFER, this.glFbo);
        this.pgl.bindFramebufferImpl(PGL.DRAW_FRAMEBUFFER, frameBuffer.glFbo);
        this.pgl.blitFramebuffer(0, 0, this.width, this.height, 0, 0, frameBuffer.width, frameBuffer.height, n, PGL.NEAREST);
        this.pgl.bindFramebufferImpl(PGL.READ_FRAMEBUFFER, this.pg.getCurrentFB().glFbo);
        this.pgl.bindFramebufferImpl(PGL.DRAW_FRAMEBUFFER, this.pg.getCurrentFB().glFbo);
    }

    public void bind() {
        this.pgl.bindFramebufferImpl(PGL.FRAMEBUFFER, this.glFbo);
    }

    public void disableDepthTest() {
        this.noDepth = true;
    }

    public void finish() {
        if (this.noDepth) {
            if (this.pg.getHint(-2)) {
                this.pgl.enable(PGL.DEPTH_TEST);
            } else {
                this.pgl.disable(PGL.DEPTH_TEST);
            }
        }
    }

    public void readPixels() {
        if (this.pixelBuffer == null) {
            this.createPixelBuffer();
        }
        this.pixelBuffer.rewind();
        this.pgl.readPixels(0, 0, this.width, this.height, PGL.RGBA, PGL.UNSIGNED_BYTE, this.pixelBuffer);
    }

    public void getPixels(int[] nArray) {
        if (this.pixelBuffer != null) {
            this.pixelBuffer.get(nArray, 0, nArray.length);
            this.pixelBuffer.rewind();
        }
    }

    public IntBuffer getPixelBuffer() {
        return this.pixelBuffer;
    }

    public boolean hasDepthBuffer() {
        return 0 < this.depthBits;
    }

    public boolean hasStencilBuffer() {
        return 0 < this.stencilBits;
    }

    public void setFBO(int n) {
        if (this.screenFb) {
            this.glFbo = n;
        }
    }

    public void setColorBuffer(Texture texture) {
        this.setColorBuffers(new Texture[]{texture}, 1);
    }

    public void setColorBuffers(Texture[] textureArray) {
        this.setColorBuffers(textureArray, textureArray.length);
    }

    public void setColorBuffers(Texture[] textureArray, int n) {
        int n2;
        if (this.screenFb) {
            return;
        }
        if (this.numColorBuffers != PApplet.min(n, textureArray.length)) {
            throw new RuntimeException("Wrong number of textures to set the color buffers.");
        }
        for (n2 = 0; n2 < this.numColorBuffers; ++n2) {
            this.colorBufferTex[n2] = textureArray[n2];
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        for (n2 = 0; n2 < this.numColorBuffers; ++n2) {
            this.pgl.framebufferTexture2D(PGL.FRAMEBUFFER, PGL.COLOR_ATTACHMENT0 + n2, PGL.TEXTURE_2D, 0, 0);
        }
        for (n2 = 0; n2 < this.numColorBuffers; ++n2) {
            this.pgl.framebufferTexture2D(PGL.FRAMEBUFFER, PGL.COLOR_ATTACHMENT0 + n2, this.colorBufferTex[n2].glTarget, this.colorBufferTex[n2].glName, 0);
        }
        this.pgl.validateFramebuffer();
        this.pg.popFramebuffer();
    }

    public void swapColorBuffers() {
        int n;
        for (n = 0; n < this.numColorBuffers - 1; ++n) {
            int n2 = n + 1;
            Texture texture = this.colorBufferTex[n];
            this.colorBufferTex[n] = this.colorBufferTex[n2];
            this.colorBufferTex[n2] = texture;
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        for (n = 0; n < this.numColorBuffers; ++n) {
            this.pgl.framebufferTexture2D(PGL.FRAMEBUFFER, PGL.COLOR_ATTACHMENT0 + n, this.colorBufferTex[n].glTarget, this.colorBufferTex[n].glName, 0);
        }
        this.pgl.validateFramebuffer();
        this.pg.popFramebuffer();
    }

    public int getDefaultReadBuffer() {
        if (this.screenFb) {
            return this.pgl.getDefaultReadBuffer();
        }
        return PGL.COLOR_ATTACHMENT0;
    }

    public int getDefaultDrawBuffer() {
        if (this.screenFb) {
            return this.pgl.getDefaultDrawBuffer();
        }
        return PGL.COLOR_ATTACHMENT0;
    }

    protected void allocate() {
        this.dispose();
        this.context = this.pgl.getCurrentContext();
        if (this.screenFb) {
            this.glFbo = 0;
        } else {
            this.glFbo = PGraphicsOpenGL.createFrameBufferObject(this.context, this.pgl);
            if (this.multisample) {
                this.createColorBufferMultisample();
            }
            if (this.packedDepthStencil) {
                this.createPackedDepthStencilBuffer();
            } else {
                if (0 < this.depthBits) {
                    this.createDepthBuffer();
                }
                if (0 < this.stencilBits) {
                    this.createStencilBuffer();
                }
            }
        }
    }

    protected void dispose() {
        if (this.screenFb) {
            return;
        }
        if (this.glFbo != 0) {
            PGraphicsOpenGL.finalizeFrameBufferObject(this.glFbo, this.context);
            this.glFbo = 0;
        }
        if (this.glDepth != 0) {
            PGraphicsOpenGL.finalizeRenderBufferObject(this.glDepth, this.context);
            this.glDepth = 0;
        }
        if (this.glStencil != 0) {
            PGraphicsOpenGL.finalizeRenderBufferObject(this.glStencil, this.context);
            this.glStencil = 0;
        }
        if (this.glMultisample != 0) {
            PGraphicsOpenGL.finalizeRenderBufferObject(this.glMultisample, this.context);
            this.glMultisample = 0;
        }
        if (this.glDepthStencil != 0) {
            PGraphicsOpenGL.finalizeRenderBufferObject(this.glDepthStencil, this.context);
            this.glDepthStencil = 0;
        }
    }

    protected boolean contextIsOutdated() {
        boolean bl;
        if (this.screenFb) {
            return false;
        }
        boolean bl2 = bl = !this.pgl.contextIsCurrent(this.context);
        if (bl) {
            PGraphicsOpenGL.removeFrameBufferObject(this.glFbo, this.context);
            PGraphicsOpenGL.removeRenderBufferObject(this.glDepth, this.context);
            PGraphicsOpenGL.removeRenderBufferObject(this.glStencil, this.context);
            PGraphicsOpenGL.removeRenderBufferObject(this.glDepthStencil, this.context);
            PGraphicsOpenGL.removeRenderBufferObject(this.glMultisample, this.context);
            this.glFbo = 0;
            this.glDepth = 0;
            this.glStencil = 0;
            this.glDepthStencil = 0;
            this.glMultisample = 0;
            for (int i = 0; i < this.numColorBuffers; ++i) {
                this.colorBufferTex[i] = null;
            }
        }
        return bl;
    }

    protected void createColorBufferMultisample() {
        if (this.screenFb) {
            return;
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.glMultisample = PGraphicsOpenGL.createRenderBufferObject(this.context, this.pgl);
        this.pgl.bindRenderbuffer(PGL.RENDERBUFFER, this.glMultisample);
        this.pgl.renderbufferStorageMultisample(PGL.RENDERBUFFER, this.nsamples, PGL.RGBA8, this.width, this.height);
        this.pgl.framebufferRenderbuffer(PGL.FRAMEBUFFER, PGL.COLOR_ATTACHMENT0, PGL.RENDERBUFFER, this.glMultisample);
        this.pg.popFramebuffer();
    }

    protected void createPackedDepthStencilBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.glDepthStencil = PGraphicsOpenGL.createRenderBufferObject(this.context, this.pgl);
        this.pgl.bindRenderbuffer(PGL.RENDERBUFFER, this.glDepthStencil);
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(PGL.RENDERBUFFER, this.nsamples, PGL.DEPTH24_STENCIL8, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(PGL.RENDERBUFFER, PGL.DEPTH24_STENCIL8, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(PGL.FRAMEBUFFER, PGL.DEPTH_ATTACHMENT, PGL.RENDERBUFFER, this.glDepthStencil);
        this.pgl.framebufferRenderbuffer(PGL.FRAMEBUFFER, PGL.STENCIL_ATTACHMENT, PGL.RENDERBUFFER, this.glDepthStencil);
        this.pg.popFramebuffer();
    }

    protected void createDepthBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.glDepth = PGraphicsOpenGL.createRenderBufferObject(this.context, this.pgl);
        this.pgl.bindRenderbuffer(PGL.RENDERBUFFER, this.glDepth);
        int n = PGL.DEPTH_COMPONENT16;
        if (this.depthBits == 16) {
            n = PGL.DEPTH_COMPONENT16;
        } else if (this.depthBits == 24) {
            n = PGL.DEPTH_COMPONENT24;
        } else if (this.depthBits == 32) {
            n = PGL.DEPTH_COMPONENT32;
        }
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(PGL.RENDERBUFFER, this.nsamples, n, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(PGL.RENDERBUFFER, n, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(PGL.FRAMEBUFFER, PGL.DEPTH_ATTACHMENT, PGL.RENDERBUFFER, this.glDepth);
        this.pg.popFramebuffer();
    }

    protected void createStencilBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.glStencil = PGraphicsOpenGL.createRenderBufferObject(this.context, this.pgl);
        this.pgl.bindRenderbuffer(PGL.RENDERBUFFER, this.glStencil);
        int n = PGL.STENCIL_INDEX1;
        if (this.stencilBits == 1) {
            n = PGL.STENCIL_INDEX1;
        } else if (this.stencilBits == 4) {
            n = PGL.STENCIL_INDEX4;
        } else if (this.stencilBits == 8) {
            n = PGL.STENCIL_INDEX8;
        }
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(PGL.RENDERBUFFER, this.nsamples, n, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(PGL.RENDERBUFFER, n, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(PGL.FRAMEBUFFER, PGL.STENCIL_ATTACHMENT, PGL.RENDERBUFFER, this.glStencil);
        this.pg.popFramebuffer();
    }

    protected void createPixelBuffer() {
        this.pixelBuffer = IntBuffer.allocate(this.width * this.height);
        this.pixelBuffer.rewind();
    }
}

