/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import processing.core.PApplet;

public class XML
implements Serializable {
    protected Node node;
    protected XML parent;
    protected XML[] children;

    protected XML() {
    }

    public XML(File file) throws IOException, ParserConfigurationException, SAXException {
        this(file, null);
    }

    public XML(File file, String string) throws IOException, ParserConfigurationException, SAXException {
        this(PApplet.createReader(file), string);
    }

    public XML(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        this(inputStream, null);
    }

    public XML(InputStream inputStream, String string) throws IOException, ParserConfigurationException, SAXException {
        this(PApplet.createReader(inputStream), string);
    }

    public XML(Reader reader) throws IOException, ParserConfigurationException, SAXException {
        this(reader, null);
    }

    public XML(Reader reader, String string) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        documentBuilderFactory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(reader));
        this.node = document.getDocumentElement();
    }

    public XML(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            this.node = document.createElement(string);
            this.parent = null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    protected XML(XML xML, Node node) {
        this.node = node;
        this.parent = xML;
    }

    public static XML parse(String string) throws IOException, ParserConfigurationException, SAXException {
        return XML.parse(string, null);
    }

    public static XML parse(String string, String string2) throws IOException, ParserConfigurationException, SAXException {
        return new XML(new StringReader(string), null);
    }

    public boolean save(File file, String string) {
        PrintWriter printWriter = PApplet.createWriter(file);
        boolean bl = this.write(printWriter);
        printWriter.flush();
        printWriter.close();
        return bl;
    }

    public boolean write(PrintWriter printWriter) {
        printWriter.print(this.format(2));
        printWriter.flush();
        return true;
    }

    public XML getParent() {
        return this.parent;
    }

    protected Object getNative() {
        return this.node;
    }

    public String getName() {
        return this.node.getNodeName();
    }

    public void setName(String string) {
        Document document = this.node.getOwnerDocument();
        this.node = document.renameNode(this.node, null, string);
    }

    public String getLocalName() {
        return this.node.getLocalName();
    }

    protected void checkChildren() {
        if (this.children == null) {
            NodeList nodeList = this.node.getChildNodes();
            int n = nodeList.getLength();
            this.children = new XML[n];
            for (int i = 0; i < n; ++i) {
                this.children[i] = new XML(this, nodeList.item(i));
            }
        }
    }

    public int getChildCount() {
        this.checkChildren();
        return this.children.length;
    }

    public boolean hasChildren() {
        this.checkChildren();
        return this.children.length > 0;
    }

    public String[] listChildren() {
        this.checkChildren();
        String[] stringArray = new String[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            stringArray[i] = this.children[i].getName();
        }
        return stringArray;
    }

    public XML[] getChildren() {
        this.checkChildren();
        return this.children;
    }

    public XML getChild(int n) {
        this.checkChildren();
        return this.children[n];
    }

    public XML getChild(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            throw new IllegalArgumentException("getChild() should not begin with a slash");
        }
        if (string.indexOf(47) != -1) {
            return this.getChildRecursive(PApplet.split(string, '/'), 0);
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            XML xML = this.getChild(i);
            String string2 = xML.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return xML;
        }
        return null;
    }

    protected XML getChildRecursive(String[] stringArray, int n) {
        if (Character.isDigit(stringArray[n].charAt(0))) {
            XML xML = this.getChild(Integer.parseInt(stringArray[n]));
            if (n == stringArray.length - 1) {
                return xML;
            }
            return xML.getChildRecursive(stringArray, n + 1);
        }
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            XML xML = this.getChild(i);
            String string = xML.getName();
            if (string == null || !string.equals(stringArray[n])) continue;
            if (n == stringArray.length - 1) {
                return xML;
            }
            return xML.getChildRecursive(stringArray, n + 1);
        }
        return null;
    }

    public XML[] getChildren(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            throw new IllegalArgumentException("getChildren() should not begin with a slash");
        }
        if (string.indexOf(47) != -1) {
            return this.getChildrenRecursive(PApplet.split(string, '/'), 0);
        }
        if (Character.isDigit(string.charAt(0))) {
            return new XML[]{this.getChild(Integer.parseInt(string))};
        }
        int n = this.getChildCount();
        XML[] xMLArray = new XML[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XML xML = this.getChild(i);
            String string2 = xML.getName();
            if (string2 == null || !string2.equals(string)) continue;
            xMLArray[n2++] = xML;
        }
        return (XML[])PApplet.subset(xMLArray, 0, n2);
    }

    protected XML[] getChildrenRecursive(String[] stringArray, int n) {
        if (n == stringArray.length - 1) {
            return this.getChildren(stringArray[n]);
        }
        XML[] xMLArray = this.getChildren(stringArray[n]);
        XML[] xMLArray2 = new XML[]{};
        for (int i = 0; i < xMLArray.length; ++i) {
            XML[] xMLArray3 = xMLArray[i].getChildrenRecursive(stringArray, n + 1);
            xMLArray2 = (XML[])PApplet.concat(xMLArray2, xMLArray3);
        }
        return xMLArray2;
    }

    public XML addChild(String string) {
        Document document = this.node.getOwnerDocument();
        Element element = document.createElement(string);
        return this.appendChild(element);
    }

    public XML addChild(XML xML) {
        Document document = this.node.getOwnerDocument();
        Node node = document.importNode((Node)xML.getNative(), true);
        return this.appendChild(node);
    }

    protected XML appendChild(Node node) {
        this.node.appendChild(node);
        XML xML = new XML(this, node);
        if (this.children != null) {
            this.children = (XML[])PApplet.concat(this.children, new XML[]{xML});
        }
        return xML;
    }

    public void removeChild(XML xML) {
        this.node.removeChild(xML.node);
        this.children = null;
    }

    public int getAttributeCount() {
        return this.node.getAttributes().getLength();
    }

    public String[] listAttributes() {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        String[] stringArray = new String[namedNodeMap.getLength()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = namedNodeMap.item(i).getNodeName();
        }
        return stringArray;
    }

    public boolean hasAttribute(String string) {
        return this.node.getAttributes().getNamedItem(string) != null;
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        Node node = this.node.getAttributes().getNamedItem(string);
        return node == null ? string2 : node.getNodeValue();
    }

    public void setString(String string, String string2) {
        ((Element)this.node).setAttribute(string, string2);
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public void setInt(String string, int n) {
        this.setString(string, String.valueOf(n));
    }

    public int getInt(String string, int n) {
        String string2 = this.getString(string);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    public void setLong(String string, long l) {
        this.setString(string, String.valueOf(l));
    }

    public long getLong(String string, long l) {
        String string2 = this.getString(string);
        return string2 == null ? l : Long.parseLong(string2);
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f) {
        String string2 = this.getString(string);
        return string2 == null ? f : Float.parseFloat(string2);
    }

    public void setFloat(String string, float f) {
        this.setString(string, String.valueOf(f));
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d) {
        String string2 = this.getString(string);
        return string2 == null ? d : Double.parseDouble(string2);
    }

    public void setDouble(String string, double d) {
        this.setString(string, String.valueOf(d));
    }

    public String getContent() {
        return this.node.getTextContent();
    }

    public String getContent(String string) {
        String string2 = this.node.getTextContent();
        return string2 != null ? string2 : string;
    }

    public int getIntContent() {
        return this.getIntContent(0);
    }

    public int getIntContent(int n) {
        return PApplet.parseInt(this.node.getTextContent(), n);
    }

    public float getFloatContent() {
        return this.getFloatContent(0.0f);
    }

    public float getFloatContent(float f) {
        return PApplet.parseFloat(this.node.getTextContent(), f);
    }

    public long getLongContent() {
        return this.getLongContent(0L);
    }

    public long getLongContent(long l) {
        String string = this.node.getTextContent();
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public double getDoubleContent() {
        return this.getDoubleContent(0.0);
    }

    public double getDoubleContent(double d) {
        String string = this.node.getTextContent();
        if (string != null) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public void setContent(String string) {
        this.node.setTextContent(string);
    }

    public void setIntContent(int n) {
        this.setContent(String.valueOf(n));
    }

    public void setFloatContent(float f) {
        this.setContent(String.valueOf(f));
    }

    public void setLongContent(long l) {
        this.setContent(String.valueOf(l));
    }

    public void setDoubleContent(double d) {
        this.setContent(String.valueOf(d));
    }

    public String format(int n) {
        try {
            boolean bl = false;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (n != -1) {
                try {
                    transformerFactory.setAttribute("indent-number", n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            }
            Transformer transformer = transformerFactory.newTransformer();
            if (n == -1 || this.parent == null) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                transformer.setOutputProperty("omit-xml-declaration", "no");
            }
            transformer.setOutputProperty("method", "xml");
            if (bl) {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(n));
            }
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            String string = System.getProperty("line.separator");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(new DOMSource(this.node), streamResult);
            String[] stringArray = PApplet.split(stringWriter.toString(), string);
            if (stringArray[0].startsWith("<?xml")) {
                int n2 = stringArray[0].indexOf("?>") + 2;
                if (stringArray[0].length() == n2) {
                    stringArray = PApplet.subset(stringArray, 1);
                } else {
                    stringArray[0] = stringArray[0].substring(n2);
                }
            }
            String string2 = PApplet.join(PApplet.trim(stringArray), "");
            if (n == -1) {
                return string2;
            }
            if (string2.trim().length() == 0) {
                return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string + string2;
            }
            StringWriter stringWriter2 = new StringWriter();
            StreamResult streamResult2 = new StreamResult(stringWriter2);
            StreamSource streamSource = new StreamSource(new StringReader(string2));
            transformer.transform(streamSource, streamResult2);
            String string3 = stringWriter2.toString();
            if (!string3.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
                return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string + string3;
            }
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.format(-1);
    }
}

