/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import processing.core.PApplet;
import processing.data.FloatDict;
import processing.data.FloatList;
import processing.data.IntDict;
import processing.data.IntList;
import processing.data.Sort;
import processing.data.StringDict;
import processing.data.StringList;
import processing.data.TableRow;
import processing.data.XML;

public class Table {
    protected int rowCount;
    protected String missingString = null;
    protected int missingInt = 0;
    protected long missingLong = 0L;
    protected float missingFloat = Float.NaN;
    protected double missingDouble = Double.NaN;
    protected int missingCategory = -1;
    String[] columnTitles;
    HashMapBlows[] columnCategories;
    HashMap<String, Integer> columnIndices;
    protected Object[] columns;
    public static final int STRING = 0;
    public static final int INT = 1;
    public static final int LONG = 2;
    public static final int FLOAT = 3;
    public static final int DOUBLE = 4;
    public static final int CATEGORY = 5;
    int[] columnTypes;
    protected RowIterator rowIterator;
    protected int expandIncrement;
    static final String[] loadExtensions = new String[]{"csv", "tsv", "ods", "bin"};
    static final String[] saveExtensions = new String[]{"csv", "tsv", "html", "bin"};

    public Table() {
        this.init();
    }

    public Table(File file) throws IOException {
        this(file, null);
    }

    public Table(File file, String string) throws IOException {
        this.init();
        this.parse(PApplet.createInput(file), Table.extensionOptions(true, file.getName(), string));
    }

    public Table(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public Table(InputStream inputStream, String string) throws IOException {
        this.init();
        this.parse(inputStream, string);
    }

    public Table(Iterable<TableRow> iterable) {
        boolean bl = false;
        for (TableRow tableRow : iterable) {
            if (!bl) {
                this.setColumnTypes(tableRow.getColumnTypes());
            }
            this.addRow(tableRow);
        }
    }

    public Table(ResultSet resultSet) {
        this.init();
        try {
            int n;
            int n2;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            this.setColumnCount(n3);
            block15: for (n2 = 0; n2 < n3; ++n2) {
                this.setColumnTitle(n2, resultSetMetaData.getColumnName(n2 + 1));
                n = resultSetMetaData.getColumnType(n2 + 1);
                switch (n) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.setColumnType(n2, 1);
                        continue block15;
                    }
                    case -5: {
                        this.setColumnType(n2, 2);
                        continue block15;
                    }
                    case 6: {
                        this.setColumnType(n2, 3);
                        continue block15;
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        this.setColumnType(n2, 4);
                    }
                }
            }
            n2 = 0;
            while (resultSet.next()) {
                block17: for (n = 0; n < n3; ++n) {
                    switch (this.columnTypes[n]) {
                        case 0: {
                            this.setString(n2, n, resultSet.getString(n + 1));
                            continue block17;
                        }
                        case 1: {
                            this.setInt(n2, n, resultSet.getInt(n + 1));
                            continue block17;
                        }
                        case 2: {
                            this.setLong(n2, n, resultSet.getLong(n + 1));
                            continue block17;
                        }
                        case 3: {
                            this.setFloat(n2, n, resultSet.getFloat(n + 1));
                            continue block17;
                        }
                        case 4: {
                            this.setDouble(n2, n, resultSet.getDouble(n + 1));
                            continue block17;
                        }
                        default: {
                            throw new IllegalArgumentException("column type " + this.columnTypes[n] + " not supported.");
                        }
                    }
                }
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public Table typedParse(InputStream inputStream, String string) throws IOException {
        Table table = new Table();
        table.setColumnTypes(this);
        table.parse(inputStream, string);
        return table;
    }

    protected void init() {
        this.columns = new Object[0];
        this.columnTypes = new int[0];
        this.columnCategories = new HashMapBlows[0];
    }

    public static String extensionOptions(boolean bl, String string, String string2) {
        String string3 = PApplet.checkExtension(string);
        if (string3 != null) {
            for (String string4 : bl ? loadExtensions : saveExtensions) {
                if (!string3.equals(string4)) continue;
                if (string2 == null) {
                    return string3;
                }
                return string3 + "," + string2;
            }
        }
        return string2;
    }

    protected void parse(InputStream inputStream, String string) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        boolean bl3 = false;
        String string3 = null;
        String[] stringArray = null;
        if (string != null) {
            for (String string4 : stringArray = PApplet.splitTokens(string, " ,")) {
                if (string4.equals("tsv")) {
                    string2 = "tsv";
                    continue;
                }
                if (string4.equals("csv")) {
                    string2 = "csv";
                    continue;
                }
                if (string4.equals("ods")) {
                    string2 = "ods";
                    continue;
                }
                if (string4.equals("newlines")) {
                    bl = true;
                    string2 = "csv";
                    continue;
                }
                if (string4.equals("bin")) {
                    bl3 = true;
                    string2 = "bin";
                    continue;
                }
                if (string4.equals("header")) {
                    bl2 = true;
                    continue;
                }
                if (string4.startsWith("worksheet=")) {
                    string3 = string4.substring("worksheet=".length());
                    continue;
                }
                if (string4.startsWith("dictionary=")) continue;
                throw new IllegalArgumentException("'" + string4 + "' is not a valid option for loading a Table");
            }
        }
        if (string2 == null) {
            throw new IllegalArgumentException("No extension specified for this Table");
        }
        if (bl3) {
            this.loadBinary(inputStream);
        } else if (string2.equals("ods")) {
            this.odsParse(inputStream, string3);
        } else {
            BufferedReader bufferedReader = PApplet.createReader(inputStream);
            if (bl) {
                this.parseAwfulCSV(bufferedReader, bl2);
            } else if ("tsv".equals(string2)) {
                this.parseBasic(bufferedReader, bl2, true);
            } else if ("csv".equals(string2)) {
                this.parseBasic(bufferedReader, bl2, false);
            }
        }
    }

    protected void parseBasic(BufferedReader bufferedReader, boolean bl, boolean bl2) throws IOException {
        String string = null;
        int n = 0;
        if (this.rowCount == 0) {
            this.setRowCount(10);
        }
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (n == this.getRowCount()) {
                    this.setRowCount(n << 1);
                }
                if (n == 0 && bl) {
                    this.setColumnTitles(bl2 ? PApplet.split(string, '\t') : Table.splitLineCSV(string));
                    bl = false;
                } else {
                    this.setRow(n, bl2 ? PApplet.split(string, '\t') : Table.splitLineCSV(string));
                    ++n;
                }
                if (n % 10000 != 0) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error reading table on line " + n, exception);
        }
        if (n != this.getRowCount()) {
            this.setRowCount(n);
        }
    }

    protected void parseAwfulCSV(BufferedReader bufferedReader, boolean bl) throws IOException {
        int n;
        char[] cArray = new char[100];
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        while ((n = bufferedReader.read()) != -1) {
            if (bl2) {
                if (n == 34) {
                    bufferedReader.mark(1);
                    if (bufferedReader.read() == 34) {
                        if (n2 == cArray.length) {
                            cArray = PApplet.expand(cArray);
                        }
                        cArray[n2++] = 34;
                        continue;
                    }
                    bufferedReader.reset();
                    bl2 = false;
                    continue;
                }
                if (n2 == cArray.length) {
                    cArray = PApplet.expand(cArray);
                }
                cArray[n2++] = (char)n;
                continue;
            }
            if (n == 34) {
                bl2 = true;
                continue;
            }
            if (n == 13 || n == 10) {
                if (n == 13) {
                    bufferedReader.mark(1);
                    if (bufferedReader.read() != 10) {
                        bufferedReader.reset();
                    }
                }
                this.setString(n3, n4, new String(cArray, 0, n2));
                n2 = 0;
                if (n3 == 0 && bl) {
                    this.removeTitleRow();
                    bl = false;
                }
                ++n3;
                n4 = 0;
                continue;
            }
            if (n == 44) {
                this.setString(n3, n4, new String(cArray, 0, n2));
                n2 = 0;
                this.ensureColumn(++n4);
                continue;
            }
            if (n2 == cArray.length) {
                cArray = PApplet.expand(cArray);
            }
            cArray[n2++] = (char)n;
        }
        if (n2 > 0) {
            this.setString(n3, n4, new String(cArray, 0, n2));
        }
    }

    protected static String[] splitLineCSV(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = 1;
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (!bl && cArray[i] == ',') {
                ++n2;
                continue;
            }
            if (cArray[i] != '\"') continue;
            bl = !bl;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            n = n4;
            int n5 = Table.nextComma(cArray, n4);
            n4 = n5 + 1;
            if (cArray[n] == '\"' && cArray[n5 - 1] == '\"') {
                --n5;
            }
            int n6 = ++n;
            int n7 = n;
            while (n6 < n5) {
                if (cArray[n6] == '\"') {
                    ++n6;
                }
                if (n6 != n7) {
                    cArray[n7] = cArray[n6];
                }
                ++n6;
                ++n7;
            }
            String string2 = new String(cArray, n, n7 - n);
            stringArray[n3++] = string2;
        }
        for (n = n3; n < stringArray.length; ++n) {
            stringArray[n] = "";
        }
        return stringArray;
    }

    protected static int nextComma(char[] cArray, int n) {
        boolean bl = false;
        for (int i = n; i < cArray.length; ++i) {
            if (!bl && cArray[i] == ',') {
                return i;
            }
            if (cArray[i] != '\"') continue;
            bl = !bl;
        }
        return cArray.length;
    }

    private InputStream odsFindContentXML(InputStream inputStream) {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        try {
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals("content.xml")) continue;
                return zipInputStream;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    protected void odsParse(InputStream inputStream, String string) {
        try {
            InputStream inputStream2 = this.odsFindContentXML(inputStream);
            XML xML = new XML(inputStream2);
            XML[] xMLArray = xML.getChildren("office:body/office:spreadsheet/table:table");
            boolean bl = false;
            for (XML xML2 : xMLArray) {
                if (string != null && !string.equals(xML2.getString("table:name"))) continue;
                this.odsParseSheet(xML2);
                bl = true;
                if (string == null) break;
            }
            if (!bl) {
                if (string == null) {
                    throw new RuntimeException("No worksheets found in the ODS file.");
                }
                throw new RuntimeException("No worksheet named " + string + " found in the ODS file.");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    private void odsParseSheet(XML xML) {
        XML[] xMLArray = xML.getChildren("table:table-row");
        int n = 0;
        for (XML xML2 : xMLArray) {
            int n2 = xML2.getInt("table:number-rows-repeated", 1);
            boolean bl = false;
            XML[] xMLArray2 = xML2.getChildren();
            int n3 = 0;
            for (XML xML3 : xMLArray2) {
                int n4;
                int n5 = xML3.getInt("table:number-columns-repeated", 1);
                String string = xML3.getString("office:value");
                if (string == null && (n4 = xML3.getChildCount()) != 0) {
                    XML[] xMLArray3 = xML3.getChildren("text:p");
                    if (xMLArray3.length != 1) {
                        for (XML xML4 : xMLArray3) {
                            System.err.println(xML4.toString());
                        }
                        throw new RuntimeException("found more than one text:p element");
                    }
                    XML xML4 = xMLArray3[0];
                    String string2 = xML4.getContent();
                    if (string2 != null) {
                        string = string2;
                    } else {
                        XML[] xMLArray4 = xML4.getChildren();
                        StringBuffer object = new StringBuffer();
                        for (XML xML5 : xMLArray4) {
                            String string3 = xML5.getName();
                            if (string3 == null) {
                                this.odsAppendNotNull(xML5, object);
                                continue;
                            }
                            if (string3.equals("text:s")) {
                                int n6 = xML5.getInt("text:c", 1);
                                for (int i = 0; i < n6; ++i) {
                                    object.append(' ');
                                }
                                continue;
                            }
                            if (string3.equals("text:span")) {
                                this.odsAppendNotNull(xML5, object);
                                continue;
                            }
                            if (string3.equals("text:a")) {
                                object.append(xML5.getString("xlink:href"));
                                continue;
                            }
                            this.odsAppendNotNull(xML5, object);
                            System.err.println(this.getClass().getName() + ": don't understand: " + xML5);
                        }
                        string = object.toString();
                    }
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    if (string != null) {
                        this.setString(n, n3, string);
                    }
                    ++n3;
                    if (string == null) continue;
                    bl = true;
                }
            }
            if (bl && n2 > 1) {
                Object[] objectArray = this.getStringRow(n);
                for (int i = 1; i < n2; ++i) {
                    this.addRow(objectArray);
                }
            }
            n += n2;
        }
    }

    private void odsAppendNotNull(XML xML, StringBuffer stringBuffer) {
        String string = xML.getContent();
        if (string != null) {
            stringBuffer.append(string);
        }
    }

    public void parseInto(Object object, String string) {
        GenericDeclaration genericDeclaration;
        Class<?> clazz;
        Class<?> clazz2 = null;
        Object object2 = null;
        Field field = null;
        try {
            clazz = object.getClass();
            field = clazz.getDeclaredField(string);
            genericDeclaration = field.getType();
            if (((Class)genericDeclaration).isArray()) {
                clazz2 = ((Class)genericDeclaration).getComponentType();
                object2 = Array.newInstance(clazz2, this.getRowCount());
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        clazz = clazz2.getEnclosingClass();
        genericDeclaration = null;
        try {
            genericDeclaration = clazz == null ? clazz2.getDeclaredConstructor(new Class[0]) : clazz2.getDeclaredConstructor(clazz);
            if (!((AccessibleObject)((Object)genericDeclaration)).isAccessible()) {
                ((Constructor)genericDeclaration).setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        Field[] fieldArray = clazz2.getDeclaredFields();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field2 : fieldArray) {
            String string2 = field2.getName();
            if (this.getColumnIndex(string2, false) == -1) continue;
            if (!field2.isAccessible()) {
                field2.setAccessible(true);
            }
            arrayList.add(field2);
        }
        int n = 0;
        try {
            for (TableRow tableRow : this.rows()) {
                Field field2;
                field2 = null;
                field2 = clazz == null ? ((Constructor)genericDeclaration).newInstance(new Object[0]) : ((Constructor)genericDeclaration).newInstance(object);
                for (Field field3 : arrayList) {
                    String string3;
                    String string4 = field3.getName();
                    if (field3.getType() == String.class) {
                        field3.set(field2, tableRow.getString(string4));
                        continue;
                    }
                    if (field3.getType() == Integer.TYPE) {
                        field3.setInt(field2, tableRow.getInt(string4));
                        continue;
                    }
                    if (field3.getType() == Long.TYPE) {
                        field3.setLong(field2, tableRow.getLong(string4));
                        continue;
                    }
                    if (field3.getType() == Float.TYPE) {
                        field3.setFloat(field2, tableRow.getFloat(string4));
                        continue;
                    }
                    if (field3.getType() == Double.TYPE) {
                        field3.setDouble(field2, tableRow.getDouble(string4));
                        continue;
                    }
                    if (field3.getType() == Boolean.TYPE) {
                        string3 = tableRow.getString(string4);
                        if (string3 == null || !string3.toLowerCase().equals("true") && !string3.equals("1")) continue;
                        field3.setBoolean(field2, true);
                        continue;
                    }
                    if (field3.getType() != Character.TYPE || (string3 = tableRow.getString(string4)) == null || string3.length() <= 0) continue;
                    field3.setChar(field2, string3.charAt(0));
                }
                Array.set(object2, n++, field2);
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(object, object2);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public boolean save(File file, String string) throws IOException {
        return this.save(PApplet.createOutput(file), Table.extensionOptions(false, file.getName(), string));
    }

    public boolean save(OutputStream outputStream, String string) {
        PrintWriter printWriter = PApplet.createWriter(outputStream);
        String string2 = null;
        if (string == null) {
            throw new IllegalArgumentException("No extension specified for saving this Table");
        }
        String[] stringArray = PApplet.splitTokens(string, ", ");
        string2 = stringArray[stringArray.length - 1];
        boolean bl = false;
        for (String string3 : saveExtensions) {
            if (!string2.equals(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("'" + string2 + "' not available for Table");
        }
        if (string2.equals("csv")) {
            this.writeCSV(printWriter);
        } else if (string2.equals("tsv")) {
            this.writeTSV(printWriter);
        } else if (string2.equals("html")) {
            this.writeHTML(printWriter);
        } else if (string2.equals("bin")) {
            try {
                this.saveBinary(outputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        printWriter.flush();
        printWriter.close();
        return true;
    }

    protected void writeTSV(PrintWriter printWriter) {
        int n;
        if (this.columnTitles != null) {
            for (n = 0; n < this.columns.length; ++n) {
                if (n != 0) {
                    printWriter.print('\t');
                }
                if (this.columnTitles[n] == null) continue;
                printWriter.print(this.columnTitles[n]);
            }
            printWriter.println();
        }
        for (n = 0; n < this.rowCount; ++n) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                String string;
                if (i != 0) {
                    printWriter.print('\t');
                }
                if ((string = this.getString(n, i)) == null) continue;
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.flush();
    }

    protected void writeCSV(PrintWriter printWriter) {
        int n;
        if (this.columnTitles != null) {
            for (n = 0; n < this.columns.length; ++n) {
                if (n != 0) {
                    printWriter.print(',');
                }
                if (this.columnTitles[n] == null) continue;
                this.writeEntryCSV(printWriter, this.columnTitles[n]);
            }
            printWriter.println();
        }
        for (n = 0; n < this.rowCount; ++n) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                String string;
                if (i != 0) {
                    printWriter.print(',');
                }
                if ((string = this.getString(n, i)) == null) continue;
                this.writeEntryCSV(printWriter, string);
            }
            printWriter.println();
        }
        printWriter.flush();
    }

    protected void writeEntryCSV(PrintWriter printWriter, String string) {
        if (string != null) {
            if (string.indexOf(34) != -1) {
                char[] cArray = string.toCharArray();
                printWriter.print('\"');
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] == '\"') {
                        printWriter.print("\"\"");
                        continue;
                    }
                    printWriter.print(cArray[i]);
                }
                printWriter.print('\"');
            } else if (string.indexOf(44) != -1 || string.indexOf(10) != -1 || string.indexOf(13) != -1) {
                printWriter.print('\"');
                printWriter.print(string);
                printWriter.print('\"');
            } else if (string.length() > 0 && (string.charAt(0) == ' ' || string.charAt(string.length() - 1) == ' ')) {
                printWriter.print('\"');
                printWriter.print(string);
                printWriter.print('\"');
            } else {
                printWriter.print(string);
            }
        }
    }

    protected void writeHTML(PrintWriter printWriter) {
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("  <meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\" />");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("  <table>");
        for (int i = 0; i < this.getRowCount(); ++i) {
            printWriter.println("    <tr>");
            for (int j = 0; j < this.getColumnCount(); ++j) {
                String string = this.getString(i, j);
                printWriter.print("      <td>");
                this.writeEntryHTML(printWriter, string);
                printWriter.println("      </td>");
            }
            printWriter.println("    </tr>");
        }
        printWriter.println("  </table>");
        printWriter.println("</body>");
        printWriter.println("</hmtl>");
        printWriter.flush();
    }

    protected void writeEntryHTML(PrintWriter printWriter, String string) {
        for (char c : string.toCharArray()) {
            if (c == '<') {
                printWriter.print("&lt;");
                continue;
            }
            if (c == '>') {
                printWriter.print("&gt;");
                continue;
            }
            if (c == '&') {
                printWriter.print("&amp;");
                continue;
            }
            if (c == '\'') {
                printWriter.print("&apos;");
                continue;
            }
            if (c == '\"') {
                printWriter.print("&quot;");
                continue;
            }
            printWriter.print(c);
        }
    }

    protected void saveBinary(OutputStream outputStream) throws IOException {
        int n;
        String string;
        int n2;
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        dataOutputStream.writeInt(-1878545634);
        dataOutputStream.writeInt(this.getRowCount());
        dataOutputStream.writeInt(this.getColumnCount());
        if (this.columnTitles != null) {
            dataOutputStream.writeBoolean(true);
            String[] stringArray = this.columnTitles;
            int n3 = stringArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                string = stringArray[n2];
                dataOutputStream.writeUTF(string);
            }
        } else {
            dataOutputStream.writeBoolean(false);
        }
        for (n = 0; n < this.getColumnCount(); ++n) {
            dataOutputStream.writeInt(this.columnTypes[n]);
        }
        for (n = 0; n < this.getColumnCount(); ++n) {
            if (this.columnTypes[n] != 5) continue;
            this.columnCategories[n].write(dataOutputStream);
        }
        if (this.missingString == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(this.missingString);
        }
        dataOutputStream.writeInt(this.missingInt);
        dataOutputStream.writeLong(this.missingLong);
        dataOutputStream.writeFloat(this.missingFloat);
        dataOutputStream.writeDouble(this.missingDouble);
        dataOutputStream.writeInt(this.missingCategory);
        for (TableRow tableRow : this.rows()) {
            block12: for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                switch (this.columnTypes[n2]) {
                    case 0: {
                        string = tableRow.getString(n2);
                        if (string == null) {
                            dataOutputStream.writeBoolean(false);
                            continue block12;
                        }
                        dataOutputStream.writeBoolean(true);
                        dataOutputStream.writeUTF(string);
                        continue block12;
                    }
                    case 1: {
                        dataOutputStream.writeInt(tableRow.getInt(n2));
                        continue block12;
                    }
                    case 2: {
                        dataOutputStream.writeLong(tableRow.getLong(n2));
                        continue block12;
                    }
                    case 3: {
                        dataOutputStream.writeFloat(tableRow.getFloat(n2));
                        continue block12;
                    }
                    case 4: {
                        dataOutputStream.writeDouble(tableRow.getDouble(n2));
                        continue block12;
                    }
                    case 5: {
                        dataOutputStream.writeInt(this.columnCategories[n2].index(tableRow.getString(n2)));
                    }
                }
            }
        }
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    protected void loadBinary(InputStream inputStream) throws IOException {
        int n;
        int n2;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        int n3 = dataInputStream.readInt();
        if (n3 != -1878545634) {
            throw new IOException("Not a compatible binary table (magic was " + PApplet.hex(n3) + ")");
        }
        int n4 = dataInputStream.readInt();
        this.setRowCount(n4);
        int n5 = dataInputStream.readInt();
        this.setColumnCount(n5);
        boolean bl = dataInputStream.readBoolean();
        if (bl) {
            this.columnTitles = new String[this.getColumnCount()];
            for (n2 = 0; n2 < n5; ++n2) {
                this.setColumnTitle(n2, dataInputStream.readUTF());
            }
        }
        block17: for (n2 = 0; n2 < n5; ++n2) {
            this.columnTypes[n2] = n = dataInputStream.readInt();
            switch (n) {
                case 1: {
                    this.columns[n2] = new int[n4];
                    continue block17;
                }
                case 2: {
                    this.columns[n2] = new long[n4];
                    continue block17;
                }
                case 3: {
                    this.columns[n2] = new float[n4];
                    continue block17;
                }
                case 4: {
                    this.columns[n2] = new double[n4];
                    continue block17;
                }
                case 0: {
                    this.columns[n2] = new String[n4];
                    continue block17;
                }
                case 5: {
                    this.columns[n2] = new int[n4];
                    continue block17;
                }
                default: {
                    throw new IllegalArgumentException(n + " is not a valid column type.");
                }
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if (this.columnTypes[n2] != 5) continue;
            this.columnCategories[n2] = new HashMapBlows(dataInputStream);
        }
        this.missingString = dataInputStream.readBoolean() ? dataInputStream.readUTF() : null;
        this.missingInt = dataInputStream.readInt();
        this.missingLong = dataInputStream.readLong();
        this.missingFloat = dataInputStream.readFloat();
        this.missingDouble = dataInputStream.readDouble();
        this.missingCategory = dataInputStream.readInt();
        for (n2 = 0; n2 < n4; ++n2) {
            block20: for (n = 0; n < n5; ++n) {
                switch (this.columnTypes[n]) {
                    case 0: {
                        String string = null;
                        if (dataInputStream.readBoolean()) {
                            string = dataInputStream.readUTF();
                        }
                        this.setString(n2, n, string);
                        continue block20;
                    }
                    case 1: {
                        this.setInt(n2, n, dataInputStream.readInt());
                        continue block20;
                    }
                    case 2: {
                        this.setLong(n2, n, dataInputStream.readLong());
                        continue block20;
                    }
                    case 3: {
                        this.setFloat(n2, n, dataInputStream.readFloat());
                        continue block20;
                    }
                    case 4: {
                        this.setDouble(n2, n, dataInputStream.readDouble());
                        continue block20;
                    }
                    case 5: {
                        int n6 = dataInputStream.readInt();
                        this.setInt(n2, n, n6);
                    }
                }
            }
        }
        dataInputStream.close();
    }

    public void addColumn() {
        this.addColumn(null, 0);
    }

    public void addColumn(String string) {
        this.addColumn(string, 0);
    }

    public void addColumn(String string, int n) {
        this.insertColumn(this.columns.length, string, n);
    }

    public void insertColumn(int n) {
        this.insertColumn(n, null, 0);
    }

    public void insertColumn(int n, String string) {
        this.insertColumn(n, string, 0);
    }

    public void insertColumn(int n, String string, int n2) {
        int n3;
        if (string != null && this.columnTitles == null) {
            this.columnTitles = new String[this.columns.length];
        }
        if (this.columnTitles != null) {
            this.columnTitles = PApplet.splice(this.columnTitles, string, n);
            this.columnIndices = null;
        }
        this.columnTypes = PApplet.splice(this.columnTypes, n2, n);
        HashMapBlows[] hashMapBlowsArray = new HashMapBlows[this.columns.length + 1];
        for (n3 = 0; n3 < n; ++n3) {
            hashMapBlowsArray[n3] = this.columnCategories[n3];
        }
        hashMapBlowsArray[n] = new HashMapBlows();
        for (n3 = n; n3 < this.columns.length; ++n3) {
            hashMapBlowsArray[n3 + 1] = this.columnCategories[n3];
        }
        this.columnCategories = hashMapBlowsArray;
        Object[] objectArray = new Object[this.columns.length + 1];
        System.arraycopy(this.columns, 0, objectArray, 0, n);
        System.arraycopy(this.columns, n, objectArray, n + 1, this.columns.length - n);
        this.columns = objectArray;
        switch (n2) {
            case 1: {
                this.columns[n] = new int[this.rowCount];
                break;
            }
            case 2: {
                this.columns[n] = new long[this.rowCount];
                break;
            }
            case 3: {
                this.columns[n] = new float[this.rowCount];
                break;
            }
            case 4: {
                this.columns[n] = new double[this.rowCount];
                break;
            }
            case 0: {
                this.columns[n] = new String[this.rowCount];
                break;
            }
            case 5: {
                this.columns[n] = new int[this.rowCount];
            }
        }
    }

    public void removeColumn(String string) {
        this.removeColumn(this.getColumnIndex(string));
    }

    public void removeColumn(int n) {
        int n2;
        int n3 = this.columns.length - 1;
        Object[] objectArray = new Object[n3];
        HashMapBlows[] hashMapBlowsArray = new HashMapBlows[n3];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray[n2] = this.columns[n2];
            hashMapBlowsArray[n2] = this.columnCategories[n2];
        }
        for (n2 = n; n2 < n3; ++n2) {
            objectArray[n2] = this.columns[n2 + 1];
            hashMapBlowsArray[n2] = this.columnCategories[n2 + 1];
        }
        this.columns = objectArray;
        this.columnCategories = hashMapBlowsArray;
        if (this.columnTitles != null) {
            int n4;
            String[] stringArray = new String[n3];
            for (n4 = 0; n4 < n; ++n4) {
                stringArray[n4] = this.columnTitles[n4];
            }
            for (n4 = n; n4 < n3; ++n4) {
                stringArray[n4] = this.columnTitles[n4 + 1];
            }
            this.columnTitles = stringArray;
            this.columnIndices = null;
        }
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public void setColumnCount(int n) {
        int n2 = this.columns.length;
        if (n2 != n) {
            this.columns = (Object[])PApplet.expand(this.columns, n);
            for (int i = n2; i < n; ++i) {
                this.columns[i] = new String[this.rowCount];
            }
            if (this.columnTitles != null) {
                this.columnTitles = PApplet.expand(this.columnTitles, n);
            }
            this.columnTypes = PApplet.expand(this.columnTypes, n);
            this.columnCategories = (HashMapBlows[])PApplet.expand(this.columnCategories, n);
        }
    }

    public void setColumnType(String string, String string2) {
        this.setColumnType(this.checkColumnIndex(string), string2);
    }

    public void setColumnType(int n, String string) {
        int n2 = -1;
        if (string.equals("String")) {
            n2 = 0;
        } else if (string.equals("int")) {
            n2 = 1;
        } else if (string.equals("long")) {
            n2 = 2;
        } else if (string.equals("float")) {
            n2 = 3;
        } else if (string.equals("double")) {
            n2 = 4;
        } else if (string.equals("category")) {
            n2 = 5;
        } else {
            throw new IllegalArgumentException("'" + string + "' is not a valid column type.");
        }
        this.setColumnType(n, n2);
    }

    public void setColumnType(String string, int n) {
        this.setColumnType(this.checkColumnIndex(string), n);
    }

    public void setColumnType(int n, int n2) {
        switch (n2) {
            case 1: {
                int[] nArray = new int[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    String string = this.getString(i, n);
                    nArray[i] = PApplet.parseInt(string, this.missingInt);
                }
                this.columns[n] = nArray;
                break;
            }
            case 2: {
                long[] lArray = new long[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    String string = this.getString(i, n);
                    try {
                        lArray[i] = Long.parseLong(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        lArray[i] = this.missingLong;
                    }
                }
                this.columns[n] = lArray;
                break;
            }
            case 3: {
                float[] fArray = new float[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    String string = this.getString(i, n);
                    fArray[i] = PApplet.parseFloat(string, this.missingFloat);
                }
                this.columns[n] = fArray;
                break;
            }
            case 4: {
                double[] dArray = new double[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    String string = this.getString(i, n);
                    try {
                        dArray[i] = Double.parseDouble(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        dArray[i] = this.missingDouble;
                    }
                }
                this.columns[n] = dArray;
                break;
            }
            case 0: {
                if (this.columnTypes[n] == 0) break;
                String[] stringArray = new String[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    stringArray[i] = this.getString(i, n);
                }
                this.columns[n] = stringArray;
                break;
            }
            case 5: {
                int[] nArray = new int[this.rowCount];
                HashMapBlows hashMapBlows = new HashMapBlows();
                for (int i = 0; i < this.rowCount; ++i) {
                    String string = this.getString(i, n);
                    nArray[i] = hashMapBlows.index(string);
                }
                this.columnCategories[n] = hashMapBlows;
                this.columns[n] = nArray;
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
        this.columnTypes[n] = n2;
    }

    public void setTableType(String string) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.setColumnType(i, string);
        }
    }

    public void setColumnTypes(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.setColumnType(i, nArray[i]);
        }
    }

    public void setColumnTypes(Table table) {
        block6: {
            int n = 0;
            int n2 = 1;
            if (table.hasColumnTitles()) {
                n = table.getColumnIndex("title", true);
                n2 = table.getColumnIndex("type", true);
            }
            this.setColumnTitles(table.getStringColumn(n));
            final String[] stringArray = table.getStringColumn(n2);
            if (table.getColumnCount() <= 1) break block6;
            if (this.getRowCount() > 1000) {
                int n3 = Runtime.getRuntime().availableProcessors();
                ExecutorService executorService = Executors.newFixedThreadPool(n3 / 2);
                int n4 = 0;
                while (n4 < table.getRowCount()) {
                    final int n5 = n4++;
                    executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            Table.this.setColumnType(n5, stringArray[n5]);
                        }
                    });
                }
                executorService.shutdown();
                while (!executorService.isTerminated()) {
                    Thread.yield();
                }
            } else {
                for (int i = 0; i < table.getRowCount(); ++i) {
                    this.setColumnType(i, stringArray[i]);
                }
            }
        }
    }

    public int getColumnType(String string) {
        return this.getColumnType(this.getColumnIndex(string));
    }

    public int getColumnType(int n) {
        return this.columnTypes[n];
    }

    public int[] getColumnTypes() {
        return this.columnTypes;
    }

    @Deprecated
    public String[] removeTitleRow() {
        String[] stringArray = this.getStringRow(0);
        this.removeRow(0);
        this.setColumnTitles(stringArray);
        return stringArray;
    }

    public void setColumnTitles(String[] stringArray) {
        if (stringArray != null) {
            this.ensureColumn(stringArray.length - 1);
        }
        this.columnTitles = stringArray;
        this.columnIndices = null;
    }

    public void setColumnTitle(int n, String string) {
        this.ensureColumn(n);
        if (this.columnTitles == null) {
            this.columnTitles = new String[this.getColumnCount()];
        }
        this.columnTitles[n] = string;
        this.columnIndices = null;
    }

    public boolean hasColumnTitles() {
        return this.columnTitles != null;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public String getColumnTitle(int n) {
        return this.columnTitles == null ? null : this.columnTitles[n];
    }

    public int getColumnIndex(String string) {
        return this.getColumnIndex(string, true);
    }

    protected int getColumnIndex(String string, boolean bl) {
        Integer n;
        if (this.columnTitles == null) {
            if (bl) {
                throw new IllegalArgumentException("This table has no header, so no column titles are set.");
            }
            return -1;
        }
        if (this.columnIndices == null) {
            this.columnIndices = new HashMap();
            for (int i = 0; i < this.columns.length; ++i) {
                this.columnIndices.put(this.columnTitles[i], i);
            }
        }
        if ((n = this.columnIndices.get(string)) == null) {
            if (bl) {
                throw new IllegalArgumentException("This table has no column named '" + string + "'");
            }
            return -1;
        }
        return n;
    }

    public int checkColumnIndex(String string) {
        int n = this.getColumnIndex(string, false);
        if (n != -1) {
            return n;
        }
        this.addColumn(string);
        return this.getColumnCount() - 1;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int lastRowIndex() {
        return this.getRowCount() - 1;
    }

    public void clearRows() {
        this.setRowCount(0);
    }

    public void setRowCount(int n) {
        if (n != this.rowCount) {
            int n2;
            if (n > 1000000) {
                System.out.print("Note: setting maximum row count to " + PApplet.nfc(n));
            }
            long l = System.currentTimeMillis();
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                switch (this.columnTypes[n2]) {
                    case 1: {
                        this.columns[n2] = PApplet.expand((int[])this.columns[n2], n);
                        break;
                    }
                    case 2: {
                        this.columns[n2] = PApplet.expand((Object)((long[])this.columns[n2]), n);
                        break;
                    }
                    case 3: {
                        this.columns[n2] = PApplet.expand((float[])this.columns[n2], n);
                        break;
                    }
                    case 4: {
                        this.columns[n2] = PApplet.expand((double[])this.columns[n2], n);
                        break;
                    }
                    case 0: {
                        this.columns[n2] = PApplet.expand((String[])this.columns[n2], n);
                        break;
                    }
                    case 5: {
                        this.columns[n2] = PApplet.expand((int[])this.columns[n2], n);
                    }
                }
                if (n <= 1000000) continue;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (n > 1000000) {
                n2 = (int)(System.currentTimeMillis() - l);
                System.out.println(" (resize took " + PApplet.nfc(n2) + " ms)");
            }
        }
        this.rowCount = n;
    }

    public TableRow addRow() {
        this.setRowCount(this.rowCount + 1);
        return new RowPointer(this, this.rowCount - 1);
    }

    public TableRow addRow(TableRow tableRow) {
        int n = this.rowCount;
        this.ensureBounds(n, tableRow.getColumnCount() - 1);
        block7: for (int i = 0; i < this.columns.length; ++i) {
            switch (this.columnTypes[i]) {
                case 1: 
                case 5: {
                    this.setInt(n, i, tableRow.getInt(i));
                    continue block7;
                }
                case 2: {
                    this.setLong(n, i, tableRow.getLong(i));
                    continue block7;
                }
                case 3: {
                    this.setFloat(n, i, tableRow.getFloat(i));
                    continue block7;
                }
                case 4: {
                    this.setDouble(n, i, tableRow.getDouble(i));
                    continue block7;
                }
                case 0: {
                    this.setString(n, i, tableRow.getString(i));
                    continue block7;
                }
                default: {
                    throw new RuntimeException("no types");
                }
            }
        }
        return new RowPointer(this, n);
    }

    public TableRow addRow(Object[] objectArray) {
        this.setRow(this.getRowCount(), objectArray);
        return new RowPointer(this, this.rowCount - 1);
    }

    public void insertRow(int n, Object[] objectArray) {
        block7: for (int i = 0; i < this.columns.length; ++i) {
            switch (this.columnTypes[i]) {
                case 1: 
                case 5: {
                    Object[] objectArray2 = new int[this.rowCount + 1];
                    System.arraycopy(this.columns[i], 0, objectArray2, 0, n);
                    System.arraycopy(this.columns[i], n, objectArray2, n + 1, this.rowCount - n + 1);
                    this.columns[i] = objectArray2;
                    continue block7;
                }
                case 2: {
                    Object[] objectArray2 = new long[this.rowCount + 1];
                    System.arraycopy(this.columns[i], 0, objectArray2, 0, n);
                    System.arraycopy(this.columns[i], n, objectArray2, n + 1, this.rowCount - n + 1);
                    this.columns[i] = objectArray2;
                    continue block7;
                }
                case 3: {
                    Object[] objectArray2 = new float[this.rowCount + 1];
                    System.arraycopy(this.columns[i], 0, objectArray2, 0, n);
                    System.arraycopy(this.columns[i], n, objectArray2, n + 1, this.rowCount - n + 1);
                    this.columns[i] = objectArray2;
                    continue block7;
                }
                case 4: {
                    Object[] objectArray2 = new double[this.rowCount + 1];
                    System.arraycopy(this.columns[i], 0, objectArray2, 0, n);
                    System.arraycopy(this.columns[i], n, objectArray2, n + 1, this.rowCount - n + 1);
                    this.columns[i] = objectArray2;
                    continue block7;
                }
                case 0: {
                    Object[] objectArray2 = new String[this.rowCount + 1];
                    System.arraycopy(this.columns[i], 0, objectArray2, 0, n);
                    System.arraycopy(this.columns[i], n, objectArray2, n + 1, this.rowCount - n + 1);
                    this.columns[i] = objectArray2;
                    continue block7;
                }
            }
        }
        this.setRow(n, objectArray);
        ++this.rowCount;
    }

    public void removeRow(int n) {
        block7: for (int i = 0; i < this.columns.length; ++i) {
            switch (this.columnTypes[i]) {
                case 1: 
                case 5: {
                    Object[] objectArray = new int[this.rowCount - 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n + 1, objectArray, n, this.rowCount - n - 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 2: {
                    Object[] objectArray = new long[this.rowCount - 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n + 1, objectArray, n, this.rowCount - n - 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 3: {
                    Object[] objectArray = new float[this.rowCount - 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n + 1, objectArray, n, this.rowCount - n - 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 4: {
                    Object[] objectArray = new double[this.rowCount - 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n + 1, objectArray, n, this.rowCount - n - 1);
                    this.columns[i] = objectArray;
                    continue block7;
                }
                case 0: {
                    Object[] objectArray = new String[this.rowCount - 1];
                    System.arraycopy(this.columns[i], 0, objectArray, 0, n);
                    System.arraycopy(this.columns[i], n + 1, objectArray, n, this.rowCount - n - 1);
                    this.columns[i] = objectArray;
                }
            }
        }
        --this.rowCount;
    }

    public void setRow(int n, Object[] objectArray) {
        this.ensureBounds(n, objectArray.length - 1);
        for (int i = 0; i < objectArray.length; ++i) {
            this.setRowCol(n, i, objectArray[i]);
        }
    }

    protected void setRowCol(int n, int n2, Object object) {
        switch (this.columnTypes[n2]) {
            case 0: {
                String[] stringArray = (String[])this.columns[n2];
                if (object == null) {
                    stringArray[n] = null;
                    break;
                }
                stringArray[n] = String.valueOf(object);
                break;
            }
            case 1: {
                int[] nArray = (int[])this.columns[n2];
                if (object == null) {
                    nArray[n] = this.missingInt;
                    break;
                }
                if (object instanceof Integer) {
                    nArray[n] = (Integer)object;
                    break;
                }
                nArray[n] = PApplet.parseInt(String.valueOf(object), this.missingInt);
                break;
            }
            case 2: {
                long[] lArray = (long[])this.columns[n2];
                if (object == null) {
                    lArray[n] = this.missingLong;
                    break;
                }
                if (object instanceof Long) {
                    lArray[n] = (Long)object;
                    break;
                }
                try {
                    lArray[n] = Long.parseLong(String.valueOf(object));
                }
                catch (NumberFormatException numberFormatException) {
                    lArray[n] = this.missingLong;
                }
                break;
            }
            case 3: {
                float[] fArray = (float[])this.columns[n2];
                if (object == null) {
                    fArray[n] = this.missingFloat;
                    break;
                }
                if (object instanceof Float) {
                    fArray[n] = ((Float)object).floatValue();
                    break;
                }
                fArray[n] = PApplet.parseFloat(String.valueOf(object), this.missingFloat);
                break;
            }
            case 4: {
                double[] dArray = (double[])this.columns[n2];
                if (object == null) {
                    dArray[n] = this.missingDouble;
                    break;
                }
                if (object instanceof Double) {
                    dArray[n] = (Double)object;
                    break;
                }
                try {
                    dArray[n] = Double.parseDouble(String.valueOf(object));
                }
                catch (NumberFormatException numberFormatException) {
                    dArray[n] = this.missingDouble;
                }
                break;
            }
            case 5: {
                int[] nArray = (int[])this.columns[n2];
                if (object == null) {
                    nArray[n] = this.missingCategory;
                    break;
                }
                nArray[n] = this.columnCategories[n2].index(String.valueOf(object));
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
    }

    public TableRow getRow(int n) {
        return new RowPointer(this, n);
    }

    public Iterable<TableRow> rows() {
        return new Iterable<TableRow>(){

            @Override
            public Iterator<TableRow> iterator() {
                if (Table.this.rowIterator == null) {
                    Table.this.rowIterator = new RowIterator(Table.this);
                } else {
                    Table.this.rowIterator.reset();
                }
                return Table.this.rowIterator;
            }
        };
    }

    public Iterable<TableRow> rows(final int[] nArray) {
        return new Iterable<TableRow>(){

            @Override
            public Iterator<TableRow> iterator() {
                return new RowIndexIterator(Table.this, nArray);
            }
        };
    }

    public int getInt(int n, int n2) {
        this.checkBounds(n, n2);
        if (this.columnTypes[n2] == 1 || this.columnTypes[n2] == 5) {
            int[] nArray = (int[])this.columns[n2];
            return nArray[n];
        }
        String string = this.getString(n, n2);
        return string == null || string.equals(this.missingString) ? this.missingInt : PApplet.parseInt(string, this.missingInt);
    }

    public int getInt(int n, String string) {
        return this.getInt(n, this.getColumnIndex(string));
    }

    public void setMissingInt(int n) {
        this.missingInt = n;
    }

    public void setInt(int n, int n2, int n3) {
        if (this.columnTypes[n2] == 0) {
            this.setString(n, n2, String.valueOf(n3));
        } else {
            this.ensureBounds(n, n2);
            if (this.columnTypes[n2] != 1 && this.columnTypes[n2] != 5) {
                throw new IllegalArgumentException("Column " + n2 + " is not an int column.");
            }
            int[] nArray = (int[])this.columns[n2];
            nArray[n] = n3;
        }
    }

    public void setInt(int n, String string, int n2) {
        this.setInt(n, this.getColumnIndex(string), n2);
    }

    public int[] getIntColumn(String string) {
        int n = this.getColumnIndex(string);
        return n == -1 ? null : this.getIntColumn(n);
    }

    public int[] getIntColumn(int n) {
        int[] nArray = new int[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            nArray[i] = this.getInt(i, n);
        }
        return nArray;
    }

    public int[] getIntRow(int n) {
        int[] nArray = new int[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            nArray[i] = this.getInt(n, i);
        }
        return nArray;
    }

    public long getLong(int n, int n2) {
        this.checkBounds(n, n2);
        if (this.columnTypes[n2] == 2) {
            long[] lArray = (long[])this.columns[n2];
            return lArray[n];
        }
        String string = this.getString(n, n2);
        if (string == null || string.equals(this.missingString)) {
            return this.missingLong;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.missingLong;
        }
    }

    public long getLong(int n, String string) {
        return this.getLong(n, this.getColumnIndex(string));
    }

    public void setMissingLong(long l) {
        this.missingLong = l;
    }

    public void setLong(int n, int n2, long l) {
        if (this.columnTypes[n2] == 0) {
            this.setString(n, n2, String.valueOf(l));
        } else {
            this.ensureBounds(n, n2);
            if (this.columnTypes[n2] != 2) {
                throw new IllegalArgumentException("Column " + n2 + " is not a 'long' column.");
            }
            long[] lArray = (long[])this.columns[n2];
            lArray[n] = l;
        }
    }

    public void setLong(int n, String string, long l) {
        this.setLong(n, this.getColumnIndex(string), l);
    }

    public long[] getLongColumn(String string) {
        int n = this.getColumnIndex(string);
        return n == -1 ? null : this.getLongColumn(n);
    }

    public long[] getLongColumn(int n) {
        long[] lArray = new long[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            lArray[i] = this.getLong(i, n);
        }
        return lArray;
    }

    public long[] getLongRow(int n) {
        long[] lArray = new long[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            lArray[i] = this.getLong(n, i);
        }
        return lArray;
    }

    public float getFloat(int n, int n2) {
        this.checkBounds(n, n2);
        if (this.columnTypes[n2] == 3) {
            float[] fArray = (float[])this.columns[n2];
            return fArray[n];
        }
        String string = this.getString(n, n2);
        if (string == null || string.equals(this.missingString)) {
            return this.missingFloat;
        }
        return PApplet.parseFloat(string, this.missingFloat);
    }

    public float getFloat(int n, String string) {
        return this.getFloat(n, this.getColumnIndex(string));
    }

    public void setMissingFloat(float f) {
        this.missingFloat = f;
    }

    public void setFloat(int n, int n2, float f) {
        if (this.columnTypes[n2] == 0) {
            this.setString(n, n2, String.valueOf(f));
        } else {
            this.ensureBounds(n, n2);
            if (this.columnTypes[n2] != 3) {
                throw new IllegalArgumentException("Column " + n2 + " is not a float column.");
            }
            float[] fArray = (float[])this.columns[n2];
            fArray[n] = f;
        }
    }

    public void setFloat(int n, String string, float f) {
        this.setFloat(n, this.getColumnIndex(string), f);
    }

    public float[] getFloatColumn(String string) {
        int n = this.getColumnIndex(string);
        return n == -1 ? null : this.getFloatColumn(n);
    }

    public float[] getFloatColumn(int n) {
        float[] fArray = new float[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            fArray[i] = this.getFloat(i, n);
        }
        return fArray;
    }

    public float[] getFloatRow(int n) {
        float[] fArray = new float[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            fArray[i] = this.getFloat(n, i);
        }
        return fArray;
    }

    public double getDouble(int n, int n2) {
        this.checkBounds(n, n2);
        if (this.columnTypes[n2] == 4) {
            double[] dArray = (double[])this.columns[n2];
            return dArray[n];
        }
        String string = this.getString(n, n2);
        if (string == null || string.equals(this.missingString)) {
            return this.missingDouble;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.missingDouble;
        }
    }

    public double getDouble(int n, String string) {
        return this.getDouble(n, this.getColumnIndex(string));
    }

    public void setMissingDouble(double d) {
        this.missingDouble = d;
    }

    public void setDouble(int n, int n2, double d) {
        if (this.columnTypes[n2] == 0) {
            this.setString(n, n2, String.valueOf(d));
        } else {
            this.ensureBounds(n, n2);
            if (this.columnTypes[n2] != 4) {
                throw new IllegalArgumentException("Column " + n2 + " is not a 'double' column.");
            }
            double[] dArray = (double[])this.columns[n2];
            dArray[n] = d;
        }
    }

    public void setDouble(int n, String string, double d) {
        this.setDouble(n, this.getColumnIndex(string), d);
    }

    public double[] getDoubleColumn(String string) {
        int n = this.getColumnIndex(string);
        return n == -1 ? null : this.getDoubleColumn(n);
    }

    public double[] getDoubleColumn(int n) {
        double[] dArray = new double[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            dArray[i] = this.getDouble(i, n);
        }
        return dArray;
    }

    public double[] getDoubleRow(int n) {
        double[] dArray = new double[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            dArray[i] = this.getDouble(n, i);
        }
        return dArray;
    }

    public String getString(int n, int n2) {
        this.checkBounds(n, n2);
        if (this.columnTypes[n2] == 0) {
            String[] stringArray = (String[])this.columns[n2];
            return stringArray[n];
        }
        if (this.columnTypes[n2] == 5) {
            int n3 = this.getInt(n, n2);
            if (n3 == this.missingCategory) {
                return this.missingString;
            }
            return this.columnCategories[n2].key(n3);
        }
        return String.valueOf(Array.get(this.columns[n2], n));
    }

    public String getString(int n, String string) {
        return this.getString(n, this.getColumnIndex(string));
    }

    public void setMissingString(String string) {
        this.missingString = string;
    }

    public void setString(int n, int n2, String string) {
        this.ensureBounds(n, n2);
        if (this.columnTypes[n2] != 0) {
            throw new IllegalArgumentException("Column " + n2 + " is not a String column.");
        }
        String[] stringArray = (String[])this.columns[n2];
        stringArray[n] = string;
    }

    public void setString(int n, String string, String string2) {
        int n2 = this.checkColumnIndex(string);
        this.setString(n, n2, string2);
    }

    public String[] getStringColumn(String string) {
        int n = this.getColumnIndex(string);
        return n == -1 ? null : this.getStringColumn(n);
    }

    public String[] getStringColumn(int n) {
        String[] stringArray = new String[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            stringArray[i] = this.getString(i, n);
        }
        return stringArray;
    }

    public String[] getStringRow(int n) {
        String[] stringArray = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            stringArray[i] = this.getString(n, i);
        }
        return stringArray;
    }

    public int findRowIndex(String string, int n) {
        this.checkColumn(n);
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            if (string == null) {
                for (int i = 0; i < this.rowCount; ++i) {
                    if (stringArray[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.rowCount; ++i) {
                    if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
                    return i;
                }
            }
        } else {
            for (int i = 0; i < this.rowCount; ++i) {
                String string2 = this.getString(i, n);
                if (!(string2 == null ? string == null : string2.equals(string))) continue;
                return i;
            }
        }
        return -1;
    }

    public int findRowIndex(String string, String string2) {
        return this.findRowIndex(string, this.getColumnIndex(string2));
    }

    public int[] findRowIndices(String string, int n) {
        int[] nArray = new int[this.rowCount];
        int n2 = 0;
        this.checkColumn(n);
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            if (string == null) {
                for (int i = 0; i < this.rowCount; ++i) {
                    if (stringArray[i] != null) continue;
                    nArray[n2++] = i;
                }
            } else {
                for (int i = 0; i < this.rowCount; ++i) {
                    if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
                    nArray[n2++] = i;
                }
            }
        } else {
            for (int i = 0; i < this.rowCount; ++i) {
                String string2 = this.getString(i, n);
                if (string2 == null) {
                    if (string != null) continue;
                    nArray[n2++] = i;
                    continue;
                }
                if (!string2.equals(string)) continue;
                nArray[n2++] = i;
            }
        }
        return PApplet.subset(nArray, 0, n2);
    }

    public int[] findRowIndices(String string, String string2) {
        return this.findRowIndices(string, this.getColumnIndex(string2));
    }

    public TableRow findRow(String string, int n) {
        int n2 = this.findRowIndex(string, n);
        return n2 == -1 ? null : new RowPointer(this, n2);
    }

    public TableRow findRow(String string, String string2) {
        return this.findRow(string, this.getColumnIndex(string2));
    }

    public Iterable<TableRow> findRows(final String string, final int n) {
        return new Iterable<TableRow>(){

            @Override
            public Iterator<TableRow> iterator() {
                return Table.this.findRowIterator(string, n);
            }
        };
    }

    public Iterable<TableRow> findRows(String string, String string2) {
        return this.findRows(string, this.getColumnIndex(string2));
    }

    public Iterator<TableRow> findRowIterator(String string, int n) {
        return new RowIndexIterator(this, this.findRowIndices(string, n));
    }

    public Iterator<TableRow> findRowIterator(String string, String string2) {
        return this.findRowIterator(string, this.getColumnIndex(string2));
    }

    public int matchRowIndex(String string, int n) {
        this.checkColumn(n);
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            for (int i = 0; i < this.rowCount; ++i) {
                if (stringArray[i] == null || PApplet.match(stringArray[i], string) == null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.rowCount; ++i) {
                String string2 = this.getString(i, n);
                if (string2 == null || PApplet.match(string2, string) == null) continue;
                return i;
            }
        }
        return -1;
    }

    public int matchRowIndex(String string, String string2) {
        return this.matchRowIndex(string, this.getColumnIndex(string2));
    }

    public int[] matchRowIndices(String string, int n) {
        int[] nArray = new int[this.rowCount];
        int n2 = 0;
        this.checkColumn(n);
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            for (int i = 0; i < this.rowCount; ++i) {
                if (stringArray[i] == null || PApplet.match(stringArray[i], string) == null) continue;
                nArray[n2++] = i;
            }
        } else {
            for (int i = 0; i < this.rowCount; ++i) {
                String string2 = this.getString(i, n);
                if (string2 == null || PApplet.match(string2, string) == null) continue;
                nArray[n2++] = i;
            }
        }
        return PApplet.subset(nArray, 0, n2);
    }

    public int[] matchRowIndices(String string, String string2) {
        return this.matchRowIndices(string, this.getColumnIndex(string2));
    }

    public TableRow matchRow(String string, int n) {
        int n2 = this.matchRowIndex(string, n);
        return n2 == -1 ? null : new RowPointer(this, n2);
    }

    public TableRow matchRow(String string, String string2) {
        return this.matchRow(string, this.getColumnIndex(string2));
    }

    public Iterable<TableRow> matchRows(final String string, final int n) {
        return new Iterable<TableRow>(){

            @Override
            public Iterator<TableRow> iterator() {
                return Table.this.matchRowIterator(string, n);
            }
        };
    }

    public Iterable<TableRow> matchRows(String string, String string2) {
        return this.matchRows(string, this.getColumnIndex(string2));
    }

    public Iterator<TableRow> matchRowIterator(String string, int n) {
        return new RowIndexIterator(this, this.matchRowIndices(string, n));
    }

    public Iterator<TableRow> matchRowIterator(String string, String string2) {
        return this.matchRowIterator(string, this.getColumnIndex(string2));
    }

    public void replace(String string, String string2) {
        for (int i = 0; i < this.columns.length; ++i) {
            this.replace(string, string2, i);
        }
    }

    public void replace(String string, String string2, int n) {
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            for (int i = 0; i < this.rowCount; ++i) {
                if (!stringArray[i].equals(string)) continue;
                stringArray[i] = string2;
            }
        }
    }

    public void replace(String string, String string2, String string3) {
        this.replace(string, string2, this.getColumnIndex(string3));
    }

    public void replaceAll(String string, String string2) {
        for (int i = 0; i < this.columns.length; ++i) {
            this.replaceAll(string, string2, i);
        }
    }

    public void replaceAll(String string, String string2, int n) {
        this.checkColumn(n);
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            for (int i = 0; i < this.rowCount; ++i) {
                if (stringArray[i] == null) continue;
                stringArray[i] = stringArray[i].replaceAll(string, string2);
            }
        } else {
            throw new IllegalArgumentException("replaceAll() can only be used on String columns");
        }
    }

    public void replaceAll(String string, String string2, String string3) {
        this.replaceAll(string, string2, this.getColumnIndex(string3));
    }

    public void removeTokens(String string) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.removeTokens(string, i);
        }
    }

    public void removeTokens(String string, int n) {
        for (int i = 0; i < this.rowCount; ++i) {
            String string2 = this.getString(i, n);
            if (string2 == null) continue;
            char[] cArray = string2.toCharArray();
            int n2 = 0;
            for (int j = 0; j < cArray.length; ++j) {
                if (string.indexOf(cArray[j]) != -1) continue;
                if (n2 != j) {
                    cArray[n2] = cArray[j];
                }
                ++n2;
            }
            if (n2 == cArray.length) continue;
            this.setString(i, n, new String(cArray, 0, n2));
        }
    }

    public void removeTokens(String string, String string2) {
        this.removeTokens(string, this.getColumnIndex(string2));
    }

    public void trim() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.trim(i);
        }
    }

    public void trim(int n) {
        if (this.columnTypes[n] == 0) {
            String[] stringArray = (String[])this.columns[n];
            for (int i = 0; i < this.rowCount; ++i) {
                if (stringArray[i] == null) continue;
                stringArray[i] = PApplet.trim(stringArray[i]);
            }
        }
    }

    public void trim(String string) {
        this.trim(this.getColumnIndex(string));
    }

    protected void ensureColumn(int n) {
        if (n >= this.columns.length) {
            this.setColumnCount(n + 1);
        }
    }

    protected void ensureRow(int n) {
        if (n >= this.rowCount) {
            this.setRowCount(n + 1);
        }
    }

    protected void ensureBounds(int n, int n2) {
        this.ensureRow(n);
        this.ensureColumn(n2);
    }

    protected void checkRow(int n) {
        if (n < 0 || n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException("Row " + n + " does not exist.");
        }
    }

    protected void checkColumn(int n) {
        if (n < 0 || n >= this.columns.length) {
            throw new ArrayIndexOutOfBoundsException("Column " + n + " does not exist.");
        }
    }

    protected void checkBounds(int n, int n2) {
        this.checkRow(n);
        this.checkColumn(n2);
    }

    public void sort(String string) {
        this.sort(this.getColumnIndex(string), false);
    }

    public void sort(int n) {
        this.sort(n, false);
    }

    public void sortReverse(String string) {
        this.sort(this.getColumnIndex(string), true);
    }

    public void sortReverse(int n) {
        this.sort(n, true);
    }

    protected void sort(final int n, final boolean bl) {
        final int[] nArray = IntList.fromRange(this.getRowCount()).array();
        Sort sort = new Sort(){

            @Override
            public int size() {
                return Table.this.getRowCount();
            }

            @Override
            public float compare(int n5, int n2) {
                int n3 = bl ? nArray[n2] : nArray[n5];
                int n4 = bl ? nArray[n5] : nArray[n2];
                switch (Table.this.getColumnType(n)) {
                    case 1: {
                        return Table.this.getInt(n3, n) - Table.this.getInt(n4, n);
                    }
                    case 2: {
                        return Table.this.getLong(n3, n) - Table.this.getLong(n4, n);
                    }
                    case 3: {
                        return Table.this.getFloat(n3, n) - Table.this.getFloat(n4, n);
                    }
                    case 4: {
                        return (float)(Table.this.getDouble(n3, n) - Table.this.getDouble(n4, n));
                    }
                    case 0: {
                        return Table.this.getString(n3, n).compareToIgnoreCase(Table.this.getString(n4, n));
                    }
                    case 5: {
                        return Table.this.getInt(n3, n) - Table.this.getInt(n4, n);
                    }
                }
                throw new IllegalArgumentException("Invalid column type: " + Table.this.getColumnType(n));
            }

            @Override
            public void swap(int n4, int n2) {
                int n3 = nArray[n4];
                nArray[n4] = nArray[n2];
                nArray[n2] = n3;
            }
        };
        sort.run();
        block7: for (int i = 0; i < this.getColumnCount(); ++i) {
            switch (this.getColumnType(i)) {
                case 1: 
                case 5: {
                    int[] nArray2 = (int[])this.columns[i];
                    int[] nArray3 = new int[this.rowCount];
                    for (int j = 0; j < this.getRowCount(); ++j) {
                        nArray3[j] = nArray2[nArray[j]];
                    }
                    this.columns[i] = nArray3;
                    continue block7;
                }
                case 2: {
                    long[] lArray = (long[])this.columns[i];
                    long[] lArray2 = new long[this.rowCount];
                    for (int j = 0; j < this.getRowCount(); ++j) {
                        lArray2[j] = lArray[nArray[j]];
                    }
                    this.columns[i] = lArray2;
                    continue block7;
                }
                case 3: {
                    float[] fArray = (float[])this.columns[i];
                    float[] fArray2 = new float[this.rowCount];
                    for (int j = 0; j < this.getRowCount(); ++j) {
                        fArray2[j] = fArray[nArray[j]];
                    }
                    this.columns[i] = fArray2;
                    continue block7;
                }
                case 4: {
                    double[] dArray = (double[])this.columns[i];
                    double[] dArray2 = new double[this.rowCount];
                    for (int j = 0; j < this.getRowCount(); ++j) {
                        dArray2[j] = dArray[nArray[j]];
                    }
                    this.columns[i] = dArray2;
                    continue block7;
                }
                case 0: {
                    String[] stringArray = (String[])this.columns[i];
                    String[] stringArray2 = new String[this.rowCount];
                    for (int j = 0; j < this.getRowCount(); ++j) {
                        stringArray2[j] = stringArray[nArray[j]];
                    }
                    this.columns[i] = stringArray2;
                }
            }
        }
    }

    public String[] getUnique(String string) {
        return this.getUnique(this.getColumnIndex(string));
    }

    public String[] getUnique(int n) {
        StringList stringList = new StringList(this.getStringColumn(n));
        return stringList.getUnique();
    }

    public IntDict getTally(String string) {
        return this.getTally(this.getColumnIndex(string));
    }

    public IntDict getTally(int n) {
        StringList stringList = new StringList(this.getStringColumn(n));
        return stringList.getTally();
    }

    public IntDict getOrder(String string) {
        return this.getOrder(this.getColumnIndex(string));
    }

    public IntDict getOrder(int n) {
        StringList stringList = new StringList(this.getStringColumn(n));
        return stringList.getOrder();
    }

    public IntList getIntList(String string) {
        return new IntList(this.getIntColumn(string));
    }

    public IntList getIntList(int n) {
        return new IntList(this.getIntColumn(n));
    }

    public FloatList getFloatList(String string) {
        return new FloatList(this.getFloatColumn(string));
    }

    public FloatList getFloatList(int n) {
        return new FloatList(this.getFloatColumn(n));
    }

    public StringList getStringList(String string) {
        return new StringList(this.getStringColumn(string));
    }

    public StringList getStringList(int n) {
        return new StringList(this.getStringColumn(n));
    }

    public IntDict getIntDict(String string, String string2) {
        return new IntDict(this.getStringColumn(string), this.getIntColumn(string2));
    }

    public IntDict getIntDict(int n, int n2) {
        return new IntDict(this.getStringColumn(n), this.getIntColumn(n2));
    }

    public FloatDict getFloatDict(String string, String string2) {
        return new FloatDict(this.getStringColumn(string), this.getFloatColumn(string2));
    }

    public FloatDict getFloatDict(int n, int n2) {
        return new FloatDict(this.getStringColumn(n), this.getFloatColumn(n2));
    }

    public StringDict getStringDict(String string, String string2) {
        return new StringDict(this.getStringColumn(string), this.getStringColumn(string2));
    }

    public StringDict getStringDict(int n, int n2) {
        return new StringDict(this.getStringColumn(n), this.getStringColumn(n2));
    }

    protected Table createSubset(int[] nArray) {
        Table table = new Table();
        table.setColumnTitles(this.columnTitles);
        table.columnTypes = this.columnTypes;
        table.setRowCount(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            block8: for (int j = 0; j < this.columns.length; ++j) {
                switch (this.columnTypes[j]) {
                    case 0: {
                        table.setString(i, j, this.getString(n, j));
                        continue block8;
                    }
                    case 1: {
                        table.setInt(i, j, this.getInt(n, j));
                        continue block8;
                    }
                    case 2: {
                        table.setLong(i, j, this.getLong(n, j));
                        continue block8;
                    }
                    case 3: {
                        table.setFloat(i, j, this.getFloat(n, j));
                        continue block8;
                    }
                    case 4: {
                        table.setDouble(i, j, this.getDouble(n, j));
                    }
                }
            }
        }
        return table;
    }

    protected float getMaxFloat() {
        boolean bl = false;
        float f = -3.4028235E38f;
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                float f2 = this.getFloat(i, j);
                if (Float.isNaN(f2)) continue;
                if (!bl) {
                    f = f2;
                    bl = true;
                    continue;
                }
                if (!(f2 > f)) continue;
                f = f2;
            }
        }
        return bl ? f : this.missingFloat;
    }

    protected void convertBasic(BufferedReader bufferedReader, boolean bl, File file) throws IOException {
        String string;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 16384);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this.getColumnCount());
        if (this.columnTitles != null) {
            dataOutputStream.writeBoolean(true);
            for (String string2 : this.columnTitles) {
                dataOutputStream.writeUTF(string2);
            }
        } else {
            dataOutputStream.writeBoolean(false);
        }
        for (int n : this.columnTypes) {
            dataOutputStream.writeInt(n);
        }
        Object var7_9 = null;
        int n = -1;
        int n2 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            int n3;
            this.convertRow(dataOutputStream, bl ? PApplet.split(string, '\t') : Table.splitLineCSV(string));
            if (++n2 % 10000 != 0 || n2 >= this.rowCount || (n3 = 100 * n2 / this.rowCount) == n) continue;
            System.out.println(n3 + "%");
            n = n3;
        }
        int n4 = 0;
        for (HashMapBlows hashMapBlows : this.columnCategories) {
            if (hashMapBlows == null) {
                dataOutputStream.writeInt(0);
            } else {
                hashMapBlows.write(dataOutputStream);
                hashMapBlows.writeln(PApplet.createWriter(new File(this.columnTitles[n4] + ".categories")));
            }
            ++n4;
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.writeInt(this.rowCount);
        randomAccessFile.close();
    }

    protected void convertRow(DataOutputStream dataOutputStream, String[] stringArray) throws IOException {
        int n;
        if (stringArray.length > this.getColumnCount()) {
            throw new IllegalArgumentException("Row with too many columns: " + PApplet.join(stringArray, ","));
        }
        block20: for (n = 0; n < stringArray.length; ++n) {
            switch (this.columnTypes[n]) {
                case 0: {
                    dataOutputStream.writeUTF(stringArray[n]);
                    continue block20;
                }
                case 1: {
                    dataOutputStream.writeInt(PApplet.parseInt(stringArray[n], this.missingInt));
                    continue block20;
                }
                case 2: {
                    try {
                        dataOutputStream.writeLong(Long.parseLong(stringArray[n]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        dataOutputStream.writeLong(this.missingLong);
                    }
                    continue block20;
                }
                case 3: {
                    dataOutputStream.writeFloat(PApplet.parseFloat(stringArray[n], this.missingFloat));
                    continue block20;
                }
                case 4: {
                    try {
                        dataOutputStream.writeDouble(Double.parseDouble(stringArray[n]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        dataOutputStream.writeDouble(this.missingDouble);
                    }
                    continue block20;
                }
                case 5: {
                    dataOutputStream.writeInt(this.columnCategories[n].index(stringArray[n]));
                }
            }
        }
        block21: for (n = stringArray.length; n < this.getColumnCount(); ++n) {
            switch (this.columnTypes[n]) {
                case 0: {
                    dataOutputStream.writeUTF("");
                    continue block21;
                }
                case 1: {
                    dataOutputStream.writeInt(this.missingInt);
                    continue block21;
                }
                case 2: {
                    dataOutputStream.writeLong(this.missingLong);
                    continue block21;
                }
                case 3: {
                    dataOutputStream.writeFloat(this.missingFloat);
                    continue block21;
                }
                case 4: {
                    dataOutputStream.writeDouble(this.missingDouble);
                    continue block21;
                }
                case 5: {
                    dataOutputStream.writeInt(this.missingCategory);
                }
            }
        }
    }

    class HashMapBlows {
        HashMap<String, Integer> dataToIndex = new HashMap();
        ArrayList<String> indexToData = new ArrayList();

        HashMapBlows() {
        }

        HashMapBlows(DataInputStream dataInputStream) throws IOException {
            this.read(dataInputStream);
        }

        int index(String string) {
            Integer n = this.dataToIndex.get(string);
            if (n != null) {
                return n;
            }
            int n2 = this.dataToIndex.size();
            this.dataToIndex.put(string, n2);
            this.indexToData.add(string);
            return n2;
        }

        String key(int n) {
            return this.indexToData.get(n);
        }

        int size() {
            return this.dataToIndex.size();
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.size());
            for (String string : this.indexToData) {
                dataOutputStream.writeUTF(string);
            }
        }

        private void writeln(PrintWriter printWriter) throws IOException {
            for (String string : this.indexToData) {
                printWriter.println(string);
            }
            printWriter.flush();
            printWriter.close();
        }

        void read(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            this.dataToIndex = new HashMap(n);
            for (int i = 0; i < n; ++i) {
                String string = dataInputStream.readUTF();
                this.dataToIndex.put(string, i);
                this.indexToData.add(string);
            }
        }
    }

    static class RowIndexIterator
    implements Iterator<TableRow> {
        Table table;
        RowPointer rp;
        int[] indices;
        int index;

        public RowIndexIterator(Table table, int[] nArray) {
            this.table = table;
            this.indices = nArray;
            this.index = -1;
            this.rp = new RowPointer(table, -1);
        }

        @Override
        public void remove() {
            this.table.removeRow(this.indices[this.index]);
        }

        @Override
        public TableRow next() {
            this.rp.setRow(this.indices[++this.index]);
            return this.rp;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.indices.length;
        }

        public void reset() {
            this.index = -1;
        }
    }

    static class RowIterator
    implements Iterator<TableRow> {
        Table table;
        RowPointer rp;
        int row;

        public RowIterator(Table table) {
            this.table = table;
            this.row = -1;
            this.rp = new RowPointer(table, this.row);
        }

        @Override
        public void remove() {
            this.table.removeRow(this.row);
        }

        @Override
        public TableRow next() {
            this.rp.setRow(++this.row);
            return this.rp;
        }

        @Override
        public boolean hasNext() {
            return this.row + 1 < this.table.getRowCount();
        }

        public void reset() {
            this.row = -1;
        }
    }

    static class RowPointer
    implements TableRow {
        Table table;
        int row;

        public RowPointer(Table table, int n) {
            this.table = table;
            this.row = n;
        }

        public void setRow(int n) {
            this.row = n;
        }

        @Override
        public String getString(int n) {
            return this.table.getString(this.row, n);
        }

        @Override
        public String getString(String string) {
            return this.table.getString(this.row, string);
        }

        @Override
        public int getInt(int n) {
            return this.table.getInt(this.row, n);
        }

        @Override
        public int getInt(String string) {
            return this.table.getInt(this.row, string);
        }

        @Override
        public long getLong(int n) {
            return this.table.getLong(this.row, n);
        }

        @Override
        public long getLong(String string) {
            return this.table.getLong(this.row, string);
        }

        @Override
        public float getFloat(int n) {
            return this.table.getFloat(this.row, n);
        }

        @Override
        public float getFloat(String string) {
            return this.table.getFloat(this.row, string);
        }

        @Override
        public double getDouble(int n) {
            return this.table.getDouble(this.row, n);
        }

        @Override
        public double getDouble(String string) {
            return this.table.getDouble(this.row, string);
        }

        @Override
        public void setString(int n, String string) {
            this.table.setString(this.row, n, string);
        }

        @Override
        public void setString(String string, String string2) {
            this.table.setString(this.row, string, string2);
        }

        @Override
        public void setInt(int n, int n2) {
            this.table.setInt(this.row, n, n2);
        }

        @Override
        public void setInt(String string, int n) {
            this.table.setInt(this.row, string, n);
        }

        @Override
        public void setLong(int n, long l) {
            this.table.setLong(this.row, n, l);
        }

        @Override
        public void setLong(String string, long l) {
            this.table.setLong(this.row, string, l);
        }

        @Override
        public void setFloat(int n, float f) {
            this.table.setFloat(this.row, n, f);
        }

        @Override
        public void setFloat(String string, float f) {
            this.table.setFloat(this.row, string, f);
        }

        @Override
        public void setDouble(int n, double d) {
            this.table.setDouble(this.row, n, d);
        }

        @Override
        public void setDouble(String string, double d) {
            this.table.setDouble(this.row, string, d);
        }

        @Override
        public int getColumnCount() {
            return this.table.getColumnCount();
        }

        @Override
        public int getColumnType(String string) {
            return this.table.getColumnType(string);
        }

        @Override
        public int getColumnType(int n) {
            return this.table.getColumnType(n);
        }

        @Override
        public int[] getColumnTypes() {
            return this.table.getColumnTypes();
        }
    }
}

