/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.IntDict;
import processing.data.Sort;

public class StringList
implements Iterable<String> {
    int count;
    String[] data;

    public StringList() {
        this(10);
    }

    public StringList(int n) {
        this.data = new String[n];
    }

    public StringList(String[] stringArray) {
        this.count = stringArray.length;
        this.data = new String[this.count];
        System.arraycopy(stringArray, 0, this.data, 0, this.count);
    }

    public StringList(Iterable<String> iterable) {
        this(10);
        for (String string : iterable) {
            this.append(string);
        }
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int n) {
        if (n > this.data.length) {
            String[] stringArray = new String[n];
            System.arraycopy(this.data, 0, stringArray, 0, this.count);
            this.data = stringArray;
        } else if (n > this.count) {
            Arrays.fill(this.data, this.count, n, (Object)0);
        }
        this.count = n;
    }

    public void clear() {
        this.count = 0;
    }

    public String get(int n) {
        return this.data[n];
    }

    public void set(int n, String string) {
        if (n >= this.count) {
            this.data = PApplet.expand(this.data, n + 1);
            for (int i = this.count; i < n; ++i) {
                this.data[i] = null;
            }
            this.count = n + 1;
        }
        this.data[n] = string;
    }

    public String remove(int n) {
        if (n < 0 || n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        String string = this.data[n];
        for (int i = n; i < this.count - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        --this.count;
        return string;
    }

    public int removeValue(String string) {
        if (string == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != null) continue;
                this.remove(i);
                return i;
            }
        } else {
            int n = this.index(string);
            if (n != -1) {
                this.remove(n);
                return n;
            }
        }
        return -1;
    }

    public int removeValues(String string) {
        int n;
        int n2 = 0;
        if (string == null) {
            for (n = 0; n < this.count; ++n) {
                if (this.data[n] == null) continue;
                this.data[n2++] = this.data[n];
            }
        } else {
            for (n = 0; n < this.count; ++n) {
                if (string.equals(this.data[n])) continue;
                this.data[n2++] = this.data[n];
            }
        }
        n = this.count - n2;
        this.count = n2;
        return n;
    }

    public int replaceValue(String string, String string2) {
        if (string == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = string2;
                return i;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (!string.equals(this.data[i])) continue;
                this.data[i] = string2;
                return i;
            }
        }
        return -1;
    }

    public int replaceValues(String string, String string2) {
        int n = 0;
        if (string == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = string2;
                ++n;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (!string.equals(this.data[i])) continue;
                this.data[i] = string2;
                ++n;
            }
        }
        return n;
    }

    public void append(String string) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = string;
    }

    public void append(String[] stringArray) {
        for (String string : stringArray) {
            this.append(string);
        }
    }

    public void append(StringList stringList) {
        for (String string : stringList.values()) {
            this.append(string);
        }
    }

    public void insert(int n, String[] stringArray) {
        if (n < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + n);
        }
        if (n >= stringArray.length) {
            throw new IllegalArgumentException("insert() index " + n + " is past the end of this list");
        }
        String[] stringArray2 = new String[this.count + stringArray.length];
        System.arraycopy(this.data, 0, stringArray2, 0, Math.min(this.count, n));
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        System.arraycopy(this.data, n, stringArray2, n + stringArray.length, this.count - n);
        this.count += stringArray.length;
        this.data = stringArray2;
    }

    public void insert(int n, StringList stringList) {
        this.insert(n, stringList.values());
    }

    public int index(String string) {
        if (string == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (!string.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean hasValue(String string) {
        if (string == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (!string.equals(this.data[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void sort() {
        this.sortImpl(false);
    }

    public void sortReverse() {
        this.sortImpl(true);
    }

    private void sortImpl(final boolean bl) {
        new Sort(){

            @Override
            public int size() {
                return StringList.this.count;
            }

            @Override
            public float compare(int n, int n2) {
                float f = StringList.this.data[n].compareToIgnoreCase(StringList.this.data[n2]);
                return bl ? -f : f;
            }

            @Override
            public void swap(int n, int n2) {
                String string = StringList.this.data[n];
                StringList.this.data[n] = StringList.this.data[n2];
                StringList.this.data[n2] = string;
            }
        }.run();
    }

    public void reverse() {
        int n = this.count - 1;
        for (int i = 0; i < this.count / 2; ++i) {
            String string = this.data[i];
            this.data[i] = this.data[n];
            this.data[n] = string;
            --n;
        }
    }

    public void shuffle() {
        Random random = new Random();
        int n = this.count;
        while (n > 1) {
            int n2 = random.nextInt(n);
            String string = this.data[--n];
            this.data[n] = this.data[n2];
            this.data[n2] = string;
        }
    }

    public void shuffle(PApplet pApplet) {
        int n = this.count;
        while (n > 1) {
            int n2 = (int)pApplet.random(n);
            String string = this.data[--n];
            this.data[n] = this.data[n2];
            this.data[n2] = string;
        }
    }

    public void lower() {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] == null) continue;
            this.data[i] = this.data[i].toLowerCase();
        }
    }

    public void upper() {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] == null) continue;
            this.data[i] = this.data[i].toUpperCase();
        }
    }

    public StringList copy() {
        StringList stringList = new StringList(this.data);
        stringList.count = this.count;
        return stringList;
    }

    public String[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                StringList.this.remove(this.index);
            }

            @Override
            public String next() {
                return StringList.this.data[++this.index];
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < StringList.this.count;
            }
        };
    }

    public String[] array() {
        return this.array(null);
    }

    public String[] array(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.count) {
            stringArray = new String[this.count];
        }
        System.arraycopy(this.data, 0, stringArray, 0, this.count);
        return stringArray;
    }

    public StringList getSubset(int n) {
        return this.getSubset(n, this.count - n);
    }

    public StringList getSubset(int n, int n2) {
        String[] stringArray = new String[n2];
        System.arraycopy(this.data, n, stringArray, 0, n2);
        return new StringList(stringArray);
    }

    public String[] getUnique() {
        return this.getTally().keyArray();
    }

    public IntDict getTally() {
        IntDict intDict = new IntDict();
        for (int i = 0; i < this.count; ++i) {
            intDict.increment(this.data[i]);
        }
        return intDict;
    }

    public IntDict getOrder() {
        IntDict intDict = new IntDict();
        for (int i = 0; i < this.count; ++i) {
            intDict.set(this.data[i], i);
        }
        return intDict;
    }

    public String join(String string) {
        if (this.count == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.data[0]);
        for (int i = 1; i < this.count; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(this.data[i]);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + " size=" + this.size() + " [ ");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(i + ": \"" + this.data[i] + "\"");
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

