/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import processing.core.PApplet;
import processing.data.FloatDict;
import processing.data.IntDict;
import processing.data.JSONArray;
import processing.data.JSONTokener;
import processing.data.StringDict;

public class JSONObject {
    private static final int keyPoolSize = 100;
    private static HashMap<String, Object> keyPool = new HashMap(100);
    private final HashMap<String, Object> map = new HashMap();
    public static final Object NULL = new Null();

    public JSONObject() {
    }

    public JSONObject(Reader reader) {
        this(new JSONTokener(reader));
    }

    protected JSONObject(JSONTokener jSONTokener) {
        this();
        if (jSONTokener.nextClean() != '{') {
            throw new RuntimeException("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = jSONTokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw new RuntimeException("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jSONTokener.back();
            String string = jSONTokener.nextValue().toString();
            c = jSONTokener.nextClean();
            if (c == '=') {
                if (jSONTokener.next() != '>') {
                    jSONTokener.back();
                }
            } else if (c != ':') {
                throw new RuntimeException("Expected a ':' after a key");
            }
            this.putOnce(string, jSONTokener.nextValue());
            switch (jSONTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == '}') {
                        return;
                    }
                    jSONTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw new RuntimeException("Expected a ',' or '}'");
    }

    protected JSONObject(HashMap<String, Object> hashMap) {
        if (hashMap != null) {
            for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
                Object object = entry.getValue();
                if (object == null) continue;
                hashMap.put(entry.getKey(), JSONObject.wrap(object));
            }
        }
    }

    public JSONObject(IntDict intDict) {
        for (int i = 0; i < intDict.size(); ++i) {
            this.setInt(intDict.key(i), intDict.value(i));
        }
    }

    public JSONObject(FloatDict floatDict) {
        for (int i = 0; i < floatDict.size(); ++i) {
            this.setFloat(floatDict.key(i), floatDict.value(i));
        }
    }

    public JSONObject(StringDict stringDict) {
        for (int i = 0; i < stringDict.size(); ++i) {
            this.setString(stringDict.key(i), stringDict.value(i));
        }
    }

    protected JSONObject(Object object) {
        this();
        this.populateMap(object);
    }

    public static JSONObject parse(String string) {
        return new JSONObject(new JSONTokener(string));
    }

    protected static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private Object get(String string) {
        if (string == null) {
            throw new RuntimeException("Null key.");
        }
        Object object = this.opt(string);
        if (object == null) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(string) + "] not found.");
        }
        return object;
    }

    public String getString(String string) {
        Object object = this.get(string);
        if (object instanceof String) {
            return (String)object;
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(string) + "] not a string.");
    }

    public String getString(String string, String string2) {
        Object object = this.opt(string);
        return NULL.equals(object) ? string2 : object.toString();
    }

    public int getInt(String string) {
        Object object = this.get(string);
        try {
            return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(string) + "] is not an int.");
        }
    }

    public int getInt(String string, int n) {
        try {
            return this.getInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public long getLong(String string) {
        Object object = this.get(string);
        try {
            return object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
        }
        catch (Exception exception) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(string) + "] is not a long.", exception);
        }
    }

    public long getLong(String string, long l) {
        try {
            return this.getLong(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public float getFloat(String string) {
        return (float)this.getDouble(string);
    }

    public float getFloat(String string, float f) {
        try {
            return this.getFloat(string);
        }
        catch (Exception exception) {
            return f;
        }
    }

    public double getDouble(String string) {
        Object object = this.get(string);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(string) + "] is not a number.");
        }
    }

    public double getDouble(String string, double d) {
        try {
            return this.getDouble(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public boolean getBoolean(String string) {
        Object object = this.get(string);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(string) + "] is not a Boolean.");
    }

    public boolean getBoolean(String string, boolean bl) {
        try {
            return this.getBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public JSONArray getJSONArray(String string) {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String string) {
        Object object = this.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONObject.");
    }

    public boolean hasKey(String string) {
        return this.map.containsKey(string);
    }

    public boolean isNull(String string) {
        return NULL.equals(this.opt(string));
    }

    public Iterator keyIterator() {
        return this.map.keySet().iterator();
    }

    public Set keys() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    private static String numberToString(Number number) {
        if (number == null) {
            throw new RuntimeException("Null pointer");
        }
        JSONObject.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private Object opt(String string) {
        return string == null ? null : this.map.get(string);
    }

    private void populateMap(Object object) {
        Class<?> clazz = object.getClass();
        boolean bl = clazz.getClassLoader() != null;
        Method[] methodArray = bl ? clazz.getMethods() : clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            try {
                Method method = methodArray[i];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String string = method.getName();
                String string2 = "";
                if (string.startsWith("get")) {
                    string2 = "getClass".equals(string) || "getDeclaringClass".equals(string) ? "" : string.substring(3);
                } else if (string.startsWith("is")) {
                    string2 = string.substring(2);
                }
                if (string2.length() <= 0 || !Character.isUpperCase(string2.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (string2.length() == 1) {
                    string2 = string2.toLowerCase();
                } else if (!Character.isUpperCase(string2.charAt(1))) {
                    string2 = string2.substring(0, 1).toLowerCase() + string2.substring(1);
                }
                Object object2 = method.invoke(object, (Object[])null);
                if (object2 == null) continue;
                this.map.put(string2, JSONObject.wrap(object2));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject setString(String string, String string2) {
        return this.put(string, string2);
    }

    public JSONObject setInt(String string, int n) {
        this.put(string, new Integer(n));
        return this;
    }

    public JSONObject setLong(String string, long l) {
        this.put(string, new Long(l));
        return this;
    }

    public JSONObject setFloat(String string, float f) {
        this.put(string, new Double(f));
        return this;
    }

    public JSONObject setDouble(String string, double d) {
        this.put(string, new Double(d));
        return this;
    }

    public JSONObject setBoolean(String string, boolean bl) {
        this.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject setJSONObject(String string, JSONObject jSONObject) {
        return this.put(string, jSONObject);
    }

    public JSONObject setJSONArray(String string, JSONArray jSONArray) {
        return this.put(string, jSONArray);
    }

    private JSONObject put(String string, Object object) {
        if (string == null) {
            throw new RuntimeException("Null key.");
        }
        if (object != null) {
            JSONObject.testValidity(object);
            String string2 = (String)keyPool.get(string);
            if (string2 == null) {
                if (keyPool.size() >= 100) {
                    keyPool = new HashMap(100);
                }
                keyPool.put(string, string);
            } else {
                string = string2;
            }
            this.map.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    private JSONObject putOnce(String string, Object object) {
        if (string != null && object != null) {
            if (this.opt(string) != null) {
                throw new RuntimeException("Duplicate key \"" + string + "\"");
            }
            this.put(string, object);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String quote(String string) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        synchronized (stringBuffer) {
            try {
                return JSONObject.quote(string, stringWriter).toString();
            }
            catch (IOException iOException) {
                return "";
            }
        }
    }

    protected static Writer quote(String string, Writer writer) throws IOException {
        if (string == null || string.length() == 0) {
            writer.write("\"\"");
            return writer;
        }
        char c = '\u0000';
        int n = string.length();
        writer.write(34);
        block9: for (int i = 0; i < n; ++i) {
            char c2 = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.write(92);
                    writer.write(c);
                    continue block9;
                }
                case '/': {
                    if (c2 == '<') {
                        writer.write(92);
                    }
                    writer.write(c);
                    continue block9;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block9;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block9;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block9;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block9;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        writer.write("\\u");
                        String string2 = Integer.toHexString(c);
                        writer.write("0000", 0, 4 - string2.length());
                        writer.write(string2);
                        continue block9;
                    }
                    writer.write(c);
                }
            }
        }
        writer.write(34);
        return writer;
    }

    public Object remove(String string) {
        return this.map.remove(string);
    }

    protected static Object stringToValue(String string) {
        block10: {
            if (string.equals("")) {
                return string;
            }
            if (string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if (string.equalsIgnoreCase("null")) {
                return NULL;
            }
            char c = string.charAt(0);
            if (c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+') {
                try {
                    if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                        Double d = Double.valueOf(string);
                        if (!d.isInfinite() && !d.isNaN()) {
                            return d;
                        }
                        break block10;
                    }
                    Long l = new Long(string);
                    if (l == (long)l.intValue()) {
                        return new Integer(l.intValue());
                    }
                    return l;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    protected static void testValidity(Object object) {
        if (object != null && (object instanceof Double ? ((Double)object).isInfinite() || ((Double)object).isNaN() : object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN()))) {
            throw new RuntimeException("JSON does not allow non-finite numbers.");
        }
    }

    public boolean save(File file, String string) {
        return this.write(PApplet.createWriter(file));
    }

    public boolean write(PrintWriter printWriter) {
        printWriter.print(this.format(2));
        printWriter.flush();
        return true;
    }

    public String toString() {
        try {
            return this.format(2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(int n) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        synchronized (stringBuffer) {
            return this.write(stringWriter, n, 0).toString();
        }
    }

    protected static String valueToString(Object object) {
        if (object == null || object.equals(null)) {
            return "null";
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean || object instanceof JSONObject || object instanceof JSONArray) {
            return object.toString();
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object).toString();
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString();
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString();
        }
        return JSONObject.quote(object.toString());
    }

    protected static Object wrap(Object object) {
        try {
            String string;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            Package package_ = object.getClass().getPackage();
            String string2 = string = package_ != null ? package_.getName() : "";
            if (string.startsWith("java.") || string.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static final Writer writeValue(Writer writer, Object object, int n, int n2) throws IOException {
        if (object == null || object.equals(null)) {
            writer.write("null");
        } else if (object instanceof JSONObject) {
            ((JSONObject)object).write(writer, n, n2);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).write(writer, n, n2);
        } else if (object instanceof Map) {
            new JSONObject((Map)object).write(writer, n, n2);
        } else if (object instanceof Collection) {
            new JSONArray((Collection)object).write(writer, n, n2);
        } else if (object.getClass().isArray()) {
            new JSONArray(object).write(writer, n, n2);
        } else if (object instanceof Number) {
            writer.write(JSONObject.numberToString((Number)object));
        } else if (object instanceof Boolean) {
            writer.write(object.toString());
        } else {
            JSONObject.quote(object.toString(), writer);
        }
        return writer;
    }

    static final void indent(Writer writer, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write(32);
        }
    }

    protected Writer write(Writer writer, int n, int n2) {
        try {
            int n3;
            boolean bl = false;
            int n4 = this.size();
            Iterator iterator = this.keyIterator();
            writer.write(123);
            int n5 = n3 = n == -1 ? 0 : n;
            if (n4 == 1) {
                Object e = iterator.next();
                writer.write(JSONObject.quote(e.toString()));
                writer.write(58);
                if (n3 > 0) {
                    writer.write(32);
                }
                JSONObject.writeValue(writer, this.map.get(e), n3, n2);
            } else if (n4 != 0) {
                int n6 = n2 + n3;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (bl) {
                        writer.write(44);
                    }
                    if (n != -1) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, n6);
                    writer.write(JSONObject.quote(e.toString()));
                    writer.write(58);
                    if (n3 > 0) {
                        writer.write(32);
                    }
                    JSONObject.writeValue(writer, this.map.get(e), n3, n6);
                    bl = true;
                }
                if (n != -1) {
                    writer.write(10);
                }
                JSONObject.indent(writer, n2);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

