/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.IntList;
import processing.data.Sort;

public class FloatList
implements Iterable<Float> {
    int count;
    float[] data;

    public FloatList() {
        this.data = new float[10];
    }

    public FloatList(int n) {
        this.data = new float[n];
    }

    public FloatList(float[] fArray) {
        this.count = fArray.length;
        this.data = new float[this.count];
        System.arraycopy(fArray, 0, this.data, 0, this.count);
    }

    public FloatList(Iterable<Float> iterable) {
        this(10);
        for (float f : iterable) {
            this.append(f);
        }
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int n) {
        if (n > this.data.length) {
            float[] fArray = new float[n];
            System.arraycopy(this.data, 0, fArray, 0, this.count);
            this.data = fArray;
        } else if (n > this.count) {
            Arrays.fill(this.data, this.count, n, 0.0f);
        }
        this.count = n;
    }

    public void clear() {
        this.count = 0;
    }

    public float get(int n) {
        return this.data[n];
    }

    public void set(int n, float f) {
        if (n >= this.count) {
            this.data = PApplet.expand(this.data, n + 1);
            for (int i = this.count; i < n; ++i) {
                this.data[i] = 0.0f;
            }
            this.count = n + 1;
        }
        this.data[n] = f;
    }

    public float remove(int n) {
        if (n < 0 || n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        float f = this.data[n];
        for (int i = n; i < this.count - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        --this.count;
        return f;
    }

    public int removeValue(int n) {
        int n2 = this.index(n);
        if (n2 != -1) {
            this.remove(n2);
            return n2;
        }
        return -1;
    }

    public int removeValues(int n) {
        int n2;
        int n3 = 0;
        if (Float.isNaN(n)) {
            for (n2 = 0; n2 < this.count; ++n2) {
                if (Float.isNaN(this.data[n2])) continue;
                this.data[n3++] = this.data[n2];
            }
        } else {
            for (n2 = 0; n2 < this.count; ++n2) {
                if (this.data[n2] == (float)n) continue;
                this.data[n3++] = this.data[n2];
            }
        }
        n2 = this.count - n3;
        this.count = n3;
        return n2;
    }

    public boolean replaceValue(float f, float f2) {
        if (Float.isNaN(f)) {
            for (int i = 0; i < this.count; ++i) {
                if (!Float.isNaN(this.data[i])) continue;
                this.data[i] = f2;
                return true;
            }
        } else {
            int n = this.index(f);
            if (n != -1) {
                this.data[n] = f2;
                return true;
            }
        }
        return false;
    }

    public boolean replaceValues(float f, float f2) {
        boolean bl = false;
        if (Float.isNaN(f)) {
            for (int i = 0; i < this.count; ++i) {
                if (!Float.isNaN(this.data[i])) continue;
                this.data[i] = f2;
                bl = true;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != f) continue;
                this.data[i] = f2;
                bl = true;
            }
        }
        return bl;
    }

    public void append(float f) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = f;
    }

    public void append(float[] fArray) {
        for (float f : fArray) {
            this.append(f);
        }
    }

    public void append(FloatList floatList) {
        for (float f : floatList.values()) {
            this.append(f);
        }
    }

    public void insert(int n, int[] nArray) {
        if (n < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + n);
        }
        if (n >= this.data.length) {
            throw new IllegalArgumentException("insert() index " + n + " is past the end of this list");
        }
        float[] fArray = new float[this.count + nArray.length];
        System.arraycopy(this.data, 0, fArray, 0, Math.min(this.count, n));
        System.arraycopy(nArray, 0, fArray, n, nArray.length);
        System.arraycopy(this.data, n, fArray, n + nArray.length, this.count - n);
        this.count += nArray.length;
        this.data = fArray;
    }

    public void insert(int n, IntList intList) {
        this.insert(n, intList.values());
    }

    public int index(float f) {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != f) continue;
            return i;
        }
        return -1;
    }

    public boolean hasValue(float f) {
        if (Float.isNaN(f)) {
            for (int i = 0; i < this.count; ++i) {
                if (!Float.isNaN(this.data[i])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != f) continue;
                return true;
            }
        }
        return false;
    }

    public void add(int n, float f) {
        int n2 = n;
        this.data[n2] = this.data[n2] + f;
    }

    public void sub(int n, float f) {
        int n2 = n;
        this.data[n2] = this.data[n2] - f;
    }

    public void mult(int n, float f) {
        int n2 = n;
        this.data[n2] = this.data[n2] * f;
    }

    public void div(int n, float f) {
        int n2 = n;
        this.data[n2] = this.data[n2] / f;
    }

    private void checkMinMax(String string) {
        if (this.count == 0) {
            String string2 = String.format("Cannot use %s() on an empty %s.", string, this.getClass().getSimpleName());
            throw new RuntimeException(string2);
        }
    }

    public float min() {
        this.checkMinMax("min");
        int n = this.minIndex();
        return n == -1 ? Float.NaN : this.data[n];
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        float f = Float.NaN;
        int n = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != this.data[i]) continue;
            f = this.data[i];
            n = i;
            for (int j = i + 1; j < this.count; ++j) {
                float f2 = this.data[j];
                if (Float.isNaN(f2) || !(f2 < f)) continue;
                f = this.data[j];
                n = j;
            }
            break;
        }
        return n;
    }

    public float max() {
        this.checkMinMax("max");
        int n = this.maxIndex();
        return n == -1 ? Float.NaN : this.data[n];
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        float f = Float.NaN;
        int n = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != this.data[i]) continue;
            f = this.data[i];
            n = i;
            for (int j = i + 1; j < this.count; ++j) {
                float f2 = this.data[j];
                if (Float.isNaN(f2) || !(f2 > f)) continue;
                f = this.data[j];
                n = j;
            }
            break;
        }
        return n;
    }

    public float sum() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += (double)this.data[i];
        }
        return (float)d;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.count);
    }

    public void sortReverse() {
        new Sort(){

            @Override
            public int size() {
                return FloatList.this.count;
            }

            @Override
            public float compare(int n, int n2) {
                return FloatList.this.data[n2] - FloatList.this.data[n];
            }

            @Override
            public void swap(int n, int n2) {
                float f = FloatList.this.data[n];
                FloatList.this.data[n] = FloatList.this.data[n2];
                FloatList.this.data[n2] = f;
            }
        }.run();
    }

    public void reverse() {
        int n = this.count - 1;
        for (int i = 0; i < this.count / 2; ++i) {
            float f = this.data[i];
            this.data[i] = this.data[n];
            this.data[n] = f;
            --n;
        }
    }

    public void shuffle() {
        Random random = new Random();
        int n = this.count;
        while (n > 1) {
            int n2 = random.nextInt(n);
            float f = this.data[--n];
            this.data[n] = this.data[n2];
            this.data[n2] = f;
        }
    }

    public void shuffle(PApplet pApplet) {
        int n = this.count;
        while (n > 1) {
            int n2 = (int)pApplet.random(n);
            float f = this.data[--n];
            this.data[n] = this.data[n2];
            this.data[n2] = f;
        }
    }

    public FloatList copy() {
        FloatList floatList = new FloatList(this.data);
        floatList.count = this.count;
        return floatList;
    }

    public float[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){
            int index = -1;

            @Override
            public void remove() {
                FloatList.this.remove(this.index);
            }

            @Override
            public Float next() {
                return Float.valueOf(FloatList.this.data[++this.index]);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatList.this.count;
            }
        };
    }

    public float[] array() {
        return this.array(null);
    }

    public float[] array(float[] fArray) {
        if (fArray == null || fArray.length != this.count) {
            fArray = new float[this.count];
        }
        System.arraycopy(this.data, 0, fArray, 0, this.count);
        return fArray;
    }

    public FloatList getPercent() {
        double d = 0.0;
        for (float f : this.array()) {
            d += (double)f;
        }
        Object object = new FloatList(this.count);
        for (int i = 0; i < this.count; ++i) {
            double d2 = (double)this.data[i] / d;
            ((FloatList)object).set(i, (float)d2);
        }
        return object;
    }

    public FloatList getSubset(int n) {
        return this.getSubset(n, this.count - n);
    }

    public FloatList getSubset(int n, int n2) {
        float[] fArray = new float[n2];
        System.arraycopy(this.data, n, fArray, 0, n2);
        return new FloatList(fArray);
    }

    public String join(String string) {
        if (this.count == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.data[0]);
        for (int i = 1; i < this.count; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(this.data[i]);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + " size=" + this.size() + " [ ");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(i + ": " + this.data[i]);
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

