/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.Sort;

public class FloatDict {
    protected int count;
    protected String[] keys;
    protected float[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public FloatDict() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new float[10];
    }

    public FloatDict(int n) {
        this.count = 0;
        this.keys = new String[n];
        this.values = new float[n];
    }

    public FloatDict(BufferedReader bufferedReader) {
        String[] stringArray = PApplet.loadStrings(bufferedReader);
        this.keys = new String[stringArray.length];
        this.values = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = PApplet.split(stringArray[i], '\t');
            if (stringArray2.length != 2) continue;
            this.keys[this.count] = stringArray2[0];
            this.values[this.count] = PApplet.parseFloat(stringArray2[1]);
            ++this.count;
        }
    }

    public FloatDict(String[] stringArray, float[] fArray) {
        if (stringArray.length != fArray.length) {
            throw new IllegalArgumentException("key and value arrays must be the same length");
        }
        this.keys = stringArray;
        this.values = fArray;
        this.count = stringArray.length;
        for (int i = 0; i < this.count; ++i) {
            this.indices.put(stringArray[i], i);
        }
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.indices = new HashMap();
    }

    public String key(int n) {
        return this.keys[n];
    }

    protected void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int index = -1;

                    @Override
                    public void remove() {
                        FloatDict.this.removeIndex(this.index);
                    }

                    @Override
                    public String next() {
                        return FloatDict.this.key(++this.index);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index + 1 < FloatDict.this.size();
                    }
                };
            }
        };
    }

    public String[] keyArray() {
        return this.keyArray(null);
    }

    public String[] keyArray(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.count) {
            stringArray = new String[this.count];
        }
        System.arraycopy(this.keys, 0, stringArray, 0, this.count);
        return stringArray;
    }

    public float value(int n) {
        return this.values[n];
    }

    public Iterable<Float> values() {
        return new Iterable<Float>(){

            @Override
            public Iterator<Float> iterator() {
                return new Iterator<Float>(){
                    int index = -1;

                    @Override
                    public void remove() {
                        FloatDict.this.removeIndex(this.index);
                    }

                    @Override
                    public Float next() {
                        return Float.valueOf(FloatDict.this.value(++this.index));
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index + 1 < FloatDict.this.size();
                    }
                };
            }
        };
    }

    public float[] valueArray() {
        return this.valueArray(null);
    }

    public float[] valueArray(float[] fArray) {
        if (fArray == null || fArray.length != this.size()) {
            fArray = new float[this.count];
        }
        System.arraycopy(this.values, 0, fArray, 0, this.count);
        return fArray;
    }

    public float get(String string) {
        int n = this.index(string);
        if (n == -1) {
            return 0.0f;
        }
        return this.values[n];
    }

    public void set(String string, float f) {
        int n = this.index(string);
        if (n == -1) {
            this.create(string, f);
        } else {
            this.values[n] = f;
        }
    }

    public boolean hasKey(String string) {
        return this.index(string) != -1;
    }

    public void add(String string, float f) {
        int n = this.index(string);
        if (n == -1) {
            this.create(string, f);
        } else {
            int n2 = n;
            this.values[n2] = this.values[n2] + f;
        }
    }

    public void sub(String string, float f) {
        this.add(string, -f);
    }

    public void mult(String string, float f) {
        int n = this.index(string);
        if (n != -1) {
            int n2 = n;
            this.values[n2] = this.values[n2] * f;
        }
    }

    public void div(String string, float f) {
        int n = this.index(string);
        if (n != -1) {
            int n2 = n;
            this.values[n2] = this.values[n2] / f;
        }
    }

    private void checkMinMax(String string) {
        if (this.count == 0) {
            String string2 = String.format("Cannot use %s() on an empty %s.", string, this.getClass().getSimpleName());
            throw new RuntimeException(string2);
        }
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        float f = Float.NaN;
        int n = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.values[i] != this.values[i]) continue;
            f = this.values[i];
            n = i;
            for (int j = i + 1; j < this.count; ++j) {
                float f2 = this.values[j];
                if (Float.isNaN(f2) || !(f2 < f)) continue;
                f = this.values[j];
                n = j;
            }
            break;
        }
        return n;
    }

    public String minKey() {
        this.checkMinMax("minKey");
        return this.keys[this.minIndex()];
    }

    public float minValue() {
        this.checkMinMax("minValue");
        return this.values[this.minIndex()];
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        float f = Float.NaN;
        int n = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.values[i] != this.values[i]) continue;
            f = this.values[i];
            n = i;
            for (int j = i + 1; j < this.count; ++j) {
                float f2 = this.values[j];
                if (Float.isNaN(f2) || !(f2 > f)) continue;
                f = this.values[j];
                n = j;
            }
            break;
        }
        return n;
    }

    public String maxKey() {
        this.checkMinMax("maxKey");
        return this.keys[this.maxIndex()];
    }

    public float maxValue() {
        this.checkMinMax("maxValue");
        return this.values[this.maxIndex()];
    }

    public int index(String string) {
        Integer n = this.indices.get(string);
        return n == null ? -1 : n;
    }

    protected void create(String string, float f) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(string, new Integer(this.count));
        this.keys[this.count] = string;
        this.values[this.count] = f;
        ++this.count;
    }

    public int remove(String string) {
        int n = this.index(string);
        if (n != -1) {
            this.removeIndex(n);
        }
        return n;
    }

    public String removeIndex(int n) {
        if (n < 0 || n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        String string = this.keys[n];
        this.indices.remove(this.keys[n]);
        for (int i = n; i < this.count - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = 0.0f;
        return string;
    }

    protected void swap(int n, int n2) {
        String string = this.keys[n];
        float f = this.values[n];
        this.keys[n] = this.keys[n2];
        this.values[n] = this.values[n2];
        this.keys[n2] = string;
        this.values[n2] = f;
        this.indices.put(this.keys[n], new Integer(n));
        this.indices.put(this.keys[n2], new Integer(n2));
    }

    public void sortKeys() {
        this.sortImpl(true, false);
    }

    public void sortKeysReverse() {
        this.sortImpl(true, true);
    }

    public void sortValues() {
        this.sortImpl(false, false);
    }

    public void sortValuesReverse() {
        this.sortImpl(false, true);
    }

    protected void sortImpl(final boolean bl, final boolean bl2) {
        Sort sort = new Sort(){

            @Override
            public int size() {
                return FloatDict.this.count;
            }

            @Override
            public float compare(int n, int n2) {
                float f = 0.0f;
                if (bl) {
                    f = FloatDict.this.keys[n].compareToIgnoreCase(FloatDict.this.keys[n2]);
                    if (f == 0.0f) {
                        return FloatDict.this.values[n] - FloatDict.this.values[n2];
                    }
                } else {
                    f = FloatDict.this.values[n] - FloatDict.this.values[n2];
                    if (f == 0.0f) {
                        f = FloatDict.this.keys[n].compareToIgnoreCase(FloatDict.this.keys[n2]);
                    }
                }
                return bl2 ? -f : f;
            }

            @Override
            public void swap(int n, int n2) {
                FloatDict.this.swap(n, n2);
            }
        };
        sort.run();
    }

    public FloatDict getPercent() {
        double d = 0.0;
        for (float f : this.valueArray()) {
            d += (double)f;
        }
        Object object = new FloatDict();
        for (int i = 0; i < this.size(); ++i) {
            double d2 = (double)this.value(i) / d;
            ((FloatDict)object).set(this.key(i), (float)d2);
        }
        return object;
    }

    public FloatDict copy() {
        FloatDict floatDict = new FloatDict(this.count);
        System.arraycopy(this.keys, 0, floatDict.keys, 0, this.count);
        System.arraycopy(this.values, 0, floatDict.values, 0, this.count);
        for (int i = 0; i < this.count; ++i) {
            floatDict.indices.put(this.keys[i], i);
        }
        floatDict.count = this.count;
        return floatDict;
    }

    public void write(PrintWriter printWriter) {
        for (int i = 0; i < this.count; ++i) {
            printWriter.println(this.keys[i] + "\t" + this.values[i]);
        }
        printWriter.flush();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + " size=" + this.size() + " { ");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"" + this.keys[i] + "\": " + this.values[i]);
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

