/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PVector;

public class PShape
implements PConstants {
    protected String name;
    protected HashMap<String, PShape> nameTable;
    public static final int PRIMITIVE = 1;
    public static final int PATH = 2;
    public static final int GEOMETRY = 3;
    protected int family;
    protected int kind;
    protected PMatrix matrix;
    protected int textureMode;
    protected PImage image;
    public static final String OUTSIDE_BEGIN_END_ERROR = "%1$s can only be called between beginShape() and endShape()";
    public static final String INSIDE_BEGIN_END_ERROR = "%1$s can only be called outside beginShape() and endShape()";
    public float width;
    public float height;
    public float depth;
    protected boolean visible = true;
    protected boolean openShape = false;
    protected boolean openContour = false;
    protected boolean stroke;
    protected int strokeColor;
    protected float strokeWeight;
    protected int strokeCap;
    protected int strokeJoin;
    protected boolean fill;
    protected int fillColor;
    protected boolean tint;
    protected int tintColor;
    protected int ambientColor;
    protected boolean setAmbient;
    protected int specularColor;
    protected int emissiveColor;
    protected float shininess;
    protected int sphereDetailU;
    protected int sphereDetailV;
    protected int rectMode;
    protected int ellipseMode;
    protected boolean style = true;
    protected float[] params;
    protected int vertexCount;
    protected float[][] vertices;
    protected PShape parent;
    protected int childCount;
    protected PShape[] children;
    protected int vertexCodeCount;
    protected int[] vertexCodes;
    protected boolean close;
    protected float calcR;
    protected float calcG;
    protected float calcB;
    protected float calcA;
    protected int calcRi;
    protected int calcGi;
    protected int calcBi;
    protected int calcAi;
    protected int calcColor;
    protected boolean calcAlpha;
    public int colorMode;
    public float colorModeX;
    public float colorModeY;
    public float colorModeZ;
    public float colorModeA;
    boolean colorModeScale;
    boolean colorModeDefault;
    protected boolean is3D = false;

    public PShape() {
        this.family = 0;
    }

    public PShape(int n) {
        this.family = n;
    }

    public void setKind(int n) {
        this.kind = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void disableStyle() {
        this.style = false;
        for (int i = 0; i < this.childCount; ++i) {
            this.children[i].disableStyle();
        }
    }

    public void enableStyle() {
        this.style = true;
        for (int i = 0; i < this.childCount; ++i) {
            this.children[i].enableStyle();
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getDepth() {
        return this.depth;
    }

    public boolean is2D() {
        return !this.is3D;
    }

    public boolean is3D() {
        return this.is3D;
    }

    public void is3D(boolean bl) {
        this.is3D = bl;
    }

    public void textureMode(int n) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "textureMode()");
            return;
        }
        this.textureMode = n;
    }

    public void texture(PImage pImage) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "texture()");
            return;
        }
        this.image = pImage;
    }

    public void noTexture() {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "noTexture()");
            return;
        }
        this.image = null;
    }

    protected void solid(boolean bl) {
    }

    public void beginContour() {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "beginContour()");
            return;
        }
        if (this.family == 0) {
            PGraphics.showWarning("Cannot begin contour in GROUP shapes");
            return;
        }
        if (this.openContour) {
            PGraphics.showWarning("Already called beginContour().");
            return;
        }
        this.openContour = true;
        this.beginContourImpl();
    }

    protected void beginContourImpl() {
        if (this.vertexCodes.length == this.vertexCodeCount) {
            this.vertexCodes = PApplet.expand(this.vertexCodes);
        }
        this.vertexCodes[this.vertexCodeCount++] = 4;
    }

    public void endContour() {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "endContour()");
            return;
        }
        if (this.family == 0) {
            PGraphics.showWarning("Cannot end contour in GROUP shapes");
            return;
        }
        if (!this.openContour) {
            PGraphics.showWarning("Need to call beginContour() first.");
            return;
        }
        this.endContourImpl();
        this.openContour = false;
    }

    protected void endContourImpl() {
    }

    public void vertex(float f, float f2) {
        if (this.vertices == null) {
            this.vertices = new float[10][2];
        } else if (this.vertices.length == this.vertexCount) {
            this.vertices = (float[][])PApplet.expand(this.vertices);
        }
        this.vertices[this.vertexCount++] = new float[]{f, f2};
        if (this.vertexCodes == null) {
            this.vertexCodes = new int[10];
        } else if (this.vertexCodes.length == this.vertexCodeCount) {
            this.vertexCodes = PApplet.expand(this.vertexCodes);
        }
        this.vertexCodes[this.vertexCodeCount++] = 0;
        if (f > this.width) {
            this.width = f;
        }
        if (f2 > this.height) {
            this.height = f2;
        }
    }

    public void vertex(float f, float f2, float f3, float f4) {
    }

    public void vertex(float f, float f2, float f3) {
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
    }

    public void normal(float f, float f2, float f3) {
    }

    public void beginShape() {
        this.beginShape(20);
    }

    public void beginShape(int n) {
        this.kind = n;
        this.openShape = true;
    }

    public void endShape() {
        this.endShape(1);
    }

    public void endShape(int n) {
        if (this.family == 0) {
            PGraphics.showWarning("Cannot end GROUP shape");
            return;
        }
        if (!this.openShape) {
            PGraphics.showWarning("Need to call beginShape() first");
            return;
        }
        this.openShape = false;
    }

    public void strokeWeight(float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "strokeWeight()");
            return;
        }
        this.strokeWeight = f;
    }

    public void strokeJoin(int n) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "strokeJoin()");
            return;
        }
        this.strokeJoin = n;
    }

    public void strokeCap(int n) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "strokeCap()");
            return;
        }
        this.strokeCap = n;
    }

    public void noFill() {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "noFill()");
            return;
        }
        this.fill = false;
        this.fillColor = 0;
        if (!this.setAmbient) {
            this.ambientColor = this.fillColor;
        }
    }

    public void fill(int n) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "fill()");
            return;
        }
        this.fill = true;
        this.colorCalc(n);
        this.fillColor = this.calcColor;
        if (!this.setAmbient) {
            this.ambientColor = this.fillColor;
        }
    }

    public void fill(int n, float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "fill()");
            return;
        }
        this.fill = true;
        this.colorCalc(n, f);
        this.fillColor = this.calcColor;
        if (!this.setAmbient) {
            this.ambientColor = this.fillColor;
        }
    }

    public void fill(float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "fill()");
            return;
        }
        this.fill = true;
        this.colorCalc(f);
        this.fillColor = this.calcColor;
        if (!this.setAmbient) {
            this.ambientColor = this.fillColor;
        }
    }

    public void fill(float f, float f2) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "fill()");
            return;
        }
        this.fill = true;
        this.colorCalc(f, f2);
        this.fillColor = this.calcColor;
        if (!this.setAmbient) {
            this.ambientColor = this.fillColor;
        }
    }

    public void fill(float f, float f2, float f3) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "fill()");
            return;
        }
        this.fill = true;
        this.colorCalc(f, f2, f3);
        this.fillColor = this.calcColor;
        if (!this.setAmbient) {
            this.ambientColor = this.fillColor;
        }
    }

    public void fill(float f, float f2, float f3, float f4) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "fill()");
            return;
        }
        this.fill = true;
        this.colorCalc(f, f2, f3, f4);
        this.fillColor = this.calcColor;
        if (!this.setAmbient) {
            this.ambientColor = this.fillColor;
        }
    }

    public void noStroke() {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "noStroke()");
            return;
        }
        this.stroke = false;
    }

    public void stroke(int n) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "stroke()");
            return;
        }
        this.stroke = true;
        this.colorCalc(n);
        this.strokeColor = this.calcColor;
    }

    public void stroke(int n, float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "stroke()");
            return;
        }
        this.stroke = true;
        this.colorCalc(n, f);
        this.strokeColor = this.calcColor;
    }

    public void stroke(float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "stroke()");
            return;
        }
        this.stroke = true;
        this.colorCalc(f);
        this.strokeColor = this.calcColor;
    }

    public void stroke(float f, float f2) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "stroke()");
            return;
        }
        this.stroke = true;
        this.colorCalc(f, f2);
        this.strokeColor = this.calcColor;
    }

    public void stroke(float f, float f2, float f3) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "stroke()");
            return;
        }
        this.stroke = true;
        this.colorCalc(f, f2, f3);
        this.strokeColor = this.calcColor;
    }

    public void stroke(float f, float f2, float f3, float f4) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "stroke()");
            return;
        }
        this.stroke = true;
        this.colorCalc(f, f2, f3, f4);
        this.strokeColor = this.calcColor;
    }

    public void noTint() {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "noTint()");
            return;
        }
        this.tint = false;
    }

    public void tint(int n) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "tint()");
            return;
        }
        this.tint = true;
        this.colorCalc(n);
        this.tintColor = this.calcColor;
    }

    public void tint(int n, float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "tint()");
            return;
        }
        this.tint = true;
        this.colorCalc(n, f);
        this.tintColor = this.calcColor;
    }

    public void tint(float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "tint()");
            return;
        }
        this.tint = true;
        this.colorCalc(f);
        this.tintColor = this.calcColor;
    }

    public void tint(float f, float f2) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "tint()");
            return;
        }
        this.tint = true;
        this.colorCalc(f, f2);
        this.tintColor = this.calcColor;
    }

    public void tint(float f, float f2, float f3) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "tint()");
            return;
        }
        this.tint = true;
        this.colorCalc(f, f2, f3);
        this.tintColor = this.calcColor;
    }

    public void tint(float f, float f2, float f3, float f4) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "tint()");
            return;
        }
        this.tint = true;
        this.colorCalc(f, f2, f3, f4);
        this.tintColor = this.calcColor;
    }

    public void ambient(int n) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "ambient()");
            return;
        }
        this.setAmbient = true;
        this.colorCalc(n);
        this.ambientColor = this.calcColor;
    }

    public void ambient(float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "ambient()");
            return;
        }
        this.setAmbient = true;
        this.colorCalc(f);
        this.ambientColor = this.calcColor;
    }

    public void ambient(float f, float f2, float f3) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "ambient()");
            return;
        }
        this.setAmbient = true;
        this.colorCalc(f, f2, f3);
        this.ambientColor = this.calcColor;
    }

    public void specular(int n) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "specular()");
            return;
        }
        this.colorCalc(n);
        this.specularColor = this.calcColor;
    }

    public void specular(float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "specular()");
            return;
        }
        this.colorCalc(f);
        this.specularColor = this.calcColor;
    }

    public void specular(float f, float f2, float f3) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "specular()");
            return;
        }
        this.colorCalc(f, f2, f3);
        this.specularColor = this.calcColor;
    }

    public void emissive(int n) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "emissive()");
            return;
        }
        this.colorCalc(n);
        this.emissiveColor = this.calcColor;
    }

    public void emissive(float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "emissive()");
            return;
        }
        this.colorCalc(f);
        this.emissiveColor = this.calcColor;
    }

    public void emissive(float f, float f2, float f3) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "emissive()");
            return;
        }
        this.colorCalc(f, f2, f3);
        this.emissiveColor = this.calcColor;
    }

    public void shininess(float f) {
        if (!this.openShape) {
            PGraphics.showWarning(OUTSIDE_BEGIN_END_ERROR, "shininess()");
            return;
        }
        this.shininess = f;
    }

    public void bezierDetail(int n) {
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.vertices == null) {
            this.vertices = new float[10][];
        } else if (this.vertexCount + 2 >= this.vertices.length) {
            this.vertices = (float[][])PApplet.expand(this.vertices);
        }
        this.vertices[this.vertexCount++] = new float[]{f, f2};
        this.vertices[this.vertexCount++] = new float[]{f3, f4};
        this.vertices[this.vertexCount++] = new float[]{f5, f6};
        if (this.vertexCodes.length == this.vertexCodeCount) {
            this.vertexCodes = PApplet.expand(this.vertexCodes);
        }
        this.vertexCodes[this.vertexCodeCount++] = 1;
        if (f5 > this.width) {
            this.width = f5;
        }
        if (f6 > this.height) {
            this.height = f6;
        }
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
    }

    public void quadraticVertex(float f, float f2, float f3, float f4) {
    }

    public void quadraticVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.vertices == null) {
            this.vertices = new float[10][];
        } else if (this.vertexCount + 1 >= this.vertices.length) {
            this.vertices = (float[][])PApplet.expand(this.vertices);
        }
        this.vertices[this.vertexCount++] = new float[]{f, f2};
        this.vertices[this.vertexCount++] = new float[]{f4, f5};
        if (this.vertexCodes.length == this.vertexCodeCount) {
            this.vertexCodes = PApplet.expand(this.vertexCodes);
        }
        this.vertexCodes[this.vertexCodeCount++] = 2;
        if (f4 > this.width) {
            this.width = f4;
        }
        if (f5 > this.height) {
            this.height = f5;
        }
    }

    public void curveDetail(int n) {
    }

    public void curveTightness(float f) {
    }

    public void curveVertex(float f, float f2) {
    }

    public void curveVertex(float f, float f2, float f3) {
    }

    protected void pre(PGraphics pGraphics) {
        if (this.matrix != null) {
            pGraphics.pushMatrix();
            pGraphics.applyMatrix(this.matrix);
        }
        if (this.style) {
            pGraphics.pushStyle();
            this.styles(pGraphics);
        }
    }

    protected void styles(PGraphics pGraphics) {
        if (this.stroke) {
            pGraphics.stroke(this.strokeColor);
            pGraphics.strokeWeight(this.strokeWeight);
            pGraphics.strokeCap(this.strokeCap);
            pGraphics.strokeJoin(this.strokeJoin);
        } else {
            pGraphics.noStroke();
        }
        if (this.fill) {
            pGraphics.fill(this.fillColor);
        } else {
            pGraphics.noFill();
        }
    }

    protected void post(PGraphics pGraphics) {
        if (this.matrix != null) {
            pGraphics.popMatrix();
        }
        if (this.style) {
            pGraphics.popStyle();
        }
    }

    protected static PShape createShape(PApplet pApplet, PShape pShape) {
        PShape pShape2 = null;
        if (pShape.family == 0) {
            pShape2 = pApplet.createShape(0);
            PShape.copyGroup(pApplet, pShape, pShape2);
        } else if (pShape.family == 1) {
            pShape2 = pApplet.createShape(pShape.kind, pShape.params);
            PShape.copyPrimitive(pShape, pShape2);
        } else if (pShape.family == 3) {
            pShape2 = pApplet.createShape(pShape.kind);
            PShape.copyGeometry(pShape, pShape2);
        } else if (pShape.family == 2) {
            pShape2 = pApplet.createShape(2);
            PShape.copyPath(pShape, pShape2);
        }
        pShape2.setName(pShape.name);
        return pShape2;
    }

    protected static void copyGroup(PApplet pApplet, PShape pShape, PShape pShape2) {
        PShape.copyMatrix(pShape, pShape2);
        PShape.copyStyles(pShape, pShape2);
        PShape.copyImage(pShape, pShape2);
        for (int i = 0; i < pShape.childCount; ++i) {
            PShape pShape3 = PShape.createShape(pApplet, pShape.children[i]);
            pShape2.addChild(pShape3);
        }
    }

    protected static void copyPrimitive(PShape pShape, PShape pShape2) {
        PShape.copyMatrix(pShape, pShape2);
        PShape.copyStyles(pShape, pShape2);
        PShape.copyImage(pShape, pShape2);
    }

    protected static void copyGeometry(PShape pShape, PShape pShape2) {
        pShape2.beginShape(pShape.getKind());
        PShape.copyMatrix(pShape, pShape2);
        PShape.copyStyles(pShape, pShape2);
        PShape.copyImage(pShape, pShape2);
        if (pShape.style) {
            for (int i = 0; i < pShape.vertexCount; ++i) {
                float[] fArray = pShape.vertices[i];
                pShape2.fill((int)(fArray[3] * 255.0f) << 24 | (int)(fArray[4] * 255.0f) << 16 | (int)(fArray[5] * 255.0f) << 8 | (int)(fArray[6] * 255.0f));
                if (0.0f < PApplet.dist(fArray[9], fArray[10], fArray[11], 0.0f, 0.0f, 0.0f)) {
                    pShape2.normal(fArray[9], fArray[10], fArray[11]);
                }
                pShape2.vertex(fArray[0], fArray[1], fArray[2], fArray[7], fArray[8]);
            }
        } else {
            for (int i = 0; i < pShape.vertexCount; ++i) {
                float[] fArray = pShape.vertices[i];
                if (fArray[2] == 0.0f) {
                    pShape2.vertex(fArray[0], fArray[1]);
                    continue;
                }
                pShape2.vertex(fArray[0], fArray[1], fArray[2]);
            }
        }
        pShape2.endShape();
    }

    protected static void copyPath(PShape pShape, PShape pShape2) {
        PShape.copyMatrix(pShape, pShape2);
        PShape.copyStyles(pShape, pShape2);
        PShape.copyImage(pShape, pShape2);
        pShape2.close = pShape.close;
        pShape2.setPath(pShape.vertexCount, pShape.vertices, pShape.vertexCodeCount, pShape.vertexCodes);
    }

    protected static void copyMatrix(PShape pShape, PShape pShape2) {
        if (pShape.matrix != null) {
            pShape2.applyMatrix(pShape.matrix);
        }
    }

    protected static void copyStyles(PShape pShape, PShape pShape2) {
        if (pShape.stroke) {
            pShape2.stroke = true;
            pShape2.strokeColor = pShape.strokeColor;
            pShape2.strokeWeight = pShape.strokeWeight;
            pShape2.strokeCap = pShape.strokeCap;
            pShape2.strokeJoin = pShape.strokeJoin;
        } else {
            pShape2.stroke = false;
        }
        if (pShape.fill) {
            pShape2.fill = true;
            pShape2.fillColor = pShape.fillColor;
        } else {
            pShape2.fill = false;
        }
    }

    protected static void copyImage(PShape pShape, PShape pShape2) {
        if (pShape.image != null) {
            pShape2.texture(pShape.image);
        }
    }

    public void draw(PGraphics pGraphics) {
        if (this.visible) {
            this.pre(pGraphics);
            this.drawImpl(pGraphics);
            this.post(pGraphics);
        }
    }

    public void drawImpl(PGraphics pGraphics) {
        if (this.family == 0) {
            this.drawGroup(pGraphics);
        } else if (this.family == 1) {
            this.drawPrimitive(pGraphics);
        } else if (this.family == 3) {
            this.drawGeometry(pGraphics);
        } else if (this.family == 2) {
            this.drawPath(pGraphics);
        }
    }

    protected void drawGroup(PGraphics pGraphics) {
        for (int i = 0; i < this.childCount; ++i) {
            this.children[i].draw(pGraphics);
        }
    }

    protected void drawPrimitive(PGraphics pGraphics) {
        if (this.kind == 2) {
            pGraphics.point(this.params[0], this.params[1]);
        } else if (this.kind == 4) {
            if (this.params.length == 4) {
                pGraphics.line(this.params[0], this.params[1], this.params[2], this.params[3]);
            } else {
                pGraphics.line(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
            }
        } else if (this.kind == 8) {
            pGraphics.triangle(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
        } else if (this.kind == 16) {
            pGraphics.quad(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5], this.params[6], this.params[7]);
        } else if (this.kind == 30) {
            if (this.image != null) {
                pGraphics.imageMode(0);
                pGraphics.image(this.image, this.params[0], this.params[1], this.params[2], this.params[3]);
            } else {
                pGraphics.rectMode(0);
                pGraphics.rect(this.params[0], this.params[1], this.params[2], this.params[3]);
            }
        } else if (this.kind == 31) {
            pGraphics.ellipseMode(0);
            pGraphics.ellipse(this.params[0], this.params[1], this.params[2], this.params[3]);
        } else if (this.kind == 32) {
            pGraphics.ellipseMode(0);
            pGraphics.arc(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
        } else if (this.kind == 41) {
            if (this.params.length == 1) {
                pGraphics.box(this.params[0]);
            } else {
                pGraphics.box(this.params[0], this.params[1], this.params[2]);
            }
        } else if (this.kind == 40) {
            pGraphics.sphere(this.params[0]);
        }
    }

    protected void drawGeometry(PGraphics pGraphics) {
        pGraphics.beginShape(this.kind);
        if (this.style) {
            for (int i = 0; i < this.vertexCount; ++i) {
                pGraphics.vertex(this.vertices[i]);
            }
        } else {
            for (int i = 0; i < this.vertexCount; ++i) {
                float[] fArray = this.vertices[i];
                if (fArray[2] == 0.0f) {
                    pGraphics.vertex(fArray[0], fArray[1]);
                    continue;
                }
                pGraphics.vertex(fArray[0], fArray[1], fArray[2]);
            }
        }
        pGraphics.endShape();
    }

    protected void drawPath(PGraphics pGraphics) {
        if (this.vertices == null) {
            return;
        }
        boolean bl = false;
        pGraphics.beginShape();
        if (this.vertexCodeCount == 0) {
            if (this.vertices[0].length == 2) {
                for (int i = 0; i < this.vertexCount; ++i) {
                    pGraphics.vertex(this.vertices[i][0], this.vertices[i][1]);
                }
            } else {
                for (int i = 0; i < this.vertexCount; ++i) {
                    pGraphics.vertex(this.vertices[i][0], this.vertices[i][1], this.vertices[i][2]);
                }
            }
        } else {
            int n = 0;
            if (this.vertices[0].length == 2) {
                block16: for (int i = 0; i < this.vertexCodeCount; ++i) {
                    switch (this.vertexCodes[i]) {
                        case 0: {
                            pGraphics.vertex(this.vertices[n][0], this.vertices[n][1]);
                            ++n;
                            continue block16;
                        }
                        case 2: {
                            pGraphics.quadraticVertex(this.vertices[n + 0][0], this.vertices[n + 0][1], this.vertices[n + 1][0], this.vertices[n + 1][1]);
                            n += 2;
                            continue block16;
                        }
                        case 1: {
                            pGraphics.bezierVertex(this.vertices[n + 0][0], this.vertices[n + 0][1], this.vertices[n + 1][0], this.vertices[n + 1][1], this.vertices[n + 2][0], this.vertices[n + 2][1]);
                            n += 3;
                            continue block16;
                        }
                        case 3: {
                            pGraphics.curveVertex(this.vertices[n][0], this.vertices[n][1]);
                            ++n;
                            continue block16;
                        }
                        case 4: {
                            if (bl) {
                                pGraphics.endContour();
                            }
                            pGraphics.beginContour();
                            bl = true;
                        }
                    }
                }
            } else {
                block17: for (int i = 0; i < this.vertexCodeCount; ++i) {
                    switch (this.vertexCodes[i]) {
                        case 0: {
                            pGraphics.vertex(this.vertices[n][0], this.vertices[n][1], this.vertices[n][2]);
                            ++n;
                            continue block17;
                        }
                        case 2: {
                            pGraphics.quadraticVertex(this.vertices[n + 0][0], this.vertices[n + 0][1], this.vertices[n + 0][2], this.vertices[n + 1][0], this.vertices[n + 1][1], this.vertices[n + 0][2]);
                            n += 2;
                            continue block17;
                        }
                        case 1: {
                            pGraphics.bezierVertex(this.vertices[n + 0][0], this.vertices[n + 0][1], this.vertices[n + 0][2], this.vertices[n + 1][0], this.vertices[n + 1][1], this.vertices[n + 1][2], this.vertices[n + 2][0], this.vertices[n + 2][1], this.vertices[n + 2][2]);
                            n += 3;
                            continue block17;
                        }
                        case 3: {
                            pGraphics.curveVertex(this.vertices[n][0], this.vertices[n][1], this.vertices[n][2]);
                            ++n;
                            continue block17;
                        }
                        case 4: {
                            if (bl) {
                                pGraphics.endContour();
                            }
                            pGraphics.beginContour();
                            bl = true;
                        }
                    }
                }
            }
        }
        if (bl) {
            pGraphics.endContour();
        }
        pGraphics.endShape(this.close ? 2 : 1);
    }

    public PShape getParent() {
        return this.parent;
    }

    public int getChildCount() {
        return this.childCount;
    }

    public PShape[] getChildren() {
        return this.children;
    }

    public PShape getChild(int n) {
        return this.children[n];
    }

    public PShape getChild(String string) {
        PShape pShape;
        if (this.name != null && this.name.equals(string)) {
            return this;
        }
        if (this.nameTable != null && (pShape = this.nameTable.get(string)) != null) {
            return pShape;
        }
        for (int i = 0; i < this.childCount; ++i) {
            PShape pShape2 = this.children[i].getChild(string);
            if (pShape2 == null) continue;
            return pShape2;
        }
        return null;
    }

    public PShape findChild(String string) {
        if (this.parent == null) {
            return this.getChild(string);
        }
        return this.parent.findChild(string);
    }

    public void addChild(PShape pShape) {
        if (this.children == null) {
            this.children = new PShape[1];
        }
        if (this.childCount == this.children.length) {
            this.children = (PShape[])PApplet.expand(this.children);
        }
        this.children[this.childCount++] = pShape;
        pShape.parent = this;
        if (pShape.getName() != null) {
            this.addName(pShape.getName(), pShape);
        }
    }

    public void addChild(PShape pShape, int n) {
        if (n < this.childCount) {
            if (this.childCount == this.children.length) {
                this.children = (PShape[])PApplet.expand(this.children);
            }
            for (int i = this.childCount - 1; i >= n; --i) {
                this.children[i + 1] = this.children[i];
            }
            ++this.childCount;
            this.children[n] = pShape;
            pShape.parent = this;
            if (pShape.getName() != null) {
                this.addName(pShape.getName(), pShape);
            }
        }
    }

    public void removeChild(int n) {
        if (n < this.childCount) {
            PShape pShape = this.children[n];
            for (int i = n; i < this.childCount - 1; ++i) {
                this.children[i] = this.children[i + 1];
            }
            --this.childCount;
            if (pShape.getName() != null && this.nameTable != null) {
                this.nameTable.remove(pShape.getName());
            }
        }
    }

    public void addName(String string, PShape pShape) {
        if (this.parent != null) {
            this.parent.addName(string, pShape);
        } else {
            if (this.nameTable == null) {
                this.nameTable = new HashMap();
            }
            this.nameTable.put(string, pShape);
        }
    }

    public int getChildIndex(PShape pShape) {
        for (int i = 0; i < this.childCount; ++i) {
            if (this.children[i] != pShape) continue;
            return i;
        }
        return -1;
    }

    public PShape getTessellation() {
        return null;
    }

    public int getFamily() {
        return this.family;
    }

    public int getKind() {
        return this.kind;
    }

    public float[] getParams() {
        return this.getParams(null);
    }

    public float[] getParams(float[] fArray) {
        if (fArray == null || fArray.length != this.params.length) {
            fArray = new float[this.params.length];
        }
        PApplet.arrayCopy(this.params, fArray);
        return fArray;
    }

    public float getParam(int n) {
        return this.params[n];
    }

    protected void setParams(float[] fArray) {
        if (this.params == null) {
            this.params = new float[fArray.length];
        }
        if (fArray.length != this.params.length) {
            PGraphics.showWarning("Wrong number of parameters");
            return;
        }
        PApplet.arrayCopy(fArray, this.params);
    }

    public void setPath(int n, float[][] fArray) {
        this.setPath(n, fArray, 0, null);
    }

    protected void setPath(int n, float[][] fArray, int n2, int[] nArray) {
        if (fArray == null || fArray.length < n) {
            return;
        }
        if (0 < n2 && (nArray == null || nArray.length < n2)) {
            return;
        }
        int n3 = fArray[0].length;
        this.vertexCount = n;
        this.vertices = new float[this.vertexCount][n3];
        for (int i = 0; i < this.vertexCount; ++i) {
            PApplet.arrayCopy(fArray[i], this.vertices[i]);
        }
        this.vertexCodeCount = n2;
        if (0 < this.vertexCodeCount) {
            this.vertexCodes = new int[this.vertexCodeCount];
            PApplet.arrayCopy(nArray, this.vertexCodes, this.vertexCodeCount);
        }
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public PVector getVertex(int n) {
        return this.getVertex(n, null);
    }

    public PVector getVertex(int n, PVector pVector) {
        if (pVector == null) {
            pVector = new PVector();
        }
        float[] fArray = this.vertices[n];
        pVector.x = fArray[0];
        pVector.y = fArray[1];
        pVector.z = fArray.length > 2 ? fArray[2] : 0.0f;
        return pVector;
    }

    public float getVertexX(int n) {
        return this.vertices[n][0];
    }

    public float getVertexY(int n) {
        return this.vertices[n][1];
    }

    public float getVertexZ(int n) {
        return this.vertices[n][2];
    }

    public void setVertex(int n, float f, float f2) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setVertex()");
            return;
        }
        this.vertices[n][0] = f;
        this.vertices[n][1] = f2;
    }

    public void setVertex(int n, float f, float f2, float f3) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setVertex()");
            return;
        }
        this.vertices[n][0] = f;
        this.vertices[n][1] = f2;
        this.vertices[n][2] = f3;
    }

    public void setVertex(int n, PVector pVector) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setVertex()");
            return;
        }
        this.vertices[n][0] = pVector.x;
        this.vertices[n][1] = pVector.y;
        this.vertices[n][2] = pVector.z;
    }

    public PVector getNormal(int n) {
        return this.getNormal(n, null);
    }

    public PVector getNormal(int n, PVector pVector) {
        if (pVector == null) {
            pVector = new PVector();
        }
        pVector.x = this.vertices[n][9];
        pVector.y = this.vertices[n][10];
        pVector.z = this.vertices[n][11];
        return pVector;
    }

    public float getNormalX(int n) {
        return this.vertices[n][9];
    }

    public float getNormalY(int n) {
        return this.vertices[n][10];
    }

    public float getNormalZ(int n) {
        return this.vertices[n][11];
    }

    public void setNormal(int n, float f, float f2, float f3) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setNormal()");
            return;
        }
        this.vertices[n][9] = f;
        this.vertices[n][10] = f2;
        this.vertices[n][11] = f3;
    }

    public float getTextureU(int n) {
        return this.vertices[n][7];
    }

    public float getTextureV(int n) {
        return this.vertices[n][8];
    }

    public void setTextureUV(int n, float f, float f2) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setTextureUV()");
            return;
        }
        this.vertices[n][7] = f;
        this.vertices[n][8] = f2;
    }

    public void setTextureMode(int n) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setTextureMode()");
            return;
        }
        this.textureMode = n;
    }

    public void setTexture(PImage pImage) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setTexture()");
            return;
        }
        this.image = pImage;
    }

    public int getFill(int n) {
        if (this.image == null) {
            int n2 = (int)(this.vertices[n][6] * 255.0f);
            int n3 = (int)(this.vertices[n][3] * 255.0f);
            int n4 = (int)(this.vertices[n][4] * 255.0f);
            int n5 = (int)(this.vertices[n][5] * 255.0f);
            return n2 << 24 | n3 << 16 | n4 << 8 | n5;
        }
        return 0;
    }

    public void setFill(boolean bl) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setFill()");
            return;
        }
        this.fill = bl;
    }

    public void setFill(int n) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setFill()");
            return;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            this.setFill(i, n);
        }
    }

    public void setFill(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setFill()");
            return;
        }
        if (this.image == null) {
            this.vertices[n][6] = (float)(n2 >> 24 & 0xFF) / 255.0f;
            this.vertices[n][3] = (float)(n2 >> 16 & 0xFF) / 255.0f;
            this.vertices[n][4] = (float)(n2 >> 8 & 0xFF) / 255.0f;
            this.vertices[n][5] = (float)(n2 >> 0 & 0xFF) / 255.0f;
        }
    }

    public int getTint(int n) {
        if (this.image != null) {
            int n2 = (int)(this.vertices[n][6] * 255.0f);
            int n3 = (int)(this.vertices[n][3] * 255.0f);
            int n4 = (int)(this.vertices[n][4] * 255.0f);
            int n5 = (int)(this.vertices[n][5] * 255.0f);
            return n2 << 24 | n3 << 16 | n4 << 8 | n5;
        }
        return 0;
    }

    public void setTint(boolean bl) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setTint()");
            return;
        }
        this.tint = bl;
    }

    public void setTint(int n) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setTint()");
            return;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            this.setFill(i, n);
        }
    }

    public void setTint(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setTint()");
            return;
        }
        if (this.image != null) {
            this.vertices[n][6] = (float)(n2 >> 24 & 0xFF) / 255.0f;
            this.vertices[n][3] = (float)(n2 >> 16 & 0xFF) / 255.0f;
            this.vertices[n][4] = (float)(n2 >> 8 & 0xFF) / 255.0f;
            this.vertices[n][5] = (float)(n2 >> 0 & 0xFF) / 255.0f;
        }
    }

    public int getStroke(int n) {
        int n2 = (int)(this.vertices[n][16] * 255.0f);
        int n3 = (int)(this.vertices[n][13] * 255.0f);
        int n4 = (int)(this.vertices[n][14] * 255.0f);
        int n5 = (int)(this.vertices[n][15] * 255.0f);
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public void setStroke(boolean bl) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setStroke()");
            return;
        }
        this.stroke = bl;
    }

    public void setStroke(int n) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setStroke()");
            return;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            this.setStroke(i, n);
        }
    }

    public void setStroke(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setStroke()");
            return;
        }
        this.vertices[n][16] = (float)(n2 >> 24 & 0xFF) / 255.0f;
        this.vertices[n][13] = (float)(n2 >> 16 & 0xFF) / 255.0f;
        this.vertices[n][14] = (float)(n2 >> 8 & 0xFF) / 255.0f;
        this.vertices[n][15] = (float)(n2 >> 0 & 0xFF) / 255.0f;
    }

    public float getStrokeWeight(int n) {
        return this.vertices[n][17];
    }

    public void setStrokeWeight(float f) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setStrokeWeight()");
            return;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            this.setStrokeWeight(i, f);
        }
    }

    public void setStrokeWeight(int n, float f) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setStrokeWeight()");
            return;
        }
        this.vertices[n][17] = f;
    }

    public void setStrokeJoin(int n) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setStrokeJoin()");
            return;
        }
        this.strokeJoin = n;
    }

    public void setStrokeCap(int n) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setStrokeCap()");
            return;
        }
        this.strokeCap = n;
    }

    public int getAmbient(int n) {
        int n2 = (int)(this.vertices[n][25] * 255.0f);
        int n3 = (int)(this.vertices[n][26] * 255.0f);
        int n4 = (int)(this.vertices[n][27] * 255.0f);
        return 0xFF000000 | n2 << 16 | n3 << 8 | n4;
    }

    public void setAmbient(int n) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setAmbient()");
            return;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            this.setAmbient(i, n);
        }
    }

    public void setAmbient(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setAmbient()");
            return;
        }
        this.vertices[n][25] = (float)(n2 >> 16 & 0xFF) / 255.0f;
        this.vertices[n][26] = (float)(n2 >> 8 & 0xFF) / 255.0f;
        this.vertices[n][27] = (float)(n2 >> 0 & 0xFF) / 255.0f;
    }

    public int getSpecular(int n) {
        int n2 = (int)(this.vertices[n][28] * 255.0f);
        int n3 = (int)(this.vertices[n][29] * 255.0f);
        int n4 = (int)(this.vertices[n][30] * 255.0f);
        return 0xFF000000 | n2 << 16 | n3 << 8 | n4;
    }

    public void setSpecular(int n) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setSpecular()");
            return;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            this.setSpecular(i, n);
        }
    }

    public void setSpecular(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setSpecular()");
            return;
        }
        this.vertices[n][28] = (float)(n2 >> 16 & 0xFF) / 255.0f;
        this.vertices[n][29] = (float)(n2 >> 8 & 0xFF) / 255.0f;
        this.vertices[n][30] = (float)(n2 >> 0 & 0xFF) / 255.0f;
    }

    public int getEmissive(int n) {
        int n2 = (int)(this.vertices[n][32] * 255.0f);
        int n3 = (int)(this.vertices[n][33] * 255.0f);
        int n4 = (int)(this.vertices[n][34] * 255.0f);
        return 0xFF000000 | n2 << 16 | n3 << 8 | n4;
    }

    public void setEmissive(int n) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setEmissive()");
            return;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            this.setEmissive(i, n);
        }
    }

    public void setEmissive(int n, int n2) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setEmissive()");
            return;
        }
        this.vertices[n][32] = (float)(n2 >> 16 & 0xFF) / 255.0f;
        this.vertices[n][33] = (float)(n2 >> 8 & 0xFF) / 255.0f;
        this.vertices[n][34] = (float)(n2 >> 0 & 0xFF) / 255.0f;
    }

    public float getShininess(int n) {
        return this.vertices[n][31];
    }

    public void setShininess(float f) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setShininess()");
            return;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            this.setShininess(i, f);
        }
    }

    public void setShininess(int n, float f) {
        if (this.openShape) {
            PGraphics.showWarning(INSIDE_BEGIN_END_ERROR, "setShininess()");
            return;
        }
        this.vertices[n][31] = f;
    }

    public int[] getVertexCodes() {
        if (this.vertexCodes == null) {
            return null;
        }
        if (this.vertexCodes.length != this.vertexCodeCount) {
            this.vertexCodes = PApplet.subset(this.vertexCodes, 0, this.vertexCodeCount);
        }
        return this.vertexCodes;
    }

    public int getVertexCodeCount() {
        return this.vertexCodeCount;
    }

    public int getVertexCode(int n) {
        return this.vertexCodes[n];
    }

    public boolean isClosed() {
        return this.close;
    }

    public boolean contains(float f, float f2) {
        if (this.family == 2) {
            boolean bl = false;
            int n = 0;
            int n2 = this.vertexCount - 1;
            while (n < this.vertexCount) {
                if (this.vertices[n][1] > f2 != this.vertices[n2][1] > f2 && f < (this.vertices[n2][0] - this.vertices[n][0]) * (f2 - this.vertices[n][1]) / (this.vertices[n2][1] - this.vertices[n][1]) + this.vertices[n][0]) {
                    bl = !bl;
                }
                n2 = n++;
            }
            return bl;
        }
        throw new IllegalArgumentException("The contains() method is only implemented for paths.");
    }

    public void translate(float f, float f2) {
        this.checkMatrix(2);
        this.matrix.translate(f, f2);
    }

    public void translate(float f, float f2, float f3) {
        this.checkMatrix(3);
        this.matrix.translate(f, f2, f3);
    }

    public void rotateX(float f) {
        this.rotate(f, 1.0f, 0.0f, 0.0f);
    }

    public void rotateY(float f) {
        this.rotate(f, 0.0f, 1.0f, 0.0f);
    }

    public void rotateZ(float f) {
        this.rotate(f, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float f) {
        this.checkMatrix(2);
        this.matrix.rotate(f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        this.checkMatrix(3);
        float f5 = f2 * f2 + f3 * f3 + f4 * f4;
        if (Math.abs(f5 - 1.0f) > 1.0E-4f) {
            float f6 = PApplet.sqrt(f5);
            f2 /= f6;
            f3 /= f6;
            f4 /= f6;
        }
        this.matrix.rotate(f, f2, f3, f4);
    }

    public void scale(float f) {
        this.checkMatrix(2);
        this.matrix.scale(f);
    }

    public void scale(float f, float f2) {
        this.checkMatrix(2);
        this.matrix.scale(f, f2);
    }

    public void scale(float f, float f2, float f3) {
        this.checkMatrix(3);
        this.matrix.scale(f, f2, f3);
    }

    public void resetMatrix() {
        this.checkMatrix(2);
        this.matrix.reset();
    }

    public void applyMatrix(PMatrix pMatrix) {
        if (pMatrix instanceof PMatrix2D) {
            this.applyMatrix((PMatrix2D)pMatrix);
        } else if (pMatrix instanceof PMatrix3D) {
            this.applyMatrix((PMatrix3D)pMatrix);
        }
    }

    public void applyMatrix(PMatrix2D pMatrix2D) {
        this.applyMatrix(pMatrix2D.m00, pMatrix2D.m01, 0.0f, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, 0.0f, pMatrix2D.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.checkMatrix(2);
        this.matrix.apply(f, f2, f3, f4, f5, f6);
    }

    public void applyMatrix(PMatrix3D pMatrix3D) {
        this.applyMatrix(pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.checkMatrix(3);
        this.matrix.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    protected void checkMatrix(int n) {
        if (this.matrix == null) {
            this.matrix = n == 2 ? new PMatrix2D() : new PMatrix3D();
        } else if (n == 3 && this.matrix instanceof PMatrix2D) {
            this.matrix = new PMatrix3D(this.matrix);
        }
    }

    public void colorMode(int n) {
        this.colorMode(n, this.colorModeX, this.colorModeY, this.colorModeZ, this.colorModeA);
    }

    public void colorMode(int n, float f) {
        this.colorMode(n, f, f, f, f);
    }

    public void colorMode(int n, float f, float f2, float f3) {
        this.colorMode(n, f, f2, f3, this.colorModeA);
    }

    public void colorMode(int n, float f, float f2, float f3, float f4) {
        this.colorMode = n;
        this.colorModeX = f;
        this.colorModeY = f2;
        this.colorModeZ = f3;
        this.colorModeA = f4;
        this.colorModeScale = f4 != 1.0f || f != f2 || f2 != f3 || f3 != f4;
        this.colorModeDefault = this.colorMode == 1 && this.colorModeA == 255.0f && this.colorModeX == 255.0f && this.colorModeY == 255.0f && this.colorModeZ == 255.0f;
    }

    protected void colorCalc(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.colorCalc((float)n);
        } else {
            this.colorCalcARGB(n, this.colorModeA);
        }
    }

    protected void colorCalc(int n, float f) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.colorCalc((float)n, f);
        } else {
            this.colorCalcARGB(n, f);
        }
    }

    protected void colorCalc(float f) {
        this.colorCalc(f, this.colorModeA);
    }

    protected void colorCalc(float f, float f2) {
        if (f > this.colorModeX) {
            f = this.colorModeX;
        }
        if (f2 > this.colorModeA) {
            f2 = this.colorModeA;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        this.calcG = this.calcR = this.colorModeScale ? f / this.colorModeX : f;
        this.calcB = this.calcR;
        this.calcA = this.colorModeScale ? f2 / this.colorModeA : f2;
        this.calcRi = (int)(this.calcR * 255.0f);
        this.calcGi = (int)(this.calcG * 255.0f);
        this.calcBi = (int)(this.calcB * 255.0f);
        this.calcAi = (int)(this.calcA * 255.0f);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    protected void colorCalc(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3, this.colorModeA);
    }

    protected void colorCalc(float f, float f2, float f3, float f4) {
        if (f > this.colorModeX) {
            f = this.colorModeX;
        }
        if (f2 > this.colorModeY) {
            f2 = this.colorModeY;
        }
        if (f3 > this.colorModeZ) {
            f3 = this.colorModeZ;
        }
        if (f4 > this.colorModeA) {
            f4 = this.colorModeA;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        block0 : switch (this.colorMode) {
            case 1: {
                if (this.colorModeScale) {
                    this.calcR = f / this.colorModeX;
                    this.calcG = f2 / this.colorModeY;
                    this.calcB = f3 / this.colorModeZ;
                    this.calcA = f4 / this.colorModeA;
                    break;
                }
                this.calcR = f;
                this.calcG = f2;
                this.calcB = f3;
                this.calcA = f4;
                break;
            }
            case 3: {
                f /= this.colorModeX;
                f3 /= this.colorModeZ;
                float f5 = this.calcA = this.colorModeScale ? f4 / this.colorModeA : f4;
                if ((f2 /= this.colorModeY) == 0.0f) {
                    this.calcG = this.calcB = f3;
                    this.calcR = this.calcB;
                    break;
                }
                float f6 = (f - (float)((int)f)) * 6.0f;
                float f7 = f6 - (float)((int)f6);
                float f8 = f3 * (1.0f - f2);
                float f9 = f3 * (1.0f - f2 * f7);
                float f10 = f3 * (1.0f - f2 * (1.0f - f7));
                switch ((int)f6) {
                    case 0: {
                        this.calcR = f3;
                        this.calcG = f10;
                        this.calcB = f8;
                        break block0;
                    }
                    case 1: {
                        this.calcR = f9;
                        this.calcG = f3;
                        this.calcB = f8;
                        break block0;
                    }
                    case 2: {
                        this.calcR = f8;
                        this.calcG = f3;
                        this.calcB = f10;
                        break block0;
                    }
                    case 3: {
                        this.calcR = f8;
                        this.calcG = f9;
                        this.calcB = f3;
                        break block0;
                    }
                    case 4: {
                        this.calcR = f10;
                        this.calcG = f8;
                        this.calcB = f3;
                        break block0;
                    }
                    case 5: {
                        this.calcR = f3;
                        this.calcG = f8;
                        this.calcB = f9;
                    }
                }
            }
        }
        this.calcRi = (int)(255.0f * this.calcR);
        this.calcGi = (int)(255.0f * this.calcG);
        this.calcBi = (int)(255.0f * this.calcB);
        this.calcAi = (int)(255.0f * this.calcA);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    protected void colorCalcARGB(int n, float f) {
        if (f == this.colorModeA) {
            this.calcAi = n >> 24 & 0xFF;
            this.calcColor = n;
        } else {
            this.calcAi = (int)((float)(n >> 24 & 0xFF) * (f / this.colorModeA));
            this.calcColor = this.calcAi << 24 | n & 0xFFFFFF;
        }
        this.calcRi = n >> 16 & 0xFF;
        this.calcGi = n >> 8 & 0xFF;
        this.calcBi = n & 0xFF;
        this.calcA = (float)this.calcAi / 255.0f;
        this.calcR = (float)this.calcRi / 255.0f;
        this.calcG = (float)this.calcGi / 255.0f;
        this.calcB = (float)this.calcBi / 255.0f;
        this.calcAlpha = this.calcAi != 255;
    }
}

