/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import java.util.zip.GZIPInputStream;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PShapeSVG;
import processing.data.XML;

public class PGraphicsAndroid2D
extends PGraphics {
    public Canvas canvas;
    boolean breakShape;
    float[] curveCoordX;
    float[] curveCoordY;
    float[] curveDrawX;
    float[] curveDrawY;
    float[] transform = new float[9];
    Path path = new Path();
    RectF rect = new RectF();
    Paint fillPaint = new Paint();
    Paint strokePaint;
    Paint tintPaint;
    Rect imageImplSrcRect;
    RectF imageImplDstRect;
    float[] screenPoint;
    static int[] getset = new int[1];

    public PGraphicsAndroid2D() {
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.strokePaint = new Paint();
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.tintPaint = new Paint(2);
    }

    @Override
    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.reapplySettings();
    }

    @Override
    protected void allocate() {
        if (this.bitmap != null) {
            this.bitmap.recycle();
        }
        this.bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.canvas = new Canvas(this.bitmap);
    }

    @Override
    public void dispose() {
        this.bitmap.recycle();
    }

    @Override
    public void requestDraw() {
        this.parent.handleDraw();
    }

    @Override
    public void beginDraw() {
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void endDraw() {
        if (this.primarySurface) {
            var1_1 = null;
            try {
                var1_1 = this.parent.getSurfaceHolder().lockCanvas(null);
                if (var1_1 == null) ** GOTO lbl13
                var1_1.drawBitmap(this.bitmap, new Matrix(), null);
            }
            finally {
                if (var1_1 != null) {
                    this.parent.getSurfaceHolder().unlockCanvasAndPost(var1_1);
                }
            }
        } else {
            this.loadPixels();
        }
lbl13:
        // 3 sources

        this.setModified();
        super.updatePixels();
    }

    @Override
    public void beginShape(int n) {
        this.shape = n;
        this.vertexCount = 0;
        this.curveVertexCount = 0;
    }

    @Override
    public void texture(PImage pImage) {
        PGraphicsAndroid2D.showMethodWarning("texture");
    }

    @Override
    public void vertex(float f, float f2) {
        if (this.shape == 20) {
            if (this.vertexCount == 0) {
                this.path.reset();
                this.path.moveTo(f, f2);
                this.vertexCount = 1;
            } else if (this.breakShape) {
                this.path.moveTo(f, f2);
                this.breakShape = false;
            } else {
                this.path.lineTo(f, f2);
            }
        } else {
            this.curveVertexCount = 0;
            if (this.vertexCount == this.vertices.length) {
                float[][] fArray = new float[this.vertexCount << 1][37];
                System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
                this.vertices = fArray;
            }
            this.vertices[this.vertexCount][0] = f;
            this.vertices[this.vertexCount][1] = f2;
            ++this.vertexCount;
            switch (this.shape) {
                case 3: {
                    break;
                }
                case 5: {
                    if (this.vertexCount % 2 != 0) break;
                    this.line(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], f, f2);
                    this.vertexCount = 0;
                    break;
                }
                case 9: {
                    if (this.vertexCount % 3 != 0) break;
                    this.triangle(this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], f, f2);
                    this.vertexCount = 0;
                    break;
                }
                case 10: {
                    if (this.vertexCount < 3) break;
                    this.triangle(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], f, f2, this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                    break;
                }
                case 11: {
                    if (this.vertexCount < 3) break;
                    this.triangle(this.vertices[0][0], this.vertices[0][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], f, f2);
                    break;
                }
                case 16: 
                case 17: {
                    if (this.vertexCount % 4 != 0) break;
                    this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], f, f2);
                    this.vertexCount = 0;
                    break;
                }
                case 18: {
                    if (this.vertexCount < 4 || this.vertexCount % 2 != 0) break;
                    this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], f, f2, this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                }
            }
        }
    }

    @Override
    public void vertex(float f, float f2, float f3) {
        PGraphicsAndroid2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void vertex(float f, float f2, float f3, float f4) {
        PGraphicsAndroid2D.showVariationWarning("vertex(x, y, u, v)");
    }

    @Override
    public void vertex(float f, float f2, float f3, float f4, float f5) {
        PGraphicsAndroid2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void breakShape() {
        this.breakShape = true;
    }

    @Override
    public void endShape(int n) {
        if (this.shape == 3 && this.stroke && this.vertexCount > 0) {
            Matrix matrix = this.canvas.getMatrix();
            if (this.strokeWeight == 1.0f && matrix.isIdentity()) {
                if (this.screenPoint == null) {
                    this.screenPoint = new float[2];
                }
                for (int i = 0; i < this.vertexCount; ++i) {
                    this.screenPoint[0] = this.vertices[i][0];
                    this.screenPoint[1] = this.vertices[i][1];
                    matrix.mapPoints(this.screenPoint);
                    this.set(PApplet.round(this.screenPoint[0]), PApplet.round(this.screenPoint[1]), this.strokeColor);
                    float f = this.vertices[i][0];
                    float f2 = this.vertices[i][1];
                    this.set(PApplet.round(this.screenX(f, f2)), PApplet.round(this.screenY(f, f2)), this.strokeColor);
                }
            } else {
                float f = this.strokeWeight / 2.0f;
                this.strokePaint.setStyle(Paint.Style.FILL);
                for (int i = 0; i < this.vertexCount; ++i) {
                    float f3 = this.vertices[i][0];
                    float f4 = this.vertices[i][1];
                    this.rect.set(f3 - f, f4 - f, f3 + f, f4 + f);
                    this.canvas.drawOval(this.rect, this.strokePaint);
                }
                this.strokePaint.setStyle(Paint.Style.STROKE);
            }
        } else if (this.shape == 20 && !this.path.isEmpty()) {
            if (n == 2) {
                this.path.close();
            }
            this.drawPath();
        }
        this.shape = 0;
    }

    @Override
    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bezierVertexCheck();
        this.path.cubicTo(f, f2, f3, f4, f5, f6);
    }

    @Override
    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        PGraphicsAndroid2D.showDepthWarningXYZ("bezierVertex");
    }

    @Override
    public void quadraticVertex(float f, float f2, float f3, float f4) {
        this.bezierVertexCheck();
        this.path.quadTo(f, f2, f3, f4);
    }

    @Override
    public void quadraticVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        PGraphicsAndroid2D.showDepthWarningXYZ("quadVertex");
    }

    @Override
    protected void curveVertexCheck() {
        super.curveVertexCheck();
        if (this.curveCoordX == null) {
            this.curveCoordX = new float[4];
            this.curveCoordY = new float[4];
            this.curveDrawX = new float[4];
            this.curveDrawY = new float[4];
        }
    }

    @Override
    protected void curveVertexSegment(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.curveCoordX[0] = f;
        this.curveCoordY[0] = f2;
        this.curveCoordX[1] = f3;
        this.curveCoordY[1] = f4;
        this.curveCoordX[2] = f5;
        this.curveCoordY[2] = f6;
        this.curveCoordX[3] = f7;
        this.curveCoordY[3] = f8;
        this.curveToBezierMatrix.mult(this.curveCoordX, this.curveDrawX);
        this.curveToBezierMatrix.mult(this.curveCoordY, this.curveDrawY);
        if (this.vertexCount == 0) {
            this.path.moveTo(this.curveDrawX[0], this.curveDrawY[0]);
            this.vertexCount = 1;
        }
        this.path.cubicTo(this.curveDrawX[1], this.curveDrawY[1], this.curveDrawX[2], this.curveDrawY[2], this.curveDrawX[3], this.curveDrawY[3]);
    }

    @Override
    public void curveVertex(float f, float f2, float f3) {
        PGraphicsAndroid2D.showDepthWarningXYZ("curveVertex");
    }

    @Override
    public void point(float f, float f2) {
        this.beginShape(3);
        this.vertex(f, f2);
        this.endShape();
    }

    @Override
    public void line(float f, float f2, float f3, float f4) {
        if (this.stroke) {
            this.canvas.drawLine(f, f2, f3, f4, this.strokePaint);
        }
    }

    @Override
    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.path.reset();
        this.path.moveTo(f, f2);
        this.path.lineTo(f3, f4);
        this.path.lineTo(f5, f6);
        this.path.close();
        this.drawPath();
    }

    @Override
    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.path.reset();
        this.path.moveTo(f, f2);
        this.path.lineTo(f3, f4);
        this.path.lineTo(f5, f6);
        this.path.lineTo(f7, f8);
        this.path.close();
        this.drawPath();
    }

    @Override
    protected void rectImpl(float f, float f2, float f3, float f4) {
        if (this.fill) {
            this.canvas.drawRect(f, f2, f3, f4, this.fillPaint);
        }
        if (this.stroke) {
            this.canvas.drawRect(f, f2, f3, f4, this.strokePaint);
        }
    }

    @Override
    protected void ellipseImpl(float f, float f2, float f3, float f4) {
        this.rect.set(f, f2, f + f3, f2 + f4);
        if (this.fill) {
            this.canvas.drawOval(this.rect, this.fillPaint);
        }
        if (this.stroke) {
            this.canvas.drawOval(this.rect, this.strokePaint);
        }
    }

    @Override
    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6, int n) {
        if (f6 - f5 >= (float)Math.PI * 2) {
            this.ellipseImpl(f, f2, f3, f4);
        } else {
            float f7;
            f5 *= 57.295776f;
            f6 *= 57.295776f;
            while (f5 < 0.0f) {
                f5 += 360.0f;
                f6 += 360.0f;
            }
            if (f5 > f6) {
                f7 = f5;
                f5 = f6;
                f6 = f7;
            }
            f7 = f6 - f5;
            this.rect.set(f, f2, f + f3, f2 + f4);
            if (n == 0) {
                if (this.fill) {
                    this.canvas.drawArc(this.rect, f5, f7, true, this.fillPaint);
                }
                if (this.stroke) {
                    this.canvas.drawArc(this.rect, f5, f7, false, this.strokePaint);
                }
            } else if (n == 1) {
                if (this.fill) {
                    PGraphicsAndroid2D.showMissingWarning("arc");
                }
                if (this.stroke) {
                    this.canvas.drawArc(this.rect, f5, f7, false, this.strokePaint);
                }
            } else if (n == 2) {
                PGraphicsAndroid2D.showMissingWarning("arc");
            } else if (n == 3) {
                if (this.fill) {
                    this.canvas.drawArc(this.rect, f5, f7, true, this.fillPaint);
                }
                if (this.stroke) {
                    this.canvas.drawArc(this.rect, f5, f7, true, this.strokePaint);
                }
            }
        }
    }

    protected void drawPath() {
        if (this.fill) {
            this.canvas.drawPath(this.path, this.fillPaint);
        }
        if (this.stroke) {
            this.canvas.drawPath(this.path, this.strokePaint);
        }
    }

    @Override
    public void box(float f, float f2, float f3) {
        PGraphicsAndroid2D.showMethodWarning("box");
    }

    @Override
    public void sphere(float f) {
        PGraphicsAndroid2D.showMethodWarning("sphere");
    }

    @Override
    public void bezierDetail(int n) {
    }

    @Override
    public void curveDetail(int n) {
    }

    @Override
    public void smooth() {
        this.smooth = true;
        this.strokePaint.setAntiAlias(true);
        this.fillPaint.setAntiAlias(true);
    }

    @Override
    public void noSmooth() {
        this.smooth = false;
        this.strokePaint.setAntiAlias(false);
        this.fillPaint.setAntiAlias(false);
    }

    @Override
    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        Object object;
        if (pImage.bitmap != null && pImage.bitmap.isRecycled()) {
            pImage.bitmap = null;
        }
        if (pImage.bitmap == null && pImage.format == 4) {
            pImage.bitmap = Bitmap.createBitmap((int)pImage.width, (int)pImage.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            object = new int[pImage.pixels.length];
            for (int i = 0; i < ((int[])object).length; ++i) {
                object[i] = pImage.pixels[i] << 24 | 0xFFFFFF;
            }
            pImage.bitmap.setPixels(object, 0, pImage.width, 0, 0, pImage.width, pImage.height);
            pImage.modified = false;
        }
        if (pImage.bitmap == null || pImage.width != pImage.bitmap.getWidth() || pImage.height != pImage.bitmap.getHeight()) {
            if (pImage.bitmap != null) {
                pImage.bitmap.recycle();
            }
            pImage.bitmap = Bitmap.createBitmap((int)pImage.width, (int)pImage.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            pImage.modified = true;
        }
        if (pImage.modified) {
            if (!pImage.bitmap.isMutable()) {
                pImage.bitmap.recycle();
                pImage.bitmap = Bitmap.createBitmap((int)pImage.width, (int)pImage.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            if (pImage.pixels != null) {
                pImage.bitmap.setPixels(pImage.pixels, 0, pImage.width, 0, 0, pImage.width, pImage.height);
            }
            pImage.modified = false;
        }
        if (this.imageImplSrcRect == null) {
            this.imageImplSrcRect = new Rect(n, n2, n3, n4);
            this.imageImplDstRect = new RectF(f, f2, f3, f4);
        } else {
            this.imageImplSrcRect.set(n, n2, n3, n4);
            this.imageImplDstRect.set(f, f2, f3, f4);
        }
        this.canvas.drawBitmap(pImage.bitmap, this.imageImplSrcRect, this.imageImplDstRect, this.tint ? this.tintPaint : null);
        object = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)this.parent.getApplicationContext().getSystemService("activity");
        activityManager.getMemoryInfo((ActivityManager.MemoryInfo)object);
        if (object.lowMemory) {
            pImage.bitmap.recycle();
            pImage.bitmap = null;
        }
    }

    @Override
    public PShape loadShape(String string) {
        String string2 = PApplet.getExtension(string);
        PShapeSVG pShapeSVG = null;
        if (string2.equals("svg")) {
            pShapeSVG = new PShapeSVG(this.parent.loadXML(string));
        } else if (string2.equals("svgz")) {
            try {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(this.parent.createInput(string));
                XML xML = new XML(gZIPInputStream);
                pShapeSVG = new PShapeSVG(xML);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            PGraphics.showWarning("Unsupported format");
        }
        return pShapeSVG;
    }

    @Override
    public void textFont(PFont pFont) {
        super.textFont(pFont);
        this.fillPaint.setTypeface((Typeface)pFont.getNative());
    }

    @Override
    protected boolean textModeCheck(int n) {
        return n == 4;
    }

    @Override
    public void textSize(float f) {
        Typeface typeface;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textSize", f);
        }
        if ((typeface = (Typeface)this.textFont.getNative()) != null) {
            this.fillPaint.setTextSize(f);
        }
        this.textSize = f;
        this.textLeading = (this.textAscent() + this.textDescent()) * 1.275f;
    }

    protected void beginTextScreenMode() {
        this.loadPixels();
    }

    protected void endTextScreenMode() {
        this.updatePixels();
    }

    @Override
    protected float textWidthImpl(char[] cArray, int n, int n2) {
        Typeface typeface = (Typeface)this.textFont.getNative();
        if (typeface == null) {
            return super.textWidthImpl(cArray, n, n2);
        }
        int n3 = n2 - n;
        return this.fillPaint.measureText(cArray, n, n3);
    }

    @Override
    protected void textLineImpl(char[] cArray, int n, int n2, float f, float f2) {
        Typeface typeface = (Typeface)this.textFont.getNative();
        if (typeface == null) {
            PGraphicsAndroid2D.showWarning("Inefficient font rendering: use createFont() with a TTF/OTF instead of loadFont().");
            super.textLineImpl(cArray, n, n2, f, f2);
            return;
        }
        this.fillPaint.setAntiAlias(this.textFont.smooth);
        int n3 = n2 - n;
        this.canvas.drawText(cArray, n, n3, f, f2, this.fillPaint);
        this.fillPaint.setAntiAlias(this.smooth);
    }

    @Override
    public void pushMatrix() {
        this.canvas.save(1);
    }

    @Override
    public void popMatrix() {
        this.canvas.restore();
    }

    @Override
    public void translate(float f, float f2) {
        this.canvas.translate(f, f2);
    }

    @Override
    public void rotate(float f) {
        this.canvas.rotate(f * 57.295776f);
    }

    @Override
    public void rotateX(float f) {
        PGraphicsAndroid2D.showDepthWarning("rotateX");
    }

    @Override
    public void rotateY(float f) {
        PGraphicsAndroid2D.showDepthWarning("rotateY");
    }

    @Override
    public void rotateZ(float f) {
        PGraphicsAndroid2D.showDepthWarning("rotateZ");
    }

    @Override
    public void rotate(float f, float f2, float f3, float f4) {
        PGraphicsAndroid2D.showVariationWarning("rotate");
    }

    @Override
    public void scale(float f) {
        this.canvas.scale(f, f);
    }

    @Override
    public void scale(float f, float f2) {
        this.canvas.scale(f, f2);
    }

    @Override
    public void scale(float f, float f2, float f3) {
        PGraphicsAndroid2D.showDepthWarningXYZ("scale");
    }

    @Override
    public void shearX(float f) {
        this.canvas.skew((float)Math.tan(f), 0.0f);
    }

    @Override
    public void shearY(float f) {
        this.canvas.skew(0.0f, (float)Math.tan(f));
    }

    @Override
    public void resetMatrix() {
        this.canvas.setMatrix(new Matrix());
    }

    @Override
    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        Matrix matrix = new Matrix();
        matrix.setValues(new float[]{f, f2, f3, f4, f5, f6, 0.0f, 0.0f, 1.0f});
        this.canvas.concat(matrix);
    }

    @Override
    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        PGraphicsAndroid2D.showVariationWarning("applyMatrix");
    }

    @Override
    public PMatrix getMatrix() {
        return this.getMatrix((PMatrix2D)null);
    }

    @Override
    public PMatrix2D getMatrix(PMatrix2D pMatrix2D) {
        if (pMatrix2D == null) {
            pMatrix2D = new PMatrix2D();
        }
        Matrix matrix = new Matrix();
        this.canvas.getMatrix(matrix);
        matrix.getValues(this.transform);
        pMatrix2D.set(this.transform[0], this.transform[1], this.transform[2], this.transform[3], this.transform[4], this.transform[5]);
        return pMatrix2D;
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D pMatrix3D) {
        PGraphicsAndroid2D.showVariationWarning("getMatrix");
        return pMatrix3D;
    }

    @Override
    public void setMatrix(PMatrix2D pMatrix2D) {
        Matrix matrix = new Matrix();
        matrix.setValues(new float[]{pMatrix2D.m00, pMatrix2D.m01, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, pMatrix2D.m12, 0.0f, 0.0f, 1.0f});
        this.canvas.setMatrix(matrix);
    }

    @Override
    public void setMatrix(PMatrix3D pMatrix3D) {
        PGraphicsAndroid2D.showVariationWarning("setMatrix");
    }

    @Override
    public void printMatrix() {
        this.getMatrix((PMatrix2D)null).print();
    }

    @Override
    public float screenX(float f, float f2) {
        if (this.screenPoint == null) {
            this.screenPoint = new float[2];
        }
        this.screenPoint[0] = f;
        this.screenPoint[1] = f2;
        this.canvas.getMatrix().mapPoints(this.screenPoint);
        return this.screenPoint[0];
    }

    @Override
    public float screenY(float f, float f2) {
        if (this.screenPoint == null) {
            this.screenPoint = new float[2];
        }
        this.screenPoint[0] = f;
        this.screenPoint[1] = f2;
        this.canvas.getMatrix().mapPoints(this.screenPoint);
        return this.screenPoint[1];
    }

    @Override
    public float screenX(float f, float f2, float f3) {
        PGraphicsAndroid2D.showDepthWarningXYZ("screenX");
        return 0.0f;
    }

    @Override
    public float screenY(float f, float f2, float f3) {
        PGraphicsAndroid2D.showDepthWarningXYZ("screenY");
        return 0.0f;
    }

    @Override
    public float screenZ(float f, float f2, float f3) {
        PGraphicsAndroid2D.showDepthWarningXYZ("screenZ");
        return 0.0f;
    }

    @Override
    public void strokeCap(int n) {
        super.strokeCap(n);
        if (this.strokeCap == 2) {
            this.strokePaint.setStrokeCap(Paint.Cap.ROUND);
        } else if (this.strokeCap == 4) {
            this.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        } else {
            this.strokePaint.setStrokeCap(Paint.Cap.BUTT);
        }
    }

    @Override
    public void strokeJoin(int n) {
        super.strokeJoin(n);
        if (this.strokeJoin == 8) {
            this.strokePaint.setStrokeJoin(Paint.Join.MITER);
        } else if (this.strokeJoin == 2) {
            this.strokePaint.setStrokeJoin(Paint.Join.ROUND);
        } else {
            this.strokePaint.setStrokeJoin(Paint.Join.BEVEL);
        }
    }

    @Override
    public void strokeWeight(float f) {
        super.strokeWeight(f);
        this.strokePaint.setStrokeWidth(f);
    }

    @Override
    protected void strokeFromCalc() {
        super.strokeFromCalc();
        this.strokePaint.setColor(this.strokeColor);
        this.strokePaint.setShader(null);
    }

    @Override
    protected void tintFromCalc() {
        super.tintFromCalc();
        this.tintPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.tintColor, PorterDuff.Mode.MULTIPLY));
    }

    @Override
    protected void fillFromCalc() {
        super.fillFromCalc();
        this.fillPaint.setColor(this.fillColor);
        this.fillPaint.setShader(null);
    }

    @Override
    public void backgroundImpl() {
        this.canvas.drawColor(this.backgroundColor);
    }

    @Override
    public void beginRaw(PGraphics pGraphics) {
        PGraphicsAndroid2D.showMethodWarning("beginRaw");
    }

    @Override
    public void endRaw() {
        PGraphicsAndroid2D.showMethodWarning("endRaw");
    }

    @Override
    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
        }
        this.bitmap.getPixels(this.pixels, 0, this.width, 0, 0, this.width, this.height);
    }

    @Override
    public void updatePixels() {
        this.bitmap.setPixels(this.pixels, 0, this.width, 0, 0, this.width, this.height);
    }

    @Override
    public void updatePixels(int n, int n2, int n3, int n4) {
        if (n != 0 || n2 != 0 || n3 != this.width || n4 != this.height) {
            PGraphicsAndroid2D.showVariationWarning("updatePixels(x, y, w, h)");
        }
        this.updatePixels();
    }

    @Override
    public void resize(int n, int n2) {
        PGraphicsAndroid2D.showMethodWarning("resize");
    }

    @Override
    public int get(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 0;
        }
        return this.bitmap.getPixel(n, n2);
    }

    @Override
    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    @Override
    public void set(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        this.bitmap.setPixel(n, n2, n3);
    }

    @Override
    public void set(int n, int n2, PImage pImage) {
        if (pImage.format == 4) {
            throw new RuntimeException("set() not available for ALPHA images");
        }
        if (pImage.bitmap == null) {
            this.canvas.drawBitmap(pImage.pixels, 0, pImage.width, n, n2, pImage.width, pImage.height, false, null);
        } else {
            if (pImage.width != pImage.bitmap.getWidth() || pImage.height != pImage.bitmap.getHeight()) {
                pImage.bitmap.recycle();
                pImage.bitmap = Bitmap.createBitmap((int)pImage.width, (int)pImage.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                pImage.modified = true;
            }
            if (pImage.modified) {
                if (!pImage.bitmap.isMutable()) {
                    pImage.bitmap.recycle();
                    pImage.bitmap = Bitmap.createBitmap((int)pImage.width, (int)pImage.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                pImage.bitmap.setPixels(pImage.pixels, 0, pImage.width, 0, 0, pImage.width, pImage.height);
                pImage.modified = false;
            }
            this.canvas.save(1);
            this.canvas.setMatrix(null);
            this.canvas.drawBitmap(pImage.bitmap, (float)n, (float)n2, null);
            this.canvas.restore();
        }
    }

    @Override
    public void mask(int[] nArray) {
        PGraphicsAndroid2D.showMethodWarning("mask");
    }

    @Override
    public void mask(PImage pImage) {
        PGraphicsAndroid2D.showMethodWarning("mask");
    }

    @Override
    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.rect.set((float)n, (float)n2, (float)(n + n3), (float)(n2 + n4));
        Rect rect = new Rect(n5, n6, n5 + n7, n6 + n8);
        this.canvas.drawBitmap(this.bitmap, rect, this.rect, null);
    }
}

