//ACHTUNG:
//W-Lan aktivieren und dann
//prüfen, wie gut die interne Uhr gestellt ist, mit der APP "ClockSync"
//Bei Nexus7 wird angezeigt als "local offset": -104,994
//D.h. das gerät geht 104994 Millisekunden nach.
//Darum muß als Wert für OFFSET_MILLIS in der datei Interner Speicher/Download/OFFSET_MILLIS.txt
//der Wert 104994 eingetragen werden.
//
//Kontrollrechnung: Atomzeit: 18:45:55    Nexus7: 18:44:10 => Differenz von 60+45==105 Sekunden 

import java.util.*;
import info.kramann.crossplattform.system.Sequenzer;
import info.kramann.crossplattform.system.Audioout;
import info.kramann.crossplattform.mathematik.Zufall;

import info.kramann.crossplattform.system.Datei;

import ketai.sensors.*;

Audioout audioout;
MeinSequenzer meinsequenzer;

Datei datei;

int TONINDEX = 0;

KetaiSensor sensor;
float accelerometerX, accelerometerY, accelerometerZ;

double gesamt = 0.0;

long OFFSET_MILLIS=0;

boolean GESTARTET = false;

void setup()
{
  datei = new Datei(this);
  
  try
  {
      String offset = datei.ladeString("OFFSET_MILLIS.txt");
      OFFSET_MILLIS = (long)Double.parseDouble(offset); 
  }
  catch(Exception e)
  {
  }
  
  meinsequenzer = new MeinSequenzer(this,240);
   
  sensor = new KetaiSensor(this);
  sensor.start();
  orientation(LANDSCAPE);
  textAlign(CENTER, CENTER);
  textSize(36);
  
  System.out.println("Warte auf Synchronität.");
  //Ist schon eingebaut!!!!
  while((System.currentTimeMillis()+OFFSET_MILLIS)%5000!=0);
  audioout = new Audioout(meinsequenzer);
  System.out.println("GESTARTET!");

}

void draw()
{
  background(78, 93, 75);
   
  text("Accelerometer: \n" + 
    "x: " + nfp(accelerometerX, 1, 3) + "\n" +
    "y: " + nfp(accelerometerY, 1, 3) + "\n" +
    "z: " + nfp(accelerometerZ, 1, 3) + "\n" +
    "ges: " + gesamt  + "\n" +
    "OFFSET_MILLIS = " + OFFSET_MILLIS
    , 0, 0, width, height);
}

void onAccelerometerEvent(float x, float y, float z)
{
  accelerometerX = x;
  accelerometerY = y;
  accelerometerZ = z;
  //Gesamtvektor abzüglich Erdbeschleunigung:
  gesamt = Math.sqrt(x*x+y*y+z*z) - 9.81;
  
      TONINDEX = 0;
      if(x>5.0)
          TONINDEX=0;
      else if(x<-5.0)    
          TONINDEX=1;
      else if(y>5.0)    
          TONINDEX=2;
      else if(y<-5.0)
          TONINDEX=3;
      else if(z>5.0)
          TONINDEX=4;
      else if(z<-5.0)
          TONINDEX=5;
}

/*
	available sensors/methods 
	
 * void onSensorEvent(SensorEvent e) - raw android sensor event <br />
 * void onAccelerometerEvent(float x, float y, float z, long a, int b): x,y,z force in m/s^2, a=timestamp(nanos), b=accuracy
 * void onAccelerometerEvent(float x, float y, float z):  x,y,z force in m/s2
 * void onOrientationEvent(float x, float y, flaot z, long a, int b):  x,y,z rotation in degrees, a=timestamp(nanos), b=accuracy
 * void onOrientationEvent(float x, float y, float z) : x,y,z rotation in degrees
 * void onMagneticFieldEvent(float x, float y, float z, long a, int b) : x,y,z geomag field in uT, a=timestamp(nanos), b=accuracy
 * void onMagneticFieldEvent(float x, float y, float z): x,y,z geomagnetic field in uT
 * void onGyroscopeEvent(float x, float y, float z, long a, int b):x,y,z rotation in rads/sec, a=timestamp(nanos), b=accuracy
 * void onGyroscopeEvent(float x, float y, float z): x,y,z rotation in rads/sec
 * void onGravityEvent(float x, float y, float z, long a, int b): x,y,z force of gravity in m/s^2, a=timestamp(nanos), b=accuracy
 * void onGravityEvent(float x, float y, float z): x,y,z rotation in m/s^s
 * void onProximityEvent(float d, long a, int b): d distance from sensor (typically 0,1), a=timestamp(nanos), b=accuracy
 * void onProximityEvent(float d): d distance from sensor (typically 0,1)
 * void onLightEvent(float d, long a, int b): d illumination from sensor in lx
 * void onLightEvent(float d): d illumination from sensor in lx
 * void onPressureEvent(float p, long a, int b): p ambient pressure in hPa or mbar, a=timestamp(nanos), b=accuracy
 * void onPressureEvent(float p): p ambient pressure in hPa or mbar
 * void onTemperatureEvent(float t, long a, int b): t temperature in degrees in degrees Celsius, a=timestamp(nanos), a=timestamp(nanos), b=accuracy
 * void onTemperatureEvent(float t): t temperature in degrees in degrees Celsius
 * void onLinearAccelerationEvent(float x, float y, float z, long a, int b): x,y,z acceleration force in m/s^2, minus gravity, a=timestamp(nanos), b=accuracy
 * void onLinearAccelerationEvent(float x, float y, float z): x,y,z acceleration force in m/s^2, minus gravity
 * void onRotationVectorEvent(float x, float y, float z, long a, int b): x,y,z rotation vector values, a=timestamp(nanos), b=accuracy
 * void onRotationVectorEvent(float x, float y, float z):x,y,z rotation vector values
 * void onAmibentTemperatureEvent(float t): same as temp above (newer API)
 * void onRelativeHumidityEvent(float h): h ambient humidity in percentage
 
*/
