import processing.video.*;

public class Kamera extends Capture
{
     private int SCHWELLE = 50;
  
     private PApplet pap;
     private int ZEILEN  = 480;
     private int SPALTEN = 640;
     private Capture cam;
     public int[] pix;
     public int[] rot;
     public int[] gruen;
     public int[] blau;
     public int[] gelb;
     public int[] grau;
     public int[] kante;
     
     public int[][] zeitbild;
     public int[]   zbild;
     private int PUFFER = 50;
     private int INDEX = 0;
     
     public Kamera(PApplet pap,int nr)
     {         
         //cam = new Capture(pap,640,480,"/dev/video"+nr,30);
         //cam.start();
         super(pap,640,480,"/dev/video"+nr,30);
         this.pap = pap;
         start();
         rot = new int[ZEILEN*SPALTEN];
         gruen = new int[ZEILEN*SPALTEN];
         blau = new int[ZEILEN*SPALTEN];
         gelb = new int[ZEILEN*SPALTEN];
         grau = new int[ZEILEN*SPALTEN];
         kante = new int[ZEILEN*SPALTEN];
         zeitbild = new int[ZEILEN*SPALTEN][PUFFER];
         zbild = new int[ZEILEN*SPALTEN];
     }

     int[] help;
     public void shrink(int[] px)
     {
         if(help==null)
             help = new int[px.length];

         for(int i=0;i<help.length;i++)
             help[i]=0;
         for(int z=1;z<ZEILEN-1;z++)
         {
              for(int s=1;s<SPALTEN-1;s++)
              {
                   int anz = 0;
                   if(px[(z-1)*SPALTEN+(s-1)]>0) anz++;
                   if(px[(z-1)*SPALTEN+(s+0)]>0) anz++;
                   if(px[(z-1)*SPALTEN+(s+1)]>0) anz++;
                   if(px[(z+0)*SPALTEN+(s-1)]>0) anz++;
                   //if(px[(z+0)*SPALTEN+(s+0)]>0) anz++;
                   if(px[(z+0)*SPALTEN+(s+1)]>0) anz++;
                   if(px[(z+1)*SPALTEN+(s-1)]>0) anz++;
                   if(px[(z+1)*SPALTEN+(s+0)]>0) anz++;
                   if(px[(z+1)*SPALTEN+(s+1)]>0) anz++;
                   
                   if(px[(z+0)*SPALTEN+(s+0)]>0 && anz>0)
                       help[(z+0)*SPALTEN+(s+0)]=255;
              }
         }
         
         for(int i=0;i<help.length;i++)
             px[i] = help[i];
         
     }

     
     public void blur(int[] px)
     {
         if(help==null)
             help = new int[px.length];

         for(int i=0;i<help.length;i++)
             help[i]=0;
         for(int z=1;z<ZEILEN-1;z++)
         {
              for(int s=1;s<SPALTEN-1;s++)
              {
                   int anz = 0;
                   if(px[(z-1)*SPALTEN+(s-1)]>0) anz++;
                   if(px[(z-1)*SPALTEN+(s+0)]>0) anz++;
                   if(px[(z-1)*SPALTEN+(s+1)]>0) anz++;
                   if(px[(z+0)*SPALTEN+(s-1)]>0) anz++;
                   //if(px[(z+0)*SPALTEN+(s+0)]>0) anz++;
                   if(px[(z+0)*SPALTEN+(s+1)]>0) anz++;
                   if(px[(z+1)*SPALTEN+(s-1)]>0) anz++;
                   if(px[(z+1)*SPALTEN+(s+0)]>0) anz++;
                   if(px[(z+1)*SPALTEN+(s+1)]>0) anz++;
                   
                   if(px[(z+0)*SPALTEN+(s+0)]>=0 && anz>0)
                       help[(z+0)*SPALTEN+(s+0)]=255;
              }
         }
         
         for(int i=0;i<help.length;i++)
             px[i] = help[i];
         
     }
     
     public void updateFarben()
     {
         updatePixels();
         pix = pixels;
         for(int i=0;i<rot.length;i++)
         {
               int r = (int)pap.red(pix[i]);
               int g = (int)pap.green(pix[i]);
               int b = (int)pap.blue(pix[i]);
               if(r>g+SCHWELLE && r>b+SCHWELLE)
                   rot[i]=255;
               else
                   rot[i]=0;
               if(g>r+SCHWELLE && g>b+SCHWELLE)
                   gruen[i]=255;
               else
                   gruen[i]=0;
               if(b>r+SCHWELLE && b>g+SCHWELLE)
                   blau[i]=255;
               else
                   blau[i]=0;
               if(r>b+SCHWELLE/8 && g>b+SCHWELLE/4)
                   gelb[i]=255;
               else
                   gelb[i]=0;
                   
               grau[i] = (r+g+b)/3;    
         }
         
         for(int z=1;z<ZEILEN-1;z++)
         {
              for(int s=1;s<SPALTEN-1;s++)
              {
                    int anz = gelb[(z+1)*SPALTEN+s]/255+
                        gelb[(z-1)*SPALTEN+s]/255+
                        gelb[(z+1)*SPALTEN+s+1]/255+
                        gelb[(z-1)*SPALTEN+s+1]/255+
                        gelb[(z+1)*SPALTEN+s-1]/255+
                        gelb[(z-1)*SPALTEN+s-1]/255+
                        gelb[z*SPALTEN+s+1]/255+
                        gelb[z*SPALTEN+s-1]/255;
                              
                    if( gelb[z*SPALTEN+s]==0 && anz==1  
                        )
                      
                      {
                           zeitbild[z*SPALTEN+s][INDEX] = 255;
                      }
                      else
                      {
                           zeitbild[z*SPALTEN+s][INDEX] = 0;
                      }
              }
         }

         for(int i=0;i<zbild.length;i++)
         {
              int anz = 0;
              for(int k=0;k<PUFFER;k++)
                  if(zeitbild[i][k]>0)
                     anz++;
              if(anz>(3*PUFFER)/10)
                  zbild[i]=255;
              else
                  zbild[i]=0;
         }
         
         INDEX++;
         INDEX%=PUFFER;
     }

     int[][] filt = new int[3][3];
     public void updateKantenfilter()
     {
       
         for(int z=1;z<ZEILEN-1;z++)
         {
              for(int s=1;s<SPALTEN-1;s++)
              {
                   filt[0][0] = grau[(z-1)*SPALTEN+(s-1)]; 
                   filt[0][1] = grau[(z-1)*SPALTEN+(s)]; 
                   filt[0][2] = grau[(z-1)*SPALTEN+(s+1)];
                   
                   filt[1][0] = grau[(z)*SPALTEN+(s-1)]; 
                   filt[1][1] = grau[(z)*SPALTEN+(s)]; 
                   filt[1][2] = grau[(z)*SPALTEN+(s+1)];
                   
                   filt[2][0] = grau[(z+1)*SPALTEN+(s-1)]; 
                   filt[2][1] = grau[(z+1)*SPALTEN+(s)]; 
                   filt[2][2] = grau[(z+1)*SPALTEN+(s+1)];
                   
                   kante[z*SPALTEN + s] = filt[1][1]*8 
                                          - filt[0][0]
                                          - filt[0][1]
                                          - filt[0][2]
                                          - filt[1][0]
                                          - filt[1][2]
                                          - filt[2][0]
                                          - filt[2][1]
                                          - filt[2][2];
              }
         }     
     }
     
     public void zeigeRot(int x, int y)
     {
          pap.noFill();
          pap.stroke(255,0,0);
          for(int i=0;i<rot.length;i++)
              if(rot[i]>0)
                 pap.rect(x+i%SPALTEN,y+i/SPALTEN,1,1);
     }
     
     public void zeigeGruen(int x, int y)
     {
          pap.noFill();
          pap.stroke(0,255,0);
          for(int i=0;i<gruen.length;i++)
              if(gruen[i]>0)
                 pap.rect(x+i%SPALTEN,y+i/SPALTEN,1,1);
     }
     
     public void zeigeBlau(int x, int y)
     {
          pap.noFill();
          pap.stroke(0,0,255);
          for(int i=0;i<blau.length;i++)
              if(blau[i]>0)
                 pap.rect(x+i%SPALTEN,y+i/SPALTEN,1,1);
     }     

     public void zeigeGelb(int x, int y)
     {
          pap.noFill();
          pap.stroke(255,255,0);
          for(int i=0;i<gelb.length;i++)
              if(gelb[i]>0)
                 pap.rect(x+i%SPALTEN,y+i/SPALTEN,1,1);
     }     

     public void zeigeZBILD(int x, int y)
     {
          pap.noFill();
          pap.stroke(255,255,255);
          for(int i=0;i<zbild.length;i++)
              if(zbild[i]>0)
                 pap.rect(x+i%SPALTEN,y+i/SPALTEN,1,1);
     }     
     
     public void zeigeKante(int x, int y)
     {
          pap.noFill();
          for(int i=0;i<kante.length;i++)
              if(kante[i]>0)
              {
                 pap.stroke(kante[i]);
                 pap.rect(x+i%SPALTEN,y+i/SPALTEN,1,1);
              }   
     }
     
     public void zeigeKante2(int x, int y)
     {
          pap.noFill();
          pap.stroke(0);
          for(int i=0;i<kante.length;i++)
              if(kante[i]>127)
              {
                 pap.rect(x+i%SPALTEN,y+i/SPALTEN,1,1);
              }   
     }
     
}