import processing.video.*;
import themidibus.*; //Import the library

MidiBus myBus; // The MidiBus

boolean ACTIVE = true;

public void changeSound(int channel, int sound_nr)
{
  int status_byte = 0xC0; // Sound selection
  int channel_byte = channel; // On channel 0 again
  int first_byte = sound_nr; // The same note;
  int second_byte = 0; // But with less velocity
  myBus.sendMessage(status_byte, channel_byte, first_byte, second_byte);
}



//Differenzbild
Capture cam;

void setup() 
{
  size(700,600);
  cam = new Capture(this,640,480,"/dev/video1",30);
  cam.start();
  
  //SOUND
  MidiBus.list(); // List all available Midi devices on STDOUT. This will show each device's index and name.

  // Either you can
  //                   Parent In Out
  //                     |    |  |
  myBus = new MidiBus(this,  -1, 1); // Create a new MidiBus using the device index to select the Midi input and output devices respectively.

/*  
schlagphon.sf2

0  vibraphone-sustain-ff.sf2
1  marimba-deadstroke.sf2
2  ConcertoXylophone.sf2
3  balafon1.sf2 ff
4  balafon      mf
5  KinderXylophon.sf2
6  TrebleKalimbaRD.sf2
7  bongos.sf2
8  turtledrum.sf2
9  tubulars.sf2
10  Nigerian_UDU.sf2
11 tamburin.sf2
12 windchimes.sf2
*/
  changeSound(0,4);
  changeSound(1,11);
  changeSound(2,12);
    
  
  
  frameRate(30);
}
int KANAELE = 13;

int[] pix;
int[][] bild_neu = new int[480][640];
int[][] bild_alt = new int[480][640];
int[][] bild =     new int[480][640];

int ZZZ=0;
int[] pitch = new int[KANAELE];
int[] velocity = new int[KANAELE];

int[] COUNTDOWN = new int[KANAELE];
int MAXDAUER = 5;
void draw() 
{
  background(255,0,0);
  
  if (cam.available() == true) 
  {
    cam.read();
    cam.updatePixels();
    pix = cam.pixels;
    int ii=0;
 
    for(int i=0;i<bild.length;i++)
       for(int k=0;k<bild[i].length;k++)
           bild_alt[i][k] = bild_neu[i][k];
 
 
    for(int i=0;i<pix.length;i++)
    {
        int zeile = i/640;
        int spalte = i%640;
        
         bild_neu[zeile][spalte] = pix[i];
    }
    
    for(int i=0;i<bild.length;i++)
    {
       for(int k=0;k<bild[i].length;k++)
       {
           int rotanteil_alt   = (int)red(bild_alt[i][k]);
           int rotanteil_neu   = (int)red(bild_neu[i][k]);

           if( abs(rotanteil_alt - rotanteil_neu) > 50 )
               bild[i][k] = 255;
           else    
               bild[i][k] = 0;
       }    
    }
  }
  //image(cam, 0, 0);
  noStroke();
  for(int i=0;i<bild.length;i++)  
  {
       for(int k=0;k<bild[i].length;k++)
       {
           fill(bild[i][k]);
           rect(k,i,1,1);
       }    
  }
  
  
  //SOUND
  
  if(ACTIVE==false)
  {
      myBus.clearAll();
      background(0,255,0);
      return;
  }

  noFill();
  stroke(255);
  for(int kan=0;kan<13;kan++)
  {
       int xwert = 40*kan + 20;
       line(xwert,0,xwert,480);

     if(COUNTDOWN[kan]==0)
       for(int i=0;i<480;i++)
       {
           if(bild[i][xwert]>0)
           {
                int tonhoehe = 48 + (480 - i)/10;
                if(tonhoehe>127) tonhoehe = 127;
                
                
                pitch[kan]    = tonhoehe;
                velocity[kan] = 88;

                myBus.sendNoteOn(kan, pitch[kan], velocity[kan]); // Send a Midi noteOn
                
                COUNTDOWN[kan] = 1;
                break;
           }
       }
  }
 
  for(int i=0;i<COUNTDOWN.length;i++)
  {
      if(COUNTDOWN[i]>0)
          COUNTDOWN[i]++;
          
      if(COUNTDOWN[i] > MAXDAUER)
      {
          myBus.sendNoteOff(i, pitch[i], velocity[i]); // Send a Midi noteOn
          COUNTDOWN[i] = 0;
      }
  }
  
}


void keyPressed() 
{
  if (key == ' ') 
  {
      ACTIVE = false;
  }
}