library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;


entity neuro2 is
    Port ( MEINECLOCK : in  STD_LOGIC;
           MEINELED : out  STD_LOGIC;
           S0 : in  STD_LOGIC;
           S1 : in  STD_LOGIC;
           S2 : in  STD_LOGIC;
           S3 : in  STD_LOGIC;
           LENK0 : out  STD_LOGIC;
           LENK1 : out  STD_LOGIC);
end neuro2;
-- Clock-In == 6MHz, Toggeln nach 3000000 Schritten ergibt 1Hz Blinkfrequenz.
architecture Behavioral of neuro2 is
--w-werte als Konstanten für FPGA:
constant w0: integer := -77;
constant w1: integer := -77;
constant w2: integer := 127;
constant w3: integer := -23;
constant w4: integer := 73;
constant w5: integer := -127;
constant w6: integer := 23;
constant w7: integer := -27;
constant w8: integer := 73;
constant w9: integer := -27;
constant w10: integer := -23;
constant w11: integer := -127;
constant w12: integer := 23;
constant w13: integer := -27;
constant w14: integer := -127;
constant w15: integer := -27;
constant w16: integer := 23;
constant w17: integer := -27;
constant w18: integer := 127;
constant w19: integer := -73;
    signal zaehler    : integer range 0 to 2999999 := 0;
    signal logikpegel : std_logic := '0';
	 
	 -- Speichern der gewichteten Summen:
    signal out0    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal out1    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal out2    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal out3    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal out4    : integer range -32768 to 32767 := 0; -- 16Bit Variable

    -- Speichern der out-Werte nach Anwendung der sigmoiden Funktion:
    signal out0_sigmo    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal out1_sigmo    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal out2_sigmo    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal out3_sigmo    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal out4_sigmo    : integer range -32768 to 32767 := 0; -- 16Bit Variable
	 
	 -- Sensorzustände als Integer-Werte zur Verfügung stellen:
    signal iS0    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal iS1    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal iS2    : integer range -32768 to 32767 := 0; -- 16Bit Variable
    signal iS3    : integer range -32768 to 32767 := 0; -- 16Bit Variable
begin
        process begin
            wait until rising_edge(MEINECLOCK);
            if (zaehler<2999999) then
                zaehler <= zaehler+1;
            else
                zaehler <= 0;
                logikpegel <= not logikpegel;					 
            end if;
        end process;
        MEINELED <= logikpegel;
		  
		  -- Sensorwerte als Integer-Werte zur Verfügung stellen:
		  iS0 <= 1 when (S0 = '1') else 0;
		  iS1 <= 1 when (S1 = '1') else 0;
		  iS2 <= 1 when (S2 = '1') else 0;
		  iS3 <= 1 when (S3 = '1') else 0;

        -- Gewichtete Summen der ersten Schicht:		  
		  out0 <= w0*iS0 + w1*iS1 + w2*iS2 + w3*iS3;
		  out1 <= w4*iS0 + w5*iS1 + w6*iS2 + w7*iS3;
		  out2 <= w8*iS0 + w9*iS1 + w10*iS2 + w11*iS3;
		  out3 <= w12*iS0 + w13*iS1 + w14*iS2 + w15*iS3;

        -- So kann der Lookup-Table der sigmoiden Funktion umgesetzt werden:
        with out0 select out0_sigmo <=
		      0 when -32768 to -5, 
		      2 when -4, 
		      6 when -3, 
		      15 when -2, 
		      34 when -1, 
		      63 when 0, 
		      92 when 1, 
		      111 when 2, 
		      120 when 3, 
		      124 when 4, 
		      126 when 5 to 17, 
				127 when others;

        with out1 select out1_sigmo <=
		      0 when -32768 to -5, 
		      2 when -4, 
		      6 when -3, 
		      15 when -2, 
		      34 when -1, 
		      63 when 0, 
		      92 when 1, 
		      111 when 2, 
		      120 when 3, 
		      124 when 4, 
		      126 when 5 to 17, 
				127 when others;

        with out2 select out2_sigmo <=
		      0 when -32768 to -5, 
		      2 when -4, 
		      6 when -3, 
		      15 when -2, 
		      34 when -1, 
		      63 when 0, 
		      92 when 1, 
		      111 when 2, 
		      120 when 3, 
		      124 when 4, 
		      126 when 5 to 17, 
				127 when others;

        with out3 select out3_sigmo <=
		      0 when -32768 to -5, 
		      2 when -4, 
		      6 when -3, 
		      15 when -2, 
		      34 when -1, 
		      63 when 0, 
		      92 when 1, 
		      111 when 2, 
		      120 when 3, 
		      124 when 4, 
		      126 when 5 to 17, 
				127 when others;
		  		  
		  out4 <= w16*out0_sigmo + w17*out1_sigmo +w18*out2_sigmo +w19*out3_sigmo;

        with out4 select out4_sigmo <=
		      0 when -32768 to -5, 
		      2 when -4, 
		      6 when -3, 
		      15 when -2, 
		      34 when -1, 
		      63 when 0, 
		      92 when 1, 
		      111 when 2, 
		      120 when 3, 
		      124 when 4, 
		      126 when 5 to 17, 
				127 when others;

        -- Generieren binärer Zustände aus dem Wert des Ausgangsneurons		  
        with out4_sigmo select LENK0 <=
		      '1' when -32768 to -32, 
				'0' when others;
				
        with out4_sigmo select LENK1 <=
		      '1' when 32 to 32767, 
				'0' when others;		  
end Behavioral;

