library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity neuro1 is
    Port ( MEINECLOCK : in  STD_LOGIC;
           MEINELED : out  STD_LOGIC;
           S0 : in  STD_LOGIC;
           S1 : in  STD_LOGIC;
           S2 : in  STD_LOGIC;
           S3 : in  STD_LOGIC;
           LENK0 : out  STD_LOGIC;
           LENK1 : out  STD_LOGIC);
end neuro1;
-- Clock-In == 6MHz, Toggeln nach 3000000 Schritten ergibt 1Hz Blinkfrequenz.
architecture Behavioral of neuro1 is
    signal zaehler    : integer range 0 to 2999999 := 0;
    signal logikpegel : std_logic := '0';
    signal dummy0 : std_logic := '0';
    signal dummy1 : std_logic := '0';
    signal dummy2 : std_logic := '0';
begin
        process begin
            wait until rising_edge(MEINECLOCK);
            if (zaehler<2999999) then
                zaehler <= zaehler+1;
            else
                zaehler <= 0;
                logikpegel <= not logikpegel;					 
            end if;
        end process;
        MEINELED <= logikpegel or ( dummy0 and dummy1 );
		  LENK0 <= not S2;
		  LENK1 <= not S3;
		  dummy0 <= S0; -- Um Compilerprobleme an dieser Stelle zu vermeiden
		  dummy1 <= S1;
end Behavioral;

