//Leitet Sensorwerte weiter an den FPGA:
//Sensor Arduino(out) FPGA(in)
// s0 == IO5 ==   IO25 
// s1 == IO6 ==   IO26 
// s2 == IO7 ==   IO27 
// s3 == IO8 ==   IO28 

//Lenkwert:
//Wert Arduino(in) FPGA(out)
//-1    IO3     IO23
// 1    IO4     IO24
// 0    IO3==IO4==0

//Sendet den Lenkzustand zurück an den PC:
// X==-1 Y==1  Z==0

int sensor=0;
int lenk = 0;
int i; //Laufvariable für Schleifen
void setup() 
{

    //Verbindung zu FPGA
    //Sensoren: von Arduino nach FPGA
    pinMode(5,INPUT);
    pinMode(6,INPUT);
    pinMode(7,INPUT);
    pinMode(8,INPUT);

    digitalWrite(5,LOW);
    digitalWrite(6,LOW);
    digitalWrite(7,LOW);
    digitalWrite(8,LOW);

    //Lenkzustand von FPGA nach Arduino
    pinMode(3,INPUT);
    pinMode(4,INPUT);
    digitalWrite(3,LOW); //hier auch kein pullup!
    digitalWrite(4,LOW); //  ... dadurch positive Logik möglich        

    //Kontroll-LEDs:
    pinMode(9,OUTPUT);
    pinMode(10,OUTPUT);
    pinMode(11,OUTPUT);
    pinMode(12,OUTPUT);

    digitalWrite(9,LOW);
    digitalWrite(10,LOW);
    digitalWrite(11,LOW);
    digitalWrite(12,LOW);
    
    Serial.begin(9600);
}

void loop() 
{
    while(Serial.available())
    {
        sensor = Serial.read();
    }

    if(sensor>='A' && sensor<='A'+15)
    {
        sensor-='A';

        //Regeln wie in regel() ... einfache Version im Processing Sketch
//Processing:        
//      public float regeln(int[] sensorwerte) //liefert omega
//     {
//         if(sensorwerte[2]==0)
//            return -1;
//         else if(sensorwerte[3]==0)
//            return 1;
//         else
//            return 0.0;
//      }

//Hier: DEAKTIVIERT, soll jetzt von FPGA kommen.
//        if((sensor/4)%2==0)  //s2
//            lenk = -1;
//        else if((sensor/8)%2==0) //s3
//            lenk =  1;
//        else
//            lenk = 0;    

//Dazu zuerst Sensorzustand an FPGA weiterleiten:
        //s0
        if((sensor/1)%2==1)
            pinMode(5,INPUT); //High bei FPGA wird über dessen Pullup-R erreicht!!!            
        else
            pinMode(5,OUTPUT); //Damit wird GROUND übertragen und LOW bei FPGA stellt sich ein

        //s1
        if((sensor/2)%2==1)
            pinMode(6,INPUT); 
        else
            pinMode(6,OUTPUT); 

        //s2
        if((sensor/4)%2==1)
            pinMode(7,INPUT); 
        else
            pinMode(7,OUTPUT); 

        //s3
        if((sensor/8)%2==1)
            pinMode(8,INPUT); 
        else
            pinMode(8,OUTPUT); 

        //Jetzt ein paar Taktzyklen Pause, bis sich der
        //Ausgabezustand beim FPGA stabilisiert hat (ev. unnötig):
        for(i=0;i<100;i++)
            PORTB|=0b00000000;

        //Nun Lenkzustand von FPGA holen:
        if( digitalRead(3)>0 )
            lenk = -1;
        else if( digitalRead(4)>0 )
            lenk = 1;
        else
            lenk = 0;    

        //Zurück schicken:
        if(lenk==-1)
            Serial.write('X');
        else if(lenk==1)
            Serial.write('Y');
        else
            Serial.write('Z');

        // S0
        if(sensor%2>0) 
            digitalWrite(9,HIGH);
        else  
            digitalWrite(9,LOW);
        sensor/=2;
        // S1
        if(sensor%2>0) 
            digitalWrite(10,HIGH);
        else  
            digitalWrite(10,LOW);
        sensor/=2;
        // S2
        if(sensor%2>0) 
            digitalWrite(11,HIGH);
        else  
            digitalWrite(11,LOW);
        sensor/=2;
        // S3
        if(sensor%2>0) 
            digitalWrite(12,HIGH);
        else  
            digitalWrite(12,LOW);
         
    }
}
