//Punkte vor Fahrzeug erkennen:
// 
//        *              (0,40)
//
//     *  *  *  (-20,20) (0,20) (20,20)
//
//       |-| Fahrzeug fährt nach oben

public class Auto
{
    public float x;
    public float y;
    public float phi;
    public float omega;
    public float v;

    public int[] sensorwerte = new int[4];  

    //Sensor-Koordinaten
    public float x1,y1,x2,y2,x3,y3,x4,y4;
    
    public Auto(float x, float y, float phi, float v)
    {
         this.x   = x;
         this.y   = y;
         this.phi = phi;
         this.v   = v;
         this.omega = 0.0;
         zeitschritt(0.0);
    }
    
    public void setPhi(float phi)
    {
          this.phi = phi;
    }
    
    public void setOmega(float omega)
    {
          this.omega = omega;
    }
    
    public void zeitschritt(float dt)
    {
         phi+=omega*dt;
      
         x+= v*cos(phi)*dt;     
         y+= v*sin(phi)*dt; 
         
         //Sensorpositionen auffrischen
         x1 = x + 20.0*cos(phi);  //gruen (mitte)
         y1 = y + 20.0*sin(phi);
     
         x2 = x + 40.0*cos(phi);  //gelb (vorn)
         y2 = y + 40.0*sin(phi);
     
         x3 = x + 20.0*cos(phi)  - 20.0*sin(phi);  //blau (links)
         y3 = y + 20.0*sin(phi)  + 20.0*cos(phi);
     
         x4 = x + 20.0*cos(phi)  + 20.0*sin(phi);  //türkis (rechts)
         y4 = y + 20.0*sin(phi)  - 20.0*cos(phi); 
         
         //Sensorwerte aktualisieren:
         //float Rbahn = 250;
         //float bahnbreite = 40;
         
         float r = Rbahn - 0.5f*bahnbreite;
         float R = Rbahn + 0.5f*bahnbreite;
         
         float s1 = sqrt(x1*x1+y1*y1);
         if(s1>=r && s1<=R)
            sensorwerte[0] = 1;
         else   
            sensorwerte[0] = 0;
            
         float s2 = sqrt(x2*x2+y2*y2);
         if(s2>=r && s2<=R)
            sensorwerte[1] = 1;
         else   
            sensorwerte[1] = 0;
            
         float s3 = sqrt(x3*x3+y3*y3);
         if(s3>=r && s3<=R)
            sensorwerte[2] = 1;
         else   
            sensorwerte[2] = 0;
            
         float s4 = sqrt(x4*x4+y4*y4);
         if(s4>=r && s4<=R)
            sensorwerte[3] = 1;
         else   
            sensorwerte[3] = 0;
            
            
    }
    
    public void draw()
    {
     noStroke();
     fill(255,0,0);
     ellipse(x,y,20,20);
 
     x+= v*cos(phi)*dt;     
     y+= v*sin(phi)*dt;
     stroke(255,0,0);
     line(x,y,x+15.0*cos(phi),y+15.0*sin(phi));
     
     noFill();
     stroke(0,255,0);
     ellipse(x1,y1,8,8);
     
     stroke(255,255,0);
     ellipse(x2,y2,8,8);
     
     stroke(0,0,255);
     ellipse(x3,y3,8,8);
     
     stroke(0,255,255);
     ellipse(x4,y4,8,8);     
    }

    public void drawSensorwerte()
    {
       noStroke();
       for(int ii=0;ii<sensorwerte.length;ii++)
       {
           if(sensorwerte[ii]>0 && x>=-width/2 && x<=width/2 && y>=-height/2 && y<=height/2)
              fill(0,255,0);
           else    
              fill(255,0,0);
           rect(width/2-25,height/2-25-26*ii,25,25);
       }
    }
    
    public int getSensorwert(int nr)
    {
          return sensorwerte[nr];
    }
    
    public int[] getSensorwerte()
    {
          return sensorwerte;
    }
}