//Jetzt werden die Sesnorwerte nicht mehr aus Farbpixeln gewonnen, sondern geometrisch,
//was eine Offline-Simulation (ohne Visualisierung) ermöglicht.
import java.util.Random;

int MINWERT = 0;
int MAXWERT = 0;

float Rbahn = 250;
float bahnbreite = 40;

float v = 40;
float phi = PI/4;
float x = 0;
float y = 0;
float dt = 1.0/30.0;

public Auto auto;

//Neuronales Netz
int[] w = new int[20];   //Alle Gewichte des Neuronalen Netzes
int[] out = new int[5];  //Ausgänge der 5 Neuronen des Neuronalen Netzes
//Random zufall = new Random(System.currentTimeMillis());
Random zufall = new Random(0);  //um wg. Reproduzierbarkeit immer gleiche Ergebnisse zu bekommen.
// siehe Funktion "regeln(..)"

public void setup()
{
    for(int i=0;i<w.length;i++)
    {
        float ww = 20.0f*(zufall.nextFloat() -0.5f)  ; // Zufallswerte zwischen ]-1000,+1000[
        if(ww>127.0) ww=127.0;
        if(ww<-127.0) ww=-127.0;
        w[i] = (int)ww;
    }
    auto = new Auto(x,-height/2+bahnbreite,phi,v);

    float aktueller_fehler = (float)fehlerfunktion(w);
    
    println("Anfangsfehler: "+aktueller_fehler);

    //Optimierung hier vornehmen, bevor visualisiert wird:
    for(int schritte=0;schritte<10000;schritte++)
    {
          //Zufällig ein Gewicht auswählen:
          int inx = zufall.nextInt(w.length);
          int richtung = zufall.nextInt(2)*2-1; // -1 oder 1
          float alfa = 50.0f;
          
          int alter_wert = w[inx];
          
          w[inx] += alfa*(float)richtung; 
          
          if(w[inx]<-127) w[inx] = -127;
          if(w[inx]>127) w[inx] = 127;
          
          float neuer_fehler = fehlerfunktion(w);
           
          if(neuer_fehler<=aktueller_fehler)
          {
               if(neuer_fehler<aktueller_fehler)
               {
                    println("Fehler = "+neuer_fehler);
               }
               aktueller_fehler = neuer_fehler;  //Neuer Fehler wird aktueller
          }
          else
          {
              w[inx] = alter_wert; //Änderung rückgängig machen
          }
          
    }
    println();
    println();
    println("Sigmoid - Lookup: -127...+127");
    for(int i=-127;i<=127;i++)
        print(sigmoid(i)+",");
  
    println();
    println();
    println("w-werte:");
    for(int i=0;i<w.length;i++)
        print(w[i]+",");
  
MINWERT = 0;
MAXWERT = 0;
  
    size(600,600);
    frameRate(1.0/dt);
    
    
}

public void draw()
{   
     translate(width/2, height/2);
     scale(1.0,-1.0);
     background(0);
          
     noStroke();
     fill(255);
     ellipse(0,0,2*Rbahn+bahnbreite,2*Rbahn+bahnbreite);
     fill(0);
     ellipse(0,0,2*Rbahn-bahnbreite,2*Rbahn-bahnbreite);
     
     auto.draw();
     auto.drawSensorwerte();
     
     auto.zeitschritt(dt);
     
     auto.setOmega(regeln(auto.sensorwerte));
}

public void keyPressed()
{
        if (key == CODED) 
        {
            if (keyCode == LEFT) 
            {
                phi+=PI/16.0;
                auto.setPhi(phi);
            } 
            else if (keyCode == RIGHT) 
            {
                phi-=PI/16.0;
                auto.setPhi(phi);
            } 
        }
  
}