public class Zeichentafel
{
      String zeichen = "ABCDEFGHIJKLMNOPQRSTUVWXZ";
      float[][] koord;
      public Zeichentafel()
      {
           koord = new float[zeichen.length()][3];
           for(int i=0;i<zeichen.length();i++)
           {
      
               float z = -500.0f;
               float y = - 200 + (i/5)*100;
               float x = 100*(i%5) - 200;
               koord[i][0] = x;
               koord[i][1] = y;
               koord[i][2] = z;
           }  
      }
      
      public void draw()
      {
        textSize(64);
        for(int i=0;i<zeichen.length();i++)
        {
          pushMatrix();
          translate(koord[i][0],koord[i][1],koord[i][2]); 
          noStroke();
          fill(0,255,0);
          text(zeichen.substring(i,i+1),-20,20);
          popMatrix();
        }
      }
      
      /**
      *     Liefert entweder den angeschauten Buchstaben, oder null, wenn keiner genau angeschaut wird.
      */      
      public String angeblickt(float ez_x,float ez_y,float ez_z)
      {
        for(int i=0;i<zeichen.length();i++)
        {
           float x = koord[i][0]; 
           float y = koord[i][1]; 
           float z = koord[i][2]; 
           //1) Einheitsvektor bilden:
           float laenge = sqrt(x*x+y*y+z*z);
           float xx=x/laenge;
           float yy=y/laenge;
           float zz=z/laenge;
      
           //2) Skalarprodukt mit Blickrichtung (ez)      
           float sk = xx*ez_x + yy*ez_y + zz*ez_z;
           
           if(sk>0.99f)
           {
                return zeichen.substring(i,i+1);
           }
        }
        return null;
      }
      
      public void setText(String neu)
      {
           if(zeichen.length()==neu.length())
               zeichen = neu;
           else
               println("Neue Zeichentafel hat die falasche Länge");
      }
}