package xxxsimulatorxxx;
import processing.core.*;

/**
<code>
<pre>
 This sourcecode is part of the library xxxsimulatorxxx

 Copyright (c) 2013-05 Guido Kramann
 Fachhochschule Brandenburg
 University of Applied Sciences Brandenburg
 Germany 

 http://www.kramann.info

 The library xxxsimulatorxxx is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation, version 2.1.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General
 Public License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA  02111-1307  USA
</pre>
</code>
<br/>
<br/>
 * @author Guido Kramann
 * @version 1.0
<br/>
<br/>
*/

public class Test
{
  Integrator integrator;
  FahrzeugModell     modell;

  double dt = 0.1;
  double  t = 0.0;

  double[] y;
  double[] y0;
  double[] y_alt;

  void initialisieren()
  {  
    modell = new FahrzeugModell();
    modell.phi = 0.1;    
    y = new double[modell.anzahl];
    y0 = new double[] {0.0,0.0,0.0};
    y[0] = y0[0];
    y[1] = y0[1];
    y[2] = y0[2];
    y_alt = new double[modell.anzahl];
    integrator = new Integrator(modell);
  }

  void zeitschritt()
  { 
    System.out.print("t="+t+" ");   
    for(int i=0;i<y.length;i++)
    {
        System.out.print("y"+i+"="+y[i]+" ");   
    }
    System.out.println();

    for(int i=0;i<y.length;i++)
        y_alt[i] = y[i];
  
    integrator.zeitschritt(y,y_alt,t,dt); //Ergebnis wird in y gelegt
    
    t+=dt;   
  }
  
  public static void main(String[] args)
  {
     Test test = new Test();
     test.initialisieren();
     for(int i=0;i<100;i++)
     {
         test.zeitschritt();
     }
  }
}



