package xxxevooptxxx;
import processing.core.*;

/**
<code>
<pre>
 This sourcecode is part of the library xxxevooptxxx

 Copyright (c) 2013-05 Guido Kramann
 Fachhochschule Brandenburg
 University of Applied Sciences Brandenburg
 Germany 

 http://www.kramann.info

 The library xxxevooptxxx is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation, version 2.1.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General
 Public License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA  02111-1307  USA
</pre>
</code>
<br/>
<br/>
 * @author Guido Kramann
 * @version 1.0
<br/>
<br/>
Einfaches Beispiel f&uuml;r eine Implementierung der Schnittstelle Fehlerfunktion f&uuml;r das
Erraten einer Zahl.
*/
public class MeineFehlerfunktion implements Fehlerfunktion
{
//    private int x=128;
    private int[] x = {0,0,0,0,0,0,0,1};
    private int[] xgray = {0,0,0,0,0,0,0,0}; //Hilfsarray, in dem das von Bin&auml;rcode nach
                                             //nach Graycode umgerechnete Bitpattern abgelegt wird.   
    private int[] genbin = {0,0,0,0,0,0,0,0}; //Hilfsarray, in dem das von Graycode nach                 
                                              //Bin&auml;rcode umgerechnete Bitpattern abgelegt wird.
  
    private PApplet pap;
    private Graycode graycode;
  
    public MeineFehlerfunktion(PApplet pap)
    {
        this.pap = pap;
        graycode = new Graycode(pap);      
    }
  
    public double berechne(Gen gen)
    {
        //Gesuchte Zahl in Bin&auml;rcode umrechnen:
        graycode.bin2gray(xgray,x);
      
        //bestimmt Hamiltonabstand:
        int h=0;
        for(int i=0;i<x.length;i++)
            if(xgray[i]!=gen.arr[i])
                h++;
        
        return (double)h;        
    }
  
    public double berechneUndZeige(Gen gen)
    {
        //Gesuchte Zahl in Bin&auml;rcode umrechnen:
        graycode.bin2gray(xgray,x);

         //bestimmt Hamiltonabstand:
        int h=0;
        for(int i=0;i<x.length;i++)
            if(xgray[i]!=gen.arr[i])
                h++;
        
        System.out.println("F&uuml;r das gen ");
        graycode.gray2bin(genbin,gen.arr);
        graycode.showBitpattern(genbin);        
        System.out.println(" wurde folgender Fehler bestimmt: err="+(double)h);
        //System.out.println("Bei dem Fahrzeugmodell könnte hier (s. Klasse Fehlerfunktion) eine Animation aufgerufen werden!");
        //System.out.println("Hier beim Zahleraten wird lediglich die Zahl ausgegeben:");
        int geraten = (genbin[0]*1+genbin[1]*2+genbin[2]*4+genbin[3]*8+genbin[4]*16+genbin[5]*32+genbin[6]*64+genbin[7]*128);
        System.out.println("Geratene Zahl:"+geraten);
        System.out.println("Richtig ist:128");
        System.out.println("Zur Kontrolle beide Zahlen in Graycode:");
        System.out.println("Zu ratende Zahl (128):");
        graycode.showBitpattern(xgray);
        System.out.println("Geratene Zahl ("+geraten+"):");
        graycode.showBitpattern(gen.arr);
        System.out.println();
        
        return (double)h;        
    }
    
}
