package xxxevooptxxx;
import processing.core.*;

/**
<code>
<pre>
 This sourcecode is part of the library xxxevooptxxx

 Copyright (c) 2013-05 Guido Kramann
 Fachhochschule Brandenburg
 University of Applied Sciences Brandenburg
 Germany 

 http://www.kramann.info

 The library xxxevooptxxx is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation, version 2.1.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General
 Public License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA  02111-1307  USA
</pre>
</code>
<br/>
<br/>
 * @author Guido Kramann
 * @version 1.0
<br/>
<br/>
Methoden, um Bitmuster von Bin&auml;rcode in Gray-Code umzurechnen und umgekehrt.<br/>
Achtung: in den Bitpattern steht stets das niederwertigste Bit zuerst!
*/
public class Graycode
{
    private PApplet pap;
    
    public Graycode(PApplet pap)
    {
        this.pap = pap;
    }
  
    public void bin2gray(int[] gray, int[] bin)
    {
        for(int i=0;i<bin.length;i++)
        {
            if(i<bin.length-1)
            {
                if(bin[i]!=bin[i+1])
                    gray[i] = 1;
                else              
                    gray[i] = 0;
            }          
            else
            {
                if(bin[i]!=0)
                    gray[i] = 1;
                else              
                    gray[i] = 0;
            }
        }      
    }  
    
    public void gray2bin(int[] bin, int[] gray)
    {
        
        for(int i=bin.length-1;i>=0;i--)
        {
            if(i<bin.length-1)
            {
                 if(gray[i] != bin[i+1])
                     bin[i] = 1;
                 else              
                     bin[i] = 0;
            }
            else
            {
                 if(gray[i] != 0)
                     bin[i] = 1;
                 else              
                     bin[i] = 0;
            }          
        }              
    }
    
    public void showBitpattern(int[] bp)
    {
        for(int i=0;i<bp.length;i++)
            System.out.print(bp[i]);
        System.out.println();      
    }
    
    
    /**
    Zur Bew&auml;ltigung von Optimierungsaufgaben ist es nötig, Parameters&auml;tze in Gene, also hier Graycode-Bitpattern umzusetzen,
    um diese mit aktuellen Genen vergleichen zu können.<br/>
    Umgekehrt m&uuml;ssen Gene (Graycode-Bitpattern) in Parameters&auml;tze umgewandelt werden, um deren Ph&auml;notypen bilden zu können.<br/>
    <br/>
    Die Nachfolgende Methode bekommt als &uuml;bergabeparameter eine positive Integerzahl (oder Null), einen positiven Maximalwert und
    ein Bitarray, in das die Integerzahl als Bin&auml;rcode abgebildet werden soll. 
    */
    public void posint2bin(int[] bin, int wert,int maxwert)
    {
        //Skalierung:
        int maxgray = 1;
        for(int i=0;i<bin.length;i++)
            maxgray*=2;
        maxgray--;
        //Zwischenumwandlung nach long int nötig, um &uuml;berl&auml;ufe zu vermeiden. 
        long lwert = ((long)wert*(long)maxgray)/(long)maxwert;
        wert = (int)lwert;
//????????        
//System.out.println(wert+" "+maxgray+" "+maxwert);     
        for(int i=0;i<bin.length;i++)
        {
            bin[i]=wert%2;
            wert/=2;          
        }
    }
    /**
    Wie posint2bin, jedoch Umwandlung in Graycode.
    */ 
    public void posint2gray(int[] gray, int wert,int maxwert)
    {
        int[] bin = new int[gray.length];
        posint2bin(bin,wert,maxwert);  
        bin2gray(gray,bin);
    }
    
    /**
    Umkehrmethode zu posint2bin
    */
    public int bin2posint(int[] bin, int maxwert)
    {
        int wert = 0;
        int potenz = 1;

        for(int i=0;i<bin.length;i++)
        {
            wert+=bin[i]*potenz;
            potenz*=2;
        }            
      
        potenz--;
        
        //Zwischenumwandlung nach long int nötig, um &uuml;berl&auml;ufe zu vermeiden. 
        return (int)(((long)wert*(long)maxwert)/(long)potenz);      
    }

    /**
    Umkehrmethode zu posint2gray
    */
    public int gray2posint(int[] gray, int maxwert)
    {
        int[] bin = new int[gray.length];
        gray2bin(bin,gray);        
        return bin2posint(bin,maxwert);
    }

    /**
    Die nachfolgenden Methoden erweitern die vier voangehenden um den negativen Zahlenbereich.<br/>
    */

    public void int2bin(int[] bin, int wert,int minwert, int maxwert)
    {
        posint2bin(bin,wert-minwert,maxwert-minwert);
    }
    /**
    Wie int2bin, jedoch Umwandlung in Graycode.
    */ 
    public void int2gray(int[] gray, int wert,int minwert, int maxwert)
    {
        posint2gray(gray,wert-minwert,maxwert-minwert);
    }
    
    /**
    Umkehrmethode zu int2bin
    */
    public int bin2int(int[] bin, int minwert, int maxwert)
    {
        return minwert + bin2posint(bin,maxwert-minwert);
    }

    /**
    Umkehrmethode zu int2gray
    */
    public int gray2int(int[] gray, int minwert, int maxwert)
    {
        return minwert + gray2posint(gray,maxwert-minwert);
    }

    /**
    Die nachfolgenden vier Methoden erlauben es einzelne Double-Parameter in Bin&auml;rcode oder Graycode umzuwandeln.
    <br/>
    */

    public void double2bin(int[] bin, double dwert,double dminwert, double dmaxwert)
    {
        //Alle double-Werte bezogen auf das Bitarray optimal auf Integer-Werte skalieren:
        int maxbin = 1;
        for(int i=0;i<bin.length;i++)
            maxbin*=2;
        maxbin--;
        
        int wert = (int)(0.5+((dwert-dminwert)*(double)maxbin)/(dmaxwert-dminwert));
//????????        
//System.out.println(wert+" "+maxbin);     
        posint2bin(bin,wert,maxbin);
    }
    /**
    Wie double2bin, jedoch Umwandlung in Graycode.
    */ 
    public void double2gray(int[] gray, double dwert,double dminwert, double dmaxwert)
    {
        int[] bin = new int[gray.length];
        double2bin(bin,dwert,dminwert,dmaxwert);
        bin2gray(gray,bin);        
    }
    
    /**
    Umkehrmethode zu double2bin
    */
    public double bin2double(int[] bin, double dminwert, double dmaxwert)
    {
        int maxbin = 1;
        for(int i=0;i<bin.length;i++)
            maxbin*=2;
        maxbin--;
        
        int wert = bin2posint(bin,maxbin);
//????????        
//System.out.println(wert+" "+maxbin);     
        
        return dminwert + ((double)wert*(dmaxwert-dminwert))/(double)maxbin;
    }

    /**
    Umkehrmethode zu double2gray
    */
    public double gray2double(int[] gray, double dminwert, double dmaxwert)
    {
        int[] bin = new int[gray.length];
        gray2bin(bin,gray);        
        return bin2double(bin,dminwert,dmaxwert);
    }
 
    /**
    Typischerweise sollen nicht einzelne Parameter, sondern Parameters&auml;tze optimiert werden.<br/>
    Die nachfolgenden Methoden bilden Parameters&auml;tze auf Bitpattern und Bitpattern auf Parameters&auml;tze ab.<br/>
    Grundlage bilden die vorangehend umgesetzten Methoden.<br/>
    Jedem Parameter ist stets ein eigener Minimalwert und ein eigener Maximalwert zugeordnet, die ebenfalls in Array abgelegt sind.<br/>
    Es wird davon auagegangen, dass alle m Parameter mit gleichvielen n Bits repr&auml;sentiert werden.<br/>
    Deshalb m&uuml;ssen die Bitarrays bin und gray die L&auml;nge m*n haben. DIES WIRD BEI ALLEN METHODEN VORAUSGESETZT.    
    */
    public void doublearr2bin(int[] bin, double[] dwert,double[] dminwert, double[] dmaxwert)
    {
        //Aufspaltung des Bitarrays:
        int[][] bbin = new int[dwert.length][];
        for(int i=0;i<bbin.length;i++)
        {
            bbin[i] = new int[bin.length/dwert.length];
            double2bin(bbin[i],dwert[i],dminwert[i],dmaxwert[i]);                            
        }
        
        //Bitarray wieder zusammensetzen:
        for(int i=0;i<bbin.length;i++)
            for(int k=0;k<bbin[i].length;k++)
                bin[i*bbin[i].length+k] = bbin[i][k];        
    }

    /**
    Wie doublearr2bin, jedoch Umwandlung in Graycode.
    */ 
    public void doublearr2gray(int[] gray, double[] dwert,double[] dminwert, double[] dmaxwert)
    {
        int[] bin = new int[gray.length];
        doublearr2bin(bin,dwert,dminwert,dmaxwert);
        bin2gray(gray,bin);        
    }

    /**
    Umkehrmethode zu doublearr2bin
    */
    public void bin2doublearr(double[] dwert, int[] bin, double[] dminwert, double[] dmaxwert)
    {
        //Aufspaltung des Bitarrays:
        int[][] bbin = new int[dwert.length][];
        for(int i=0;i<bbin.length;i++)
        {
            bbin[i] = new int[bin.length/dwert.length];
            for(int k=0;k<bbin[i].length;k++)
                bbin[i][k] = bin[i*bbin[i].length+k];
            dwert[i] = bin2double(bbin[i],dminwert[i],dmaxwert[i]);            
        }        
    }

    /**
    Umkehrmethode zu doublearr2gray
    */
    public void gray2doublearr(double[] dwert, int[] gray, double[] dminwert, double[] dmaxwert)
    {
        int[] bin = new int[gray.length];
        gray2bin(bin,gray);        
        bin2doublearr(dwert,bin,dminwert,dmaxwert);
    }
       
       
    /**
    Gleiches f&uuml;r Integer-Parameters&auml;tze
    */

    public void intarr2bin(int[] bin, int[] dwert,int[] dminwert, int[] dmaxwert)
    {
        //Aufspaltung des Bitarrays:
        int[][] bbin = new int[dwert.length][];
        for(int i=0;i<bbin.length;i++)
        {
            bbin[i] = new int[bin.length/dwert.length];
            int2bin(bbin[i],dwert[i],dminwert[i],dmaxwert[i]);                            
        }
        
        //Bitarray wieder zusammensetzen:
        for(int i=0;i<bbin.length;i++)
            for(int k=0;k<bbin[i].length;k++)
                bin[i*bbin[i].length+k] = bbin[i][k];        
    }

    /**
    Wie intarr2bin, jedoch Umwandlung in Graycode.
    */ 
    public void intarr2gray(int[] gray, int[] dwert,int[] dminwert, int[] dmaxwert)
    {
        int[] bin = new int[gray.length];
        intarr2bin(bin,dwert,dminwert,dmaxwert);
        bin2gray(gray,bin);        
    }

    /**
    Umkehrmethode zu intarr2bin
    */
    public void bin2intarr(int[] dwert, int[] bin, int[] dminwert, int[] dmaxwert)
    {
        //Aufspaltung des Bitarrays:
        int[][] bbin = new int[dwert.length][];
        for(int i=0;i<bbin.length;i++)
        {
            bbin[i] = new int[bin.length/dwert.length];
            for(int k=0;k<bbin[i].length;k++)
                bbin[i][k] = bin[i*bbin[i].length+k];
            dwert[i] = bin2int(bbin[i],dminwert[i],dmaxwert[i]);            
        }        
    }

    /**
    Umkehrmethode zu intarr2gray
    */
    public void gray2intarr(int[] dwert, int[] gray, int[] dminwert, int[] dmaxwert)
    {
        int[] bin = new int[gray.length];
        gray2bin(bin,gray);        
        bin2intarr(dwert,bin,dminwert,dmaxwert);
    }

    public void showParam(double[] param)
    {
        for(int i=0;i<param.length;i++)
            System.out.println(i+".:"+param[i]);      
    }    
}
