package xxxevooptxxx;
import processing.core.*;

/**
<code>
<pre>
 This sourcecode is part of the library xxxevooptxxx

 Copyright (c) 2013-05 Guido Kramann
 Fachhochschule Brandenburg
 University of Applied Sciences Brandenburg
 Germany 

 http://www.kramann.info

 The library xxxevooptxxx is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation, version 2.1.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General
 Public License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA  02111-1307  USA
</pre>
</code>
<br/>
<br/>
 * @author Guido Kramann
 * @version 1.0
<br/>
<br/>
Die Gene werden durch jeweils ein eindimensionales Integer-Array repr&auml;sentiert,
dessen Pl&auml;tze nur mit 1 oder 0 belegt werden können.<br/>
Geeignete Umwandlungsmethoden, um Parameters&auml;tze (ein Array mit mehreren double-Variablen) in
ein Gen-Array umzuwandeln, finden sich in der Klasse Graycode.<br/>
Diese werden i.d.R. benutzt, um die eigene Fehlerfunktions-Klasse zu erzeugen.
*/
public class Gen
{
    private Zufall zufall;
    public int[] arr;
   
  
    public Gen(Zufall zufall, int anzahlbits)
    {
        this.zufall = zufall;
        arr = new int[anzahlbits];
        zufall.init(arr);      
    }  
    
    public void mutieren(int sooft)
    {
        for(int i=0;i<sooft;i++)
        {
            int index = zufall.stelle(arr.length);
            arr[index] = 1 - arr[index];          
        }        
    }
    
    public void rekombinieren(Gen gen1, Gen gen2)
    {
        for(int i=0;i<arr.length;i++)
        {
            if(zufall.nextBoolean())
                arr[i] = gen1.arr[i];
            else                
                arr[i] = gen2.arr[i];
        }      
    }   
    
    public void copy(Gen gen)
    {
        for(int i=0;i<arr.length;i++)
            arr[i] = gen.arr[i];      
    }
    
    public Gen clone()
    {
        Gen gen = new Gen(zufall, arr.length);
        for(int i=0;i<arr.length;i++)
            gen.arr[i] = arr[i];      
        return gen;              
    }
    
    public void show()
    {
        for(int i=0;i<arr.length;i++)
            System.out.print(arr[i]);     
        System.out.println();            
    }
}


