package xxxevooptxxx;
import processing.core.*;

/**
<code>
<pre>
 This sourcecode is part of the library xxxevooptxxx

 Copyright (c) 2013-05 Guido Kramann
 Fachhochschule Brandenburg
 University of Applied Sciences Brandenburg
 Germany 

 http://www.kramann.info

 The library xxxevooptxxx is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation, version 2.1.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General
 Public License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA  02111-1307  USA
</pre>
</code>
<br/>
<br/>
 * @author Guido Kramann
 * @version 1.0
<br/>
<br/>
Schnittstellendefinition f&uuml;r den Teil des evolution&auml;ren Optimierers, der 
berechnet, wie groß der Fehler bei einem bestimmten Gen ist, also wie gut sich
dessen Ph&auml;notyp in der Umwelt bew&auml;hrt.<br/><br/>
Dies kann eine einfache Berechnung sein, wie beim Zahlen-raten-Beispiel, aber auch
eine komplette Simulation.
*/
public interface Fehlerfunktion
{
    /**
    Berechnung des Fehlers f&uuml;r ein bestimmtes Gen
    */
    public abstract double berechne(Gen gen);  
    /**
    Berechnung des Fehlers f&uuml;r ein bestimmtes Gen und Darstellung des Ergebnisses.<br/>
    Dies kann beispielsweise eine Simulation und Animation auf Grundlage des
    &uuml;bergebenen Gens sein.
    */
    public abstract double berechneUndZeige(Gen gen);
}
