package xxxevooptxxx;
import processing.core.*;

/**
<code>
<pre>
 This sourcecode is part of the library xxxevooptxxx

 Copyright (c) 2013-05 Guido Kramann
 Fachhochschule Brandenburg
 University of Applied Sciences Brandenburg
 Germany 

 http://www.kramann.info

 The library xxxevooptxxx is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation, version 2.1.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General
 Public License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA  02111-1307  USA
</pre>
</code>
<br/>
<br/>
 * @author Guido Kramann
 * @version 1.0
<br/>
<br/>
*/
import java.util.Random;

public class Zufall
{
    Random rand;
  
    private PApplet pap;
  
    public Zufall(PApplet pap, long seed)
    {
        rand = new Random(seed);
        this.pap = pap;      
    }  
    public Zufall(PApplet pap)
    {
        rand = new Random(System.currentTimeMillis());      
        this.pap = pap;      
    }
  
    public void init(int[] arr)
    {
        for(int i=0;i<arr.length;i++)
        {
             if(rand.nextBoolean())
                 arr[i] = 1;
             else                 
                 arr[i] = 0;
        }      
    }  
    
    public int stelle(int arrgroesse)
    {
        return rand.nextInt(arrgroesse);  
    }   
    
    public boolean nextBoolean()
    {
        return rand.nextBoolean();      
    }
    
    /**Liefert eine zuf&auml;llige Index-Reihenfolge*/
    public void puzzelReihenfolge(int[] index)
    {
        for(int i=0;i<index.length;i++)
            index[i] = -1;
      
        for(int i=0;i<index.length;i++)
        {
            int zufallswert = rand.nextInt(index.length-i);
            int u=0;
            int q=0;
            while(u<=zufallswert)
            {
                if(index[q]==-1)
                {
                    if(u==zufallswert)
                    {
                        index[q]=i;                      
                    }
                    u++;                                      
                }              
                q++;
                q%=index.length;
            }           
        }      
    }
    
    public void showReihenfolge(int[] index)
    {
        for(int i=0;i<index.length;i++)
            pap.print(index[i]+" ");
        pap.println();      
    }
}
