package xxxevooptxxx;
import processing.core.*;

/**
<code>
<pre>
 This sourcecode is part of the library xxxevooptxxx

 Copyright (c) 2013-05 Guido Kramann
 Fachhochschule Brandenburg
 University of Applied Sciences Brandenburg
 Germany 

 http://www.kramann.info

 The library xxxevooptxxx is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation, version 2.1.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General
 Public License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA  02111-1307  USA
</pre>
</code>
<br/>
<br/>
 * @author Guido Kramann
 * @version 1.0
<br/>
<br/>
Beim Konstruktoraufruf werden die Gene zuf&auml;llig initialisiert
und es wird gleich der Fehler f&uuml;r alle Gene berechnet und die besten Gene bestimmt.<br/>
Deshalb erfolgt diese Fehlerbestimmung immer am Ende eines Aufrufs der zentralen Methode "neueGeneration".
<br/>
Um eine vereinfachte Schnittstelle nach aussn anzubieten, wird noch ein reduzierter Konstruktor angeboten,
bei dem die sonst n&ouml;tigen Parameter in f&uuml;r viele F&auml;lle sinnvoller Weise vorbelegt sind.</br/>
Diese Vorbelegung sieht dann folgendermassn aus:<br/>
<code><pre>
anzahlgene     == 200
anzahlbeste    == 20
anzahlstellen  == 120 == 2*2*2*3*5, passt f&uuml;r 1,2,3,4,5,6,8,10,12,15,... Parameter
sooftmutieren  == 50
zufall         Vorinitialisierung mit millis.
</pre></code>
*/
public class Generation
{
    private PApplet pap;
    private Zufall zufall;
  
    public Fehlerfunktion fehlerfunktion;
    public Gen[] gen;
    public Gen[] beste;
    public int sooftmutieren;
  
    public double[] genguete;    
    public double[] besteguete;    

    private boolean[] bereits_gespeichert; //bereits gefundene Beste merken.
    private int[] index; //Immer wieder ge&auml;nderte Reihenfolge, in der nach den Besten gesucht wird. 
    private int[] indexbeste; //Indices der Besten in gen-Array. 

    public void initialisieren(int anzahlgene,int anzahlbeste, int anzahlstellen, int sooftmutieren, 
                      Zufall zufall, Fehlerfunktion fehlerfunktion)
    {
        this.fehlerfunktion = fehlerfunktion;
        this.sooftmutieren = sooftmutieren;
        this.zufall = zufall;

        gen   = new Gen[anzahlgene];      
        beste = new Gen[anzahlbeste];

        genguete   = new double[anzahlgene];
        
        bereits_gespeichert = new boolean[anzahlgene];      
        index = new int[anzahlgene];
        indexbeste = new int[anzahlbeste];

        besteguete = new double[anzahlbeste];
  
        for(int i=0;i<gen.length;i++)
            gen[i] = new Gen(zufall,anzahlstellen);      
        for(int i=0;i<beste.length;i++) //zuf&auml;llig erzeugt - sp&auml;ter werden in sie die besten aus gen kopiert.
            beste[i] = new Gen(zufall,anzahlstellen);      

        //Fehler f&uuml;r alle Gene berechnen:
        berechneFehler();
        //Beste finden
        findeBeste();
    }      

    public Generation(PApplet pap, Fehlerfunktion fehlerfunktion) //erzeugt erste Generation
    {
        int anzahlgene    = 200;
        int anzahlbeste   = 20;
        int anzahlstellen = 120;
        int sooftmutieren = 50; 
        Zufall zufall = new Zufall(pap);   
        
        this.pap = pap;
        
        initialisieren(anzahlgene,anzahlbeste,anzahlstellen,sooftmutieren,zufall,fehlerfunktion);      
    }
  
    public Generation(PApplet pap,int anzahlgene,int anzahlbeste, int anzahlstellen, int sooftmutieren, 
                      Zufall zufall, Fehlerfunktion fehlerfunktion) //erzeugt erste Generation
    {
        this.pap = pap;
        
        initialisieren(anzahlgene,anzahlbeste,anzahlstellen,sooftmutieren,zufall,fehlerfunktion);      
    }  
    
    //Fehler f&uuml;r alle Gene berechnen:
    public void berechneFehler()
    {
        for(int i=0;i<gen.length;i++)
            genguete[i] = fehlerfunktion.berechne(gen[i]);
    }

    //Beste finden
    public void findeBeste()
    {
        int indexaktuell=0;
        double fehleraktuell=0.0;
      
        for(int i=0;i<bereits_gespeichert.length;i++)
            bereits_gespeichert[i] = false;
      
  
        //Reihenfolge puzzeln, damit bei gleich grossen Fehlern nicht immer dieselben
        //Eintr&auml;ge vor den anderen genommen werden:
        zufall.puzzelReihenfolge(index);
               
        for(int i=0;i<beste.length;i++)
        {
            boolean erstereintrag = true;
            for(int kk=0;kk<gen.length;kk++)
            {
                int k=index[kk];
                if( bereits_gespeichert[k]==false && (erstereintrag==true || genguete[k]<=fehleraktuell) )
                {
                    erstereintrag = false;
                    fehleraktuell = genguete[k];
                    indexaktuell = k;
                }
            }             
            besteguete[i] = fehleraktuell;
            indexbeste[i] = indexaktuell;
            beste[i].copy(gen[indexaktuell]);   
            bereits_gespeichert[indexaktuell]=true;
        }
    }
        
    public void neueGeneration()
    {
        //Fehler f&uuml;r alle Gene berechnen:
        //berechneFehler(); //- wird besser bei Aufruf des Konstruktors zum ersten mal und dann immer AM ENDE von neue Generation() durchgef&uuml;hrt
        //Beste finden
        //findeBeste();     //- wird besser bei Aufruf des Konstruktors zum ersten mal und dann immer AM ENDE von neue Generation() durchgef&uuml;hrt

        //Neue Generation bilden:
        //Array beste an die unteren Array-Pl&auml;tze von Array gen kopieren und Restpl&auml;tze durch
        //Rekombination bilden, dann noch Restpl&auml;tze mutieren.
        for(int i=0;i<beste.length;i++)
            gen[i].copy(beste[i]);   
        for(int i=beste.length;i<gen.length;i++)
        {
            int p = zufall.stelle(beste.length);
            int q = zufall.stelle(beste.length-1);
            q = (p+q)%beste.length;
            gen[i].rekombinieren(gen[p],gen[q]);          
        }    
        
        //Mutattionen bei den rekombinierten Genen durchf&uuml;hren:
        for(int i=0;i<sooftmutieren;i++)
        {
            int p = beste.length + zufall.stelle(gen.length-beste.length);
            gen[p].mutieren(1);          
        }        


        //Fehler f&uuml;r alle Gene berechnen:
        berechneFehler();
        //Beste finden
        findeBeste();
    }
    
       
}
