package xxxsimulatorxxx;
import processing.core.*;

/**
<code>
<pre>
 This sourcecode is part of the library xxxsimulatorxxx

 Copyright (c) 2013-05 Guido Kramann
 Fachhochschule Brandenburg
 University of Applied Sciences Brandenburg
 Germany 

 http://www.kramann.info

 The library xxxsimulatorxxx is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation, version 2.1.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General
 Public License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA  02111-1307  USA
</pre>
</code>
<br/>
<br/>
 * @author Guido Kramann
 * @version 1.0
<br/>
<br/>
*/
public class Integrator
{
    int anzahl;
  
    double[] k1,k2,k3,k4;
    
    double[] yhilf;
  
    Modell modell;
  
    public Integrator(Modell modell)
    {
        this.modell = modell;
        anzahl = modell.getGleichungsanzahl();
        k1 = new double[anzahl];      
        k2 = new double[anzahl];      
        k3 = new double[anzahl];      
        k4 = new double[anzahl];
  
        yhilf = new double[anzahl];            
    }  
    
    public void zeitschritt(double[] y,double[] y_alt, double t, double dt)
    {
        modell.steigung(k1,y_alt,t);
        for(int i=0;i<anzahl;i++)
            yhilf[i] = y_alt[i] + 0.5*dt*k1[i];
            
        modell.steigung(k2,yhilf,t+0.5*dt);            
        for(int i=0;i<anzahl;i++)
            yhilf[i] = y_alt[i] + 0.5*dt*k2[i];

        modell.steigung(k3,yhilf,t+0.5*dt);            
        for(int i=0;i<anzahl;i++)
            yhilf[i] = y_alt[i] + dt*k3[i];

        modell.steigung(k4,yhilf,t+dt);

        for(int i=0;i<anzahl;i++)
            y[i] = y_alt[i] + (dt/6.0)*(k1[i]+2.0*k2[i]+2.0*k3[i]+k4[i]);        
     }
}

