package xxxsimulatorxxx;
import processing.core.*;

/**
<code>
<pre>
 This sourcecode is part of the library xxxsimulatorxxx

 Copyright (c) 2013-05 Guido Kramann
 Fachhochschule Brandenburg
 University of Applied Sciences Brandenburg
 Germany 

 http://www.kramann.info

 The library xxxsimulatorxxx is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation, version 2.1.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General
 Public License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA  02111-1307  USA
</pre>
</code>
<br/>
<br/>
 * @author Guido Kramann
 * @version 1.0
<br/>
<br/>
Fahrzeugmodell:<br/>
Systemzusände:       <br/>
phi       <br/>
xA        <br/>
yA        <br/>

Ableitungen:       <br/>
wA       <br/>
vxA        <br/>
vyA        <br/>

*/
public class FahrzeugModell implements Modell
{
    //Modellparameter in Metern MUSS MIT PARAMETERN IN "Fahrzeug" übereinstimmen!!!
    double achsabstand = 0.08;
    double raddurchmesser = 0.058;
    double raddicke = 0.02;
    double laenge = 0.175;
  
  
    double phimin = 0.001; //Lenkwinkel, ab dem von Geradeausfahrt ausgegangen wird (in rad)!
  
    double xA;
    double yA;
    double beta; //Chassis-Winkel im Inertialkoordinatensystem
    
    double vxA; //Winkelgeschwindigkeit Punkt A
    double vyA; //Winkelgeschwindigkeit Punkt A
    double wA; //Winkelgeschwindigkeit Punkt A

    double vA; //Geschwindigkeit Punkt A in Fahrtrichtung in I'


    double xQ; //X-Koordinate Momentanpol in I'
    double yQ; //Y-Koordinate Momentanpol in I'
  
    //Vorgegeben wird:
    public double phi  = 0.0; //aktueller Lenkwinkel
    public double vB   = 0.1; //Geschwindigkeit Punkt B in Fahrtrichtung (Antriebsrad)
  
    public int getGleichungsanzahl()
    {
        return 3;      
    }
  
    public void steigung(double[] f, double[] yy,double t)
    {
        xA   = yy[0];
        yA   = yy[1];
        beta = yy[2];        
      
        if(phi<=phimin && phi>=-phimin)
        {
            //Modell für Geradeausfahrt
            wA = 0.0;
            vA = vB; //Radgeschw. und Geschw. in Punkt A müssen gleich sein, wenn der Lenkwinkel Null ist!
            vxA =  -Math.sin(beta)*vA;
            vyA =   Math.cos(beta)*vA;            
        }
        else
        {
            //Modell für Kurvenfahrt
            
            //1) Momentanpol in I':
            xQ = -laenge/Math.tan(phi);
            yQ = 0.0;
         
            //2) Winkelgeschwindigkeit um den Momentanpol bestimmen == Winkelgeschw. um A == wA:
            //2a) Distanz von Q zu Vorderrad B:
            double BQ = Math.sqrt(xQ*xQ + laenge*laenge);
            wA = vB/BQ;
            //Vorzeichen korrigieren:
            if(phi<0.0)
               wA=-wA;
            
            vA = -xQ*wA; //Geschw. Punkt A in I'  

            //...umrechnen ins Inertialkoordinatensystem
            vxA =  -Math.sin(beta)*vA;
            vyA =   Math.cos(beta)*vA;            
        }
      
 
        f[0] = vxA;
        f[1] = vyA; 
        f[2] = wA; 
    }  
}

