import xxxsimulatorxxx.*;
import xxxevooptxxx.*;

Fahrzeug fahrzeug;
Integrator integrator;
FahrzeugModell2     modell;

Graycode graycode;
MeineFehlerfunktion2 fehlerfunktion;
Generation generation;


float anim_phi=0.0f; //Lenkwinkel
float anim_beta=0.0f; //Chassis-Verdrehung gegenüber Inertialkoordinatensystem
float anim_x=0.0f;
float anim_y=0.0f;

double dt = 0.2;
double  t = 0.0;


double[] y;
double[] y0;
double[] y_alt;

boolean started = false;

//Neue Parameter, die den Parcours festlegen:
double RADIUSPARCOURS = 1.0;

//Neue Parameter für Regler global definieren, um sie in
//der Fehlerfunktion verfügbar zu haben:

double[] PID = {2.0,1.0,1.0};

void setup()
{  
    fahrzeug = new Fahrzeug(this);    
    modell = new FahrzeugModell2();
    graycode = new Graycode(this);      
    
    y = new double[modell.getGleichungsanzahl()];
    y0 = new double[] {0.0,0.9,HALF_PI,0.0,0.0}; //x, y, beta
    y[0] = y0[0];
    y[1] = y0[1];
    y[2] = y0[2];
    y[3] = y0[3]; //Aufintegrieren von sensorwert (Regeldifferenz)
    y[4] = y0[4]; //Aufintegrieren der Servo-Lenkwinkelgeschw.
    y_alt = new double[modell.getGleichungsanzahl()];
    integrator = new Integrator(modell);

    //Notwendige Objekte für die Optimierung anlegen:
    fehlerfunktion = new MeineFehlerfunktion2(this,integrator,modell);
    //generation = new Generation(this,fehlerfunktion);

    int anzahlgene = 20;
    int anzahlbeste = 4;
    int anzahlstellen = 48;
    int sooftmutieren = 10;
    Zufall zufall = new Zufall(this);
    generation = new Generation(this,anzahlgene,anzahlbeste,
                             anzahlstellen,sooftmutieren,
                             zufall,fehlerfunktion); 


    //Optimierung durchführen:
    int MAXDURCHLAEUFE = 10;
    for(int i=0;i<MAXDURCHLAEUFE;i++)
    {
        println("BESTES ERGEBNIS BEI DURCHLAUF Nr."+i+":");
        Gen bestesgen = generation.beste[0];
        graycode.gray2doublearr(PID,bestesgen.arr,new double[] {0.0,0.0,0.0},new  double[] {10.0,10.0,10.0});
        double PP = PID[0];      
        double II = PID[1];      
        double DD = PID[2];      
        bestesgen = generation.beste[0];
        double fehler = fehlerfunktion.berechne(bestesgen);
//        println("P="+PID[0]+" I="+PID[1]+" D="+PID[2]+" Fehler="+fehler);
        println("P="+PP+" I="+II+" D="+DD+" Fehler="+fehler);
        if(i<MAXDURCHLAEUFE-1)
            generation.neueGeneration();
    }   


//    frameRate((int)(1.0/dt));
    frameRate(20);
    
     size(800,800);
   
    smooth();
  
    started = true;  
}

void draw()
{
    translate(width/2,height/2);
    scale(3.0f,3.0f);

    clear();
    background(200,200,255);
    
    anim_x = 100.0f*(float)y[0]; //in cm umrechnen    
    anim_y = 100.0f*(float)y[1];        
    anim_beta = (float)y[2]; //Chassis-Winkel
    anim_phi  = (float)modell.phi;  //Lenkwinkel

    //Parcours einzeichenen:
    noFill();
    stroke(255,0,0);
    ellipse(0,0,(float)(RADIUSPARCOURS*200.0),(float)(RADIUSPARCOURS*200.0));   
    
    fahrzeug.draw(anim_x,anim_y,anim_beta,anim_phi);
  
    translate(-width/2,-height/2);
    
    for(int i=0;i<y.length;i++)
        y_alt[i] = y[i];
  
    integrator.zeitschritt(y,y_alt,t,dt); //Ergebnis wird in y gelegt

    modell.sensorwert_alt = modell.sensorwert;
    
    t+=dt;   
}
