import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import xxxsimulatorxxx.*; 
import xxxevooptxxx.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class fahrzeug6 extends PApplet {




Fahrzeug fahrzeug;
Integrator integrator;
FahrzeugModell2     modell;

Graycode graycode;
MeineFehlerfunktion2 fehlerfunktion;
Generation generation;


float anim_phi=0.0f; //Lenkwinkel
float anim_beta=0.0f; //Chassis-Verdrehung gegen\u00fcber Inertialkoordinatensystem
float anim_x=0.0f;
float anim_y=0.0f;

double dt = 0.2f;
double  t = 0.0f;


double[] y;
double[] y0;
double[] y_alt;

boolean started = false;

//Neue Parameter, die den Parcours festlegen:
double RADIUSPARCOURS = 1.0f;

//Neue Parameter f\u00fcr Regler global definieren, um sie in
//der Fehlerfunktion verf\u00fcgbar zu haben:

double[] PID = {2.0f,1.0f,1.0f};

public void setup()
{  
    fahrzeug = new Fahrzeug(this);    
    modell = new FahrzeugModell2();
    graycode = new Graycode(this);      
    
    y = new double[modell.getGleichungsanzahl()];
    y0 = new double[] {0.0f,0.9f,HALF_PI,0.0f,0.0f}; //x, y, beta
    y[0] = y0[0];
    y[1] = y0[1];
    y[2] = y0[2];
    y[3] = y0[3]; //Aufintegrieren von sensorwert (Regeldifferenz)
    y[4] = y0[4]; //Aufintegrieren der Servo-Lenkwinkelgeschw.
    y_alt = new double[modell.getGleichungsanzahl()];
    integrator = new Integrator(modell);

    //Notwendige Objekte f\u00fcr die Optimierung anlegen:
    fehlerfunktion = new MeineFehlerfunktion2(this,integrator,modell);
    //generation = new Generation(this,fehlerfunktion);

    int anzahlgene = 20;
    int anzahlbeste = 4;
    int anzahlstellen = 48;
    int sooftmutieren = 10;
    Zufall zufall = new Zufall(this);
    generation = new Generation(this,anzahlgene,anzahlbeste,
                             anzahlstellen,sooftmutieren,
                             zufall,fehlerfunktion); 


    //Optimierung durchf\u00fchren:
    int MAXDURCHLAEUFE = 10;
    for(int i=0;i<MAXDURCHLAEUFE;i++)
    {
        println("BESTES ERGEBNIS BEI DURCHLAUF Nr."+i+":");
        Gen bestesgen = generation.beste[0];
        graycode.gray2doublearr(PID,bestesgen.arr,new double[] {0.0f,0.0f,0.0f},new  double[] {10.0f,10.0f,10.0f});
        double PP = PID[0];      
        double II = PID[1];      
        double DD = PID[2];      
        bestesgen = generation.beste[0];
        double fehler = fehlerfunktion.berechne(bestesgen);
//        println("P="+PID[0]+" I="+PID[1]+" D="+PID[2]+" Fehler="+fehler);
        println("P="+PP+" I="+II+" D="+DD+" Fehler="+fehler);
        if(i<MAXDURCHLAEUFE-1)
            generation.neueGeneration();
    }   


//    frameRate((int)(1.0/dt));
    frameRate(20);
    
     size(800,800);
   
    smooth();
  
    started = true;  
}

public void draw()
{
    translate(width/2,height/2);
    scale(3.0f,3.0f);

    clear();
    background(200,200,255);
    
    anim_x = 100.0f*(float)y[0]; //in cm umrechnen    
    anim_y = 100.0f*(float)y[1];        
    anim_beta = (float)y[2]; //Chassis-Winkel
    anim_phi  = (float)modell.phi;  //Lenkwinkel

    //Parcours einzeichenen:
    noFill();
    stroke(255,0,0);
    ellipse(0,0,(float)(RADIUSPARCOURS*200.0f),(float)(RADIUSPARCOURS*200.0f));   
    
    fahrzeug.draw(anim_x,anim_y,anim_beta,anim_phi);
  
    translate(-width/2,-height/2);
    
    for(int i=0;i<y.length;i++)
        y_alt[i] = y[i];
  
    integrator.zeitschritt(y,y_alt,t,dt); //Ergebnis wird in y gelegt

    modell.sensorwert_alt = modell.sensorwert;
    
    t+=dt;   
}
/**
Alle Parameter in cm.
*/
public class Fahrzeug
{
    float achsabstand = 8.0f;
    float raddurchmesser = 5.8f;
    float raddicke = 2.0f;
    float laenge = 17.5f;
  
    float[] merkerX;    
    float[] merkerY;    
  
    int merkanzahl;
    int merkindex;
  
    private PApplet pap;
    public Fahrzeug(PApplet pap)
    {
        this.pap = pap;
  
        merkerX = new float[1000];      
        merkerY = new float[1000];
        merkanzahl = 0;
        merkindex  = 0;      
    }  
    
    /**
    Punkt A: Mitte Hinterachse, Absolutkoordinaten xA, yA.<br/>
    phi: Chassis-Drehung im Inertialkoordinatensystem in rad<br/>
    beta: Lenkwinkel in rad <br/>
    Der Koordinatenursprung wird in die Bildmitte gelegt,<br/>
    Die y-Achse wird gespiegelt.
    */
    public void draw(float xA, float yA, float beta, float phi)
    {
        beta = -beta;
        phi = -phi;
        yA = -yA;

        merkerX[merkindex]=xA;                
        merkerY[merkindex]=yA;
        if(merkanzahl<merkerX.length)
            merkanzahl++;
    

        noFill();
        stroke(100,255,100);

        if(merkanzahl>1)
        {
            for(int i=0;i<merkanzahl-1;i++)
            {
                int u=(merkindex-i+merkerX.length)%merkerX.length;
                int v=(merkindex-i-1+merkerX.length)%merkerX.length;
              
                line(merkerX[u],merkerY[u],merkerX[v],merkerY[v]);              
            }          
        }

        merkindex++;
        merkindex%=merkerY.length;
        
        fill(255);
        stroke(0);
        
        pap.translate(xA,yA);
        pap.rotate(beta);      

        //Chassis:
        pap.beginShape();
            pap.vertex(0.0f,0.0f);
            pap.vertex(-achsabstand/2.0f,0.0f);
            pap.vertex(-achsabstand/2.0f,-raddurchmesser/2.0f);
            pap.vertex(-achsabstand/2.0f-raddicke,-raddurchmesser/2.0f);
            pap.vertex(-achsabstand/2.0f-raddicke,raddurchmesser/2.0f);
            pap.vertex(-achsabstand/2.0f,raddurchmesser/2.0f);
            pap.vertex(-achsabstand/2.0f,0.0f);
            pap.vertex(0.0f,0.0f);
            pap.vertex(achsabstand/2.0f,0.0f);
            pap.vertex(achsabstand/2.0f,raddurchmesser/2.0f);
            pap.vertex(achsabstand/2.0f+raddicke,raddurchmesser/2.0f);
            pap.vertex(achsabstand/2.0f+raddicke,-raddurchmesser/2.0f);
            pap.vertex(achsabstand/2.0f,-raddurchmesser/2.0f);
            pap.vertex(achsabstand/2.0f,0.0f);
            pap.vertex(0.0f,0.0f);
            pap.vertex(0.0f,-laenge);            
            pap.vertex(0.0f,0.0f);
        pap.endShape();
  
        //Vorderrad:
        pap.translate(0.0f,-laenge);
        pap.rotate(phi);

        pap.beginShape();
            pap.vertex(-raddicke/2.0f,-raddurchmesser/2.0f);
            pap.vertex(-raddicke/2.0f,raddurchmesser/2.0f);
            pap.vertex(raddicke/2.0f,raddurchmesser/2.0f);
            pap.vertex(raddicke/2.0f,-raddurchmesser/2.0f);
            pap.vertex(-raddicke/2.0f,-raddurchmesser/2.0f);
        pap.endShape();

        pap.rotate(-phi);
        pap.translate(0.0f,laenge);
        
        pap.rotate(-beta);      
        pap.translate(-xA,-yA);
    }
}
/**
Fahrzeugmodell:<br/>
Systemzus\u00e4nde:       <br/>
phi       <br/>
xA        <br/>
yA        <br/>

Ableitungen:       <br/>
wA       <br/>
vxA        <br/>
vyA        <br/>

*/
public class FahrzeugModell2 implements Modell
{
    //Modellparameter in Metern MUSS MIT PARAMETERN IN "Fahrzeug" \u00fcbereinstimmen!!!
    double achsabstand = 0.08f;
    double raddurchmesser = 0.058f;
    double raddicke = 0.02f;
    double laenge = 0.175f;
  
  
    double phimin = 0.001f; //Lenkwinkel, ab dem von Geradeausfahrt ausgegangen wird (in rad)!
  
    double xA;
    double yA;
    double beta; //Chassis-Winkel im Inertialkoordinatensystem
    
    double vxA; //Winkelgeschwindigkeit Punkt A
    double vyA; //Winkelgeschwindigkeit Punkt A
    double wA; //Winkelgeschwindigkeit Punkt A

    double vA; //Geschwindigkeit Punkt A in Fahrtrichtung in I'


    double xQ; //X-Koordinate Momentanpol in I'
    double yQ; //Y-Koordinate Momentanpol in I'
  
    //Vorgegeben wird:
    public double phi  = 0.0f; //aktueller Lenkwinkel
    public double vB   = 0.1f; //Geschwindigkeit Punkt B in Fahrtrichtung (Antriebsrad)

//Neu: Hilfsvariablen f\u00fcr PID-Regler:
    public double i_sensorwert = 0.0f;
    public double sensorwert = 0.0f;
    public double d_sensorwert = 0.0f;
    public double sensorwert_alt = 0.0f;
    public double phi_soll = 0.0f;
    //3 Bilder f\u00fcr 45 Grad und 25 Bilder pro Sekunde
    //=> 45/(3/25) => 375 Grad/sek ==  
//    public double phiradprosekunde = 6.5;
    public double phiradprosekunde = 1.0f;
  
    public int getGleichungsanzahl()
    {
        return 5;      
    }
  
    public void steigung(double[] f, double[] yy,double t)
    {
        xA   = yy[0];
        yA   = yy[1];
        beta = yy[2];        

        phi = yy[4];

//Neu: Berechnung des Sensorwertes (Distanz A zu Parcourskreisrand):
        double xB = xA - Math.sin(beta)*laenge;
        double yB = yA + Math.cos(beta)*laenge;

        //a) Einheitsvektor nach A:
        double dd = Math.sqrt(xB*xB+yB*yB);
        sensorwert = RADIUSPARCOURS-dd;             
//println(sensorwert);
//Neu: Regler
        double pid = PID[0]*sensorwert + PID[1]*i_sensorwert + PID[2]*(sensorwert-sensorwert_alt)/dt;
//        double pid = PI[0]*sensorwert + PI[1]*i_sensorwert;
//        double pid = PID[0]*sensorwert;

        i_sensorwert=y[3];
//        sensorwert_alt = sensorwert;

        phi_soll = -pid;
        
        if(phi_soll>HALF_PI)
            phi_soll = (double)HALF_PI;
        if(phi_soll<-HALF_PI)
            phi_soll = -(double)HALF_PI;

//phi = phi_soll;
        
        if(phi<phi_soll)
            f[4] = phiradprosekunde;
        else if(phi>phi_soll)            
            f[4] = -phiradprosekunde;
        else
            f[4] = 0.0f;             
             
        if(phi<=phimin && phi>=-phimin)
        {
            //Modell f\u00fcr Geradeausfahrt
            wA = 0.0f;
            vA = vB; //Radgeschw. und Geschw. in Punkt A m\u00fcssen gleich sein, wenn der Lenkwinkel Null ist!
            vxA =  -Math.sin(beta)*vA;
            vyA =   Math.cos(beta)*vA;            
        }
        else
        {
            //Modell f\u00fcr Kurvenfahrt
            
            //1) Momentanpol in I':
            xQ = -laenge/Math.tan(phi);
            yQ = 0.0f;
         
            //2) Winkelgeschwindigkeit um den Momentanpol bestimmen == Winkelgeschw. um A == wA:
            //2a) Distanz von Q zu Vorderrad B:
            double BQ = Math.sqrt(xQ*xQ + laenge*laenge);
            wA = vB/BQ;
            //Vorzeichen korrigieren:
            if(phi<0.0f)
               wA=-wA;
            
            vA = -xQ*wA; //Geschw. Punkt A in I'  

            //...umrechnen ins Inertialkoordinatensystem
            vxA =  -Math.sin(beta)*vA;
            vyA =   Math.cos(beta)*vA;            
        }
      
 
        f[0] = vxA;
        f[1] = vyA; 
        f[2] = wA;
        f[3] = sensorwert; //Aufintegrieren der Regeldifferenz 
    }  
}
public class MeineFehlerfunktion2 implements Fehlerfunktion
{
    private PApplet pap;
    private Integrator integrator;
    private FahrzeugModell2     modell;

    private Graycode graycode;

    double[] y;
    double[] y0;
    double[] y_alt;
  
    public MeineFehlerfunktion2(PApplet pap,Integrator integrator,FahrzeugModell2     modell)
    {
        this.pap = pap;
        graycode = new Graycode(pap);      
        
        this.integrator = integrator;
        this.modell = modell;
    }

    
  
    public double berechne(Gen gen)
    {
        graycode.gray2doublearr(PID,gen.arr,new double[] {0.0f,0.0f,0.0f},new  double[] {10.0f,10.0f,10.0f});      
      
        y = new double[modell.getGleichungsanzahl()];
        y0 = new double[] {0.0f,0.9f,HALF_PI,0.0f,0.0f}; //x, y, beta
        y[0] = y0[0];
        y[1] = y0[1];
        y[2] = y0[2];
        y[3] = y0[3]; //Aufintegrieren von sensorwert (Regeldifferenz)
        y[4] = y0[4]; //Aufintegrieren der Servo-Lenkwinkelgeschw.
        y_alt = new double[modell.getGleichungsanzahl()];

        int MAXSCHRITTE = 200;

        double fehler = 0.0f;
        t=0.0f;
//println("??? "+PID[0]+" "+PID[1]+" "+PID[2]);        
        for(int i=0;i<MAXSCHRITTE;i++)
        {
            fehler += Math.abs(RADIUSPARCOURS - Math.sqrt(y[0]*y[0]+y[1]*y[1]));

            for(int ii=0;ii<y.length;ii++)
                y_alt[ii] = y[ii];
          
            integrator.zeitschritt(y,y_alt,t,dt); //Ergebnis wird in y gelegt

            modell.sensorwert_alt = modell.sensorwert;    
            t+=dt;             
        }

        return fehler;
    }
  
    public double berechneUndZeige(Gen gen)
    {
        return 0.0f;      
    }
    
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "fahrzeug6" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
