/**
Alle Parameter in cm.
*/
public class Fahrzeug
{
    float achsabstand = 8.0f;
    float raddurchmesser = 5.8f;
    float raddicke = 2.0f;
    float laenge = 17.5f;
  
    float[] merkerX;    
    float[] merkerY;    
  
    int merkanzahl;
    int merkindex;
  
    private PApplet pap;
    public Fahrzeug(PApplet pap)
    {
        this.pap = pap;
  
        merkerX = new float[1000];      
        merkerY = new float[1000];
        merkanzahl = 0;
        merkindex  = 0;      
    }  
    
    /**
    Punkt A: Mitte Hinterachse, Absolutkoordinaten xA, yA.<br/>
    phi: Chassis-Drehung im Inertialkoordinatensystem in rad<br/>
    beta: Lenkwinkel in rad <br/>
    Der Koordinatenursprung wird in die Bildmitte gelegt,<br/>
    Die y-Achse wird gespiegelt.
    */
    public void draw(float xA, float yA, float beta, float phi)
    {
        beta = -beta;
        phi = -phi;
        yA = -yA;

        merkerX[merkindex]=xA;                
        merkerY[merkindex]=yA;
        if(merkanzahl<merkerX.length)
            merkanzahl++;
    

        noFill();
        stroke(100,255,100);

        if(merkanzahl>1)
        {
            for(int i=0;i<merkanzahl-1;i++)
            {
                int u=(merkindex-i+merkerX.length)%merkerX.length;
                int v=(merkindex-i-1+merkerX.length)%merkerX.length;
              
                line(merkerX[u],merkerY[u],merkerX[v],merkerY[v]);              
            }          
        }

        merkindex++;
        merkindex%=merkerY.length;
        
        fill(255);
        stroke(0);
        
        pap.translate(xA,yA);
        pap.rotate(beta);      

        //Chassis:
        pap.beginShape();
            pap.vertex(0.0f,0.0f);
            pap.vertex(-achsabstand/2.0f,0.0f);
            pap.vertex(-achsabstand/2.0f,-raddurchmesser/2.0f);
            pap.vertex(-achsabstand/2.0f-raddicke,-raddurchmesser/2.0f);
            pap.vertex(-achsabstand/2.0f-raddicke,raddurchmesser/2.0f);
            pap.vertex(-achsabstand/2.0f,raddurchmesser/2.0f);
            pap.vertex(-achsabstand/2.0f,0.0f);
            pap.vertex(0.0f,0.0f);
            pap.vertex(achsabstand/2.0f,0.0f);
            pap.vertex(achsabstand/2.0f,raddurchmesser/2.0f);
            pap.vertex(achsabstand/2.0f+raddicke,raddurchmesser/2.0f);
            pap.vertex(achsabstand/2.0f+raddicke,-raddurchmesser/2.0f);
            pap.vertex(achsabstand/2.0f,-raddurchmesser/2.0f);
            pap.vertex(achsabstand/2.0f,0.0f);
            pap.vertex(0.0f,0.0f);
            pap.vertex(0.0f,-laenge);            
            pap.vertex(0.0f,0.0f);
        pap.endShape();
  
        //Vorderrad:
        pap.translate(0.0f,-laenge);
        pap.rotate(phi);

        pap.beginShape();
            pap.vertex(-raddicke/2.0f,-raddurchmesser/2.0f);
            pap.vertex(-raddicke/2.0f,raddurchmesser/2.0f);
            pap.vertex(raddicke/2.0f,raddurchmesser/2.0f);
            pap.vertex(raddicke/2.0f,-raddurchmesser/2.0f);
            pap.vertex(-raddicke/2.0f,-raddurchmesser/2.0f);
        pap.endShape();

        pap.rotate(-phi);
        pap.translate(0.0f,laenge);
        
        pap.rotate(-beta);      
        pap.translate(-xA,-yA);
    }
}
